/*
 * Copyright (c) 2014, STMicroelectronics International N.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "testframework.h"

#define COMPOSITE 0
#define PRIME 1
#define PROB_PRIME -1

#define IS_COMPOSITE(str)                           \
do {                                                \
	TEE_BigIntConvertFromString(x, str);        \
	int tmp = TEE_BigIntIsProbablePrime(x, 80); \
	TB_ASSERT(tmp == COMPOSITE);                \
} while (0)

#define IS_PRIME(str)                                       \
do {                                                        \
	TEE_BigIntConvertFromString(x, str);                \
	int tmp = TEE_BigIntIsProbablePrime(x, 80);         \
	TB_ASSERT(((tmp == PRIME) || (tmp == PROB_PRIME))); \
} while (0)

static void simple(void)
{

	TB_INFO("Simple cases");

	DEF_BIGINT(x, 2048);

	IS_COMPOSITE("0");
	IS_COMPOSITE("1");
	IS_PRIME("2");
	IS_PRIME("3");
	IS_PRIME("17");
	IS_PRIME("FA1");
	IS_COMPOSITE("FA0");

	DEL_BIGINT(x);

}

static void large_composites(void)
{
	TB_INFO("Large Composites");

	DEF_BIGINT(x, 2048);

	IS_COMPOSITE("136233FDE5569");
	IS_COMPOSITE("177B96388FD94D5D7EC9AE513");
	IS_COMPOSITE("22770A7DC599BC90B2FF981CCB5CF05703344C8F3504189ED");

	IS_COMPOSITE("0002ECD5_3B215054_2D1494A4_24D50322_EBABBBD5_DB89392A_368D7759");

	IS_COMPOSITE("00000004_C8971C2B_6F7A8503_AB80749E_2BBA5BB6_B6031BD4_3564DCA8_003F0E3E_54E677A0_A4B1B615_3662B313_0C11C273_C0F94084_45B2ABB4_7D64153B_EB48C154_659FDFDE_DC496C8E_A81AA7B7_CE2B2CB1_AA7C8B40_7DE8C86F_122607B2_A226385D_9432F6CB_30B5E4DE_033E3363_D48A1865_D9BC95DC_7883D9DC_9331691A_17964979");

	IS_COMPOSITE("00038AFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFFF_FFFFFFEA_5C6D11ED_D2905192_C5429E6A_6D796E89_250BF563_DA53D393_25129B70_435894B5_6E337D58_66F0BEF6_63D6C26D_A889B69D_4B1508ED_63A17AFD_8BC0C5BE_09AC18B6_4B2B7D87_279D32EB_4F3375C1_0D58DF1F_7CA2147A_61CFA557_235244D4_A4700AB5_953C4C6E_D428EB5F_09F07DAE_D46A995B_8FFE48EF_B93390C9_60685A31_987879F8_18CCE9B9_816E13DE_E4BEA5CC_38C56A5D_1983425D_DD909C88_463B447F");

	DEL_BIGINT(x);
}

static void large_primes(void)
{
	TB_INFO("Large Primes");

	DEF_BIGINT(x, 2048);

	IS_PRIME("000136A3_52B2C7A5");
	IS_PRIME("00000002_2770A7DC_599BC90B_2FF981CC_B5CF0570_3344C8F3_50418AAD");

	IS_PRIME("000067E0_4F440C5F_ECCA2694_B1A4AB4F_CEC2D2B2_D286FC93_DD259D2B_36A3A00D_F3726A4D_4DFA9919_5998D92F_43DD7370_B8C079E2_3072036F_0C13F3F6_ABA1D6DF");

	IS_PRIME("000BC9F7_E42CE741_32EC6933_DE1B8357_CD2AEB9E_4B8A5F26_BD233D1E_6F295555_4D2CFA97_60F3F69C_CC52E8E4_28F68C37_AD5BC70C_DB12F4DC_EF23CB10_1C36A2A7");

	IS_PRIME("00000005_233FE157_B5B44102_598513AE_BB8876B0_D1791769_C8A1B0F3_6875D06F_E26951C7_372192C7_B21CAB67_ADF0D6FE_1A718FB3_FC4A5145_4DE87CD3_F852005B_AAEC35D5");

	IS_PRIME("0000001A_655954FB_C4408E09_FE97EB82_5E0F0964_26B42317_A36E53FF_9608DD3F_A6610402_45906334_496987EF_B14BEA5F_7C050444_C9B22A09_EC76AF4E_BDC609D8_A90C05E9_E5AF0682_9C542DFC_F7E6B9DC_0B065659_C1816309_CD6012C3_7F8CE649_8DECF850_F33943F0_F8308140_6846D306_22E0BCE6_97E612FC_1F7A5D90_2280D6E0_3009E585");

	DEL_BIGINT(x);
}

void tb_prime(void)
{
	TB_HEADER("Primality Algorithms");
	simple();
	large_composites();
	large_primes();
	TB_FOOTER("Primality Algorithms");
}
