// SPDX-License-Identifier: BSD-2-Clause
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef _TEST_CRYPTO_H_
#define _TEST_CRYPTO_H_

#include <stdint.h>

#define HSM_TA_DEBUG 1

#define COMMANDID_TEST_0    (0x56)
#define COMMANDID_TEST_1    (0x78)
#define COMMANDID_SKS_TA    (0xDD)

enum Crypto_OperationModeType
{
	CRYPTO_OPERATIONMODE_INVALID        = 0x00,
	CRYPTO_OPERATIONMODE_START          = 0x01,
	CRYPTO_OPERATIONMODE_UPDATE         = 0x02,
	CRYPTO_OPERATIONMODE_STREAMSTART    = 0x03,
	CRYPTO_OPERATIONMODE_FINISH         = 0x04,
	CRYPTO_OPERATIONMODE_SINGLECALL     = 0x05,
};

enum Crypto_ServiceInfoType
{
	CRYPTO_HASH                     = 0x00,
	CRYPTO_MACGENERATE              = 0x01,
	CRYPTO_MACVERIFY                = 0x02,
	CRYPTO_ENCRYPT                  = 0x03,
	CRYPTO_DECRYPT                  = 0x04,

//    CRYPTO_AEADENCRYPT              = 0x05,
//    CRYPTO_AEADDECRYPT              = 0x06,

	CRYPTO_SIGNATUREGENERATE        = 0x07,
	CRYPTO_SIGNATUREVERIFY          = 0x08,
	CRYPTO_SECCOUNTERINCREMENT      = 0x09,
	CRYPTO_SECCOUNTERREAD           = 0x0A,
	CRYPTO_RANDOMGENERATE           = 0x0B,
	CRYPTO_PLATFORMIDGET            = 0x0C,
};

enum Crypto_VerifyResultType
{
	CRYPTO_E_VER_OK     = 0x00,
	CRYPTO_E_VER_NOT_OK = 0x01,
};

enum Crypto_JobStateType
{
	CRYPTO_JOBSTATE_IDLE   = 0x00,
	CRYPTO_JOBSTATE_ACTIVE = 0x01,
};

struct Crypto_JobPrimitiveInputOutputType
{
	/*const*/ uint8_t               *inputPtr;
	uint32_t                        inputLength;
	/*const*/ uint8_t               *secondaryInputPtr;
	uint32_t                        secondaryInputLength;
	/*const*/ uint8_t               *tertiaryInputPtr;
	uint32_t                        tertiaryInputLength;
	uint8_t                         *outputPtr;
	uint32_t                        *outputLengthPtr;
	uint8_t                         *secondaryOutputPtr;
	uint32_t                        *secondaryOutputLengthPtr;
	uint64_t                        input64;
	enum Crypto_VerifyResultType    *verifyPtr;  // Ptr to
	uint64_t                        *output64Ptr;
	enum Crypto_OperationModeType   mode;
};

enum Crypto_AlgorithmFamilyType
{
	CRYPTO_ALGOFAM_NOT_SET          = 0x00,
	CRYPTO_ALGOFAM_SHA1             = 0x01,
	CRYPTO_ALGOFAM_SHA2_224         = 0x02,
	CRYPTO_ALGOFAM_SHA2_256         = 0x03,
	CRYPTO_ALGOFAM_SHA2_384         = 0x04,
	CRYPTO_ALGOFAM_SHA2_512         = 0x05,
	CRYPTO_ALGOFAM_WHP              = 0x06,
	CRYPTO_ALGOFAM_AES              = 0x14,
	CRYPTO_ALGOFAM_ECCNIST          = 0x19,
	CRYPTO_ALGOFAM_SECURECOUNTER    = 0x1A,
	CRYPTO_ALGOFAM_RNG              = 0x1B,
	CRYPTO_ALGOFAM_ECCNIST_SM2      = 0x1C,
};

enum Crypto_AlgorithmModeType
{
	CRYPTO_ALGOMODE_NOT_SET             = 0x00,
	CRYPTO_ALGOMODE_ECB                 = 0x01,
	CRYPTO_ALGOMODE_CBC                 = 0x02,
	CRYPTO_ALGOMODE_CTR                 = 0x05,
	CRYPTO_ALGOMODE_GCM                 = 0x06,
	CRYPTO_ALGOMODE_XTS                 = 0x07,
	CRYPTO_ALGOMODE_HMAC                = 0x0F,
	CRYPTO_ALGOMODE_CMAC                = 0x10,
	CRYPTO_ALGOMODE_GMAC                = 0x11,
	CRYPTO_ALGOMODE_CTRDRBG             = 0x12,
};

struct Crypto_AlgorithmInfoType
{
	enum Crypto_AlgorithmFamilyType                 family;
	enum Crypto_AlgorithmFamilyType                 secondaryFamily;
	uint32_t                                        keyLength;
	enum Crypto_AlgorithmModeType                   mode;
};

struct Crypto_PrimitiveInfoType
{
	/*const*/ uint32_t                              resultLength;
	/*const*/ enum Crypto_ServiceInfoType           service;
	/*const*/ struct Crypto_AlgorithmInfoType       algorithm;
};

enum Crypto_ProcessingType
{
	CRYPTO_PROCESSING_ASYNC = 0x00,
	CRYPTO_PROCESSING_SYNC  = 0x01,
};

struct Crypto_JobPrimitiveInfoType
{
	/*const*/ uint32_t                              callbackId;
	/*const*/ struct Crypto_PrimitiveInfoType       *primitiveInfo;
	/*const*/ uint32_t                              secureCounterId;
	/*const*/ uint32_t                              cryIfKeyId;
	/*const*/ enum Crypto_ProcessingType            processingType;
	/*const*/ uint8_t                               callbackUpdateNotification; // A boolean value
};

struct Crypto_JobInfoType
{
	/*const*/ uint32_t                              jobId;
	/*const*/ uint32_t                              jobPriority;
};

struct Crypto_JobType
{
	/*const*/ uint32_t                              jobId;
	enum Crypto_JobStateType                        jobState;
	struct Crypto_JobPrimitiveInputOutputType       jobPrimitiveInputOutput;
	/*const*/ struct Crypto_JobPrimitiveInfoType    *jobPrimitiveInfo;
	/*const*/ struct Crypto_JobInfoType             *jobInfo;
	uint32_t                                        cryptoKeyId;
};

typedef enum Std_ReturnType_t
{
	E_OK_1                          = 0x00,
	E_NOT_OK_1                      = 0x01,
	CRYPTO_E_BUSY                   = 0x02,
	CRYPTO_E_SMALL_BUFFER           = 0x03,
	CRYPTO_E_ENTROPY_EXHAUSTION     = 0x04,
	CRYPTO_E_QUEUE_FULL             = 0x05,
	CRYPTO_E_KEY_READ_FAIL          = 0x06,
	CRYPTO_E_KEY_WRITE_FAIL         = 0x07,
	CRYPTO_E_KEY_NOT_AVAILABLE      = 0x08,
	CRYPTO_E_KEY_NOT_VALID          = 0x09,
	CRYPTO_E_KEY_SIZE_MISMATCH      = 0x0A,
	CRYPTO_E_COUNTER_OVERFLOW       = 0x0B,
	CRYPTO_E_JOB_CANCELED           = 0x0C,
} Std_ReturnType;

struct Mtk_JobPrimitiveInfoType
{
	uint32_t                            callbackId;
	struct Crypto_PrimitiveInfoType     primitiveInfo;
	uint32_t                            secureCounterId;
	uint32_t                            cryIfKeyId;
	enum Crypto_ProcessingType          processingType;
	uint8_t                             callbackUpdateNotification; // A boolean value
};

struct Mtk_JobPrimitiveInputOutputType
{
	uint8_t                             *inputPtr;              // V -> P
	uint32_t                            inputLength;
	uint8_t                             *secondaryInputPtr;     // V -> P
	uint32_t                            secondaryInputLength;
	uint8_t                             *tertiaryInputPtr;      // V -> P
	uint32_t                            tertiaryInputLength;
	uint8_t                             *outputPtr;             // V -> P
	uint32_t                            outputLength;
	uint8_t                             *secondaryOutputPtr;    // V -> P
	uint32_t                            secondaryOutputLength;
//    uint64_t                          input64;
//    enum Crypto_VerifyResultType      *verifyPtr;  // Ptr to
//    uint64_t                          *output64Ptr;
//    enum Crypto_OperationModeType     mode;
};

struct Mtk_JobType
{
	uint32_t                                    jobId;
	enum Crypto_JobStateType                    jobState;
	struct Mtk_JobPrimitiveInputOutputType      jobPrimitiveInputOutput;
	struct Mtk_JobPrimitiveInfoType             jobPrimitiveInfo;
	struct Crypto_JobInfoType                   jobInfo;
	uint32_t                                    cryptoKeyId;
};

uint8_t Mtk_ProcessJob    // Std_ReturnType
(
	uint32_t objectId,
	struct Mtk_JobType   *job
);


#endif /* _TEST_CRYPTO_H_ */
