// SPDX-License-Identifier: BSD-2-Clause
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
#ifndef __MTK_KEY_H__
#define __MTK_KEY_H__

#include <stdint.h>

// #define PTA_GPT_TEST_PTA_UUID { 0x472567ad, 0xa180, 0x402c, \
// 			{ 0x50, 0x95, 0x7b, 0x4e, 0xd3, 0xe0, 0x5e, 0x83 } }

#define PTA_MBOX_UUID {0x598e9628, 0xf233, 0x4c83, {0x8d, 0x4c, 0xbd, 0x2f, 0x0a, 0xd4, 0xb2, 0xe4}}

/* command IDs to PTA */
#define PTA_CMD_HSM_GEN_KEY_PAIR        1
#define PTA_CMD_HSM_GEN_SYMM_KEY        2
#define PTA_CMD_HSM_GET_KEY_BLOB        3
#define PTA_CMD_HSM_GET_KEY_TABLE       4
#define PTA_CMD_HSM_REBUILD_KEY_TABLE   5
#define PTA_CMD_HSM_REBUILD_KEY_BLOB    6
#define PTA_CMD_HSM_IMPORT_KEY          7
#define PTA_CMD_HSM_EXPORT_KEY          8
#define PTA_CMD_HSM_SEND_JOB            9
#define PTA_CMD_HSM_DUMP_LOG           10
#define PTA_CMD_HSM_DELETE_KEY         11

/* The return value of key management in HSM */
#define KM_OK                               (0)
#define KM_FAIL                            (-1)
#define KM_ERROR_BAD_ARGUMENTS             (-2)
#define KM_ERROR_GET_SLOT_FAIL             (-3)
#define KM_ERROR_RESOURCE_ALLOCATE_FAIL    (-4)
#define KM_ERROR_DEBLOB_FAIL               (-5)
#define KM_ERROR_ENBLOB_FAIL               (-6)
#define KM_ERROR_INVALID_CURVE             (-7)
#define KM_ERROR_UECC_FAIL                 (-8)
#define KM_ERROR_SET_KEY_FAIL              (-9)
#define KM_ERROR_GET_KEY_FAIL             (-10)
#define KM_ERROR_INTERNAL_ERROR           (-11)
#define KM_ERROR_INVALID_ECC_KEY_PAIR     (-12)

#define MAX_KEY_NUMS (25)

#define KEY_ALGO_ID_AES    1
#define KEY_ALGO_ID_ECC    2

#define MAX_BLOB_SIZE (256)
#define BLOB_HEADER_SIZE (sizeof(key_blob_header))
#define BLOB_MAC_SIZE (16)


typedef struct key_blob_header_t
{
	uint32_t id;
	uint32_t algorithm;
	uint32_t body_size;
} key_blob_header;

typedef struct key_wrapper
{
	uint32_t size;
	uint32_t addr32;
} key_wrapper;

typedef struct key_slot
{
	uint32_t valid;
	uint32_t id;
	uint32_t algorithm;
	key_wrapper key_w;
} key_slot;

/* This structure must be consistent with the one in HSM side */
typedef struct key_table_t
{
	uint32_t is_rebuild_done;
	uint32_t nkeys;
	key_slot slot[MAX_KEY_NUMS];
} key_table;

/* This enum must be consistent with the one in HSM side */
typedef enum uECC_curve_id
{
	UECC_CURVE_ID_UNSUPPORT,
	UECC_CURVE_ID_SECP160R1,
	UECC_CURVE_ID_SECP192R1,
	UECC_CURVE_ID_SECP224R1,
	UECC_CURVE_ID_SECP256R1,
	UECC_CURVE_ID_SECP256K1,
	UECC_CURVE_ID_SECP384R1,
} uECC_curve_id;

typedef struct ecc_keypair_datastruct
{
	uECC_curve_id curve_id;
	uint8_t public[96];
	uint8_t private[48];
	uint8_t reserved[12];
} ecc_keypair_datastruct;

#endif /*__MTK_KEY_H__*/
