// SPDX-License-Identifier: BSD-2-Clause
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef __PROCESSING_MTK_HSM_H
#define __PROCESSING_MTK_HSM_H

#include <assert.h>
#include <sks_internal_abi.h>
#include <sks_ta.h>
#include <string.h>
#include <tee_api_defines.h>
#include <tee_internal_api.h>
#include <tee_internal_api_extensions.h>
#include <util.h>

#include "attributes.h"
#include "object.h"
#include "pkcs11_token.h"
#include "pkcs11_attributes.h"
#include "processing.h"
#include "serializer.h"
#include "sks_helpers.h"


#define PTA_MBOX_UUID     {0x12345678, 0x1234, 0x5678, {0x12, 0x23, 0x34, 0x45, 0x56, 0x67, 0x78, 0x89}}

extern uint32_t mtk_AES_ECB_init(struct pkcs11_session *session,
                                 struct sks_attribute_head *proc_params,
                                 struct sks_object *key);
extern uint32_t mtk_AES_CBC_init(struct pkcs11_session *session,
                                 struct sks_attribute_head *proc_params,
                                 struct sks_object *key);
extern uint32_t mtk_AES_CTR_init(struct pkcs11_session *session,
                                 struct sks_attribute_head *proc_params,
                                 struct sks_object *key);
extern uint32_t mtk_AES_GCM_init(struct pkcs11_session *session,
                                 struct sks_attribute_head *proc_params,
                                 struct sks_object *key);
extern uint32_t mtk_AES_CMAC_init(struct pkcs11_session *session,
                                 struct sks_attribute_head *proc_params,
                                 struct sks_object *key);
extern uint32_t mtk_HMAC_init(struct pkcs11_session *session,
                                 struct sks_attribute_head *proc_params,
                                 struct sks_object *key);
extern uint32_t mtk_ECDSA_init(struct pkcs11_session *session,
                               struct sks_attribute_head *proc_params,
                               struct sks_object *key);
extern uint32_t mtk_SHA_init(struct pkcs11_session *session,
                             struct sks_attribute_head *proc_params);
extern uint32_t mtk_ECDSA_SHA_init(struct pkcs11_session *session,
                               struct sks_attribute_head *proc_params,
                               struct sks_object *key);
extern uint32_t mtk_SHA_step(uint32_t mecha_type,
                             struct pkcs11_session *session,
                             TEE_Param *in, TEE_Param *out,
                             enum processing_func function,
                             enum processing_step step);

extern uint32_t mtk_AES_ECB_step(struct pkcs11_session *session,
                                 TEE_Param *in, TEE_Param *out,
                                 enum processing_func function,
                                 enum processing_step step);
extern uint32_t mtk_AES_CBC_step(struct pkcs11_session *session,
                                 TEE_Param *in, TEE_Param *out,
                                 enum processing_func function,
                                 enum processing_step step);
extern uint32_t mtk_AES_CTR_step(struct pkcs11_session *session,
                                 TEE_Param *in, TEE_Param *out,
                                 enum processing_func function,
                                 enum processing_step step);
extern uint32_t mtk_AES_GCM_step(struct pkcs11_session *session,
                                 TEE_Param *in, TEE_Param *out,
                                 enum processing_func function,
                                 enum processing_step step);
extern uint32_t mtk_AES_CMAC_step(struct pkcs11_session *session,
                                  TEE_Param *in, TEE_Param *out,
                                  enum processing_func function,
                                  enum processing_step step);
extern uint32_t mtk_SHA256_HMAC_step(struct pkcs11_session *session,
                                     TEE_Param *in, TEE_Param *inout,
                                     enum processing_func function,
                                     enum processing_step step);
extern uint32_t mtk_SHA384_HMAC_step(struct pkcs11_session *session,
                                     TEE_Param *in, TEE_Param *inout,
                                     enum processing_func function,
                                     enum processing_step step);
extern uint32_t mtk_ECDSA_step(struct pkcs11_session *session,
                                     TEE_Param *in, TEE_Param *inout,
                                     enum processing_func function,
                                     enum processing_step step);
extern uint32_t mtk_ECDSA_SHA_step(struct pkcs11_session *session,
                                     TEE_Param *in, TEE_Param *inout,
                                     enum processing_func function,
                                     enum processing_step step);

extern uint32_t mtk_generate_random(TEE_Param *out);

extern uint32_t mtk_dump_hsm_log(void);

#endif // __PROCESSING_MTK_HSM_H
