/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __MBOX_COMMON_H__
#define __MBOX_COMMON_H__

#include <stdint.h>
// #include <drStd.h>
// #include <DrApi/DrApi.h>
// #include <DrApi/DrApiLogging.h>
// #include <DrApi/DrApiThread.h>
#include "drCommon.h"

#include "tee_common.h"
#include "mbox_hw.h"
#include "mbox_sw.h"
#include "reg_op.h"
#include "processor.h"
#include "system_event.h"

#define MBOX_DEBUG      0

#if MBOX_DEBUG
#define TEE_MBOX_DEBUG(string, args...)            \
	if(1) {                                   \
		drDbgPrintf("[MBOX]"string, ##args);  \
	}
#else
#define TEE_MBOX_DEBUG(string, args...)
#endif

#define TEE_MBOX_ERR(string, args...)              \
	if(1) {                                   \
		drDbgPrintf("[MBOX]"string, ##args);  \
	}

#endif  // __MBOX_COMMON_H__
