/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __MBOX_DRV_H__
#define __MBOX_DRV_H__

#include <stdint.h>
#include "processor.h"

#define MBOX_SUCC 		0
#define MBOX_FAIL 		-1

#define MBOX_MSG_ID_MIN 	0U
#define MBOX_MSG_ID_MAX 	31U
#define MBOX_INVALID 		0xFFU

#define MBOX_REGION_SIZE_MIN 	0U
#define MBOX_REGION_SIZE_MAX 	32U

enum mbox_regions {
	MBOX_REGION_0,
	MBOX_REGION_1,
	MBOX_REGION_2,
	MBOX_REGION_3,
	MBOX_REGION_RX,
	MBOX_DOMAIN_CNT,
	MBOX_REGION_INVALID = -1,
};

/* Give boundary of r0,r1,r2, then the rest space is for r3 */
#define MBOX_BOUNDARY_01	0U
#define MBOX_BOUNDARY_12	1U
#define MBOX_BOUNDARY_CNT	2U

#define ISR(x) void x(void)

// extern void mbox_init(void);
extern void mbox_deinit(void);
// extern void mbox_write(int idx, int val);
// extern void mbox_read(int idx, uint32_t *pmsg);
extern void mbox_irq_done(void);

extern void mbox_init(enum CPU_SERIAL cpu_serial, void (*p_mbox_msg_isr)(uint8_t msg_id));

extern void mbox_msg_tx(enum CPU_SERIAL send_to, uint8_t msg_id, uint32_t msg);
extern void mbox_msg_rx(enum CPU_SERIAL send_to, uint8_t msg_id, uint32_t *pmsg);

extern void mbox_set_ca53_intr_msg_id(uint8_t msg_id);

#endif //__MBOX_DRV_H__
