/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __MBOX_HW_H__
#define __MBOX_HW_H__

#if defined(PLATFORM_FLAVOR_mt2731)
// #include "reg_base.h"

#define IO_PHYS  0x10000000

#define HSM_MBOX_BASE       (IO_PHYS + 0x00651000)
#define HSM_ERMST_BASE      (IO_PHYS + 0x00650000)

#define MBOX_REGISTER_RANGE           0x180
#define ERMST_REGISTER_RANGE          0x28

#define IVALID_IRQ_ID               0
#define ERM_IRQ_ID                196//SYSCIRQ 91

#define ERM_LBIST_BIT             2

#define CA53_INTR_MSG_ID          15

#define INVALID_MBOX_E_IRQ        (-1)

#elif defined (PLATFORM_FLAVOR_mt2735)

#define IO_PHYS  0x10000000

#define HSM_MBOX_BASE       (IO_PHYS + 0x06651000)
#define HSM_ERMST_BASE      (IO_PHYS + 0x06650000)

#define MBOX_REGISTER_RANGE           0x180
#define ERMST_REGISTER_RANGE          0x28

#define IVALID_IRQ_ID               0
#define ERM_IRQ_ID                334// SYSCIRQ 238

#define ERM_LBIST_BIT             2

#define CA53_INTR_MSG_ID          15

#define INVALID_MBOX_E_IRQ        (-1)

#endif

#endif //__MBOX_HW_H__