/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _MBOX_SERV_H_
#define _MBOX_SERV_H_

#include <stdbool.h>
#include <stdint.h>
#include "system_event.h"

#define MBOX_SERV_EVENT_ID_MASK	0xffUL

#define MBOX_SERV_ENTRY_CNT     2U
#define MBOX_SERV_QUEUE_SIZE    8U

#define MBOX_SERV_JOB_IN_ACTIVE         (1)
#define MBOX_SERV_OK                    (0)
#define MBOX_SERV_ERR_FAIL              (-1)
#define MBOX_SERV_ERR_BUSY              (-2)
#define MBOX_SERV_ERR_Q_FULL            (-3)
#define MBOX_SERV_ERR_NO_REGISTRY       (-4)
#define MBOX_SERV_ERR_INVALID_ID        (-5)
#define MBOX_SERV_ERR_NO_RES            (-6)
#define MBOX_SERV_ERR_REMOTE_FAIL       (-7)
#define MBOX_SERV_ERR_NO_JOB_CANCELED   (-8)

#define MBOX_SERV_CBK_STATUS_IDLE    (0)
#define MBOX_SERV_CBK_STATUS_ENABLE  (1)
#define MBOX_SERV_CBK_STATUS_DISABLE (2)

#define MBOX_SERV_FEEDBACK_INIT_VAL     (0x33)
#define MBOX_SERV_FEEDBACK_MAGIC_NUM    (0xAD)
#define MBOX_SERV_FEEDBACK_VERIFY_FAIL  (0xDC)

struct mbox_callback
{
	uint32_t status;
	void (*fpCallback)(void);
};

struct mbox_serv_queue {
	uint8_t in_idx;
	uint8_t out_idx;
	struct sys_event event[MBOX_SERV_QUEUE_SIZE];
};

struct mbox_serv_registry {
	uint32_t task_id;
	uint32_t rx_mask;
	struct mbox_callback cbk;
	struct mbox_serv_queue *q;
};

void mbox_serv_init(void);
int8_t mbox_serv_register_event(uint8_t event_id,
				const struct mbox_serv_registry *registry);
int8_t mbox_serv_tx(const struct sys_event *event);
struct sys_event* mbox_serv_rx(struct mbox_serv_queue * const q);
// void mbox_serv_set_region(int8_t lock_enable);
void mbox_serv_dequeue(struct mbox_serv_queue *const q);

#endif //_MBOX_SERV_H_
