/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __MBOX_SW_H__
#define __MBOX_SW_H__

struct mbox_reg {
	uint32_t msg_pending;     //0x00
	uint32_t msg_irq_en;      //0x04
	uint32_t ns_domain_cfg;   //0x08
	uint32_t reserved0;       //0x0c
	uint32_t region_size;     //0x10
	uint32_t region_err;      //0x14
	uint32_t region_irq_en;   //0x18
	uint32_t reserved1[57];   //0x20
	uint32_t msg[32];         //0x100~0x180
};

struct erm_reg {
	uint32_t pending;           //0x00
	uint32_t irq_en;            //0x04
	uint32_t irq_set;           //0x08
	uint32_t reserved0;         //0x0c
	uint32_t gdma_sram_tsel;    //0x10
	uint32_t mcu_sram_tsel;     //0x14
	uint32_t mcu_dcls_mask_h;   //0x18
	uint32_t mcu_dcls_mask_l;   //0x1c
	uint32_t eco1;              //0x20
	uint32_t eco2;              //0x24
};

#endif //__MBOX_SW_H__