// SPDX-License-Identifier: BSD-2-Clause

/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>
#include <kernel/delay.h>
#include <tee/cache.h>
#include "buddy.h"
#include "address.h"
#include "sync_obj.h"

/* map physical address from CA53 to HSM */
int hsm_addr_remap(uint32_t phyaddr, uint32_t *p_remaped)
{
	uint32_t hbit = (phyaddr & 0xf0000000) >> 28;
	int ret = 0;

	switch (hbit)
	{
	case 0x0:
		*p_remaped = phyaddr | 0x90000000;
		break;
	case 0x1:
		*p_remaped = phyaddr | 0xf0000000;
		break;
	case 0x2:
	case 0x3:
		ret = -1;
		break;
	case 0x4:
	case 0x5:
	case 0x6:
	case 0x7:
	case 0x8:
	case 0x9:
	case 0xa:
	case 0xb:
		*p_remaped = phyaddr - 0x30000000;
		break;
	case 0xc:
	case 0xd:
	case 0xe:
	case 0xf:
		*p_remaped = phyaddr - 0x20000000;
		break;
	default:
		break;
	}
	return ret;
}

int allocate_sync_handle(sync_handle *handle)
{
	uint32_t *phsm;
	addr_t *p = handle;
	int ret = buddy_malloc(sizeof(sync_object), p);
	if (ret != BUDDY_OK) {
		EMSG("[\x1b[31m%s\033[0m][%d] buddy_malloc fail \n", __FUNCTION__, __LINE__);
		return -1;
	}

	memset(p->va, 0, sizeof(sync_object));
	if (cache_operation(TEE_CACHEFLUSH, p->va, sizeof(sync_object)) != TEE_SUCCESS)
		EMSG("\x1b[31m == TEE_CACHEFLUSH FAIL!! == \033[0m\n");

	hsm_addr_remap(p->pa, &phsm);
	p->ha = phsm;

	// IMSG("[\x1b[31m%s\033[0m][%d] p->pa : 0x%x\n", __FUNCTION__, __LINE__, p->pa);
	// IMSG("[\x1b[31m%s\033[0m][%d] p->va : 0x%x\n", __FUNCTION__, __LINE__, p->va);
	// IMSG("[\x1b[31m%s\033[0m][%d] p->ha : 0x%x\n", __FUNCTION__, __LINE__, p->ha);

	return 0;
}

int release_sync_handle(sync_handle *handle)
{
	addr_t *p = handle;
	buddy_free(p);

	return 0;
}

void wait_remote_sync_done(sync_handle *handle)
{
	sync_object *psyncobj;
	addr_t *p = handle;

	psyncobj = (sync_object *)p->va;

	while (1) {

		if (cache_operation(TEE_CACHEINVALIDATE, psyncobj, sizeof(sync_object)) != TEE_SUCCESS)
			EMSG("\x1b[31m == CACHE FAIL!! == \033[0m\n");

		if (psyncobj->done == 1)
			break;

		mdelay(1);
	}
}

void *get_hsm_address(sync_handle *p)
{
	return p->ha;
}

int get_hsm_return_value(sync_handle *p)
{
	sync_object *psyncobj;

	psyncobj = (sync_object *)p->va;
	if (cache_operation(TEE_CACHEINVALIDATE, psyncobj, sizeof(sync_object)) != TEE_SUCCESS)
		EMSG("\x1b[31m == CACHE FAIL!! == \033[0m\n");

	return psyncobj->status;
}

void cclean_and_memcopy(void *dest, addr_t *src, size_t n)
{
	uint8_t *vsrc;
	vsrc = (uint8_t *)src->va;
	if (cache_operation(TEE_CACHEINVALIDATE, vsrc, n) != TEE_SUCCESS)
		EMSG("\x1b[31m == CACHE FAIL!! == \033[0m\n");

	memcpy(dest, vsrc, n);
}

void memput_and_cclean(addr_t *dest, void *src, size_t n)
{
	uint8_t *vdst;
	vdst = (uint8_t *)dest->va;

	memcpy(vdst, src, n);

	if (cache_operation(TEE_CACHECLEAN, vdst, n) != TEE_SUCCESS)
		EMSG("\x1b[31m == CACHE FAIL!! == \033[0m\n");
}


int physical_malloc(uint32_t size, addr_t *addr)
{
	addr_t tmp = {0};

	if (addr == NULL) {
		goto fail;
	}

	if (buddy_malloc(size, &tmp) != BUDDY_OK) {
		goto fail;
	}

	if (hsm_addr_remap(tmp.pa, &tmp.ha) != 0) {
		goto fail;
	}

ok:
	memcpy(addr, &tmp, sizeof(addr_t));
	return 0;
fail:
	if (tmp.va != NULL) {
		buddy_free(&tmp);
	}
	return -1;
}


void physical_free(addr_t *addr)
{
	if (addr == NULL) {
		return;
	}
	buddy_free(addr);
}