/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <pta_dapc.h>
#include <dapc_public.h>
//#include <initcall.h>
#include <io.h>
#include <kernel/pseudo_ta.h>
//#include <kernel/interrupt.h>
//#include <mm/core_memprot.h>
//#include <mm/core_mmu.h>
#include <tee_api_defines.h>

/* Static Function */
static TEE_Result invoke_command(void *pSessionContext __unused,
				 uint32_t nCommandID, uint32_t nParamTypes,
				 TEE_Param pParams[TEE_NUM_PARAMS])
{
	uint32_t p1, p2, p3;
	int ret;

	EMSG("DEVAPC nCommandID(%x)\n", nCommandID);

	switch (nCommandID) {
	case PTA_CMD_DAPC_TEST:
		EMSG("DEVAPC test command\n");

		if (TEE_PARAM_TYPE_GET(nParamTypes, 0) != TEE_PARAM_TYPE_VALUE_INOUT)
			return TEE_ERROR_BAD_PARAMETERS;

		p1 = pParams[0].value.a;
		p2 = pParams[0].value.b;
		EMSG("input value p1: %u, p2: %u\n", p1, p2);

		return TEE_SUCCESS;

	case PTA_CMD_DAPC_MASTER_TEST:
		EMSG("DEVAPC try to set master transaction...\n");

		p1 = pParams[0].value.a;
		p2 = pParams[1].value.a;
		EMSG("input value p1: %u, p2: %u\n", p1, p2);

        set_master_transaction(p1 ,p2);
		dump_devapc();

		return TEE_SUCCESS;

	case PTA_CMD_DAPC_SLAVE_APC_TEST:
		EMSG("DEVAPC try to set module apc...\n");

		p1 = pParams[0].value.a;
		p2 = pParams[1].value.a;
		p3 = pParams[2].value.a;
		EMSG("input value p1: %u, p2: %u, p3: %u\n", p1, p2, p3);

		set_module_apc(p1, p2, p3);
		dump_devapc();

		return TEE_SUCCESS;
	default:
		break;
	}

	return TEE_ERROR_NOT_IMPLEMENTED;
}

pseudo_ta_register(.uuid = PTA_DAPC_UUID, .name = "pta_dapc",
		   .flags = PTA_DEFAULT_FLAGS,
		   .invoke_command_entry_point = invoke_command);
