/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <kernel/pseudo_ta.h>
#include <kernel/thread.h>
#include <kernel/interrupt.h>
#include <kernel/misc.h>
#include <mm/core_memprot.h>
#include <kernel/tee_time.h>
#include <io.h>
#include "gpt.h"
// #include <initcall.h>

register_phys_mem(MEM_AREA_IO_NSEC, GPT_BASE, GPT_SIZE);
vaddr_t gpt_base;
extern bool itr_set_polarity(unsigned int irq, unsigned int polarity);

void dump_gpt(void){
	DMSG("-------------gpt dump start---------------------");
	DMSG("GPT_IRQEN:%x at %p", read32(gpt_base+GPT_IRQEN),gpt_base+GPT_IRQEN);
	DMSG("GPT_IRQSTA:%x at %p", read32(gpt_base+GPT_IRQSTA),gpt_base+GPT_IRQSTA);
	DMSG("GPT_IRQACK:%x at %p", read32(gpt_base+GPT_IRQACK),gpt_base+GPT_IRQACK);
	int i=0;
	for (i=0;i<6;i++){
		DMSG("GPT(%d) GPT_CON:%x at %p", i, read32(gpt_base+GPT_CON(i)), gpt_base+GPT_CON(i));
		DMSG("GPT(%d) GPT_CLK:%x at %p", i, read32(gpt_base+GPT_CLK(i)), gpt_base+GPT_CLK(i));
		DMSG("GPT(%d) GPT_COUNT:%x at %p", i, read32(gpt_base+GPT_COUNT(i)), gpt_base+GPT_COUNT(i));
		DMSG("GPT(%d) GPT_COMPARE:%x at %p", i, read32(gpt_base+GPT_COMPARE(i)), gpt_base+GPT_COMPARE(i));
	}
	DMSG("-------------gpt dump end---------------------");
}
void gpt_irqen(uint8_t gpt_num)
{
	uint32_t value = read32(gpt_base+GPT_IRQEN);
	value |= (1<<(gpt_num));
	write32(value, gpt_base+GPT_IRQEN);
	DMSG("write %x to %p", value, gpt_base+GPT_IRQEN);
}

void gpt_irqdisableall(void)
{
	write32(0, gpt_base+GPT_IRQEN);
	DMSG("write %x to %p", 0, gpt_base+GPT_IRQEN);
}

void gpt_irqackall(void)
{
	write32(0x3F, gpt_base+GPT_IRQACK);
	DMSG("write %x to %p", 0x3F, gpt_base+GPT_IRQEN);
}

void gpt_reset(uint8_t gpt_num)
{
	write32(0x2, gpt_base+GPT_CON(gpt_num));
	write32(0, gpt_base+GPT_CLK(gpt_num));
	write32(0, gpt_base+GPT_COMPARE(gpt_num));
}

uint8_t gpt_irqsta_all()
{
	return read32(gpt_base+GPT_IRQSTA);
}

uint8_t gpt_irqsta(uint8_t gpt_num)
{
	return (read32(gpt_base+GPT_IRQSTA) & (1<<gpt_num));
}

void gpt_ackirq(uint8_t gpt_num)
{
	write32((0x1<<gpt_num), gpt_base+GPT_IRQACK);
}

void gpt_enable(uint8_t gpt_num, uint8_t mode)
{
    //clear
	write32(0x2, gpt_base+GPT_CON(gpt_num));
	uint32_t value = (mode & 0x30) | 0x1;
	DMSG("write %x to %p", value, gpt_base+GPT_CON(gpt_num));
	write32(value, gpt_base+GPT_CON(gpt_num));
}

void gpt_set_compare(uint8_t gpt_num, uint32_t value)
{
	DMSG("write %x to %p", value, gpt_base+GPT_COMPARE(gpt_num));
	write32(value, gpt_base+GPT_COMPARE(gpt_num));
}

static enum itr_return gpt_itr_cb(struct itr_handler *h)
{
    uint8_t data = *((uint8_t*)(h->data));
	EMSG("cpu %zu: got gpt interrupt for gpt :%d.", get_core_pos(), data);
	//dump_gpt();
	gpt_ackirq(data);
	//dump_gpt();
    return ITRR_HANDLED;
}

uint8_t gpt_itr_data = 0;
static struct itr_handler gpt_itr = {
        .it = IT_GPT_NUMBER,
        .flags = ITRF_TRIGGER_LEVEL,
        .handler = gpt_itr_cb,
		.data = &gpt_itr_data,
};
KEEP_PAGER(gpt_itr);

static TEE_Result init_gpt_itr(uint8_t gpt_num)
{
    *((uint8_t*)(gpt_itr.data)) = gpt_num;
	itr_add(&gpt_itr);
	/*!!!!!!!!!!!!!!!!!!!!!!!!!!!Attention!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
	// This is for mtk mt2712 platform specificlly.
	// If the irq is low level trigger, need to invert the trigger polarity.
	/*!!!!!!!!!!!!!!!!!!!!!!!!!!!Attention!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
	itr_set_polarity(IT_GPT_NUMBER, (gpt_itr.flags & ITRF_TRIGGER_LEVEL)==ITRF_TRIGGER_LEVEL);
    itr_enable(IT_GPT_NUMBER);
    return TEE_SUCCESS;
}

void gpt_init(uint8_t gpt_num, uint32_t time)
{
	gpt_base = (vaddr_t)phys_to_virt_io(GPT_BASE);
	IMSG("gpt_base: %p\n", gpt_base);
	//dump_gpt();
	// Clear the status of gpt as they may used in NWD.
	gpt_irqdisableall();
	gpt_irqackall();
	gpt_reset(0);
	gpt_reset(1);
	gpt_set_compare(gpt_num, time*13000000);
	init_gpt_itr(gpt_num);
	gpt_irqen(gpt_num);
	gpt_enable(gpt_num, 0/*mode*/);
	//dump_gpt();
}

static TEE_Result invoke_command(void *pSessionContext __unused,
				 uint32_t nCommandID, uint32_t nParamTypes,
				 TEE_Param pParams[TEE_NUM_PARAMS])
{
	IMSG("GPT nCommandID(%x)\n", nCommandID);
	switch (nCommandID) {
	case PTA_CMD_GPT_INIT:
		if (TEE_PARAM_TYPE_GET(nParamTypes, 0) !=
			TEE_PARAM_TYPE_VALUE_INPUT)
			return TEE_ERROR_BAD_PARAMETERS;
		uint32_t gpt_num = pParams[0].value.a;
		uint32_t time_value = pParams[0].value.b;
		IMSG("input value gpt num:%d, time:%d s\n", gpt_num, time_value);
		gpt_init(gpt_num, time_value);
		return TEE_SUCCESS;

	default:
		break;
	}

	return TEE_ERROR_NOT_IMPLEMENTED;
}

pseudo_ta_register(.uuid = PTA_GPT_TEST_PTA_UUID, .name = "gpt",
		   .flags = PTA_DEFAULT_FLAGS,
		   .invoke_command_entry_point = invoke_command);

