// SPDX-License-Identifier: BSD-2-Clause
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * Copyright  (C) 2020  MediaTek Inc. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>
#include <io.h>
#include <kernel/delay.h>
#include <tee/cache.h>
#include <optee_msg.h>
#include <mm/core_memprot.h>
#include "hsm_dump.h"
#include "share_memmap.h"

#define OPTEE_BUFFER_SHIFT (24) // specific for optee
#define HSM_LOG_FMT_BUF_LEN 256UL

#define HSM_LOG_BUF_LEN     (LOG_BUF_LEN - sizeof(struct hsm_log))  /* 16KB  - size of log buffer var*/
#define HSM_LOG_BUF_BASE    (JOB_PHYSICAL_BUF_BASE - HSM_LOG_BUF_LEN)
#define HSM_LOG_BUF_VAR_LEN     (sizeof(struct hsm_log))  /* size of log buffer var */
#define HSM_LOG_BUF_VAR_BASE    (HSM_LOG_BUF_BASE - HSM_LOG_BUF_VAR_LEN)

struct hsm_log {
	uint64_t log_next_seq;
	uint64_t log_next_idx;
	uint64_t log_first_seq;
	uint64_t log_first_idx;
} __attribute__ ((packed));

struct log_header {
	uint32_t next_idx;
	uint32_t text_len;
	uint32_t log_len;
	int32_t  loglevel;
};

uint8_t *gvBuffAddr = NULL;
uint8_t *gvBuffVarAddr = NULL;

static inline uint8_t *log_text(const struct log_header *msg)
{
	return (uint8_t *)msg + sizeof(struct log_header);
}

static void flush_to_console(uint8_t *msg, uint32_t len)
{
	uint32_t i = 0;
	unsigned char str[256];
	memset(str, 0, sizeof(str));
	if (len > 255)
	{
		IMSG("ingore messge!!!");
	}

	for (i = 0; i < len; i++)
	{
		str[i] = *((char *)msg + i);
		// IMSG("[%s][%d]\r\n", __FUNCTION__, __LINE__);
	}
	str[i] = '\0';
	IMSG("%s", str);
	mdelay(1);
}

static int clean_and_invalidate_log_buffer(void)
{
	if (gvBuffAddr == NULL || gvBuffVarAddr == NULL)
	{
		EMSG("== BUFFER NULL!! ==\n");
		return -1;
	}
	if (cache_operation(TEE_CACHECLEAN, gvBuffAddr, HSM_LOG_BUF_LEN) != TEE_SUCCESS)
	{
		EMSG("== CACHE FAIL!! ==\n");
		return -1;
	}
	if (cache_operation(TEE_CACHEINVALIDATE, gvBuffAddr, HSM_LOG_BUF_LEN) != TEE_SUCCESS)
	{
		EMSG("== CACHE INVALIDATE FAIL!! ==\n");
		return -1;
	}
	if (cache_operation(TEE_CACHECLEAN, gvBuffVarAddr, HSM_LOG_BUF_VAR_LEN) != TEE_SUCCESS)
	{
		EMSG("== CACHE FAIL!! ==\n");
		return -1;
	}
	if (cache_operation(TEE_CACHEINVALIDATE, gvBuffVarAddr, HSM_LOG_BUF_VAR_LEN) != TEE_SUCCESS)
	{
		EMSG("== CACHE INVALIDATE FAIL!! ==\n");
		return -1;
	}
	return 0;
}

int hsm_dump_init(void)
{
	core_mmu_add_mapping(MEM_AREA_RAM_SEC, HSM_LOG_BUF_BASE, HSM_LOG_BUF_LEN);
	gvBuffAddr = (vaddr_t)phys_to_virt(HSM_LOG_BUF_BASE, MEM_AREA_RAM_SEC);

	if (gvBuffAddr == NULL)
	{
		EMSG("[%s][%d] memory map fail.\r\n", __FUNCTION__, __LINE__);
		return -1;
	}

	core_mmu_add_mapping(MEM_AREA_RAM_SEC, HSM_LOG_BUF_VAR_BASE, HSM_LOG_BUF_VAR_LEN);
	gvBuffVarAddr = (vaddr_t)phys_to_virt(HSM_LOG_BUF_VAR_BASE, MEM_AREA_RAM_SEC);

	if (gvBuffVarAddr == NULL)
	{
		EMSG("[%s][%d] memory map fail.\r\n", __FUNCTION__, __LINE__);
		return -1;
	}

	return 0;
}


int hsm_dump_log(void)
{
	struct hsm_log *Buff_log_Var_Addr;
	uint32_t local_idx;
	uint64_t local_first_seq;
	struct log_header *msg;
	volatile uint64_t *log_first_idx;
	volatile uint64_t *log_first_seq;
	volatile uint64_t *log_next_seq;

	if(clean_and_invalidate_log_buffer() != 0)
	{
		EMSG("[%s][%d] clean & invalidate fail.\r\n", __FUNCTION__, __LINE__);
		return -1;
	}

	msg = (struct log_header *)gvBuffAddr;
	Buff_log_Var_Addr = (struct hsm_log *)gvBuffVarAddr;

	log_first_idx = (uint32_t *) & (Buff_log_Var_Addr->log_first_idx);
	log_first_seq = &(Buff_log_Var_Addr->log_first_seq);
	log_next_seq = &(Buff_log_Var_Addr->log_next_seq);

	local_idx = *log_first_idx;
	local_first_seq = *log_first_seq;
	while (local_first_seq < *log_next_seq) {
		msg = (struct log_header *)(gvBuffAddr + local_idx);

		/* The log entry may be overwritten by the new log entry and
		 * the header becomes invalid due to slow UART TX speed.
		 * IF the header meets following conditions, we assume that
		 * the log entry is courrupted.
		 * 1. The text length is greater then LOG_FMT_BUF_LEN.
		 * 2. The text buffer address is out of range.
		 */

		if ((msg->log_len > HSM_LOG_FMT_BUF_LEN) ||
		        (log_text(msg) > (gvBuffAddr + HSM_LOG_BUF_LEN)) ||
		        (log_text(msg) < gvBuffAddr)) {
			IMSG("[%s][%d]\r\n", __FUNCTION__, __LINE__);
			break;
		}

		flush_to_console((uint8_t *)log_text(msg), msg->text_len);
		local_idx = msg->next_idx;
		local_first_seq++;
	}

	return 0;
}
