// SPDX-License-Identifier: BSD-2-Clause
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <io.h>
#include <kernel/pseudo_ta.h>
#include <tee_api_defines.h>
#include <kernel/thread.h>
#include <kernel/interrupt.h>
#include <kernel/misc.h>
#include <mm/core_memprot.h>
#include <kernel/tee_time.h>

// For memcpy
#include <string.h>

// For cache clean and invalidate
#include <mm/core_memprot.h>
#include <mm/core_mmu.h>
#include <tee/cache.h>

#include "hsm_mbox_if.h"
#include "hsm_if_impl.h"
#include "hsm_pta_debug.h"
#include "system_event.h"
#include "mbox_serv.h"
#include "mtk_crypto.h"

#include "buddy.h"
#include "share_memmap.h"
#include "sync_obj.h"
#include "hsm_dump.h"

extern vaddr_t mbox_io_buf_base;

static void _pta_hsm_gen_key_pair_handler(TEE_Param *pParams)
{
	int *phsmret, *pkeyid;
	int size;
	int uECC_curve_id;

	phsmret = (int*)pParams[0].value.a;
	size = (int)pParams[0].value.b;
	uECC_curve_id = (int)pParams[1].value.a;
	pkeyid = (int*)pParams[1].value.b;

	*phsmret = hsm_gen_key_pair(size, uECC_curve_id, pkeyid);

	return;
}

static void _pta_hsm_gen_symm_key_handler(TEE_Param *pParams)
{
	int *phsmret, *pkeyid;
	int key_size;

	phsmret = (int*)pParams[0].value.a;
	pkeyid = (int*)pParams[0].value.b;
	key_size = (int)pParams[1].value.a;

	*phsmret = hsm_gen_symm_key(key_size, pkeyid);

	return;
}

static void _pta_hsm_get_key_blob_handler(TEE_Param *pParams)
{
	int *phsmret, *pblobsize;
	int buf_size, key_id, algo_id;
	uint8_t *buffer;

	phsmret = (int*) pParams[0].value.a;
	key_id = (int) pParams[0].value.b;
	buffer = (uint8_t *) pParams[1].value.a;
	buf_size = (int) pParams[1].value.b;
	algo_id = (int) pParams[2].value.a;
	pblobsize = (int*) pParams[2].value.b;

	*phsmret = hsm_get_key_blob(buffer, buf_size, key_id, algo_id, pblobsize);

	return;
}

static void _pta_hsm_get_key_table_handler(TEE_Param *pParams)
{
	int *phsmret, *ptablesize;
	int buf_size;
	uint8_t *buffer;

	phsmret = (int*)pParams[0].value.a;
	buffer = (uint8_t *)pParams[0].value.b;
	buf_size = (int)pParams[1].value.a;
	ptablesize = (int*)pParams[1].value.b;

	*phsmret = hsm_get_key_table(buffer, buf_size, ptablesize);

	return;
}

static void _pta_hsm_rebuild_key_table_handler(TEE_Param *pParams)
{
	int *phsmret;
	int table_size;
	uint8_t *buffer;

	phsmret = (int*)pParams[0].value.a;
	buffer = (uint8_t *)pParams[0].value.b;
	table_size = (int)pParams[1].value.a;

	*phsmret = hsm_rebuild_key_table(buffer, table_size);

	return;
}

static void _pta_hsm_rebuild_key_blob_handler(TEE_Param *pParams)
{
	int *phsmret;
	int blob_size;
	int key_id;
	uint8_t *buffer;

	phsmret = (int*)pParams[0].value.a;
	buffer = (uint8_t *)pParams[0].value.b;
	blob_size = (int)pParams[1].value.a;
	key_id = (int)pParams[1].value.b;

	*phsmret = hsm_rebuild_key_blob(buffer, blob_size, key_id);

	return;
}


static void _pta_hsm_import_key(TEE_Param *pParams)
{
	int *phsmret;
	uint8_t *keybuffer;
	int size;
	int *pkeyid;
	int algo_id;

	phsmret = (int*)pParams[0].value.a;
	keybuffer = (uint8_t *)pParams[0].value.b;
	size = (int)pParams[1].value.a;
	pkeyid = (int*)pParams[1].value.b;
	algo_id = (int*)pParams[2].value.a;

	*phsmret = hsm_import_key(keybuffer, size, pkeyid, algo_id);

	return;
}

static void _pta_hsm_export_key(TEE_Param *pParams)
{
	int *phsmret;
	uint8_t *pblob;
	uint32_t blobsize;
	uint8_t *ppubkey;
	uint32_t *ppubkeylength;

	phsmret = (int*)pParams[0].value.a;
	pblob = (uint8_t *)pParams[0].value.b;
	blobsize = (int)pParams[1].value.a;
	ppubkey = (uint8_t *)pParams[1].value.b;
	ppubkeylength = (int*)pParams[2].value.a;

	*phsmret = hsm_export_key(pblob, blobsize, ppubkey, ppubkeylength);

	return;
}

static void _pta_hsm_send_job_handler(TEE_Param *pParams)
{
	int *phsmret;
	job_struct *pjob;
	uint32_t in_size;

	pjob = (job_struct *)(pParams[0].value.a);
	in_size = pParams[0].value.b;
	phsmret = (int*)pParams[1].value.a;

	*phsmret = hsm_send_job(pjob);
}

static void _pta_hsm_delete_key(TEE_Param *pParams)
{
	int *phsmret;
	uint32_t keyid;

	phsmret = (int*)pParams[0].value.a;
	keyid = (uint32_t)pParams[0].value.b;

	*phsmret = hsm_delete_key(keyid);

	return;
}

TEE_Result TA_CreateEntryPoint(void)
{
	static int inited = 0;

	if (inited)
		return TEE_SUCCESS;

	/* Allocate some resources, init something, ... */
	mbox_serv_init();
	hsm_dump_init();
	buddy_init();

	core_mmu_add_mapping(MEM_AREA_RAM_SEC, HSM_ALL_IO_BUF_BASE, HSM_ALL_IO_BUF_LEN);
	mbox_io_buf_base = (vaddr_t)phys_to_virt(HSM_ALL_IO_BUF_BASE, MEM_AREA_RAM_SEC);

	inited = 1;

	/* Return with a status */
	return TEE_SUCCESS;
}

void TA_DestroyEntryPoint(void)
{
	/* Release resources if required before TA destruction */
}

/* Static Function */
static TEE_Result invoke_command(void *pSessionContext __unused,
                                 uint32_t nCommandID, uint32_t nParamTypes,
                                 TEE_Param pParams[TEE_NUM_PARAMS])
{
	if(pParams == NULL){
		return TEE_ERROR_BAD_PARAMETERS;
	}

	HSM_PTA_DEBUG("\x1b[1;31m MBOX receives nCommandID(%x)  \033[0m\n", nCommandID);

	switch (nCommandID)
	{
	case PTA_CMD_HSM_SEND_JOB:
		_pta_hsm_send_job_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_GEN_KEY_PAIR:
		_pta_hsm_gen_key_pair_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_GEN_SYMM_KEY:
		_pta_hsm_gen_symm_key_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_GET_KEY_BLOB:
		_pta_hsm_get_key_blob_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_GET_KEY_TABLE:
		_pta_hsm_get_key_table_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_REBUILD_KEY_TABLE:
		_pta_hsm_rebuild_key_table_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_REBUILD_KEY_BLOB:
		_pta_hsm_rebuild_key_blob_handler(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_IMPORT_KEY:
		_pta_hsm_import_key(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_EXPORT_KEY:
		_pta_hsm_export_key(pParams);
		return TEE_SUCCESS;

	case PTA_CMD_HSM_DUMP_LOG:
		hsm_dump_log();
		return TEE_SUCCESS;

	case PTA_CMD_HSM_DELETE_KEY:
		_pta_hsm_delete_key(pParams);
		return TEE_SUCCESS;

	default:
		break;
	}

	return TEE_ERROR_NOT_IMPLEMENTED;
}

pseudo_ta_register(.uuid = PTA_MBOX_UUID, .name = "mbox",
                   .flags = PTA_DEFAULT_FLAGS,
                   .invoke_command_entry_point = invoke_command,
                   .create_entry_point = TA_CreateEntryPoint,
                   .destroy_entry_point = TA_DestroyEntryPoint);

