/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2018. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef _REG_OP_H_
#define _REG_OP_H_

#include <stdint.h>

#define BIT(x) ((0x1ul) << ((uint32_t)(x)))

#ifndef read8
#define read8(addr) (*(volatile uint8_t*)(addr))
#endif
#ifndef write8
#define write8(addr, val) ((*(volatile uint8_t*)(addr)) = (val))
#endif

#ifndef read16
#define read16(addr) (*(volatile uint16_t*)(addr))
#endif
#ifndef write16
#define write16(addr, val) ((*(volatile uint16_t*)(addr)) = (val))
#endif

#ifndef read32
#define read32(addr) (*(volatile uint32_t*)(addr))
#endif
#ifndef write32
#define write32(addr, val) ((*(volatile uint32_t*)(addr)) = (val))
#endif




#define setbits_le8(addr, set) \
		write8((addr), (read8((addr)) | (uint8_t)(set)))

#define clrbits_le8(addr, clear) \
		write8((addr), (read8((addr)) & ~(uint8_t)(clear)))

#define clrsetbits_le8(addr, clear, set) \
		write8((addr), ((read8((addr)) & ~((uint8_t)(clear))) | (uint8_t)(set)))

#define setbits_le16(addr, set) \
		write16((addr), (read16((addr)) | (uint16_t)(set)))

#define clrbits_le16(addr, clear) \
		write16((addr), (read16((addr)) & ~(uint16_t)(clear)))

#define clrsetbits_le16(addr, clear, set) \
		write16((addr), ((read16((addr)) & ~((uint16_t)(clear))) | (uint16_t)(set)))

#define setbits_le32(addr, set) \
		write32((addr), (read32((addr)) | (uint32_t)(set)))

#define clrbits_le32(addr, clear) \
		write32((addr), (read32((addr)) & ~(uint32_t)(clear)))

#define clrsetbits_le32(addr, clear, set) \
		write32((addr), ((read32((addr)) & ~((uint32_t)(clear))) | (uint32_t)(set)))

#endif /* _REG_OP_H */