#ifndef __MTK_GNSS_AT_SERVER_H__
#define __MTK_GNSS_AT_SERVER_H__

#include "mtk_gnss_at_struct.h"

#ifdef __cplusplus
extern "C" {
#endif


//Common
bool mtk_at_send_ok(int fd);
bool mtk_at_send_error(int fd);
//GNSS
bool mtk_at_send_gnss_nmea_notify(int fd, const char* nmea);
bool mtk_at_send_gnss_nmea_end_notify(int fd);
bool mtk_at_send_gnss_satellite_notify(int fd, mtk_gnss_satellite_list* list);
bool mtk_at_send_gnss_location_notify(int fd, mtk_gnss_location* location);
bool mtk_at_send_gnss_agnss_location_notify(int fd, mtk_agnss_location* location);
bool mtk_at_send_gnss_device_reset_notify(int fd, const char* reason);
bool mtk_at_send_gnss_status_response(int fd, mtk_gnss_status* status);
bool mtk_at_send_gnss_ni_notify_request(int fd, mtk_gnss_ni_notify* notify);
bool mtk_at_send_gnss_ref_location_request(int fd);
bool mtk_at_send_gnss_ref_time_request(int fd);
bool mtk_at_send_gnss_loopback_response(int fd, const char* msg);
bool mtk_at_send_gnss_cert_name_response(int fd, mtk_gnss_cert_name_list* list);
//Geofence
bool mtk_at_send_geo_max_num_response(int fd, int num);
bool mtk_at_send_geo_add_circle_response(int fd, mtk_geo_fence_create_state state, int id);
bool mtk_at_send_geo_alert_notify(int fd, mtk_geo_alert_notify* notify);
bool mtk_at_send_geo_track_notify(int fd, mtk_geo_track_state state, const char* date_time);

typedef struct {
    bool (*_mtk_at_gnss_start_request) (int fd);
    bool (*_mtk_at_gnss_stop_request) (int fd);
    bool (*_mtk_at_gnss_host_reset_notify) (int fd);
    bool (*_mtk_at_gnss_status_request) (int fd);
    bool (*_mtk_at_gnss_enable_set) (int fd, bool enabled);
    bool (*_mtk_at_gnss_ni_enable_set) (int fd, bool enabled);
    bool (*_mtk_at_gnss_agps_mode_set) (int fd, mtk_gnss_agps_mode* mode);
    bool (*_mtk_at_gnss_supl_version_set) (int fd, int maj, int min, int ser_ind);
    bool (*_mtk_at_gnss_supl_addr_set) (int fd, const char* addr, int port, bool tls_enabled);
    bool (*_mtk_at_gnss_delete_aiding_data_request) (int fd, mtk_gnss_aiding_data* flags);
    bool (*_mtk_at_gnss_ni_notify_response) (int fd, int id, mtk_gnss_ni_response_type response);
    bool (*_mtk_at_gnss_ref_location_response) (int fd, int age, double lat, double lng, float acc);
    bool (*_mtk_at_gnss_ref_time_response) (int fd, long long time, int uncertainty);
    bool (*_mtk_at_gnss_nmea_config_set) (int fd, bool enabled);
    bool (*_mkt_at_gnss_ttff_qop_set) (int fd, int mode);
    bool (*_mtk_at_gnss_loopback_request) (int fd, const char* msg);
    bool (*_mtk_at_gnss_cert_set) (int fd, mtk_gnss_cert* cert);
    bool (*_mtk_at_gnss_cert_name_request) (int fd);
    bool (*_mtk_at_gnss_cert_delete_request) (int fd, const char* name);
    bool (*_mtk_at_gnss_cert_delete_all_request) (int fd);
    bool (*_mtk_at_geo_max_num_request) (int fd);
    bool (*_mtk_at_geo_add_circle_request) (int fd, mtk_geo_add_circle* circle);
    bool (*_mtk_at_geo_delete_request) (int fd, int id);
    bool (*_mtk_at_geo_delete_all_request) (int fd);
    bool (*_mtk_at_test_request) (int fd, int num1, int num2, double d1, double d2, const char* str1, const char* str2);
} mtk_gnss_at_server_callbacks;

bool mtk_at_server_parser(int fd, const char* at_cmd, mtk_gnss_at_server_callbacks* callbacks);


#ifdef __cplusplus
}
#endif

#endif

