#ifndef __HAL2MNL_INTERFACE_H__
#define __HAL2MNL_INTERFACE_H__

#include "hal_mnl_interface_common.h"
#include "hardware/gps_mtk.h"
#include "mnldinf_basic.h"
#include "mnldinf_ext.h"

#ifdef __cplusplus
extern "C" {
#endif

int hal2mnl_hal_reboot();

int hal2mnl_gps_init();
int hal2mnl_gps_start();
int hal2mnl_gps_stop();
int hal2mnl_gps_cleanup();

int hal2mnl_gps_inject_time(int64_t time, int64_t time_reference, int uncertainty);
int hal2mnl_gps_inject_location(double lat, double lng, float acc);
int hal2mnl_gps_delete_aiding_data(int flags);
int hal2mnl_gps_set_position_mode(gps_pos_mode mode, gps_pos_recurrence recurrence,
    int min_interval, int preferred_acc, int preferred_time, bool lowPowerMode);

int hal2mnl_data_conn_open(const char* apn);
int hal2mnl_data_conn_open_with_apn_ip_type(uint64_t networkHandle, const char* apn, apn_ip_type ip_type);
int hal2mnl_data_conn_closed();
int hal2mnl_data_conn_failed();

int hal2mnl_set_server(agps_type type, const char* hostname, int port);
int hal2mnl_set_ref_location(cell_type type, int mcc, int mnc, int lac, int cid);
int hal2mnl_set_id(agps_id_type type, const char* setid);

int hal2mnl_ni_message(char* msg, int len);
int hal2mnl_ni_respond(int notif_id, ni_user_response_type user_response);

int hal2mnl_update_network_state(uint64_t networkHandle, bool isConnected,
            uint16_t capabilities, const char* apn);
int hal2mnl_update_network_availability(int available, const char* apn);

int hal2mnl_set_gps_measurement(bool enabled, bool enableFullTracking);
int hal2mnl_set_gps_navigation(bool enabled);

int hal2mnl_set_vzw_debug(bool enabled);
int hal2mnl_update_gnss_config(const char* config_data, int length);
int hal2mnl_setBlacklist(long long* blacklist, int32_t size);
int hal2mnl_set_correction(MeasurementCorrections* corrections);
int hal2mnl_set_nfw_access(char* proxy_apps, int32_t length);
int hal2mnl_send_pmtk(char* msg, int len);

// -1 means failure
int create_mnl2hal_fd_basic();

// -1 means failure
int create_mnl2hal_fd_ext();

#ifdef __cplusplus
}
#endif

#endif

