#ifndef __MNLDINF_DATA_CODER_H__
#define __MNLDINF_DATA_CODER_H__

#ifdef __cplusplus
extern "C" {
#endif

char        mnldinf_get_byte(char* buff, int* offset, int src_len);
short       mnldinf_get_short(char* buff, int* offset, int src_len);
int         mnldinf_get_int(char* buff, int* offset, int src_len);
long long   mnldinf_get_long(char* buff, int* offset, int src_len);
float       mnldinf_get_float(char* buff, int* offset, int src_len);
double      mnldinf_get_double(char* buff, int* offset, int src_len);
char*       mnldinf_get_string(char* buff, int* offset, int src_len);
char*       mnldinf_get_string2(char* buff, int* offset, int src_len);
int         mnldinf_get_binary(char* buff, int* offset, char* output, int src_len, int des_len);

void mnldinf_put_byte(char* buff, int* offset, const char input);
void mnldinf_put_short(char* buff, int* offset, const short input);
void mnldinf_put_int(char* buff, int* offset, const int input);
void mnldinf_put_long(char* buff, int* offset, const long long input);
void mnldinf_put_float(char* buff, int* offset, const float input);
void mnldinf_put_double(char* buff, int* offset, const double input);
void mnldinf_put_string(char* buff, int* offset, const char* input);
void mnldinf_put_binary(char* buff, int* offset, const char* input, int len);

#ifdef __cplusplus
}
#endif

#endif

