/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "gpshal.h"
#include <sys/epoll.h>  // epoll_create, epoll_event
#include <errno.h>     // errno
#include <string.h>    // strerror
#include <inttypes.h>
// #include <linux/in.h>   // INADDR_NONE
#include "hal2mnl_interface.h"
#include "mtk_lbs_utility.h"
#if 0
#ifdef LOGD
#undef LOGD
#endif
#ifdef LOGW
#undef LOGW
#endif
#ifdef LOGE
#undef LOGE
#endif
#if 0
#define LOGD(...) tag_log(1, "[gpshal]", __VA_ARGS__);
#define LOGW(...) tag_log(1, "[gpshal] WARNING: ", __VA_ARGS__);
#define LOGE(...) tag_log(1, "[gpshal] ERR: ", __VA_ARGS__);
#else
#define LOG_TAG "gpshal_worker"
#include <cutils/sockets.h>
#include <log/log.h>     /*logging in logcat*/
#define LOGD(fmt, arg ...) ALOGD("%s: " fmt, __FUNCTION__ , ##arg)
#define LOGW(fmt, arg ...) ALOGW("%s: " fmt, __FUNCTION__ , ##arg)
#define LOGE(fmt, arg ...) ALOGE("%s: " fmt, __FUNCTION__ , ##arg)
#endif
#endif
//=========================================================

#define GPSHAL_WORKER_THREAD_TIMEOUT (30*1000)

//connection broken retry interval, ms
#define GPSHAL_MNL_RETRY_INTERVAL (1*1000)

#define fieldp_copy(dst, src, f)  (dst)->f  = (src)->f
#define field_copy(dst, src, f)  (dst).f   = (src).f

//=========================================================
DebugData mnlDebugData; //for GNSS HIDL v1.1 GPS debug interface

extern float count;
extern float report_time_interval;

static void update_mnld_reboot() {
// GPSHAL_DEBUG_FUNC_SCOPE2(g_gpshal_ctx.mutex_gps_state_intent);
    gpshal_state state = g_gpshal_ctx.gps_state_intent;
    LOGD("state: (%d)", state);

    if (hal2mnl_set_nfw_access(g_gpshal_ctx.proxy_apps, strlen(g_gpshal_ctx.proxy_apps)) == -1) {
        LOGE("hal2mnl_set_nfw_access failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    switch (state) {
        case GPSHAL_STATE_INIT:
        case GPSHAL_STATE_STOP:
            gpshal2mnl_gps_init();
            break;
        case GPSHAL_STATE_START:
            gpshal2mnl_gps_init();
            gpshal2mnl_gps_start();
            break;
        case GPSHAL_STATE_CLEANUP:
        default:
            LOGW("Current gps_state_intent: %s (%d)",
                gpshal_state_to_string(state), state);
    }
}

static void gpshal_close(int fd) {
    if(fd != -1) {
        close(fd);
        if(fd == g_gpshal_ctx.fd_mnl2hal_basic) {
            g_gpshal_ctx.fd_mnl2hal_basic = -1;
            LOGD("mnl2hal_basic fd closed.");
        } else if(fd == g_gpshal_ctx.fd_mnl2hal_ext) {
            g_gpshal_ctx.fd_mnl2hal_ext = -1;
            LOGD("mnl2hal_ext fd closed.");
        } else {
            LOGE("unexpected fd=[%d] to be closed", fd);
        }
    }
}

void gpshal_mnl_retry_routine(void) {
    if (g_gpshal_ctx.fd_mnl2hal_basic != -1){
        mnldinf_epoll_del_fd(g_gpshal_ctx.fd_worker_epoll, g_gpshal_ctx.fd_mnl2hal_basic);
    }
    if (g_gpshal_ctx.fd_mnl2hal_ext != -1){
        mnldinf_epoll_del_fd(g_gpshal_ctx.fd_worker_epoll, g_gpshal_ctx.fd_mnl2hal_ext);
    }
    gpshal_close(g_gpshal_ctx.fd_mnl2hal_basic);
    gpshal_close(g_gpshal_ctx.fd_mnl2hal_ext);

    g_gpshal_ctx.fd_mnl2hal_basic = create_mnl2hal_fd_basic();
    if (-1 == g_gpshal_ctx.fd_mnl2hal_basic) { // error
        LOGW("fd_mnl2hal_basic recreate fail, will retry after %d ms", GPSHAL_MNL_RETRY_INTERVAL);
        mnldinf_start_timer(g_gpshal_ctx.mnl_retry_timer, GPSHAL_MNL_RETRY_INTERVAL);
        return;
    } else {
        if (mnldinf_epoll_add_fd(
                g_gpshal_ctx.fd_worker_epoll,
                g_gpshal_ctx.fd_mnl2hal_basic) == -1) {
            LOGE("Fail to add fd_mnl2hal basic");
            return;  // error
        }
    }

    g_gpshal_ctx.fd_mnl2hal_ext = create_mnl2hal_fd_ext();
    if (-1 == g_gpshal_ctx.fd_mnl2hal_ext) {  // error
        LOGW("fd_mnl2hal_ext recreate fail, will retry after %d ms", GPSHAL_MNL_RETRY_INTERVAL);
        mnldinf_start_timer(g_gpshal_ctx.mnl_retry_timer, GPSHAL_MNL_RETRY_INTERVAL);
        return;
    } else {
        if (mnldinf_epoll_add_fd(
                g_gpshal_ctx.fd_worker_epoll,
                g_gpshal_ctx.fd_mnl2hal_ext) == -1) {
            LOGE("Fail to add fd_mnl2hal ext");
            return;  // error
        }
    }

    if (-1 != g_gpshal_ctx.fd_mnl2hal_basic) {
        update_mnld_reboot();
    }
}

static void update_location(gps_location location) {

    if (report_time_interval > ++count) {
        LOGD("break location update, count is %f, interval is %f\n", count, report_time_interval);
        return;
    }

    count = 0;
    // Use mutex or not ?
    //     If no, the issue may occur.
    //     If yes, there will be a little performance impact.
  //  GPSHAL_DEBUG_FUNC_SCOPE;
    GpsLocation_ext loc;
    //dump_gps_location(location);
    gpshal_state state = g_gpshal_ctx.gps_state;
    memset(&loc, 0, sizeof(GpsLocation_ext));
    //LOGD("state: (%d)", state);
    if (GPSHAL_STATE_START == state) {
        loc.legacyLocation.size      = sizeof(loc);
        loc.legacyLocation.flags     = location.flags;
        loc.legacyLocation.latitude  = location.lat;
        loc.legacyLocation.longitude = location.lng;
        loc.legacyLocation.altitude  = location.alt;
        loc.legacyLocation.speed     = location.speed;
        loc.legacyLocation.bearing   = location.bearing;
        loc.legacyLocation.accuracy  = loc.horizontalAccuracyMeters = location.h_accuracy;
        loc.verticalAccuracyMeters       = location.v_accuracy;
        loc.speedAccuracyMetersPerSecond = location.s_accuracy;
        loc.bearingAccuracyDegrees       = location.b_accuracy;
        loc.legacyLocation.timestamp = location.timestamp;

        /// not report elapsed real time in mnld, it will be reported in frw.
        loc.elapsedRealtime.flags = 0; //HAS_TIMESTAMP_NS | HAS_TIME_UNCERTAINTY_NS;
        loc.elapsedRealtime.timestampNs = 0;
        loc.elapsedRealtime.timeUncertaintyNs = 0;
        loc.type = location.type;
        LOGD("hacc=%f,vacc=%f,sacc=%f,bacc=%f, type:%u", loc.horizontalAccuracyMeters, loc.verticalAccuracyMeters,
            loc.speedAccuracyMetersPerSecond, loc.bearingAccuracyDegrees, loc.type);
        g_gpshal_ctx.gps_cbs->location_cb(&loc);
        //For GNSS HIDL v1.1 Gps debug interface
        mnlDebugData.position.valid = true;
        mnlDebugData.position.latitudeDegrees   = location.lat;
        mnlDebugData.position.longitudeDegrees  = location.lng;
        mnlDebugData.position.altitudeMeters    = location.alt;
        mnlDebugData.position.speedMetersPerSec = location.speed;
        mnlDebugData.position.bearingDegrees    = location.bearing;
        mnlDebugData.position.horizontalAccuracyMeters     = location.h_accuracy;
        mnlDebugData.position.verticalAccuracyMeters       = location.v_accuracy;
        mnlDebugData.position.speedAccuracyMetersPerSecond = location.s_accuracy;
        mnlDebugData.position.bearingAccuracyDegrees       = location.b_accuracy;
        mnlDebugData.time.timeEstimate = location.timestamp;
    } else {
        // Do not report this location to GLP to avoid strange TTFF time issue
        LOGW("we have a location when gps_state_intent: %s (%d)",
                gpshal_state_to_string(state), state);
    }
}
static void update_gps_status(gps_status status) {
    GpsStatus s;
    memset(&s, 0, sizeof(GpsStatus));
    LOGD("  status=%d", status);
    s.size   = sizeof(s);
    s.status = status;
    g_gpshal_ctx.gps_cbs->status_cb(&s);
}

static void update_gps_sv(gnss_sv_info sv) {

   // GPSHAL_DEBUG_FUNC_SCOPE;
    int i;
    GnssSvStatus_ext gss;
    //dump_gnss_sv_info(sv);
    memset(&gss, 0, sizeof(GnssSvStatus_ext));
    gss.size = sizeof(gss);
    gss.num_svs = sv.num_svs;
    if (gss.num_svs > MTK_HAL_GNSS_MAX_MEASUREMENT) {
        gss.num_svs = MTK_HAL_GNSS_MAX_MEASUREMENT;
    }
    for (i = 0; i < gss.num_svs; i++) {
        GnssSvInfo* dst = &gss.gnss_sv_list[i].legacySvInfo;
        gnss_sv*    src = &sv.sv_list[i];
        dst->size = sizeof(*dst);
        fieldp_copy(dst, src, svid);
        fieldp_copy(dst, src, constellation);
        fieldp_copy(dst, src, c_n0_dbhz);
        fieldp_copy(dst, src, elevation);
        fieldp_copy(dst, src, azimuth);
        fieldp_copy(dst, src, flags);
        fieldp_copy(&gss.gnss_sv_list[i], src, carrier_frequency);
        fieldp_copy(&gss.gnss_sv_list[i], src, basebandCN0DbHz);//hidl v2.1
        mnlDebugData.satelliteDataArray[i].svid = gss.gnss_sv_list[i].legacySvInfo.svid;
        mnlDebugData.satelliteDataArray[i].constellation = gss.gnss_sv_list[i].legacySvInfo.constellation;
    }
    g_gpshal_ctx.gps_cbs->gnss_sv_status_cb(&gss);
}

static void update_nmea(int64_t timestamp, const char* nmea, int length) {
    /*LOGD("  timestamp=%lld nmea=[%s] length=%d",
        timestamp, nmea, length);
        LOGD("%"PRId64", nmea_cb:%p",timestamp, g_gpshal_ctx.gps_cbs->nmea_cb);*/
    g_gpshal_ctx.gps_cbs->nmea_cb(timestamp, nmea, length);
}
#if 0
static void update_gps_capabilities(gps_capabilites capabilities) {
    LOGD("  capabilities=0x%x", capabilities);
//    g_gpshal_ctx.gps_cbs->set_capabilities_cb(capabilities);
    g_gpshal_ctx.gps_cap = capabilities;
}
#endif
GnssData_ext gd;
static void update_gnss_measurements(gnss_data *data) {
    size_t i;
    //dump_gnss_data(data);
    memset(&gd, 0, sizeof(GnssData_ext));
    gd.size = sizeof(gd);
    if((*data).measurement_count > MTK_HAL_GNSS_MAX_MEASUREMENT) {
        (*data).measurement_count = MTK_HAL_GNSS_MAX_MEASUREMENT;
    }
    LOGD("meas_cnt:%zu", (*data).measurement_count);

    field_copy(gd, (*data), measurement_count);
    for (i = 0; i < (*data).measurement_count; i++) {
        GnssMeasurement*  dst = &gd.measurements[i].legacyMeasurement;
        gnss_measurement*  src = &(*data).measurements[i];
        dst->size  = sizeof(*dst);
        fieldp_copy(dst, src, flags);
        fieldp_copy(dst, src, svid);
        fieldp_copy(dst, src, constellation);
        fieldp_copy(dst, src, time_offset_ns);
        fieldp_copy(dst, src, state);
        fieldp_copy(dst, src, received_sv_time_in_ns);
        fieldp_copy(dst, src, received_sv_time_uncertainty_in_ns);
        fieldp_copy(dst, src, c_n0_dbhz);
        fieldp_copy(dst, src, pseudorange_rate_mps);
        fieldp_copy(dst, src, pseudorange_rate_uncertainty_mps);
        fieldp_copy(dst, src, accumulated_delta_range_state);
        fieldp_copy(dst, src, accumulated_delta_range_m);
        fieldp_copy(dst, src, accumulated_delta_range_uncertainty_m);
        fieldp_copy(dst, src, carrier_frequency_hz);
        fieldp_copy(dst, src, carrier_cycles);
        fieldp_copy(dst, src, carrier_phase);
        fieldp_copy(dst, src, carrier_phase_uncertainty);
        fieldp_copy(dst, src, multipath_indicator);
        fieldp_copy(dst, src, snr_db);
        fieldp_copy(&gd.measurements[i], src, fullInterSignalBiasNs);// v2.1
        fieldp_copy(&gd.measurements[i], src, fullInterSignalBiasUncertaintyNs);// v2.1
        fieldp_copy(&gd.measurements[i], src, satelliteInterSignalBiasNs);// v2.1
        fieldp_copy(&gd.measurements[i], src, satelliteInterSignalBiasUncertaintyNs);// v2.1
        fieldp_copy(&gd.measurements[i], src, basebandCN0DbHz);// v2.1
        fieldp_copy(&gd.measurements[i], src, agc_level_db);// v2.1
        /// todo
        MNLD_STRNCPY(gd.measurements[i].codeType, (*data).measurements[i].code_type, sizeof(gd.measurements[i].codeType));

    }

    // To do things like field_copy(gd, data, clock)
    {
        GnssClock*  dst = &gd.clock.legacyClock;
        gnss_clock* src = &(*data).clock;
        dst->size = sizeof(*dst);
        fieldp_copy(dst, src, flags);
        fieldp_copy(dst, src, leap_second);
        fieldp_copy(dst, src, time_ns);
        fieldp_copy(dst, src, time_uncertainty_ns);
        fieldp_copy(dst, src, full_bias_ns);
        fieldp_copy(dst, src, bias_ns);
        fieldp_copy(dst, src, bias_uncertainty_ns);
        fieldp_copy(dst, src, drift_nsps);
        fieldp_copy(dst, src, drift_uncertainty_nsps);
        fieldp_copy(dst, src, hw_clock_discontinuity_count);
        fieldp_copy(&gd.clock.referenceSignalTypeForIsb, &src->referenceSignalTypeForIsb, constellation);//hidl v2.1
        fieldp_copy(&gd.clock.referenceSignalTypeForIsb, &src->referenceSignalTypeForIsb, carrierFrequencyHz);//hidl v2.1
        MNLD_STRNCPY(gd.clock.referenceSignalTypeForIsb.codeType, src->referenceSignalTypeForIsb.codeType, sizeof(gd.clock.referenceSignalTypeForIsb.codeType));
        mnlDebugData.time.timeUncertaintyNs = src->time_uncertainty_ns;
        mnlDebugData.time.frequencyUncertaintyNsPerSec = src->drift_nsps;
        /// not report elapsed real time in mnld, real time items will be ignored.
        gd.elapsedRealtime.flags = 0; //HAS_TIMESTAMP_NS | HAS_TIME_UNCERTAINTY_NS;
        gd.elapsedRealtime.timestampNs = 0;
        gd.elapsedRealtime.timeUncertaintyNs = 0;

        /// v2.1 TODO
        //fieldp_copy(gd.clock.referenceSignalTypeForIsb.carrierFrequencyHz, src, carrierFrequencyHz);
        //fieldp_copy(gd.clock.referenceSignalTypeForIsb.constellation, src, constellation);
        //MNLD_STRNCPY(gd.clock.referenceSignalTypeForIsb.codeType, src.codeType, sizeof(src.codeType));
    }

    g_gpshal_ctx.meas_cbs->gnss_measurement_callback(&gd);
}

static void update_gnss_navigation(gnss_nav_msg *msg) {
    GnssNavigationMessage gnm;
    //dump_gnss_nav_msg(msg);
    memset(&gnm, 0, sizeof(GnssNavigationMessage));
    gnm.size = sizeof(gnm);
    field_copy(gnm, (*msg), svid);
    field_copy(gnm, (*msg), type);
    field_copy(gnm, (*msg), status);
    field_copy(gnm, (*msg), message_id);
    field_copy(gnm, (*msg), submessage_id);
    field_copy(gnm, (*msg), data_length);
    gnm.data = (uint8_t*)(*msg).data;
    if ((NULL != g_gpshal_ctx.navimsg_cbs) && (NULL != g_gpshal_ctx.navimsg_cbs->gnss_navigation_message_callback)) {
        g_gpshal_ctx.navimsg_cbs->gnss_navigation_message_callback(&gnm);
    } else {
        LOGW("navimsg_cbs or gnss_navigation_message_callback is NULL");
    }
}

static void request_wakelock() {
   // GPSHAL_DEBUG_FUNC_SCOPE;
    g_gpshal_ctx.gps_cbs->acquire_wakelock_cb();
}
static void release_wakelock() {
   // GPSHAL_DEBUG_FUNC_SCOPE;
    g_gpshal_ctx.gps_cbs->release_wakelock_cb();
}
static void request_utc_time() {
   // GPSHAL_DEBUG_FUNC_SCOPE;
    g_gpshal_ctx.gps_cbs->request_utc_time_cb();
}
static void request_data_conn(__unused struct sockaddr_storage* addr, agps_type type) {
  //  GPSHAL_DEBUG_FUNC_SCOPE;
    UNUSED(addr);
    AGpsStatus as;
    as.size   = sizeof(AGpsStatus);  // our imp supports v3
    as.type   = type;
    as.status = GPS_REQUEST_AGPS_DATA_CONN;
    // as.ipaddr = INADDR_NONE; // not used in v3
    as.addr   = *addr;
    g_gpshal_ctx.agps_cbs->status_cb(&as);
}
static void release_data_conn(agps_type type) {
    // GPSHAL_DEBUG_FUNC_SCOPE;
    AGpsStatus as;
    as.size   = sizeof(AGpsStatus_v1);  // use v1 size to omit optional fields
    as.type   = type;
    as.status = GPS_RELEASE_AGPS_DATA_CONN;
    g_gpshal_ctx.agps_cbs->status_cb(&as);
}
static void request_ni_notify(int session_id, agps_ni_type ni_type, agps_notify_type type, const char* requestor_id,
        const char* client_name, ni_encoding_type requestor_id_encoding,
        ni_encoding_type client_name_encoding) {
    /*LOGD("  session_id=%d type=%d requestor_id=[%s] client_name=[%s] requestor_id_encoding=%d client_name_encoding=%d",
        session_id, type, requestor_id, client_name, requestor_id_encoding, client_name_encoding);*/
    GpsNiNotification gnn;
    gnn.size = sizeof(gnn);
    gnn.notification_id = session_id;
    gnn.ni_type = ni_type;
    switch (type) {
        case AGPS_NOTIFY_TYPE_NOTIFY_ONLY:
            gnn.notify_flags = GPS_NI_NEED_NOTIFY;
            break;
        case AGPS_NOTIFY_TYPE_NOTIFY_ALLOW_NO_ANSWER:
            gnn.notify_flags = GPS_NI_NEED_NOTIFY|GPS_NI_NEED_VERIFY;
            break;
        case AGPS_NOTIFY_TYPE_NOTIFY_DENY_NO_ANSWER:
            gnn.notify_flags = GPS_NI_NEED_NOTIFY|GPS_NI_NEED_VERIFY;
            break;
        case AGPS_NOTIFY_TYPE_PRIVACY:
            gnn.notify_flags = GPS_NI_PRIVACY_OVERRIDE;
            break;
        default:
            gnn.notify_flags = 0;
    }
    gnn.timeout          = 8;
    gnn.default_response = GPS_NI_RESPONSE_NORESP;
    MNLD_STRNCPY(gnn.requestor_id, requestor_id,sizeof(gnn.requestor_id));
    MNLD_STRNCPY(gnn.text,client_name,sizeof(gnn.text));
    gnn.requestor_id_encoding = requestor_id_encoding;
    gnn.text_encoding         = client_name_encoding;
    gnn.extras[0] = 0;  // be an empty string ""
    if (g_gpshal_ctx.gpsni_cbs) {
        g_gpshal_ctx.gpsni_cbs->notify_cb(&gnn);
    }
}
static void request_set_id(request_setid flags) {
    //LOGD("  flags=0x%x", flags);
    if (g_gpshal_ctx.agpsril_cbs) {
        g_gpshal_ctx.agpsril_cbs->request_setid(flags);
    }
}
static void request_ref_loc(request_refloc flags) {
    //LOGD("  flags=0x%x", flags);
    if (g_gpshal_ctx.agpsril_cbs) {
        g_gpshal_ctx.agpsril_cbs->request_refloc(flags);
    }
}
static void output_vzw_debug(const char* str) {
    int len;
    len = strlen(str)+1;
    if (len > VZW_DEBUG_STRING_MAXLEN) {
        len = VZW_DEBUG_STRING_MAXLEN;
    }
    LOGD("len=%d str=%s", len, str);
    VzwDebugData vzwdebugdata;
    vzwdebugdata.size = sizeof(VzwDebugData);
    memcpy(vzwdebugdata.vzw_msg_data, str, len);
    vzwdebugdata.vzw_msg_data[VZW_DEBUG_STRING_MAXLEN - 1] = 0;

    if (g_gpshal_ctx.vzw_debug_cbs) {
        g_gpshal_ctx.vzw_debug_cbs->vzw_debug_cb(&vzwdebugdata);
    }
}

static void update_gnss_name(const char* name, int length) {
    LOGD("length=%d, name=%s", length, name);
    if(length > GNSS_NAME_LEN) {
        length = GNSS_NAME_LEN;
    }
    MNLD_STRNCPY(g_gpshal_ctx.gps_name, name, GNSS_NAME_LEN);
}

static void request_nlp(bool independentFromGnss, bool isUserEmergency) {
    LOGD("request nlp[%d], flag=%d", independentFromGnss, isUserEmergency);
    if (g_gpshal_ctx.gps_cbs) {
        //// todo
        g_gpshal_ctx.gps_cbs->request_location_cb(independentFromGnss, isUserEmergency);
    }
}

static void nfw_access_notify(mnldinf_nfw_notification *nfw_notify) {
    NfwNotification notify;
    LOGD("APP name: %s, PS: %d, otherPSName: %s, requestor: %d, requestorId: %s, responseType: %d, inEmergencyMode: %d, isCachedLocation: %d"
        ,(*nfw_notify).proxy_app_package_name
        ,(*nfw_notify).protocol_stack
        ,(*nfw_notify).other_protocol_stack_name
        ,(*nfw_notify).requestor
        ,(*nfw_notify).requestor_id
        ,(*nfw_notify).response_type
        ,(*nfw_notify).in_emergency_mode
        ,(*nfw_notify).is_cached_location
    );

    memset(&notify, 0, sizeof(notify));
    memcpy(&notify, nfw_notify, sizeof(notify));
    if(g_gpshal_ctx.visibility_control_cbs && g_gpshal_ctx.visibility_control_cbs->nfw_notify_cb) {
        g_gpshal_ctx.visibility_control_cbs->nfw_notify_cb(notify);
    }
}

void connection_broken_basic(void) {
    LOGW("connection broken...");
    if (g_gpshal_ctx.fd_mnl2hal_basic != -1){
        mnldinf_epoll_del_fd(g_gpshal_ctx.fd_worker_epoll, g_gpshal_ctx.fd_mnl2hal_basic);
    }
    mnldinf_start_timer(g_gpshal_ctx.mnl_retry_timer, GPSHAL_MNL_RETRY_INTERVAL);
}

void capability_update_basic(mnldinf_basic_server_cap *cap) {
    LOGD("capability:size:%lu", sizeof(mnldinf_basic_server_cap));
}

void nmea_done(void) {
    LOGD("NMEA done");
}

void connection_broken_ext() {
    LOGW("extension connection broken...");
    if (g_gpshal_ctx.fd_mnl2hal_ext != -1){
        mnldinf_epoll_del_fd(g_gpshal_ctx.fd_worker_epoll, g_gpshal_ctx.fd_mnl2hal_ext);
    }
    mnldinf_start_timer(g_gpshal_ctx.mnl_retry_timer, GPSHAL_MNL_RETRY_INTERVAL);
}

void capability_update_ext(mnldinf_ext_server_cap *cap) {
    LOGD("externsion capability update:size:%lu", sizeof(mnldinf_ext_server_cap));
}


static void update_agps_location(gps_location location) {
    GpsLocation_ext loc;
    gpshal_state state = g_gpshal_ctx.gps_state;
    memset(&loc, 0, sizeof(GpsLocation_ext));
    if (GPSHAL_STATE_START == state) {
        loc.legacyLocation.size      = sizeof(loc);
        loc.legacyLocation.flags     = location.flags;
        loc.legacyLocation.latitude  = location.lat;
        loc.legacyLocation.longitude = location.lng;
        loc.legacyLocation.altitude  = location.alt;
        loc.legacyLocation.speed     = location.speed;
        loc.legacyLocation.bearing   = location.bearing;
        loc.legacyLocation.accuracy  = loc.horizontalAccuracyMeters = location.h_accuracy;
        loc.verticalAccuracyMeters       = location.v_accuracy;
        loc.speedAccuracyMetersPerSecond = location.s_accuracy;
        loc.bearingAccuracyDegrees       = location.b_accuracy;
        loc.legacyLocation.timestamp = location.timestamp;

        /// not report elapsed real time in mnld, it will be reported in frw.
        loc.elapsedRealtime.flags = 0;
        loc.elapsedRealtime.timestampNs = 0;
        loc.elapsedRealtime.timeUncertaintyNs = 0;
        loc.type = location.type;
        LOGD("AGPS location: hacc=%f,vacc=%f,sacc=%f,bacc=%f, type:%u", loc.horizontalAccuracyMeters, loc.verticalAccuracyMeters,
            loc.speedAccuracyMetersPerSecond, loc.bearingAccuracyDegrees, loc.type);
        g_gpshal_ctx.gps_cbs->agps_location_cb(&loc);
    } else {
        LOGW("we have a location when gps_state_intent: %s (%d)",
                gpshal_state_to_string(state), state);
    }
}

void agps_location_update(mnldinf_agps_location location) {
    gps_location loc;
    LOGD("alt:%f, acc:%f, %lld, type:%d", location.altitude, location.accuracy, location.timestamp, location.type);

    memset(&loc, 0, sizeof(loc));
    if(location.type_used) {
        loc.type = location.type;
    } else {
        loc.type = MNLDINF_AGPS_LOC_TYPE_UNKNOWN;
    }

    loc.flags |= MTK_GPS_LOCATION_HAS_LAT_LONG;
    loc.lat = location.latitude;
    loc.lng = location.longitude;
    if (location.altitude_used) {
        loc.flags |= MTK_GPS_LOCATION_HAS_ALT;
        loc.alt = location.altitude;
    }
    if (location.speed_used) {
        loc.flags |= MTK_GPS_LOCATION_HAS_SPEED;
        loc.speed = location.speed;
    }
    if (location.bearing_used) {
        loc.flags |= MTK_GPS_LOCATION_HAS_BEARING;
        loc.bearing = location.bearing;
    }
    if (location.accuracy_used) {
        loc.flags |= MTK_GPS_LOCATION_HAS_HORIZONTAL_ACCURACY;
        loc.h_accuracy = location.accuracy;
    }
    if (location.timestamp_used) {
        loc.timestamp = location.timestamp;
    }

    if(location.type_used &&
        (location.type == MNLDINF_AGPS_LOC_TYPE_AFLT ||
        location.type == MNLDINF_AGPS_LOC_TYPE_MOLR_BEGIN_RSP ||
        location.type == MNLDINF_AGPS_LOC_TYPE_SUPL_END)) {
        update_location(loc);
    }

    update_agps_location(loc);

}

static mnldinf_basic gpshal_mnl2hal_interface_basic = {
    connection_broken_basic,
    update_location,
    update_gps_status,
    update_gps_sv,
    update_nmea,
    nmea_done,
    update_gnss_measurements,
    capability_update_basic
};

static mnldinf_ext gpshal_mnl2hal_interface_ext = {
    connection_broken_ext,
    request_wakelock,
    release_wakelock,

    request_utc_time,
    request_nlp,
    request_ni_notify,

    request_data_conn,
    release_data_conn,

    request_set_id,
    request_ref_loc,
    output_vzw_debug,

    update_gnss_name,

    update_gnss_navigation,
    nfw_access_notify,

    capability_update_ext,
    agps_location_update
};

//=========================================================

void gpshal_worker_thread(__unused void *arg) {
   // GPSHAL_DEBUG_FUNC_SCOPE;
    struct epoll_event events[MAX_EPOLL_EVENT];
    UNUSED(arg);
    mnldinf_wake_lock_init();

    while (true) {
        int i;
        int n;
        memset(events, 0, sizeof(events));
        n = epoll_wait(g_gpshal_ctx.fd_worker_epoll, events, MAX_EPOLL_EVENT , -1);
        if (n == -1) {
            if (errno == EINTR) {
                continue;
            } else {
                LOGE("%s() epoll_wait failure reason=[%s]%d",
                        __func__, strerror(errno), errno);
                return;
            }
        }
        mnldinf_wake_lock_take();
        for (i = 0; i < n; i++) {
            if (events[i].data.fd == g_gpshal_ctx.fd_mnl2hal_basic) {
                if (events[i].events & EPOLLIN) {
                    mnldinf_basic_cmd_hdlr(g_gpshal_ctx.fd_mnl2hal_basic,
                            &gpshal_mnl2hal_interface_basic);
                }
            } else if (events[i].data.fd == g_gpshal_ctx.fd_mnl2hal_ext) {
                if (events[i].events & EPOLLIN) {
                    mnldinf_ext_cmd_hdlr(g_gpshal_ctx.fd_mnl2hal_ext,
                            &gpshal_mnl2hal_interface_ext);
                }
            } else {
                LOGE("%s() unknown fd=%d",
                        __func__, events[i].data.fd);
            }
        }
        mnldinf_wake_lock_give();
    }  // of while (true)
}
