/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "gpshal.h"
#include "gpshal_param_check.h"
#include "hal2mnl_interface.h"
#include "mtk_lbs_utility.h"
#include "errno.h"
//=========================================================

extern struct hw_module_t HAL_MODULE_INFO_SYM;
extern DebugData mnlDebugData; //for GNSS HIDL v1.1 GPS debug interface

//=========================================================
// Gps Measurement Interface

// Thread: BackgroundThread
//      GpsMeasurementsProvider uses GpsLocationProvider's handler
static int measinf_init(GpsMeasurementCallbacks_ext* callbacks, bool enableFullTracking) {
    g_gpshal_ctx.meas_cbs = callbacks;
    int ret = hal2mnl_set_gps_measurement(true, enableFullTracking);
    return (ret > 0)?
            GPS_GEOFENCE_OPERATION_SUCCESS :
            GPS_GEOFENCE_ERROR_GENERIC;
}

// Thread: BackgroundThread
//      GpsMeasurementsProvider uses GpsLocationProvider's handler
static void measinf_close(void) {
    if (hal2mnl_set_gps_measurement(false, false) == -1) {
        LOGE("hal2mnl_set_gps_measurement failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

const GpsMeasurementInterface_ext mtk_gps_meas_inf = {
    sizeof(GpsMeasurementInterface_ext),
    measinf_init,
    measinf_close
};

//=========================================================
// Gnss Antenna Interface
//TODO
static int antenna_info_set_callback(GnssAntennaInfoCallbacks* callbacks) {
    UNUSED(callbacks);
    return 0;
}

static void antenna_info_close(void) {
}

const GnssAntennaInfoInterface mtk_antenna_info_inf = {
    sizeof(GnssAntennaInfoInterface),
    antenna_info_set_callback,
    antenna_info_close
};


//=========================================================
// Gnss Measurement Correction Interface
static bool meas_correct_set_callback(MeasurementCorrectionCallbacks_ext* callbacks) {
    int capabilities = LOS_SATS | EXCESS_PATH_LENGTH | REFLECTING_PLANE;
    g_gpshal_ctx.meas_correct_cbs = callbacks;
    g_gpshal_ctx.meas_correct_cbs->set_capabilities_cb(capabilities);
    return true;
}

static bool meas_correct_set_correction(MeasurementCorrections* corrections) {
    LOGD("setCorrections");
    /*LOGD("corrections = lat: %f, lng: %f, alt: %f, hUnc: %f, vUnc: %f, toa: %llu num_satCorr: %d, ",
          corrections->latitudeDegrees, corrections->longitudeDegrees, corrections->altitudeMeters,
          corrections->horizontalPositionUncertaintyMeters,
          corrections->verticalPositionUncertaintyMeters,
          corrections->toaGpsNanosecondsOfWeek,
          corrections->num_satCorrection);
    int i = 0;*/
    int ret = 0;
    if(corrections->num_satCorrection > GNSS_MAX_SVS) {
        corrections->num_satCorrection = GNSS_MAX_SVS;
    }
    /*for (i=0; i < corrections->num_satCorrection; i++) {
        SingleSatCorrection* ssc = &(corrections->satCorrections[i]);
        LOGD("i = %d, singleSatCorrection = flags: %d, constellation: %d, svid: %d, cfHz: %f, probLos: %f,"
              " epl: %f, eplUnc: %f",
              i,
              ssc->singleSatCorrectionFlags,
              ssc->constellation,
              ssc->svid, ssc->carrierFrequencyHz,
              ssc->probSatIsLos, ssc->excessPathLengthMeters,
              ssc->excessPathLengthUncertaintyMeters);
        LOGD("reflecting plane = lat: %f, lng: %f, alt: %f, azm: %f",
              ssc->reflectingPlane.latitudeDegrees,
              ssc->reflectingPlane.longitudeDegrees,
              ssc->reflectingPlane.altitudeMeters,
              ssc->reflectingPlane.azimuthDegrees);
    }*/
    ret = hal2mnl_set_correction(corrections);
    return (ret > 0) ? true:false;
}

const MeasurementCorrectionInterface mtk_gnss_meas_correction_inf = {
    sizeof(MeasurementCorrectionInterface),
    meas_correct_set_callback,
    meas_correct_set_correction
};

//=========================================================
// Gnss Visibility Control Interface
static bool visibility_set_callback(GnssVisibilityControlCallback_ext* callbacks) {
    g_gpshal_ctx.visibility_control_cbs = callbacks;
    return true;
}

static bool enable_nfw_access(const char* proxyApps, int32_t length) {
    LOGD("enable_nfw_access proxyApps: [%s], len=%d", proxyApps, length);
    if(length > HAL_NFW_USER_NUM_MAX*HAL_NFW_USER_NAME_LEN) {
        LOGW("Over length(%d), set to MAX:%d", length, HAL_NFW_USER_NUM_MAX*HAL_NFW_USER_NAME_LEN-1);
        length = HAL_NFW_USER_NUM_MAX*HAL_NFW_USER_NAME_LEN-1;
    }
    memset(g_gpshal_ctx.proxy_apps, 0, sizeof(g_gpshal_ctx.proxy_apps));  //Clear buffer before copy
    strncpy(g_gpshal_ctx.proxy_apps, proxyApps, length);
    if (hal2mnl_set_nfw_access(g_gpshal_ctx.proxy_apps, length) == -1) {
        LOGE("hal2mnl_set_nfw_access failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    return true;
}

const GnssVisibilityControlInterface mtk_visibility_control_inf = {
    sizeof(GnssVisibilityControlInterface),
    visibility_set_callback,
    enable_nfw_access
};

//=========================================================
// Gps Navigation Message Interface

// Thread: BackgroundThread
// GpsNavigationMessageProvider uses GpsLocationProvider's handler
static int navimsginf_init(GpsNavigationMessageCallbacks* callbacks) {
    g_gpshal_ctx.navimsg_cbs = callbacks;
    int ret = hal2mnl_set_gps_navigation(true);
    return (ret > 0)?
            GPS_NAVIGATION_MESSAGE_OPERATION_SUCCESS :
            GPS_NAVIGATION_MESSAGE_ERROR_GENERIC;
}

// Thread: BackgroundThread
//      GpsNavigationMessageProvider uses GpsLocationProvider's handler
static void navimsginf_close(void) {
    if (hal2mnl_set_gps_navigation(false) == -1) {
        LOGE("hal2mnl_set_gps_navigation failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

const GpsNavigationMessageInterface mtk_navi_msg_inf = {
    sizeof(GpsNavigationMessageInterface),
    navimsginf_init,
    navimsginf_close
};

static int vzwdebuginf_init(VzwDebugCallbacks* callbacks) {
    g_gpshal_ctx.vzw_debug_cbs = callbacks;
    return 0;
}

static void vzwdebuginf_set(bool enabled) {
    if (hal2mnl_set_vzw_debug(enabled) == -1) {
        LOGE("hal2mnl_set_vzw_debug failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

const VzwDebugInterface mtk_vzw_debug_inf = {
    sizeof(VzwDebugInterface),
    vzwdebuginf_init,
    vzwdebuginf_set
};

static void gnss_configuration_update(const char* config_data, int32_t length) {
    if (hal2mnl_update_gnss_config(config_data, length) == -1) {
        LOGE("hal2mnl_update_gnss_config failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

static void gnss_setBlacklist(long long* blacklist, int32_t size) {
    if (hal2mnl_setBlacklist(blacklist, size) == -1) {
        LOGE("hal2mnl_setBlacklist failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

static void gnss_setEsExtensionSec(uint32_t emergencyExtensionSeconds) {
    char temp_string[64];
    LOGD("Set Emergency State Extension Second:%d", emergencyExtensionSeconds);
    memset(temp_string, 0, sizeof(temp_string));
    MNLD_SPRINTF(temp_string, "emergencyExtensionSeconds=%d", emergencyExtensionSeconds);
    if (hal2mnl_update_gnss_config(temp_string, strlen(temp_string)) == -1) {
        LOGE("hal2mnl_update_gnss_config failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

const GnssConfigurationInterface_ext mtk_gnss_config_inf = {
    sizeof(GnssConfigurationInterface_ext),
    gnss_configuration_update,
    gnss_setBlacklist,
    gnss_setEsExtensionSec
};

static bool get_internal_state(DebugData* debugData) {
    memcpy(debugData, &mnlDebugData, sizeof(DebugData));
    LOGD("debugData->time:Esttimems:%ld, uncNs: %.3f, ppb: %.3f",
        debugData->time.timeEstimate,
        debugData->time.timeUncertaintyNs,
        debugData->time.frequencyUncertaintyNsPerSec);
    return true;
}

const GpsDebugInterface_ext mtk_gps_debug_inf = {
    sizeof(GpsDebugInterface_ext),
    get_internal_state
};

//=========================================================
// Implementation of
//     Gps Iterface

// Thread: Main thread of system server
// Call seq:
//     LocationManagerService.systemRunning
//     LocationManagerService.loadProvidersLocked
//     GpsLocationProvider.static
//     android_location_GpsLocationProvider_class_init_native
//     sGpsInterface->get_extension
static const void* gpsinf_get_extension(const char* name) {
    if (strcmp(name, AGPS_INTERFACE) == 0) {
        return &mtk_agps_inf;
    }
    if (strcmp(name, GPS_NI_INTERFACE) == 0) {
        return &mtk_gps_ni_inf;
    }
    if (strcmp(name, AGPS_RIL_INTERFACE) == 0) {
        return &mtk_agps_ril_inf;
    }
    if (strcmp(name, GPS_MEASUREMENT_INTERFACE) == 0) {
       return &mtk_gps_meas_inf;
    }
    if (strcmp(name, GNSS_MEASUREMENT_CORRECTION_INTERFACE) == 0) {
       return &mtk_gnss_meas_correction_inf;
    }
    if (strcmp(name, GNSS_VISIBILITY_CONTROL_INTERFACE) == 0) {
       return &mtk_visibility_control_inf;
    }
    if (strcmp(name, GPS_NAVIGATION_MESSAGE_INTERFACE) == 0) {
       return &mtk_navi_msg_inf;
    }

    if (strcmp(name, VZW_DEBUG_INTERFACE) == 0) {
       return &mtk_vzw_debug_inf;
    }

    if (strcmp(name, GNSS_ANTENNA_INFO_INTERFACE) == 0) {
       return &mtk_antenna_info_inf;
    }

    if (!strcmp(name, GNSS_CONFIGURATION_INTERFACE)) {
        return &mtk_gnss_config_inf;
    }
#if 0  // not ready, even in Google's GPS JNI
    if (strcmp(name, SUPL_CERTIFICATE_INTERFACE) == 0) {
       return &mtk_supl_cert_inf;
    }
#endif
#if 0  // Similar to our EPO but we will do it in mnld.
    if (!strcmp(name, GPS_XTRA_INTERFACE))
        return &mtk_gps_xtra_inf;
#endif
    if (!strcmp(name, GPS_DEBUG_INTERFACE)) {
        return &mtk_gps_debug_inf;
    }
    return NULL;  // unsupported extension
}

// Thread: BackgroundThread
//     Its looper is shared by a lot of services including
//         LocationManagerService's handler
//         GpsLocationProvider's handler
//         GpsLocationProvider's broadcast receiver
// Call seq:
//     GpsLocationProvider.ProviderHandler.handleMessage
//     GpsLocationProvider.handleEnable
//     GpsLocationProvider.native_init
//     android_location_GpsLocationProvider_init
//     sGpsInterface->init
static int gpsinf_init(GpsCallbacks_ext* callbacks) {
    // GPSHAL_DEBUG_FUNC_SCOPE2(g_gpshal_ctx.mutex_gps_state_intent);

    // mnldinf_wake_lock_init();

    if (gpshal_gpscbs_save(callbacks) != 0) {
        return -1;    //  error
    }

    gpshal_set_gps_state_intent(GPSHAL_STATE_INIT);
    gpshal2mnl_gps_init();
    g_gpshal_ctx.mnl_retry_timer = mnldinf_init_timer(gpshal_mnl_retry_routine);
    return 0;  // OK to init
}

// Thread: BackgroundThread
static int gpsinf_start(void) {
    // GPSHAL_DEBUG_FUNC_SCOPE2(g_gpshal_ctx.mutex_gps_state_intent);
    if (GPSHAL_STATE_UNKNOWN == g_gpshal_ctx.gps_state_intent){
        LOGE("gpsinf_start failed: gps_state_intent=UNKNOWN");
        return -1;
    }
    memset(&mnlDebugData, 0, sizeof(DebugData));//clear debug data every session
    gpshal_set_gps_state_intent(GPSHAL_STATE_START);
    gpshal2mnl_gps_start();
    return 0;  // OK to start
}

// Thread: BackgroundThread
static int gpsinf_stop(void) {
    // GPSHAL_DEBUG_FUNC_SCOPE2(g_gpshal_ctx.mutex_gps_state_intent);
    if (GPSHAL_STATE_UNKNOWN == g_gpshal_ctx.gps_state_intent){
        LOGE("gpsinf_stop failed: gps_state_intent=UNKNOWN");
        return -1;
    }
    gpshal_set_gps_state_intent(GPSHAL_STATE_STOP);
    gpshal2mnl_gps_stop();
    return 0;  // OK to stop
}

// Thread: BackgroundThread
static void gpsinf_cleanup(void) {
    if (GPSHAL_STATE_UNKNOWN == g_gpshal_ctx.gps_state_intent){
        LOGE("gpsinf_cleanup failed: gps_state_intent=UNKNOWN");
        return -1;
    }
    timer_t retry_timer;
    // GPSHAL_DEBUG_FUNC_SCOPE2(g_gpshal_ctx.mutex_gps_state_intent);
    gpshal_set_gps_state_intent(GPSHAL_STATE_CLEANUP);
    gpshal2mnl_gps_cleanup();
    mnldinf_wake_lock_deinit();
    retry_timer = g_gpshal_ctx.mnl_retry_timer;
    g_gpshal_ctx.mnl_retry_timer = INVALID_TIMERID;
    if(mnldinf_deinit_timer(retry_timer) == -1) {
        LOGE("mnl_retry_timer deinit fail:%s", strerror(errno));
    }
}

// Thread: BackgroundThread
static int gpsinf_inject_time(GpsUtcTime time, int64_t timeReference, int uncertainty) {
    if (hal2mnl_gps_inject_time(time, timeReference, uncertainty) == -1) {
        LOGE("hal2mnl_gps_inject_time failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

// Thread: BackgroundThread
//     NetworkLocationListener uses the looper of GpsLocationProvider's handler
static int gpsinf_inject_location(
        double latitude,
        double longitude,
        float  accuracy) {
    if (hal2mnl_gps_inject_location(latitude, longitude, accuracy) == -1) {
        LOGE("hal2mnl_gps_inject_location failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

// Thread: Binder Thread of LocationManagerService
//
// Call seq:
//     LocationManagerService.sendExtraCommand
//     GpsLocationProvider.sendExtraCommand
//     GpsLocationProvider.deleteAidingData
//     GpsLocationProvider.native_delete_aiding_data
//     android_location_GpsLocationProvider_delete_aiding_data
//     sGpsInterface->delete_aiding_data
static void gpsinf_delete_aiding_data(GpsAidingData flags) {
    if (hal2mnl_gps_delete_aiding_data(flags) == -1) {
        LOGE("hal2mnl_gps_delete_aiding_data failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
}

// Thread: BackgroundThread or ???
//     GpsLocationProvider's handler may call it
//     GpsLocationProvider's mBroadcastReceiver may call it (PowerManager's intent)
static int gpsinf_set_position_mode(
        GpsPositionMode mode,
        GpsPositionRecurrence recurrence,
        uint32_t min_interval,
        uint32_t preferred_accuracy,
        uint32_t preferred_time,
        bool lowPowerMode) {
    if (hal2mnl_gps_set_position_mode(
            mode,
            recurrence,
            min_interval,
            preferred_accuracy,
            preferred_time,
            lowPowerMode) == -1) {
        LOGE("hal2mnl_gps_set_position_mode failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    return 0;  // 0:ok,   non-zero: error; GLP will show log if error
}

static int gpsinf_inject_fused_location(
        double latitude,
        double longitude,
        float  accuracy) {
    // TODO:  hal2mnl_gps_inject_fused_location(latitude, longitude, accuracy);
    UNUSED(latitude);
    UNUSED(longitude);
    UNUSED(accuracy);
    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

//The unit of interval is ms.
//interval:100,200,500,1000
static int gpsinf_fix_interval(uint32_t interval){
    int fix_interval;
    if(interval == 100 || interval == 200 || interval == 500 ||
    interval == 1000) {
        fix_interval = interval;
    }else{
        fix_interval = 1000;  //default 1HZ.
    }
    LOGD("fix interval = %u \n", fix_interval);

    if (hal2mnl_gps_fix_interval(fix_interval) == -1) {
        LOGE("hal2mnl_gps_fix_interval failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

//2:GP+GL+BD
//3:GP
//4:BD
//6:GP+GL+GA+BD
//8:GP+GL+GA
//10:GP+GL+GA+BD+NI
static int gpsinf_opmode(uint8_t opmode){
    if (hal2mnl_gps_opmode(opmode) == -1) {
        LOGE("hal2mnl_gps_opmode failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }

    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

//Constraint range:0~30 degree
static int gpsinf_elevation_angle(uint8_t elevation){
    char gnss_elevation;
    if(elevation >= 0 && elevation <= 30){
        gnss_elevation = elevation;
    }else{
        gnss_elevation = 5;  //default 5 angle.
    }

    if (hal2mnl_gps_elevation_angle(gnss_elevation) == -1) {
        LOGE("hal2mnl_gps_elevation_angle failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }

    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

//1:Disable L5.
//0:Enable L5;
static int gpsinf_l5_disable(bool flag){
    if (hal2mnl_gps_l5_disable(flag) == -1) {
        LOGE("hal2mnl_gps_l5_disable failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}

static const GpsInterface_ext  mtk_gps_inf = {
    sizeof(GpsInterface_ext),
    gpsinf_init,
    gpsinf_start,
    gpsinf_stop,
    gpsinf_cleanup,
    gpsinf_inject_time,
    gpsinf_inject_location,
    gpsinf_delete_aiding_data,
    gpsinf_set_position_mode,
    gpsinf_get_extension,
    gpsinf_inject_fused_location,
    gpsinf_fix_interval,
    gpsinf_opmode,
    gpsinf_elevation_angle,
    gpsinf_l5_disable,
};

#ifdef __ANDROID_OS__
//=========================================================
// Between
//     Gps Interface
//     Hardware Module Interface

static const GpsInterface_ext* gps_device__get_gps_interface(
        __unused struct gps_device_t_ext* device) {
    GPS_DEVICE__GET_GPS_INTERFACE__CHECK_PARAM;
    //hal2mnl_hal_reboot();
    return &mtk_gps_inf;
}

static const struct gps_device_t_ext gps_device = {
    .common = {                           // hw_device_t
        .tag     = HARDWARE_DEVICE_TAG,
        .version = 0,                     // GPS JNI will not use it
        .module  = &HAL_MODULE_INFO_SYM,
        .reserved = {0},
        .close   = NULL                   // GPS JNI will not call it
        },
    .get_gps_interface = gps_device__get_gps_interface
};

//=========================================================
// Implementation of
//     Hardware Module Interface

static int gps_hw_module_open(
        __unused const struct hw_module_t* module,
        __unused char const* id,
        struct hw_device_t** device) {
    GPS_HW_MODULE_OPEN__CHECK_PARAM;
    *device = (struct hw_device_t*)&gps_device;
    return 0;  // OK: refer to the cpp of GPS JNI
}

static struct hw_module_methods_t gps_hw_module_methods = {
    .open = gps_hw_module_open
};

struct hw_module_t HAL_MODULE_INFO_SYM = {
    .tag = HARDWARE_MODULE_TAG,
    .version_major = 1,
    .version_minor = 0,
    .id  = GPS_HARDWARE_MODULE_ID,
    .name   = "MediaTek GPS Hardware Module",
    .author = "MediaTek, Inc.",
    .methods = &gps_hw_module_methods,
    .dso     = NULL,
    .reserved = {0}
};
#else
//=========================================================
// Between
//     Gps Interface
//     Hardware Module Interface

const GpsInterface_ext* gps_device__get_gps_interface(struct gps_device_t_ext* device)
{
    LOGD("welcome enter libgpshal world\n");
    //hal2mnl_hal_reboot();

    return &mtk_gps_inf;
}

const struct gps_device_t_ext linux_gps_device = {
    .get_gps_interface = gps_device__get_gps_interface
};

#endif
