// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include "gpslog_socket_utils.h"
#include "gpslog_socket_data_coder.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <stddef.h> // offsetof
#include <stdarg.h>
#include <sys/stat.h>
#include <unistd.h> //usleep
#include <sys/socket.h>
#include <string.h>
#include <fcntl.h>
#include <arpa/inet.h> //inet_addr
#include <sys/un.h> //struct sockaddr_un
#include <sys/epoll.h>
#include <poll.h>
#include <sys/types.h>
#include <netdb.h>
#include <inttypes.h>

#if defined(__ANDROID_OS__)
#include <cutils/log.h>     // Android log

#define ANDROID_LOG_TAG "mtk_socket"
#endif

char *safe_strncpy(char *dest, const char *src, size_t n) {
    if (dest && n > 0) {
        // Use strncat for performance because strncpy will always fill n bytes in dest
        dest[0] = '\0';            // Let dest be an empty string
        strncat(dest, src, --n);   // n-1 because strncat may fill n+1 bytes
    }
    return dest;
}

//-1 means failure
int gpslog_socket_server_bind_local(const char* path, mtk_socket_namespace sock_namespace) {
    int size;
    struct sockaddr_un addr;
    int fd = socket(AF_UNIX, SOCK_DGRAM, 0);
    if (fd < 0) {
        LOGE("mtk_socket_server_bind_local() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_UNIX;
    size = strlen(path) + offsetof(struct sockaddr_un, sun_path) + 1;
    if(sock_namespace == SOCK_NS_ABSTRACT) {
        addr.sun_path[0] = 0;
        memcpy(addr.sun_path + 1, path, strlen(path));
    } else if(sock_namespace == SOCK_NS_FILESYSTEM) {
        safe_strncpy(addr.sun_path, path, sizeof(addr.sun_path));
        unlink(addr.sun_path);
    } else {
        LOGE("mtk_socket_server_bind_local() unknown namespace=[%d]", sock_namespace);
        close(fd);
        return -1;
    }
    if (bind(fd, (struct sockaddr *)&addr, size) == -1) {
        LOGE("mtk_socket_server_bind_local() bind() failed reason=[%s]%d for path=[%s]",
            strerror(errno), errno, path);
        close(fd);
        return -1;
    }
    return fd;
}


// -1 means failure
int gpslog_safe_recvfrom(int fd, char* buff, int len) {
    int ret = 0;
    int retry = 10;

    int flags = fcntl(fd, F_GETFL, 0);
    if (fcntl(fd, F_SETFL, flags | O_NONBLOCK) == -1){
        LOGE("fcntl failed reason=[%s]%d",
                    strerror(errno), errno);
    }

    while ((ret = recvfrom(fd, buff, len, 0,
         NULL, NULL)) == -1) {
        LOGW("gpslog_safe_recvfrom() ret=%d len=%d", ret, len);
        if (errno == EINTR) continue;
        if (errno == EAGAIN) {
            if (retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
        }
        LOGE("gpslog_safe_recvfrom() recvfrom() failed reason=[%s]%d",
            strerror(errno), errno);
        break;
    }
    return ret;
}

int gpslog_safe_recv(int fd, char* buff, int len) {
    int ret = 0;
    int retry = 10;

    while ((ret = read(fd, buff, len)) == -1) {
        LOGW("mnldinf_safe_recvfrom() ret=%d len=%d", ret, len);
        if (errno == EINTR) continue;
        if (errno == EAGAIN) {
            if (retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
        }
        LOGE("mnldinf_safe_recvfrom() recvfrom() failed reason=[%s]%d",
            strerror(errno), errno);
        break;
    }
    return ret;
}

