#ifndef MTK_AGPS_DATA_BASE_H
#define MTK_AGPS_DATA_BASE_H
#include <stdbool.h>
#include <time.h>
#include "mtk_gps_agps.h"

typedef unsigned char       uint8;
typedef char                int8;
typedef unsigned short      uint16;
typedef short               int16;
typedef unsigned int        uint32;
typedef int                 int32;
typedef unsigned long long  uint64;
typedef long long           int64;


#define SOURCE_LPP  (1<<0)
#define SOURCE_NTRIP  (1<<1)


#define AGENT_DATA_CENTER_SUCCESS                    (0)

#define AGENT_DATA_CENTER_UNKNOWN_FAIL               (-1)
#define AGENT_DATA_CENTER_MALLOC_FAIL                (-2)
#define AGENT_DATA_CENTER_FUNCTION_POINTER_NULL      (-3)
#define AGENT_DATA_CENTER_OUT_OF_INDEX               (-4)
#define AGENT_DATA_CENTER_GET_ITEM_FAIL              (-5)
#define AGENT_DATA_CENTER_ALREADY_EXIST              (-6)
#define AGENT_DATA_CENTER_PARAMETER_POINTER_NULL     (-7)
#define AGENT_DATA_CENTER_SYS_API_FAIL               (-8)
#define AGENT_DATA_CENTER_NOT_SUPPORT                (-9)

#define DATA_CENTER_DEBUG_RAWDATA

#ifndef MAX
#define MAX(A,B) ((A)>(B)?(A):(B))
#endif
#ifndef MIN
#define MIN(A,B) ((A)<(B)?(A):(B))
#endif

#define ARRAY_SIZE(array) (sizeof(array)/sizeof(array[0]))


//below from RTCM 3.3
#define RTCM_MAX_SAT_32      32
#define RTCM_MAX_SAT_64      64
#define RTCM_MAX_SAT_CODE     32

#define RTCM_HEADER_LEN        3              // 1byte preamble+ 8bit reserved + 10bit length
#define RTCM_CRC_LEN           3              // CRC Length is 3 bytes
#define RTCM_PKT_BUF          (1023 + 3)      //MAX pkt length + header

#define RTCM_PKT_LEN_BIT_MASK  0x000003FF     //10 bit for pkt length
#define RTCM_PKT_PREAMBLE      0xD3


#define RTCM_1001_MAX_SAT      32
#define RTCM_1001_ONE_GPS_SAT_BITS 58

#define RTCM_1002_MAX_SAT      32
#define RTCM_1002_ONE_GPS_SAT_BITS 74

#define RTCM_1003_MAX_SAT      32
#define RTCM_1003_ONE_GPS_SAT_BITS 101

#define RTCM_1004_MAX_SAT      32
#define RTCM_1004_ONE_GPS_SAT_BITS 125

#define RTCM_1009_MAX_SAT      32
#define RTCM_1009_ONE_GLO_SAT_BITS 64

#define RTCM_1010_MAX_SAT      32
#define RTCM_1010_ONE_GLO_SAT_BITS 79

#define RTCM_1011_MAX_SAT      32
#define RTCM_1011_ONE_GLO_SAT_BITS 107

#define RTCM_1012_MAX_SAT      32
#define RTCM_1012_ONE_GLO_SAT_BITS 130

#define RTCM_1033_MAX_NUM_N    31
#define RTCM_1033_MAX_NUM_M    31
#define RTCM_1033_MAX_NUM_I    31
#define RTCM_1033_MAX_NUM_J    31
#define RTCM_1033_MAX_NUM_K    31

#define RTCM_1057_MAX_SAT      64
#define RTCM_1057_ONE_GPS_SAT_BITS 135

#define RTCM_1058_MAX_SAT      64
#define RTCM_1058_ONE_GPS_SAT_BITS 76

#define RTCM_1059_MAX_SAT      64
#define RTCM_1059_MAX_SAT_CODE 32
#define RTCM_1059_ONE_GPS_SAT_BITS 11  //need to check and confirm
#define RTCM_1059_ONE_GPS_SAT_ONE_CODE_BITS 19

#define RTCM_1060_MAX_SAT      64
#define RTCM_1060_ONE_GPS_SAT_BITS 205

#define RTCM_1061_MAX_SAT      64
#define RTCM_1061_ONE_GPS_SAT_BITS 12

#define RTCM_1062_MAX_SAT      64
#define RTCM_1062_ONE_GPS_SAT_BITS 28

#define RTCM_1063_MAX_SAT      64
#define RTCM_1063_ONE_GLO_SAT_BITS 134

#define RTCM_1064_MAX_SAT      64
#define RTCM_1064_ONE_GLO_SAT_BITS 75

#define RTCM_1065_MAX_SAT      64
#define RTCM_1065_MAX_SAT_CODE 32
#define RTCM_1065_ONE_GLO_SAT_BITS 10  //need to check and confirm
#define RTCM_1065_ONE_GLO_SAT_ONE_CODE_BITS 19

#define RTCM_1066_MAX_SAT      64
#define RTCM_1066_ONE_GLO_SAT_BITS 204

#define RTCM_1067_MAX_SAT      64
#define RTCM_1067_ONE_GLO_SAT_BITS 11

#define RTCM_1068_MAX_SAT      64
#define RTCM_1068_ONE_GLO_SAT_BITS 27

#define RTCM_MSMX_MAX_SAT      64
#define RTCM_MSMX_MAX_SAT_SIG      32

#define RTCM_MSM1_ONE_SAT_BITS 10
#define RTCM_MSM1_ONE_SIG_BITS 15

#define RTCM_MSM2_ONE_SAT_BITS 10
#define RTCM_MSM2_ONE_SIG_BITS 27

#define RTCM_MSM3_ONE_SAT_BITS 10
#define RTCM_MSM3_ONE_SIG_BITS 42

#define RTCM_MSM4_ONE_SAT_BITS 18
#define RTCM_MSM4_ONE_SIG_BITS 48

#define RTCM_MSM5_ONE_SAT_BITS 36
#define RTCM_MSM5_ONE_SIG_BITS 63

#define RTCM_MSM6_ONE_SAT_BITS 18
#define RTCM_MSM6_ONE_SIG_BITS 65

#define RTCM_MSM7_ONE_SAT_BITS 36
#define RTCM_MSM7_ONE_SIG_BITS 80


#define RTCM_1104_MAX_SAT      37
#define RTCM_1104_ONE_SAT_BLK_BITS 69


//below from LPP R16
#ifndef GNSS_SGN_ID_VALUE_MAX
#define GNSS_SGN_ID_VALUE_MAX 7
#endif

#define BITS_PER_INT  (32)


#define BITOP_MASK(nr)        (1UL << ((nr) % BITS_PER_INT))
#define BITOP_WORD(nr)        ((nr) / BITS_PER_INT)


#define MESSAGE_HASH_SIZE    255
#define ITEM_SIZE_MAX (10*1024)


#define BITS_TO_LONGS(bits) (((bits)+BITS_PER_INT-1)/BITS_PER_INT)
#define DECLARE_BITMAP(name,bits) unsigned int name[BITS_TO_LONGS(bits)]


/* GNSS ID Bitmap, use two-byte representation */
#define GNSS_ID_BITMAP_NONE     0x00
#define GNSS_ID_BITMAP_GPS      0x8000  /* gps     (0) */
#define GNSS_ID_BITMAP_SBAS     0x4000  /* sbas    (1) */
#define GNSS_ID_BITMAP_QZSS     0x2000  /* qzss    (2) */
#define GNSS_ID_BITMAP_GALILEO  0x1000  /* galileo (3) */
#define GNSS_ID_BITMAP_GLONASS  0x0800  /* glonass (4) */
#define GNSS_ID_BITMAP_BDS      0x0400  /* bds     (5) */
#define GNSS_ID_BITMAP_NAVIC    0x0200  /* navic   (6) */

#define GNSS_MAX_EQUAL_INT_AMBIGUITY_LEVEL_REF_STATION_ID_NUM 16
#define GNSS_MAX_SSR_RELATIVE_LOCATION_ELEMENT 64
#define GNSS_MAX_RTK_SAT_SIGNAL_DATA_ELEMENT 24
#define GNSS_MAX_RTK_SAT_DATA_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_ORBIT_CORRECTION_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_CLOCK_CORRECTION_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_CODE_BIAS_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_URA_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_PHASE_BIAS_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_STEC_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_STEC_RESIDUAL_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_GRID_ELEMENT 64
#define GNSS_MAX_NAVIC_CORRECTION_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_NAVIC_REGION_IGP_ELEMENT 16
#define GNSS_MAX_SAT_LIST_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */

/* GNSS Signal ID value */
#define GNSS_SGN_ID_VALUE_GPS_L1C_A       0
#define GNSS_SGN_ID_VALUE_GPS_L1C         1
#define GNSS_SGN_ID_VALUE_GPS_L2C         2
#define GNSS_SGN_ID_VALUE_GPS_L5          3
#define GNSS_SGN_ID_VALUE_GPS_L1P 4
#define GNSS_SGN_ID_VALUE_GPS_L1Z 5
#define GNSS_SGN_ID_VALUE_GPS_L2_C_A 6
#define GNSS_SGN_ID_VALUE_GPS_L2P 7
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2Z 8
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2C_M 9
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2C_L 10
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2C_M_L 11
#define GNSS_SGN_ID_EXT_VALUE_GPS_L5I 12
#define GNSS_SGN_ID_EXT_VALUE_GPS_L5Q 13
#define GNSS_SGN_ID_EXT_VALUE_GPS_L5_I_Q 14
#define GNSS_SGN_ID_EXT_VALUE_GPS_L1C_D 15
#define GNSS_SGN_ID_EXT_VALUE_GPS_L1C_P 16
#define GNSS_SGN_ID_EXT_VALUE_GPS_L1C_D_P 17

#define GNSS_SGN_ID_VALUE_SBAS_L1         0
#define GNSS_SGN_ID_VALUE_SBAS_L5I 1
#define GNSS_SGN_ID_VALUE_SBAS_L5Q 2
#define GNSS_SGN_ID_VALUE_SBAS_L5_I_Q 3

#define GNSS_SGN_ID_VALUE_QZSS_L1C_A      0
#define GNSS_SGN_ID_VALUE_QZSS_L1C        1
#define GNSS_SGN_ID_VALUE_QZSS_L2C        2
#define GNSS_SGN_ID_VALUE_QZSS_L5         3
#define GNSS_SGN_ID_VALUE_QZSS_LEX_S 4
#define GNSS_SGN_ID_VALUE_QZSS_LEX_L 5
#define GNSS_SGN_ID_VALUE_QZSS_LEX_S_L 6
#define GNSS_SGN_ID_VALUE_QZSS_L2C_M 7
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L2C_L 8
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L2C_M_L 9
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L5I 10
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L5Q 11
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L5_I_Q 12
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L1C_D 13
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L1C_P 14
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L1C_D_P 15

#define GNSS_SGN_ID_VALUE_GLONASS_G1      0
#define GNSS_SGN_ID_VALUE_GLONASS_G2      1
#define GNSS_SGN_ID_VALUE_GLONASS_G3      2
#define GNSS_SGN_ID_VALUE_GLONASS_G1P 3
#define GNSS_SGN_ID_VALUE_GLONASS_G2P 4
#define GNSS_SGN_ID_VALUE_GLONASS_G1A_D 5
#define GNSS_SGN_ID_VALUE_GLONASS_G1A_P 6
#define GNSS_SGN_ID_VALUE_GLONASS_G1A_D_P 7
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G2A_I 8
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G2A_P 9
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G2A_I_P 10
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G3I 11
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G3Q 12
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G3_I_Q 13

#define GNSS_SGN_ID_VALUE_GALILEO_E1      0
#define GNSS_SGN_ID_VALUE_GALILEO_E5A     1
#define GNSS_SGN_ID_VALUE_GALILEO_E5B     2
#define GNSS_SGN_ID_VALUE_GALILEO_E6      3
#define GNSS_SGN_ID_VALUE_GALILEO_E5_A_B  4
#define GNSS_SGN_ID_VALUE_GALILEO_E1C 5
#define GNSS_SGN_ID_VALUE_GALILEO_E1A 6
#define GNSS_SGN_ID_VALUE_GALILEO_E1B 7
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E1_B_C 8
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E1_A_B_C 9
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6C 10
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6A 11
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6B 12
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6_B_C 13
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6_A_B_C 14
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5B_I 15
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5B_Q 16
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5B_I_Q 17
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5_A_B_I 18
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5_A_B_Q 19
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5_A_B_I_Q 20
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5A_I 21
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5A_Q 22
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5A_I_Q 23

#define GNSS_SGN_ID_VALUE_BDS_B1I         0
#define GNSS_SGN_ID_VALUE_BDS_B1Q 1
#define GNSS_SGN_ID_VALUE_BDS_B1_I_Q 2
#define GNSS_SGN_ID_VALUE_BDS_B3I 3
#define GNSS_SGN_ID_VALUE_BDS_B3Q 4
#define GNSS_SGN_ID_VALUE_BDS_B3_I_Q 5
#define GNSS_SGN_ID_VALUE_BDS_B2I 6
#define GNSS_SGN_ID_VALUE_BDS_B2Q 7
#define GNSS_SGN_ID_EXT_VALUE_BDS_B2_I_Q 8
#define GNSS_SGN_ID_EXT_VALUE_BDS_B1C_D 9
#define GNSS_SGN_ID_EXT_VALUE_BDS_B1C_P 10
#define GNSS_SGN_ID_EXT_VALUE_BDS_B1C_D_P 11

#define DATA_CENTER_TRANSFER_MAX_SAT_SIG  8
#define DATA_CENTER_TRANSFER_MAX_SAT  32

typedef enum {
    GNSS_TOW,
    GNSS_TOD,
} gnss_time_type;

typedef enum {
    AGENT_ID_RefStation_info                = 0,
    AGENT_ID_Receiver_Antenna_Dec           = 1,
    AGENT_ID_Phy_Ref_Station_Info           = 2,
    AGENT_ID_RTK_MSM1_Observations          = 3,
    AGENT_ID_RTK_MSM2_Observations          = 4,
    AGENT_ID_RTK_MSM3_Observations          = 5,
    AGENT_ID_RTK_MSM4_Observations          = 6,
    AGENT_ID_RTK_MSM5_Observations          = 7,
    AGENT_ID_RTK_MSM6_Observations          = 8,
    AGENT_ID_RTK_MSM7_Observations          = 9,
    AGENT_ID_SSR_Orbit_Corrections          = 10,
    AGENT_ID_Clock_Corrections              = 11,
    AGENT_ID_Code_Bias_Datas                = 12,
    AGENT_ID_SSR_URA_Datas                  = 13,
    AGENT_ID_Phase_Bias_Datas               = 14,
    AGENT_ID_SSR_STEC_Corrections           = 15,
    AGENT_ID_SSR_CorrectionPoints           = 16,
    AGENT_ID_SSR_Gridded_Correction         = 17,
    AGENT_ID_GG_L1_Obsers                   = 18,
    AGENT_ID_GG_L1_L2_Obsers                = 19,
    AGENT_ID_BDS_GRID_ION                   = 20,
    AGENT_ID_MAX                            = 21
} data_center_msg_id;


typedef struct { DECLARE_BITMAP(bits, AGENT_ID_MAX); } fast_table_bitmap_t;


#define FAST_TABLE_MASK_NONE                            \
(fast_table_bitmap_t) { {                                \
    [0 ... BITS_TO_LONGS(AGENT_ID_MAX)-1] =  0UL                \
} }

struct id_list {
    struct id_list *next;
    uint32 id;
};

typedef struct {
    uint32 total_num;
    uint32 id_array[0];
} agps_data_base_fast_list;

#define TRANS_STRATEGY_HOLD  (1<<0) // will send fast table to mnl first
#define TRANS_STRATEGY_PERIODIC (1<<1) //will monitor the data
#define UNPACK_STRATEGY_UNPACK (1<<2) //will unpack the data when transfer
#define SAVE_STRATEGY_NO_SAVE (1<<3) //will not save to database, will free every message after sending them to mnl

typedef enum {
    DATA_CENTER_IDLE = 0, //mnld begin run.
    DATA_CENTER_REQUESTING = 1, // mnl has already required time ,but did not receieve MD ack.
    DATA_CENTER_REQUESTED = 2,  //mnl has already required time ,and receieve MD ack.
} data_center_status;

typedef enum {
    ADAPTER_SOURCE_ID_LPP = 0,
    ADAPTER_SOURCE_ID_RTCM = 1,
    ADAPTER_SOURCE_ID_MAX = 2,
} ADAPTER_SOURCE_ID;

struct agps_data_base_fast_table {
    uint32 total_num;
    struct id_list *list;// used for query
    fast_table_bitmap_t bitmap; //used for transfer
};

struct agps_data_base {
    uint32 data_size;//size of this structure with payload lenth
    struct agps_data_base *next;//mnl should not use this pointer, only can be used by data center
    uint32 source_id;
    uint32 message_id;
    time_t utc_seconds;//add os tick, utc time
    uint32 os_tick;
    uint32 total_num;
    uint32 item_size;
    union {
        uint32 rtcm_messageID;
        uint32 lpp_transactionID;
    } private_data;
    char valid;
    char data[0];
};

struct fast_table_iter {
    fast_table_bitmap_t* bitmap;
    uint32 cur;
};

struct data_center_fsm {
    data_center_status status;
    uint64 time_stamp;// unit: s
    uint16 internal_transactionID;//0:when mnld boot up; increase when new req from mnl
    void *pri;// private data of specific data source
};

struct require_parameter {
    /*tbc*/
};

struct bitmap_iter {
    unsigned int *bitmap;
    unsigned int offset;
    unsigned int size;
};

/*lpp gnss_ha_referenceStationID_struct*/
typedef struct {
    uint16 referenceStationID; /* 0..65535 */
    char providerNameValid;
    uint32 providerNameLen;
    char providerName[32]; /* SIZE (1..32) */
} referenceStationID;

/* AntennaReferencePointUnc-r15 */
typedef struct {
    uint8 uncX; /* 0..255 */
    uint8 confX; /* 0..100 */
    uint8 uncY; /* 0..255 */
    uint8 confY; /* 0..100 */
    uint8 uncZ; /* 0..255 */
    uint8 confZ; /* 0..100 */
} antennaReferencePointUnc;

typedef struct {
    MTK_GNSS_ID_ENUM gnssTimeID;
    uint32 tow;
} tow_time_struct;

typedef struct {
    referenceStationID u2RefStationID; //Reference station ID
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    char IODSValid;
    uint8 u1IODS;          //IODS-Issue of Data Station
    uint8 u1Reserved;        //Reserved
    uint8 u1ClkSteerInd;     //Clock Steering Indicator
    uint8 u1ExtClkInd;       //External Clock Indicator
    uint8 u1DFSInd;       //GNSS Divergence-free Smoothing Indicator
    uint8 u1SmthInt;      //GNSS Smoothing Interval
    /*if need? if can be instead by gnsstime*/uint8 u1DOW;           //GLONASS Day Of Week
} rtcm_msg_common_header;

//Content of Signal Data for MSM1 : DF400
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int16 i2FinePseu;          //GNSS Signal fine Pseudoranges
    uint8 u1Flag;         //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm1_sat_sig;

//Content of Satellite Date for MSM1 : DF398
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm1_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;         //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm1_sat;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm1_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm1_sat;

//Content of Signal Data for MSM2 : DF401, DF402, DF420
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int32 i4FinePhase;               //GNSS Signal fine Phaserange  data
    uint8 u1PhaseLockTimeInd; //GNSS Phaserange Lock Time Indicator
    uint8 u1HalfCycleAmbInd;  //Half-cycle ambiguity indicator
    uint8 u1Flag;         //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm2_sat_sig;

//Content of Satellite Date for MSM2 : DF398
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm2_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;          //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm2_sat;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm2_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm2_sat;

//Content of Signal Data for MSM3 : DF400, DF401, DF402, DF420
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int16 i2FinePseu;              //GNSS Signal fine Pseudoranges
    int32 i4FinePhase;               //GNSS Signal fine Phaserange  data
    uint8 u1PhaseLockTimeInd; //GNSS Phaserange Lock Time Indicator
    uint8 u1HalfCycleAmbInd;  //Half-cycle ambiguity indicator
    uint8 u1Flag;         //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm3_sat_sig;

//Content of Satellite Date for MSM3 : DF398
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm3_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;         //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm3_sat;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm3_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm3_sat;

//Content of Signal Data for MSM4 : DF400, DF401, DF402, DF420, DF403
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int16 i2FinePseu;              //GNSS Signal fine Pseudoranges
    int32 i4FinePhase;               //GNSS Signal fine Phaserange  data
    uint8 u1PhaseLockTimeInd; //GNSS Phaserange Lock Time Indicator
    uint8 u1HalfCycleAmbInd;  //Half-cycle ambiguity indicator
    uint8 u1CNRs;             //GNSS signal CNRs
    uint8 u1Flag;          //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm4_sat_sig;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm4_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm4_sat;

//Content of Satellite Date for MSM4 : DF397, DF398
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm4_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;          //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm4_sat;

//Content of Signal Data for MSM5 : DF400, DF401, DF402, DF420, DF403, DF404
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int16 i2FinePseu;              //GNSS Signal fine Pseudoranges
    int32 i4FinePhase;               //GNSS Signal fine Phaserange  data
    uint8 u1PhaseLockTimeInd; //GNSS Phaserange Lock Time Indicator
    uint8 u1HalfCycleAmbInd;  //Half-cycle ambiguity indicator
    uint8 u1CNRs;             //GNSS signal CNRs
    int16 i2FinePhaRanRates;      //GNSS signal fine PhaseRangeRates
    uint8 u1Flag;            //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm5_sat_sig;

//Content of Satellite Date for MSM5 : DF397, specific, DF398, DF399
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint8 u1ExtInfo;        //Extended Satellite Information, (if it's GLONASS satellite, it means Frequency Channel Number)
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    int16 i2RouPhaRanRates;    //GNSS Satellite rough PhaseRangeRates
    uint8 u1SigNum;
    data_center_rtcm_t_msm5_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;          //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm5_sat;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint8 u1ExtInfo;        //Extended Satellite Information, (if it's GLONASS satellite, it means Frequency Channel Number)
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    int16 i2RouPhaRanRates;    //GNSS Satellite rough PhaseRangeRates
    uint8 u1SigNum;
    data_center_rtcm_t_msm5_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm5_sat;

//Content of Signal Data for MSM6 : DF405, DF406, DF407, DF420, DF408
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int32 i4FinePseuExt;              //GNSS Signal fine Pseudoranges with extended resolution
    int32 i4FinePhaseExt;               //GNSS Signal fine Phaserange data with extended resolution
    uint16 u2PhaseLockTimeIndExt; //GNSS Phaserange Lock Time Indicator with extended range and resolution
    uint8 u1HalfCycleAmbInd;  //Half-cycle ambiguity indicator
    uint16 u2CNRsExt;         //GNSS signal CNRs with extended resolution
    uint8 u1Flag;           //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm6_sat_sig;

//Content of Satellite Date for MSM6 : DF397, DF398
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm6_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;           //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm6_sat;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm6_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm6_sat;

//Content of Signal Data for MSM7 : DF405, DF406, DF407, DF420, DF408, DF404
typedef struct {
    uint8 u1SigID;         //Signal ID in Signal Mask 1-32 [range:1-32]
    int32 i4FinePseuExt;              //GNSS Signal fine Pseudoranges with extended resolution
    int32 i4FinePhaseExt;               //GNSS Signal fine Phaserange data with extended resolution
    uint16 u2PhaseLockTimeIndExt; //GNSS Phaserange Lock Time Indicator with extended range and resolution
    uint8 u1HalfCycleAmbInd;  //Half-cycle ambiguity indicator
    char carrierToNoiseRatioValid;
    uint16 u2CNRsExt;         //GNSS signal CNRs with extended resolution
    char finePhaseRangeRateValid;
    int16 i2FinePhaRanRates;      //GNSS signal fine PhaseRangeRates
    uint8 u1Flag;           //if flag is 1, it means the signal data is available to get
} data_center_rtcm_t_msm7_sat_sig;

//Content of Satellite Date for MSM7 : DF397, specific, DF398, DF399
typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    char integerMsValid;
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint8 u1ExtInfo;        //Extended Satellite Information, (if it's GLONASS satellite, it means Frequency Channel Number)
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    char roughPhaseRangeRateValid;
    int16 i2RouPhaRanRates;    //GNSS Satellite rough PhaseRangeRates
    uint8 u1SigNum;
    data_center_rtcm_t_msm7_sat_sig rSatSigInfo[RTCM_MSMX_MAX_SAT_SIG];
    uint8 u1Flag;          //if Flag is 1, it means the satellite data is available to get
} data_center_rtcm_t_msm7_sat;

typedef struct {
    uint8 u1SatID;         //Satellite ID in Satellite Mask [range:1-64]
    uint8 u1RouRanInteger; //The number of integer milliseconds in GNSS Satellite rough ranges
    uint16 u2RouRanMod;     //GNSS Satellite rough ranges modulo 1 millisecond
    uint8 u1SigNum;
    data_center_rtcm_t_msm7_sat_sig rSatSigInfo[DATA_CENTER_TRANSFER_MAX_SAT_SIG];
} reduced_data_center_rtcm_t_msm7_sat;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm1_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm1_observation;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm2_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm2_observation;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm3_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm3_observation;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm4_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm4_observation;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm5_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm5_observation;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm6_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm6_observation;

typedef struct {
    uint8 u1SatNum;
    uint64 u8SatMask;  //GNSS Satellite Mask
    uint32 u4SigMask;            //GNSS Signal Mask
    uint64 u8CellMask; //GNSS Cell Mask
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    data_center_rtcm_t_msm7_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_rtk_msm7_observation;

typedef struct {
    uint8 u1SatID;         //GPS Satellite ID
    uint16 u1IODE;          //GPS IODE
    int32 i4DeltaRadial;             //Delta Radial
    int32 i4DeltaAlong_Track;        //Delta Along_Track
    int32 i4DeltaCross_Track;        //Delta Cross_Track
    char dotDeltaRadialValid;
    int32 i4DotDeltaRadial;          //Dot Delta Radial
    char dotDeltaAlongTrackValid;
    int32 i4DotDeltaAlong_Track;     //Dot Delta Along_Track
    char dotDeltaCrossTrackValid;
    int32 i4DotDeltaCross_Track;     //Dot Delta Cross_Track
    uint8 u1Flag;
} RTCM_T_ORBIT_SAT;

typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    char u1satRefDatumValid;
    gnss_ssr_orbit_corrections_sat_ref_datum_enum satRefDatum;
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1SatRefDat;     //Satellite Reference Datum
    uint8 u1IOD;           //IOD SSR

    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    RTCM_T_ORBIT_SAT rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_ssr_orbit_correction;

typedef struct {
    uint8 u1SatID;         //GPS Satellite ID
    int32 i4DeltaClk_C0;            //Delta Clock C0
    char deltaClockC1Valid;
    int32 i4DeltaClk_C1;            //Delta Clock C1
    char deltaClockC2Valid;
    int32 i4DeltaClk_C2;            //Delta Clock C2
    char u1HighRateClkCorValid;
    int i4HighRateClkCor;         //High Rate Clock Correction
    uint8 u1Flag;
} data_center_rtcm_t_clock_correction_sat;

typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1IOD;           //IOD SSR

    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    data_center_rtcm_t_clock_correction_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_clock_correction;

typedef struct {
    uint8 u1Signal_TrackModeInd;    //GPS Signal and Tracking Mode Indicator
    int16 i2CodeBias;   //Code Bias
    uint8 u1Flag;
} data_center_rtcm_t_code_bias_sat_code;

typedef struct {
    uint8 u1SatID;         //GPS Satellite ID
    uint8 u1CodeBiasNUM;   //No. of Code Biases Processed
    data_center_rtcm_t_code_bias_sat_code rCodeBiasMsg[RTCM_MAX_SAT_CODE];
    uint8 u1Flag;
} data_center_rtcm_t_code_bias_sat;

//Type 1059 Message, Each Satellite - SSR GPS Clock Code Bias Message
typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1IOD;           //IOD SSR
    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    data_center_rtcm_t_code_bias_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_code_bias_data;

typedef struct {
    uint8 u1SatID;         //GPS Satellite ID
    uint8 u1URA;           //SSR URA
    uint8 u1Flag;
} data_center_rtcm_t_ssr_ura_sat;

//Type 1061 Message, Each Satellite - SSR GPS URA Message
typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1IOD;           //IOD SSR
    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    data_center_rtcm_t_ssr_ura_sat rSatInfo[RTCM_MSMX_MAX_SAT];
} data_center_ssr_ura_data;

/* LPP_SSR_PhaseBiasSignalElement_r16 */
typedef struct {
    uint8 gnssSignalID; /* map to GNSS_SGN_ID_VALUE_*, 0..7 */
    char gnssSignalIDExtValid; /* KAL_TRUE: gnssSignalID is set to 7 and shall be ignored */
    uint8 gnssSignalIDExt; /* map to GNSS_SGN_ID_EXT_VALUE_*, 8..23 */
    int16 phaseBias; /* -16384..16383 */
    uint8 phaseDiscontinuityIndicator; /* 0..3 */
    char phaseBiasIntegerIndicatorValid;
    uint8 phaseBiasIntegerIndicator; /* 0..3 */
} data_center_phase_bias_signal_element_struct;

/* LPP_SSR_PhaseBiasSignalList_r16 */
typedef struct {
    uint8 numSsrPhaseBiasSigElm;
    data_center_phase_bias_signal_element_struct ssrPhaseBiasSigElm[GNSS_SGN_ID_VALUE_MAX];
} data_center_phase_bias_signal_list_struct;

/* LPP_SSR_PhaseBiasSatElement_r16 */
typedef struct {
    uint8 svID; /* 0..63 */
    data_center_phase_bias_signal_list_struct ssrPhaseBiasSigList;
} data_center_phase_bias_sat_element_struct;

/* LPP_SSR_PhaseBiasSatList_r16 */
typedef struct {
    uint8 numSsrPhaseBiasSatElm;
    data_center_phase_bias_sat_element_struct ssrPhaseBiasSatElm[GNSS_MAX_SSR_PHASE_BIAS_SAT_ELEMENT];
} data_center_phase_bias_sat_list_struct;

/* LPP_GNSS_SSR_PhaseBias_r16 */
typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 ssrUpdateInterval; /* 0..15 */
    uint8 iodSsr; /* 0..15 */
    data_center_phase_bias_sat_list_struct ssrPhaseBiasSatList;
} data_center_phase_bias_data;

typedef struct {
    uint8 svID; /* 0..63 */
    uint8 stecQualityIndicator; /* 6 bits. The 3 MSB define the CLASS with a range of 0-7 and the 3 LSB define the VALUE with a range of 0-7 */
    int16 stecC00; /* -8192..8191 */
    char stecC01Valid;
    int16 stecC01; /* -2048..2047 */
    char stecC10Valid;
    int16 stecC10; /* -2048..2047 */
    char stecC11Valid;
    int16 stecC11; /* -512..511 */
} data_center_stec_sat_element_struct;

/* LPP_STEC_SatList_r16 */
typedef struct {
    uint8 numStecSatElm;
    data_center_stec_sat_element_struct stecSatElm[GNSS_MAX_SSR_STEC_SAT_ELEMENT];
} data_center_stec_sat_list_struct;

/* LPP_GNSS_SSR_STEC_Correction_r16 */
typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 ssrUpdateInterval; /* 0..15 */
    uint8 iodSsr; /* 0..15 */
    uint16 correctionPointSetID; /* 0..16383 */
    data_center_stec_sat_list_struct stecSatList;
} data_center_ssr_stec_correction;

/* LPP_RelativeLocationElement_r16 */
typedef struct {
    int16 deltaLatitude; /* -512..511 */
    int16 deltaLongitude; /* -1024..1023 */
} data_center_relative_location_element_struct;

/* LPP_GNSS_SSR_ListOfCorrectionPoints_r16_relativeLocationsList_r16 */
typedef struct {
    uint8 numRelativeLocElm;
    data_center_relative_location_element_struct relativeLocElm[GNSS_MAX_SSR_RELATIVE_LOCATION_ELEMENT];
} data_center_relative_locations_list_struct;

/* LPP_GNSS_SSR_ListOfCorrectionPoints_r16 */
typedef struct {
    int16 referencePointLatitude; /* -16384..16383 */
    int16 referencePointLongitude; /* -32768..32767 */
    data_center_relative_locations_list_struct relativeLocList;
} data_center_ssr_list_of_correction_points_struct;

/* LPP_GNSS_SSR_ArrayOfCorrectionPoints_r16 */
typedef struct {
    int16 referencePointLatitude; /* -16384..16383 */
    int16 referencePointLongitude; /* -32768..32767 */
    uint8 numberOfStepsLatitude; /* 0..63 */
    uint8 numberOfStepsLongitude; /* 0..63 */
    uint16 stepOfLatitude; /* 1..511 */
    uint16 stepOfLongitude; /* 1..1023 */
    char bitmaskOfGridsValid;
    uint8 bitmaskOfGrids[8]; /* Only the first numberOfStepsLatitude*numberOfStepsLongitude bits are used, the remainder are set to '0' */
} data_center_ssr_array_of_correction_points_struct;

/* LPP_GNSS_SSR_CorrectionPoints_r16_correctionPoints_r16 */
typedef struct {
    gnss_ssr_correction_points_enum selection;
    union {
      data_center_ssr_list_of_correction_points_struct listOfCorrectionPoints;
      data_center_ssr_array_of_correction_points_struct arrayOfCorrectionPoints;
    } choice;
} data_center_correction_points_struct;


/* LPP_TropospericDelayCorrection_r16 */
typedef struct {
    int16 tropoHydroStaticVerticalDelay; /* -256..255 */
    int8 tropoWetVerticalDelay; /* -128..127 */
} data_center_troposperic_delay_correction_struct;

/* LPP_STEC_ResidualSatElement_r16 */
typedef struct {
    uint8 svID; /* 0..63 */
    gnss_stec_residual_correction_enum selection;
    union {
        int8 b7; /* -64..63 */
        int16 b16; /* -32768..32767 */
    } choice;
} data_center_stec_residual_sat_element_struct;

/* LPP_STEC_ResidualSatList_r16 */
typedef struct {
    uint8 numResidualSatElm;
    data_center_stec_residual_sat_element_struct stecResidualSatElm[GNSS_MAX_STEC_RESIDUAL_SAT_ELEMENT];
} data_center_stec_residual_sat_list_struct;


/* LPP_GridElement_r16 */
typedef struct {
    char tropospericDelayCorrectionValid;
    data_center_troposperic_delay_correction_struct tropospericDelayCorrection; /* OPTIONAL */
    data_center_stec_residual_sat_list_struct stecResidualSatList;
} data_center_grid_element_struct;

/* LPP_GridList_r16 */
typedef struct {
    uint8 numGridElm;
    data_center_grid_element_struct gridElm[GNSS_MAX_SSR_GRID_ELEMENT];
} data_center_grid_list_struct;

typedef struct {
    uint8 u1SatID;         //GLONASS Satellite ID(Satellite Slot Number)
    uint8 u1L1CodeInd;     //GLONASS L1 Code Indicator
    uint8 u1FreqChanNum;    //GLONASS Satellite Frequency Channel Number
    uint32 u4L1Pseu;        //GLONASS L1 Pseudorange
    int32 i4L1PhaPseuDif;           //GlONASS L1 PhaseRange - L1 Pseudorange
    uint8 u1L1TimeInd;     //GLONASS L1 Lock time Indicator
    char pseuModAmbgValid;
    uint8 u1L1PseuModAmbg; //GLONASS Integer L1 Pseudorange Modulus Ambiguity
    char L1CNRValid;
    uint8 u1L1CNR;         //GLONASS L1 CNR
    uint8 u1Flag;
} rtcm_t_gps_glonass_l1_sat;

//Type 1010 Message, Each Satellite - GLONASS Extended RTK, L1 Only
typedef struct {
    uint16 u2MsgNum;       //Message Number
    uint16 u2RefStationID; //Reference Station ID
    uint32 u4EpochTime;      //GPS/GLONASS Epoch Time (tk)
    uint8 u1GNSSFlag;     //Synchronous GNSS Flag
    uint8 u1SatNum;       //No. of GLONASS Satellite Signals Processed
    uint8 u1DFSInd;       //GLONASS Divergence-free Smoothing Indicator
    uint8 u1SmthInt;      //GLONASS Smoothing Interval
    rtcm_t_gps_glonass_l1_sat rSatInfo[RTCM_1010_MAX_SAT];
} rtcm_t_gps_glonass_l1_obser;

typedef struct {
    uint8 u1SatID;         //GLONASS Satellite ID(Satellite Slot Number)
    uint8 u1L1CodeInd;     //GLONASS L1 Code Indicator
    uint8 u1FreqChanNum;    //GLONASS Satellite Frequency Channel Number
    uint32 u4L1Pseu;         //GLONASS L1 Pseudorange
    int32 i4L1PhaPseuDif;           //GlONASS L1 PhaseRange - L1 Pseudorange
    uint8 u1L1TimeInd;     //GLONASS L1 Lock time Indicator
    uint8 u1L1PseuModAmbg; //GLONASS Integer L1 Pseudorange Modulus Ambiguity
    uint8 u1L1CNR;         //GLONASS L1 CNR
    uint8 u1L2CodeInd;     //GLONASS L2 Code Indicator
    int16 i2L2L1PseuDif;      //GLONASS L2-L1 Pseudorange Difference
    int32 i4L2PhaL1PseuDif;          //GLONASS L2 PhaseRange - L1 Pseudorange
    uint8 u1L2TimeInd;     //GLONASS L2 Lock time Indicator
    uint8 u1L2CNR;         //GLONASS L2 CNR
    uint8 u1Flag;
} rtcm_t_1012_sat;

typedef struct {
    uint8 u1SatID;         //GLONASS Satellite ID(Satellite Slot Number)
    uint8 u1L1CodeInd;     //GLONASS L1 Code Indicator
    uint8 u1FreqChanNum;    //GLONASS Satellite Frequency Channel Number
    uint32 u4L1Pseu;         //GLONASS L1 Pseudorange
    int32 i4L1PhaPseuDif;           //GlONASS L1 PhaseRange - L1 Pseudorange
    uint8 u1L1TimeInd;     //GLONASS L1 Lock time Indicator
    char pseuModAmbgValid;
    uint8 u1L1PseuModAmbg; //GLONASS Integer L1 Pseudorange Modulus Ambiguity
    char L1CNRValid;
    uint8 u1L1CNR;         //GLONASS L1 CNR
    uint8 u1L2CodeInd;     //GLONASS L2 Code Indicator
    int16 i2L2L1PseuDif;   //GLONASS L2-L1 Pseudorange Difference
    int32 i4L2PhaL1PseuDif;  //GLONASS L2 PhaseRange - L1 Pseudorange
    uint8 u1L2TimeInd;     //GLONASS L2 Lock time Indicator
    char L2CNRValid;
    uint8 u1L2CNR;         //GLONASS L2 CNR
    uint8 u1Flag;
} rtcm_t_gps_glonass_l1_l2_sat;

//Type 1012 Message, Each Satellite - GLONASS Extended RTK, L1 & L2
typedef struct {
    uint16 u2MsgNum;       //Message Number
    uint16 u2RefStationID; //Reference Station ID
    uint32 u4EpochTime;      //GLONASS Epoch Time (tk)
    uint8 u1GNSSFlag;     //Synchronous GNSS Flag
    uint8 u1SatNum;       //No. of GLONASS Satellite Signals Processed
    uint8 u1DFSInd;       //GLONASS Divergence-free Smoothing Indicator
    uint8 u1SmthInt;      //GLONASS Smoothing Interval
    rtcm_t_gps_glonass_l1_l2_sat rSatInfo[RTCM_1012_MAX_SAT];
} rtcm_t_gps_glonass_l1_l2_obser;


typedef struct {
    uint16 referenceStationID; /* 0..65535 */
    char providerNameValid;
    uint32 providerNameLen;
    char providerName[32]; /* SIZE (1..32) */
} data_center_gnss_ref_station_id_struct;


typedef struct {
    uint8 numRefStationElm;
    data_center_gnss_ref_station_id_struct refStationElm[GNSS_MAX_EQUAL_INT_AMBIGUITY_LEVEL_REF_STATION_ID_NUM];
} data_center_gnss_ref_station_list_struct;


typedef struct {
    gnss_equal_int_ambiguity_level_enum selection;
    union
    {
        data_center_gnss_ref_station_list_struct refStationList;
    } choice;
} data_center_equal_int_ambiguity_level_struct;


/**
 * @msg id: 0
 * @name: data_center_ref_station_info
 * @lpp: GNSS-RTK-ReferenceStationInfo-r15
            referenceStationID-r15
            referenceStationIndicator-r15
            antenna-reference-point-ECEF-X-r15
            antenna-reference-point-ECEF-Y-r15
            antenna-reference-point-ECEF-Z-r15
            antennaHeight-r15
            //antennaDescription-r15
            //antenna-reference-point-unc-r15
            //physical-reference-station-info-r15
            equalIntegerAmbiguityLevel-r16
 * @ntrip: 1005/1006
 * also for mnl use
 */
/*MNL Use msg id: 0*/
typedef struct {
    referenceStationID u2RefStationID; //Reference Station ID
    char ITRFValid;
    /*tbc*/uint8 u1ITRF;         //Reserved for ITRF Realization Year
    char GPSIndValid;
    /*tbc*/uint8 u1GPSInd;       //GPS Indicator
    char GLIndValid;
    /*tbc*/uint8 u1GLInd;        //GLONASS Indicator
    char GAIndValid;
    /*tbc*/uint8 u1GAInd;        //Reserved for Galileo Indicator
    uint8 u1RefStationInd;//Reference-Station Indicator
    int64 i8ECEF_X;       //Antenna Reference Point ECEF-X
    char OscIndValid;
    /*tbc*/uint8 u1OscInd;       //Single Receiver Oscillator Indicator
    uint8 u1Reserved1;    //Reserved
    int64 i8ECEF_Y;       //Antenna Reference Point ECEF-Y
    char QuarterCycleIndValid;
    /*tbc*//*3.3update*/uint8 u1QuarterCycleInd;    //Quarter Cycle Indicator
    int64 i8ECEF_Z;       //Antenna Reference Point ECEF-Z
    char AntHgtValid;
    uint16 u2AntHgt;       //Antenna Height

    /*below is expanded from LPP*/
    char EqualIntAmbiguityLevelValid;
    data_center_equal_int_ambiguity_level_struct equalIntAmbiguityLevel;
} data_center_ref_station_info;


/**
 * @msg id: 1
 * @name: data_center_receiver_antenna_dec
 * @lpp: antennaDescription-r15
     antennaDescriptor-r15
     antennaSetUpID-r15
 * @ntrip: 1007/1008/1033
 * also for mnl use
 */
/*MNL Use msg id: 1*/
typedef struct {
    referenceStationID u2RefStationID; //Reference Station ID
    char antennaDescriptionValid;
    uint8 u1AntDesCounter_N;        //Antenna Descriptor Counter N
    char chAntDes[RTCM_1033_MAX_NUM_N];     //Antenna Descriptor
    char antennaSetUpIDValid;
    uint8 u1AntSetupID;             //Antenna Setup ID
    char AntSeriNumValid;
    uint8 u1AntSeriNumCounter_M;    //Antenna Serial Number Counter M
    /*tbc*/char chAntSeriNum[RTCM_1033_MAX_NUM_M]; //Antenna Serial Number
    char RecTypeDesValid;
    uint8 u1RecTypeDesCounter_I;    //Receiver Type Descriptor Counter I
    /*tbc*/char chRecTypeDes[RTCM_1033_MAX_NUM_I]; //Receiver Type Descriptor
    char RecFwVerValid;
    uint8 u1RecFwVerCounter_J;      //Receiver Firmware Version Counter J
    /*tbc*/char chRecFwVer[RTCM_1033_MAX_NUM_J];   //Receiver Firmware Version
    char RecSeriNumValid;
    uint8 u1RecSeriNumCounter_K;    //Receiver Serial Number Counter K
    /*tbc*/char chRecSeriNum[RTCM_1033_MAX_NUM_K]; //Receiver Serial Number

    /*below is expanded from LPP*/
    char antennaRefPointUncValid;
    antennaReferencePointUnc antennaRefPointUnc;
} data_center_receiver_antenna_dec;


/**
 * @msg id: 2
 * @name: data_center_phy_ref_station_info
 * @lpp: physical-reference-station-info-r15
     antennaDescriptor-r15
     antennaSetUpID-r15
 * @ntrip: 1007/1008/1033
 * also for mnl use
 */

/*MNL Use msg id: 2*/
typedef struct {
    char nonPhyRefStationIDValid;
    /*tbc*/referenceStationID u2Non_PhyRefStationID;  //Non-PhysicalReference Station ID
    referenceStationID u2PhyRefStationID;     //Physical Reference Station ID
    char ITRFValid;
    uint8 u1ITRF;              //ITRF Epoch Year
    int64 i8ARP_ECEF_X;       //Physical referencestation ARP ECEF-X
    int64 i8ARP_ECEF_Y;       //Physical referencestation ARP ECEF-Y
    int64 i8ARP_ECEF_Z;       //Physical referencestation ARP ECEF-Z

    /*below is expanded from LPP*/
    char i1PhyArpUncValid;
    antennaReferencePointUnc phyArpUnc; /* OPTIONAL */
} data_center_phy_ref_station_info;

/**
 * @msg id: 3~9
 * @name: data_center_rtk_msmn_observations
 * @lpp:
     gnss-RTK-CommonObservationInfo-r15
        referenceStationID-r15
            referenceStationID-r15
            providerName-r15
        clockSteeringIndicator-r15
        externalClockIndicator-r15
        smoothingIndicator-r15
        smoothingInterval-r15
     gnss-RTK-Observations-r15
        epochTime-r15
        gnss-ObservationList-r15 SIZE(1..64)
            svID-r15
            integer-ms-r15 INTEGER (0..254)
            rough-range-r15  INTEGER (0..1023)
            rough-phase-range-rate-r15 INTEGER (-8192..8191)
            gnss-rtk-SatelliteSignalDataList-r15[List 24]
                gnss-SignalID-r15
                fine-PseudoRange-r15
                fine-PhaseRange-r15
                lockTimeIndicator-r15 INTEGER (0..1023)
                halfCycleAmbiguityIndicator-r15
                carrier-to-noise-ratio-r15 INTEGER (0..1023)
                fine-PhaseRangeRate-r15 INTEGER (-16384..16383)
 * @ntrip: 1071-1128,1004,1012
 */

/**
 * @msg id: 3
 * @name: data_center_rtk_msm1_observations
 * @ntrip: DF398 DF405
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm1_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm1_observations;

/*MNL Use msg id: 3*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm1_sat rSatInfo[0];
} data_center_rtk_msm1_observations_sat_item;

/**
 * @msg id: 4
 * @name: data_center_rtk_msm2_observations
 * @ntrip: DF398 DF406 DF407 DF420
 */
typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm2_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm2_observations;

/*MNL Use msg id: 4*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm2_sat rSatInfo[0];
} data_center_rtk_msm2_observations_sat_item;


/**
 * @msg id: 5
 * @name: data_center_rtk_msm3_observations
 * @ntrip: DF398 DF405 DF406 DF407 DF420
 */
typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm3_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm3_observations;

/*MNL Use msg id: 5*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm3_sat rSatInfo[0];
} data_center_rtk_msm3_observations_sat_item;

/**
 * @msg id: 6
 * @name: data_center_rtk_msm4_observations
 * @ntrip: DF397 DF398 DF405 DF406 DF407 DF420 DF408
 */
typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm4_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm4_observations;

/*MNL Use msg id: 6*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm4_sat rSatInfo[0];
} data_center_rtk_msm4_observations_sat_item;

/**
 * @msg id: 7
 * @name: data_center_rtk_msm5_observations
 * @ntrip: DF397 DF398 DF399 DF405 DF406 DF407 DF420 DF408 DF404
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm5_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm5_observations;

/*MNL Use msg id: 7*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm5_sat rSatInfo[0];
} data_center_rtk_msm5_observations_sat_item;


/**
 * @msg id: 8
 * @name: data_center_rtk_msm6_observations
 * @ntrip: DF397 DF398 DF405 DF406 DF407 DF420 DF408 DF404
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm6_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm6_observations;

/*MNL Use msg id: 8*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm6_sat rSatInfo[0];
} data_center_rtk_msm6_observations_sat_item;

/**
 * @msg id: 9
 * @name: data_center_rtk_msm7_observations
 * @ntrip: DF397 DF398 DF399 DF405 DF406 DF407 DF420 DF408 DF404
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    rtcm_msg_common_header rHeadInfo;
    data_center_rtk_msm7_observation obser[GNSS_LPP_ID_MAX];
} data_center_rtk_msm7_observations;

/*MNL Use msg id: 9*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_msg_common_header rHeadInfo;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1SatNum;
    reduced_data_center_rtcm_t_msm7_sat rSatInfo[0];
} data_center_rtk_msm7_observations_sat_item;

/**
 * @msg id: 10
 * @name: data_center_ssr_orbit_corrections
 * @lpp: gnss-SSR-OrbitCorrections-r15
 * @ntrip: 1057/1060/1063
 */
typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    data_center_ssr_orbit_correction orbit_cor[GNSS_LPP_ID_MAX];
} data_center_ssr_orbit_corrections;

/*MNL Use msg id: 10*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    char u1satRefDatumValid;
    gnss_ssr_orbit_corrections_sat_ref_datum_enum satRefDatum;
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1SatRefDat;     //Satellite Reference Datum
    uint8 u1IOD;           //IOD SSR

    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    RTCM_T_ORBIT_SAT rSatInfo[0];
} data_center_ssr_orbit_corrections_sat_item;


/**
 * @msg id: 11
 * @name: data_center_clock_corrections
 * @lpp: gnss-SSR-ClockCorrections-r15
 * @ntrip: 1058/1060/1062/1064/1066/1068
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    data_center_clock_correction clock_cor[GNSS_LPP_ID_MAX];
} data_center_clock_corrections;

/*MNL Use msg id: 11*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1IOD;           //IOD SSR

    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    data_center_rtcm_t_clock_correction_sat rSatInfo[0];
} data_center_clock_corrections_sat_item;



/**
 * @msg id: 12
 * @name: data_center_code_bias_datas
 * @lpp: gnss-SSR-CodeBias-r15
 * @ntrip: 1059/1065
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    data_center_code_bias_data code_bias[GNSS_LPP_ID_MAX];
} data_center_code_bias_datas;

/*MNL Use msg id: 12*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1IOD;           //IOD SSR
    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    data_center_rtcm_t_code_bias_sat rSatInfo[0];
} data_center_code_bias_datas_sat_item;

/**
 * @msg id: 13
 * @name: data_center_ssr_ura_datas
 * @lpp: gnss-SSR-URA-r16
 * @ntrip: 1061
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    data_center_ssr_ura_data ura[GNSS_LPP_ID_MAX];
} data_center_ssr_ura_datas;

/*MNL Use msg id: 13*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 u1UpdateInte;     //Update Interval
    uint8 u1MulMsgInd;     //Multiple Message Indicator
    uint8 u1IOD;           //IOD SSR
    char u1ProviderIDValid;
    uint16 u2ProviderID;   //Provider ID
    char u1SolutionIDValid;
    uint8 u1SolutionID;    //Solution ID
    uint8 u1SatNum;       //No. of Satellites
    data_center_rtcm_t_ssr_ura_sat rSatInfo[0];
} data_center_ssr_ura_datas_sat_item;

/**
 * @msg id: 14
 * @name: data_center_phase_bias_datas
 * @lpp: gnss-SSR-PhaseBias-r16
 * @ntrip: N/A
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    data_center_phase_bias_data phase_bias[GNSS_LPP_ID_MAX];
} data_center_phase_bias_datas;

/*MNL Use msg id: 14*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 ssrUpdateInterval; /* 0..15 */
    uint8 iodSsr; /* 0..15 */
    uint8 numSsrPhaseBiasSatElm;
    data_center_phase_bias_sat_element_struct ssrPhaseBiasSatElm[0];
} data_center_phase_bias_data_sat_item;

/**
 * @msg id: 15
 * @name: data_center_ssr_stec_corrections
 * @lpp: GNSS-SSR-STEC-Correction-r16
 * @ntrip: N/A
 */

typedef struct {
    uint32 u4Bitmap;//indecate we have which GNSS data.
    data_center_ssr_stec_correction stec_cor[GNSS_LPP_ID_MAX];
} data_center_ssr_stec_corrections;

/*MNL Use msg id: 15*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 ssrUpdateInterval; /* 0..15 */
    uint8 iodSsr; /* 0..15 */
    uint16 correctionPointSetID; /* 0..16383 */
    uint8 numStecSatElm;
    data_center_stec_sat_element_struct stecSatElm[0];
} data_center_ssr_stec_correction_sat_item;

/**
 * @msg id: 16
 * @name: data_center_ssr_correctionPoints
 * @lpp: GNSS-SSR-CorrectionPoints-r16
 * @ntrip: N/A
 * also for mnl use
 */

/*MNL Use msg id: 16*/
typedef struct {
    uint16 correctionPointSetID; /* 0..16383 */
    data_center_correction_points_struct correctionPoints; /* MANDATORY */
} data_center_ssr_correctionPoints;


/**
 * @msg id: 17
 * @name: data_center_ssr_gridded_correction
 * @lpp: gnss-SSR-GriddedCorrection-r16
 * @ntrip: N/A
 */

/* LPP_GNSS_SSR_GriddedCorrection_r16 */
typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 ssrUpdateInterval; /* 0..15 */
    uint8 iodSsr; /* 0..15 */
    char troposphericDelayQualityIndicatorValid;
    uint8 troposphericDelayQualityIndicator; /* 6 bits. The 3 MSB define the CLASS with a range of 0-7 and the 3 LSB define the VALUE with a range of 0-7 */
    uint16 correctionPointSetID; /* 0..16383 */
    data_center_grid_list_struct gridList;
} data_center_ssr_gridded_correction;

/*MNL Use msg id: 17*/
typedef struct {
    gnss_time_type time_type;
    union {
        gnss_system_time_struct epochTime;
        tow_time_struct towTime;
    } time;
    uint8 ssrUpdateInterval; /* 0..15 */
    uint8 iodSsr; /* 0..15 */
    char troposphericDelayQualityIndicatorValid;
    uint8 troposphericDelayQualityIndicator; /* 6 bits. The 3 MSB define the CLASS with a range of 0-7 and the 3 LSB define the VALUE with a range of 0-7 */
    uint16 correctionPointSetID; /* 0..16383 */
    uint8 numGridElm;
    data_center_grid_element_struct gridElm[0];
} data_center_ssr_gridded_correction_sat_item;

/**
 * @msg id: 18
 * @name: data_center_GG_L1_observations
 * @lpp: N/A
 * @ntrip: 1001/1002/1009/1010
 */

typedef struct {
    char gpsObserValid;
    rtcm_t_gps_glonass_l1_obser gpsObser;
    char glonassObserValid;
    rtcm_t_gps_glonass_l1_obser glonassObser;
} data_center_gg_L1_observations;

/*MNL Use msg id: 18*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_t_gps_glonass_l1_obser Obser;
} data_center_gg_l1_observations_cons_item;

/**
 * @msg id: 19
 * @name: data_center_gg_l1_l2_observations
 * @lpp: N/A
 * @ntrip: 1003/1004/1011/1012
 */

typedef struct {
    char gpsObserValid;
    rtcm_t_gps_glonass_l1_l2_obser gpsObser;
    char glonassObserValid;
    rtcm_t_gps_glonass_l1_l2_obser glonassObser;
} data_center_gg_l1_l2_observations;

/*MNL Use msg id: 19*/
typedef struct {
    MTK_GNSS_ID_ENUM gnss_id;
    rtcm_t_gps_glonass_l1_l2_obser Obser;
} data_center_gg_l1_l2_observations_cons_item;



/**
 * @msg id: 20
 * @name: data_center_bds_grid_model_params
 * @lpp: BDS-GridModelParameter
 * @ntrip: N/A
 */

typedef struct
{
    kal_uint16  igpID;  /* indicate the ionospheric grid point (IGP) number as defined in BDS ICD v2.0, sec 5.3.3.8 */
    kal_uint16  dt;     /* indicate dT as defined in BDS ICD v2.0, sec 5.3.3.8.1, i.e. the vertical delay at the corresponding IGP indicated by igp-ID, scale factor 0.125 meter */
    kal_uint8   givei;  /* indicate the Grid Ionospheric Vertical Error Index (GIVEI) which is used to describe the delay correction accuracy at ionospheric grid point indicated by igp-ID, the mapping between GIVEI and GIVE is defined in BDS ICD v2.0, sec 5.3.3.8.2 */
} data_center_bds_grid_ion_element;

typedef struct
{
    kal_uint16                        numGridIonElement;
    data_center_bds_grid_ion_element  gridIonElement[GNSS_MAX_BDS_GRID_ION_ELEMENT];  /* a list that provides ionospheric grid point information for each grid point. Up to 16 instances are used in this version of the specification. The values 17 to 320 are reserved for future use */
} data_center_bds_grid_ion_list;

typedef struct
{
    kal_uint16                     bdsRefTime;   /* [0..3599], the time for which the grid model parameters are valid, modulo 1 hour. bdsRefTime is given in BDS system time, scale factor 1 second */
    data_center_bds_grid_ion_list  gridIonList;  /* a list that provides ionospheric grid point information for each grid point. Up to 16 instances are used in this version of the specification. The values 17 to 320 are reserved for future use */
} data_center_bds_grid_model_params;

static inline void copy_long_long_type(void *dist, const void *src) {
    memcpy(dist, src, sizeof(int64));
}

/**
 * Description: this is a safe api to get global helper handler.
 * @param void
 * @return pointer to global helper handler
 */
struct agps_data_base_helper* get_agps_data_base_helper();


/**
 * Description: init the data base and function, must be called before require service.
 * @param void
 * @return void
 */
void init_data_base_helper(void);


/**
 * Description: get the system boot time
 * @param void
 * @return the system boot time(ms)
 */
uint32 get_boot_time_ms();


/**
 * Description: Transform the error code returned by the data center function into a more understandable way
 * @param int error type
 * @return string that description the corresponding error code
 */
const char* data_center_strerror(int32 error);


/**
 * Description: Do the bitwise AND operation of two bitmaps
 * @param dst the result bitmap
 * @param bitmap1 the source bitmap1
 * @param bitmap2 the source bitmap2
 * @param size the max number of bits supported by this bitmap
 * @return void
 */
void bitmap_and(unsigned int *dst, const unsigned int *bitmap1, const unsigned int *bitmap2, unsigned int size);


/**
 * Description: Initialization work done in advance in order to iterate a bitmap
 * @param inter the Iterator
 * @param bitmap the bitmap need to iterate
 * @param offset where to start iteration
 * @param size the max number of bits supported by this bitmap
 * @return void
 */
void bitmap_iter_init(struct bitmap_iter *inter, unsigned int *bitmap, unsigned int offset, unsigned int size);


/**
 * Description: Get the next highest bit in bitmap. for example, if bitmap is 0b01001. when
 * first called this function it will return 0, the second call will return 3, the third call will return -1;
 * @param inter the Iterator which has been initialized by function bitmap_iter_init
 * @return The next highest bit
 */
unsigned int bitmap_iter_next(struct bitmap_iter *inter);


#endif

