// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "LbsLogInterface.h"
#include "mtk_socket_data_coder.h"

// LbsLogInterface_LogCategory
const char* LbsLogInterface_LogCategory_to_string(LbsLogInterface_LogCategory data) {
    switch(data) {
    case LBS_LOG_INTERFACE_LOG_CATEGORY_GPS_LOG:
        return "gpsLog";
    case LBS_LOG_INTERFACE_LOG_CATEGORY_MPE_LOG:
        return "mpeLog";
    case LBS_LOG_INTERFACE_LOG_CATEGORY_DUMP_LOG:
        return "dumpLog";
    default:
        break;
    }
    return "UNKNOWN";
}
void LbsLogInterface_LogCategory_array_dump(LbsLogInterface_LogCategory data[], int size) {
    int i = 0;
    SOCK_LOGD("LbsLogInterface_LogCategory_array_dump() size=[%d]", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%s]", i, LbsLogInterface_LogCategory_to_string(data[i]));
    }
}

void LbsLogInterface_LogCategory_array_init(LbsLogInterface_LogCategory output[], int max_size) {
    int i = 0;
    for(i = 0; i < max_size; i++) {
        output[i] = LBS_LOG_INTERFACE_LOG_CATEGORY_GPS_LOG;
    }
}

bool LbsLogInterface_LogCategory_is_equal(LbsLogInterface_LogCategory data1, LbsLogInterface_LogCategory data2) {
    return (data1 == data2)? true : false;
}
bool LbsLogInterface_LogCategory_array_is_equal(LbsLogInterface_LogCategory data1[], int size1, LbsLogInterface_LogCategory data2[], int size2) {
    int i = 0;
    if(size1 != size2) return false;
    for(i = 0; i < size1; i++) {
        if(data1[i] != data2[i]) return false;
    }
    return true;
}

bool LbsLogInterface_LogCategory_encode(char* buff, int* offset, LbsLogInterface_LogCategory data) {
    switch(data) {
    case LBS_LOG_INTERFACE_LOG_CATEGORY_GPS_LOG:
    case LBS_LOG_INTERFACE_LOG_CATEGORY_MPE_LOG:
    case LBS_LOG_INTERFACE_LOG_CATEGORY_DUMP_LOG:
        break;
    default:
        SOCK_LOGE("LbsLogInterface_LogCategory_encode() unknown data=%d", data);
        return false;
    }
    mtk_socket_put_int(buff, offset, data);
    return true;
}
bool LbsLogInterface_LogCategory_array_encode(char* buff, int* offset, LbsLogInterface_LogCategory data[], int size) {
    int i = 0;
    mtk_socket_put_int(buff, offset, size);
    for(i = 0; i < size; i++) {
        if(!LbsLogInterface_LogCategory_encode(buff, offset, data[i])) {
            SOCK_LOGE("LbsLogInterface_LogCategory_array_encode() LbsLogInterface_LogCategory_encode() failed at i=%d", i);
            return false;
        }
    }
    return true;
}

void LbsLogInterface_LogCategory_decode(char* buff, int* offset, LbsLogInterface_LogCategory* output) {
    *output = mtk_socket_get_int(buff, offset);
}
int LbsLogInterface_LogCategory_array_decode(char* buff, int* offset, LbsLogInterface_LogCategory output[], int max_size) {
    int i = 0;
    int size = mtk_socket_get_int(buff, offset);
    for(i = 0; i < size; i++) {
        if(i < max_size) {
            LbsLogInterface_LogCategory_decode(buff, offset, &output[i]);
        } else {
            LbsLogInterface_LogCategory data;
            LbsLogInterface_LogCategory_decode(buff, offset, &data);
        }
    }
    return (size > max_size)? max_size : size;
}


// Sender
bool LbsLogInterface_openLog(mtk_socket_fd* client_fd, LbsLogInterface_LogCategory type, const char* filePath) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("LbsLogInterface_openLog() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[LBS_LOG_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, LBS_LOG_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, LBS_LOG_INTERFACE_OPEN_LOG);
    if(!LbsLogInterface_LogCategory_encode(_buff, &_offset, type)) {
        SOCK_LOGE("LbsLogInterface_openLog() LbsLogInterface_LogCategory_encode() fail on type");
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    if(strlen(filePath) > 256) {
        SOCK_LOGE("LbsLogInterface_openLog() strlen of filePath=[%zu] is over 256", strlen(filePath));
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_put_string(_buff, &_offset, filePath);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("LbsLogInterface_openLog() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

bool LbsLogInterface_closeLog(mtk_socket_fd* client_fd, LbsLogInterface_LogCategory type) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("LbsLogInterface_closeLog() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[LBS_LOG_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, LBS_LOG_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, LBS_LOG_INTERFACE_CLOSE_LOG);
    if(!LbsLogInterface_LogCategory_encode(_buff, &_offset, type)) {
        SOCK_LOGE("LbsLogInterface_closeLog() LbsLogInterface_LogCategory_encode() fail on type");
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("LbsLogInterface_closeLog() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

bool LbsLogInterface_writeLog(mtk_socket_fd* client_fd, LbsLogInterface_LogCategory type, char log[], int log_size) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("LbsLogInterface_writeLog() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[LBS_LOG_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, LBS_LOG_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, LBS_LOG_INTERFACE_WRITE_LOG);
    if(!LbsLogInterface_LogCategory_encode(_buff, &_offset, type)) {
        SOCK_LOGE("LbsLogInterface_writeLog() LbsLogInterface_LogCategory_encode() fail on type");
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    ASSERT_LESS_EQUAL_THAN_FOR_MSG(log_size, 15360);
    mtk_socket_put_char_array(_buff, &_offset, log, log_size);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("LbsLogInterface_writeLog() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

// Receiver
bool LbsLogInterface_receiver_decode(char* _buff, LbsLogInterface_callbacks* callbacks) {
    int _ret = 0;
    int _offset = 0;
    _ret = mtk_socket_get_int(_buff, &_offset);
    if(_ret != LBS_LOG_INTERFACE_PROTOCOL_TYPE) {
        SOCK_LOGE("LbsLogInterface_receiver_decode() protocol_type=[%d] is not equals to [%d]",
            _ret, LBS_LOG_INTERFACE_PROTOCOL_TYPE);
        return false;
    }
    _ret = mtk_socket_get_int(_buff, &_offset);
    switch(_ret) {
    case LBS_LOG_INTERFACE_OPEN_LOG: {
        if(callbacks->LbsLogInterface_openLog_handler == NULL) {
            SOCK_LOGE("LbsLogInterface_receiver_decode() LbsLogInterface_openLog_handler() is NULL");
            return false;
        }
        LbsLogInterface_LogCategory type;
        LbsLogInterface_LogCategory_decode(_buff, &_offset, &type);
        char filePath[256];
        mtk_socket_get_string(_buff, &_offset, filePath, 256);
        callbacks->LbsLogInterface_openLog_handler(type, filePath);
        break;
    }
    case LBS_LOG_INTERFACE_CLOSE_LOG: {
        if(callbacks->LbsLogInterface_closeLog_handler == NULL) {
            SOCK_LOGE("LbsLogInterface_receiver_decode() LbsLogInterface_closeLog_handler() is NULL");
            return false;
        }
        LbsLogInterface_LogCategory type;
        LbsLogInterface_LogCategory_decode(_buff, &_offset, &type);
        callbacks->LbsLogInterface_closeLog_handler(type);
        break;
    }
    case LBS_LOG_INTERFACE_WRITE_LOG: {
        if(callbacks->LbsLogInterface_writeLog_handler == NULL) {
            SOCK_LOGE("LbsLogInterface_receiver_decode() LbsLogInterface_writeLog_handler() is NULL");
            return false;
        }
        LbsLogInterface_LogCategory type;
        LbsLogInterface_LogCategory_decode(_buff, &_offset, &type);
        char log[LBS_LOG_INTERFACE_BUFF_SIZE] = {0};
        int log_size = mtk_socket_get_char_array(_buff, &_offset, log, LBS_LOG_INTERFACE_BUFF_SIZE);
        callbacks->LbsLogInterface_writeLog_handler(type, log, log_size);
        break;
    }
    default: {
        SOCK_LOGE("LbsLogInterface_receiver_decode() unknown msgId=[%d]", _ret);
        return false;
    }
    }
    return true;
}
bool LbsLogInterface_receiver_read_and_decode(int server_fd, LbsLogInterface_callbacks* callbacks) {
    int _ret;
    char _buff[LBS_LOG_INTERFACE_BUFF_SIZE] = {0};

    _ret = mtk_socket_read(server_fd, _buff, sizeof(_buff) - 1);
    if(_ret == -1) {
        SOCK_LOGE("LbsLogInterface_receiver_read_and_decode() mtk_socket_read() failed, fd=%d err=[%s]%d",
            server_fd, strerror(errno), errno);
        return false;
    }
    _buff[_ret] = 0;
    return LbsLogInterface_receiver_decode(_buff, callbacks);
}

