// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "Meta2MnldInterface.h"
#include "mtk_socket_data_coder.h"
#include "mtk_lbs_utility.h"


// Sender
bool Meta2MnldInterface_reqGnssLocation(mtk_socket_fd* client_fd, int source) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Meta2MnldInterface_reqGnssLocation() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[META2MNLD_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, META2MNLD_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, META2MNLD_INTERFACE_REQ_GNSS_LOCATION);
    mtk_socket_put_int(_buff, &_offset, source);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Meta2MnldInterface_reqGnssLocation() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

bool Meta2MnldInterface_cancelGnssLocation(mtk_socket_fd* client_fd, int source) {
    pthread_mutex_lock(&client_fd->mutex);
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Meta2MnldInterface_cancelGnssLocation() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    int _ret;
    char _buff[META2MNLD_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, META2MNLD_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, META2MNLD_INTERFACE_CANCEL_GNSS_LOCATION);
    mtk_socket_put_int(_buff, &_offset, source);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Meta2MnldInterface_cancelGnssLocation() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

// Receiver
bool Meta2MnldInterface_receiver_decode(char* _buff, Meta2MnldInterface_callbacks* callbacks) {
    int _ret = 0;
    int _offset = 0;
    _ret = mtk_socket_get_int(_buff, &_offset);
    if(_ret != META2MNLD_INTERFACE_PROTOCOL_TYPE) {
        SOCK_LOGE("Meta2MnldInterface_receiver_decode() protocol_type=[%d] is not equals to [%d]",
            _ret, META2MNLD_INTERFACE_PROTOCOL_TYPE);
        return false;
    }
    _ret = mtk_socket_get_int(_buff, &_offset);
    switch(_ret) {
    case META2MNLD_INTERFACE_REQ_GNSS_LOCATION: {
        if(callbacks->Meta2MnldInterface_reqGnssLocation_handler == NULL) {
            SOCK_LOGE("Meta2MnldInterface_receiver_decode() Meta2MnldInterface_reqGnssLocation_handler() is NULL");
            return false;
        }
        int source = mtk_socket_get_int(_buff, &_offset);
        callbacks->Meta2MnldInterface_reqGnssLocation_handler(source);
        break;
    }
    case META2MNLD_INTERFACE_CANCEL_GNSS_LOCATION: {
        if(callbacks->Meta2MnldInterface_cancelGnssLocation_handler == NULL) {
            SOCK_LOGE("Meta2MnldInterface_receiver_decode() Meta2MnldInterface_cancelGnssLocation_handler() is NULL");
            return false;
        }
        int source = mtk_socket_get_int(_buff, &_offset);
        callbacks->Meta2MnldInterface_cancelGnssLocation_handler(source);
        break;
    }
    default: {
        SOCK_LOGE("Meta2MnldInterface_receiver_decode() unknown msgId=[%d]", _ret);
        return false;
    }
    }
    return true;
}
bool Meta2MnldInterface_receiver_read_and_decode(int server_fd, Meta2MnldInterface_callbacks* callbacks) {
    int read_len;
    char _buff[META2MNLD_INTERFACE_BUFF_SIZE] = {0};

    read_len = safe_recvfrom(server_fd, _buff, sizeof((_buff)));

    if(read_len < 0) {
        SOCK_LOGE("Meta2MnldInterface_receiver_read_and_decode() mtk_socket_read() failed, fd=%d err=[%s]%d",
            server_fd, strerror(errno), errno);
        return false;
    }
    return Meta2MnldInterface_receiver_decode(_buff, callbacks);
}
/*********************************************************/
/* META to MNLD socket                        */
/*********************************************************/
int create_meta2mnld_fd() {
    int fd = socket_bind_udp(META_TO_MNLD_SOCKET);
    socket_set_blocking(fd, 0);
    return fd;
}

