#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>

#include <fcntl.h>
#include <sys/epoll.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <termios.h>
#if defined(__ANDROID_OS__)
#include <cutils/properties.h>
#endif
#include "mtk_prop_util.h"
#include "gps_dbg_log.h"
#include "mtk_lbs_utility.h"
#include "Mnld2DebugInterface.h"
#include "Meta2MnldInterface.h"
#include "Meta2Mnld_logctrl_Interface.h"

#define FULL_DIR_FILE        "%s%s"
#define PROP_META_CONN_TYPE  "persist.vendor.meta.connecttype"
#define PROP_WIFI_ADDR       "persist.vendor.atm.ipaddress"
#define LOG_BUFFER_SIZE      (1024*256)
extern unsigned int meta_logctrl;
extern unsigned int log_mode_bitmap;
extern char gps_debuglog_file_name[GPS_DEBUG_LOG_FILE_NAME_MAX_LEN];
extern char storagePath_mtklogger_set[GPS_DEBUG_LOG_FILE_NAME_MAX_LEN];
extern char storagePath[GPS_DEBUG_LOG_FILE_NAME_MAX_LEN];

typedef struct {
    char file_name[64];
    unsigned int file_len;
} FILE_HEADER;
typedef struct {
    FILE_HEADER file_head[1024];
    unsigned int file_num;
} LOG_LIST;
ATM_ONLINE_MODE transfer_mode = ATM_USB_MODE;
FILE_HEADER file_header_info;
char pre_fix[16] = {0};
char post_fix[16] = {0};
int log_port = -1;
int usb_port_fd = -1;
LOG_LIST m_logFilelist;
char m_DataLogBuf[LOG_BUFFER_SIZE] = {0};
int m_nSockFd = -1;
bool m_nConnect = false;
int m_nClientFd = -1;
static const int WIFI_SOCKET_PORT = 10007;
static const int BACKLOG = 32;
int pull_stop_flag = 0;
int file_count = 0;
int mSockListenId = -1;
int clientConnect = -1;

void mnld2pc_log_closeUSBPort() {
    int err;
    SOCK_LOGD("mnld begin mnld2pc_log_closeUSBPort");
    if (usb_port_fd != -1) {
        err = close(usb_port_fd);
        if (err != 0) {
            SOCK_LOGW("mnld2pc_log_closeUSBPort: close err=%d", err);
        }
        usb_port_fd = -1;
        SOCK_LOGD(" close USB port fd.");
    }
}

bool mnld2pc_log_openUSBPort() {
    mnld2pc_log_closeUSBPort();
    const char *vcom_dev_name = "/dev/ttyGS3";

    usb_port_fd = open(vcom_dev_name, O_RDWR | O_NOCTTY);
    SOCK_LOGD("open USB dev %s", vcom_dev_name);

    if (usb_port_fd == -1) {
        SOCK_LOGE("Cannot open USB fd, err=%d", errno);
        return false;
    }

    struct termios termOptions;
    if(fcntl(usb_port_fd, F_SETFL, 0) == -1) {
        SOCK_LOGE("fcntl fail, %s, usb_port_fd:%d", strerror(errno), usb_port_fd);
    }
    tcgetattr(usb_port_fd, &termOptions);

    // Raw mode
    termOptions.c_iflag &= ~(INLCR | ICRNL | IXON | IXOFF | IXANY);
    termOptions.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    termOptions.c_oflag &= ~OPOST;

    tcflush(usb_port_fd, TCIFLUSH);
    termOptions.c_cc[VTIME] = 1;
    termOptions.c_cc[VMIN] = 0;

    tcsetattr(usb_port_fd, TCSANOW, &termOptions);
    return true;
}
#ifdef META_LOG_CTRL_TEST
int fd_test;
char testlogpath[1024] = "/data/vendor/log/testlog";
#endif
bool mnld_sendLogDataToPC(const char *data, unsigned int len) {
    int bytes_left = (int) len;
    char *data_ptr = (char *) data;
    int bytes_written;

    while(bytes_left > 0) {
        bytes_written = write(log_port, data_ptr, bytes_left);
#ifdef META_LOG_CTRL_TEST
        write(fd_test, data_ptr, bytes_left);
#endif
        if (bytes_written == -1) {
            if (errno == EAGAIN) {
                SOCK_LOGE("mnld_sendLogDataToPC: EAGAIN");
                return true;
            }
            SOCK_LOGE("mnld_sendLogDataToPC: write failed, errno=%d, strerror=%s, len=%d, left=%d", errno, strerror(errno), len, bytes_left);
            if (errno == 5 || errno == 9) {
                if(transfer_mode == ATM_USB_MODE) {
                    mnld2pc_log_openUSBPort();
                }
            }
            return false;
        }
        data_ptr += bytes_written;
        bytes_left -= bytes_written;
    }
    return true;
}

int mnld_checkConnectType() {
    char connectType[PROPERTY_VALUE_MAX] = {0};
    property_get(PROP_META_CONN_TYPE, connectType, "");
    if (!strncmp("wifi", connectType, strlen("wifi"))) {
        return 0;
    }
    return 1;
}

bool mnld_TransferFile(char* logPath, const char* fileName) {
    memset(file_header_info.file_name, 0, 64);
    file_header_info.file_len = 0;
    FILE *fp = NULL;
    char full_path[256];
    memset(full_path, 0, 256);
    sprintf(full_path, FULL_DIR_FILE, logPath, fileName);
    SOCK_LOGD("file be pulled is : %s", full_path);
    fp = fopen(full_path, "rb");
    if (fp != NULL) {
        int ret = fseek(fp, 0, SEEK_END);
        if (ret == -1) {
            SOCK_LOGE("fseek end file error:%s", strerror(errno));
            fclose(fp);
            return false;
        }
        int file_size = ftell(fp);
        if (file_size == -1) {
            SOCK_LOGE("ftell file error:%s", strerror(errno));
            fclose(fp);
            return false;
        }
        MNLD_STRNCPY(file_header_info.file_name, fileName, sizeof(file_header_info.file_name));
        file_header_info.file_len = file_size;
        // send file_header data
        SOCK_LOGE("file_name %s, file_size %d", file_header_info.file_name, file_header_info.file_len);
        mnld_sendLogDataToPC((char*)(&file_header_info), sizeof(file_header_info));
        ret = fseek(fp, 0, SEEK_SET);
        if (ret == -1) {
            SOCK_LOGE("fseek end file error:%s", strerror(errno));
            fclose(fp);
            return false;
        }
        while(!feof(fp)) {
            if (pull_stop_flag == 0) {
                memset(m_DataLogBuf, 0, LOG_BUFFER_SIZE);
                ssize_t read_len = fread(m_DataLogBuf, sizeof(char), LOG_BUFFER_SIZE, fp);
                if (-1 == read_len) {
                    SOCK_LOGE("Failed to read data from file, errno=%d", errno);
                    fclose(fp);
                    return false;
                } else if (read_len > 0) {
                    mnld_sendLogDataToPC(m_DataLogBuf, read_len);
                    SOCK_LOGE("send logdata, len = %ld", read_len);
                } else {
                    SOCK_LOGE("read data from file, size = 0 .errno=%d", errno);
                }
            } else {
                pull_stop_flag = 0;
                break;
            }
        }
        fclose(fp);
    } else {
        SOCK_LOGE("Failed to open file %s, errno=%d", full_path, errno);
        return false;
    }
    return true;
}

signed int mnld2pc_wifi_createSocket()
{
 //   int ret = -1;
    int sock_opt = 1;
    int enable = 1;
    if (m_nSockFd != -1) {
        SOCK_LOGE("connsyslogger Wifi Socket already created.");
        return m_nSockFd;
    }
    //Create socket
    if((m_nSockFd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
        SOCK_LOGE("connsyslogger Wifi Socket created fail. errno=%d", errno);
        return -1;
    }

    SOCK_LOGD("connsyslogger Wifi Socket created success m_nSockFd:%d",m_nSockFd);

    // SET SOCKET REUSE Address
    if(setsockopt(m_nSockFd, SOL_SOCKET, SO_REUSEADDR, (void*)&sock_opt, sizeof(sock_opt)) < 0)
    {
        SOCK_LOGE("connsyslogger Wifi Socket setsockopt failed. errno=%d", errno);
        close(m_nSockFd);
        return -1;
    }

    //SET TCP_NODELAY
    if(setsockopt(m_nSockFd, IPPROTO_TCP, TCP_NODELAY, (void*)&enable, sizeof(enable)) < 0)
    {
        SOCK_LOGE("connsyslogger Wifi Socket setsockopt TCP_NODELAY failed. errno=%d", errno);
    }
    //Prepare the sockaddr_in structure
    struct sockaddr_in serverAddr;

    memset(&serverAddr, 0, sizeof(serverAddr));

    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port = htons(WIFI_SOCKET_PORT);
    char strIpAddr[128] = {0};
    property_get(PROP_WIFI_ADDR,strIpAddr,"0.0.0.0");
    SOCK_LOGD("connsyslogger Wifi Socket IP Addr:%s", strIpAddr);
    serverAddr.sin_addr.s_addr = inet_addr(strIpAddr);
    bzero(&(serverAddr.sin_zero),8);
    //Bind
    if(bind(m_nSockFd,(struct sockaddr*)&serverAddr, sizeof(struct sockaddr)) < 0)
    {
        SOCK_LOGE("connsyslogger Wifi Socket bind failed. errno=%d", errno);
        goto errout;
    }
    SOCK_LOGD("connsyslogger Wifi Socket bind done");

    //Listen
    if (listen(m_nSockFd, BACKLOG) == -1)
    {
        SOCK_LOGE("connsyslogger Wifi Socket Failed to listen Socket port, errno=%d", errno);
        goto errout;
    }
    SOCK_LOGD("connsyslogger Wifi Socket listen done");
    return m_nSockFd;

errout:
    close(m_nSockFd);
    m_nSockFd = -1;
    return -1;
}

void mnld2pc_wifi_disconnect() {
    if (m_nConnect) {
        if (m_nClientFd != -1) {
            m_nConnect = false;
            close(m_nClientFd);
            m_nClientFd = -1;
            SOCK_LOGD("connsyslogger wifi Socket disconnect client");
        }
    } else{
        SOCK_LOGD("connsyslogger wifi Socket already disconnect client");
    }
}

int mnld2pc_connect_wifi() {
    if (-1 == m_nSockFd) {
        SOCK_LOGE("connsyslogger wifi Socket server not create");
        return -1;
    }

    if (m_nConnect) {
        SOCK_LOGD("connsyslogger wifi Socket already conencted");
        return 0;
    }

    struct sockaddr_in clientAddr;
    memset(&clientAddr, 0, sizeof(clientAddr));

    socklen_t alen = sizeof(struct sockaddr);

    while(1) {
        SOCK_LOGD("connsyslogger wifi Socket connect, accept the connection........");
        if ((m_nClientFd = accept(m_nSockFd, (struct sockaddr*)&clientAddr, &alen)) == -1)
        {
            SOCK_LOGE("connsyslogger Socket accept error, errno=%d,m_nSockFd = %d", errno,m_nSockFd);

            if(errno == EAGAIN)
            {
                usleep(200*1000);
                continue;
            }
            m_nConnect = false;
            return -1;
        }
        else
        {
            m_nConnect = true;
            SOCK_LOGD("connsyslogger Socket connect, Received a connection from %s, m_nClientFd = %d",
                (char*)inet_ntoa(clientAddr.sin_addr), m_nClientFd);
            return 0;
        }
    }
}

void mnld2pc_wifi_socketClose() {
    mnld2pc_wifi_disconnect();
    if (m_nSockFd != -1)
    {
        close(m_nSockFd);
        m_nSockFd = -1;
    }
}

void mnld2pc_wifi_WaitConnect() {
    if (m_nConnect) {
        SOCK_LOGE("connsyslogger WaitConnect, already connected");
        return;
    }
    fd_set rfds;
    while (1) {
        FD_ZERO(&rfds);
        if(m_nSockFd > 0) {
            FD_SET(m_nSockFd, &rfds);
        }
        int maxfd = 0;
        int rc = 0;
        maxfd = m_nSockFd+1;
        if((rc = select(maxfd, &rfds, NULL, NULL, NULL)) < 0) {
            SOCK_LOGE("WaitConnect select failed (%s), errno = %d", strerror(errno), errno);
            sleep(1);
            continue;
        }
        if(FD_ISSET(m_nSockFd, &rfds)) {
            SOCK_LOGD("begin to accept client connection socketFd=%d", m_nSockFd);
            if (-1 == mnld2pc_connect_wifi()) {
                SOCK_LOGD("accept client connection failed.");
                sleep(1);
                continue;
            }
            SOCK_LOGD("accept client connection done.");
            break;
        }
   }
    return ;
}
bool mnld2pc_log_sendSourceFile(char* folder_path,ATM_ONLINE_MODE mode){
    if (mode == ATM_WIFI_MODE) {
        mnld2pc_wifi_WaitConnect();
    }
    SOCK_LOGD("sendSourceFile log folder: %s", folder_path);
    DIR* dp = NULL;
    transfer_mode = mode;
    struct dirent* dirp = NULL;
    dp = opendir(folder_path);
    if (dp == NULL) {
        SOCK_LOGE("can not open log folder: %s", folder_path);
     if (mode == 0) {
        mnld2pc_wifi_socketClose();
     }
        return false;
    }
    while ((dirp = readdir(dp)) != NULL) {
        if ((strstr(dirp->d_name,".nma") != NULL) || (strstr(dirp->d_name,".nma.curf") != NULL)) {
            MNLD_STRNCPY(m_logFilelist.file_head[m_logFilelist.file_num].file_name, dirp->d_name, sizeof(m_logFilelist.file_head[m_logFilelist.file_num].file_name));
            m_logFilelist.file_num++;
        }
    }
    closedir(dp);
    ///////begin transfer files
    if (mode == ATM_USB_MODE){
        mnld2pc_log_openUSBPort();
        log_port = usb_port_fd;
    }else {
        mnld2pc_wifi_WaitConnect();
        log_port = m_nClientFd;
    }
#ifdef META_LOG_CTRL_TEST
    fd_test = open(testlogpath, O_RDWR| O_CREAT | O_NOCTTY, 0755);
    if (fd_test == -1) {
        SOCK_LOGE("open /data/vender/log/testlog fail, errorno is %d ,%s", errno, strerror(errno));
    }
#endif
    SOCK_LOGD("mode = %d,log_port = %d,total files be pulled is : %u", mode,log_port,m_logFilelist.file_num);

    memset(pre_fix,0,16);
    MNLD_STRNCPY(pre_fix, "GPSlog_start", sizeof(pre_fix));
    pre_fix[sizeof(pre_fix) - 1] = '\0';
    file_count = m_logFilelist.file_num;

    /////send prefix
    mnld_sendLogDataToPC(pre_fix,sizeof(pre_fix));
    SOCK_LOGE("prefix %s", pre_fix);
    mnld_sendLogDataToPC((char*)&file_count,sizeof(file_count));
    SOCK_LOGE("file_count %d", file_count);
    for (int i = 0; i < m_logFilelist.file_num; i++) {
        mnld_TransferFile(folder_path,m_logFilelist.file_head[i].file_name);
    }
    memset(post_fix,0,16);
    MNLD_STRNCPY(post_fix, "GPSlog_end", sizeof(post_fix));
    post_fix[sizeof(post_fix) - 1] = '\0';
    SOCK_LOGE("post_fix %s", post_fix);
    mnld_sendLogDataToPC(post_fix,sizeof(post_fix));
    if (mode == ATM_USB_MODE)
       mnld2pc_log_closeUSBPort();
    else
       mnld2pc_wifi_socketClose(); // close cocket
    //////end transfer
    return true;
}


void mnld2meta_reply_result(char* cmd, char result) {
    char reply[META2MNLD_LOGCTRL_INTERFACE_BUFF_SIZE] = {0};

    sprintf(reply, "%s,%d", cmd, result);
    SOCK_LOGD("mnld2meta_reply, str=%s, len=%lu", reply, strlen(reply));
    write(clientConnect, reply, strlen(reply));
}

static void meta_logctrl_start_log() {
    meta_logctrl = META_LOGCTRL_ENGBLE;
    gps_dbg_log_mode_set(MNLD_WRITE_LOG_TOFILE);
    MNLD_STRNCPY(gps_debuglog_file_name, GPS_DBGLOG_FILE_NAME ,GPS_DEBUG_LOG_FILE_NAME_MAX_LEN);
    MNLD_STRNCPY(storagePath, GPS_DBGLOG_PATH ,GPS_DEBUG_LOG_FILE_NAME_MAX_LEN);
    MNLD_STRNCPY(storagePath_mtklogger_set, GPS_DBGLOG_PATH ,GPS_DEBUG_LOG_FILE_NAME_MAX_LEN);
    SOCK_LOGD("Meta enable GPS debug log\n");
    gps_dbg_log_state_set_output_enable();
    mnld2meta_reply_result(GPSLOG_START, 1);
}
static void meta_logctrl_stop_log() {
    meta_logctrl = META_LOGCTRL_DISABLE;
    gps_dbg_log_output2file_clean();
    SOCK_LOGD("Meta disable GPS debug log\n");
    gps_dbg_log_state_set_output_disable();
    mnld2meta_reply_result(GPSLOG_STOP, 1);
}
static void meta_logctrl_pull_log_start() {
    if (mnld_checkConnectType() == ATM_WIFI_MODE) {
        if(mnld2pc_wifi_createSocket() == -1) {
            SOCK_LOGE("mnld2pc_wifi_createSocket fail");
        }
        if(mnld2pc_log_sendSourceFile(storagePath, ATM_WIFI_MODE) == false) {
            SOCK_LOGE("ATM_WIFI_MODE, mnld2pc_log_sendSourceFile fail");
        }
    } else {
        if(mnld2pc_log_sendSourceFile(storagePath, ATM_USB_MODE) == false) {
            SOCK_LOGE("ATM_USB_MODE, mnld2pc_log_sendSourceFile fail");
        }
    }
    mnld2meta_reply_result(GPSLOG_PULL_START, 1);
}
static void meta_logctrl_pull_log_stop() {
    //pull_stop_flag = 1;
    mnld2meta_reply_result(GPSLOG_PULL_STOP, 1);
}

static Meta2MnldLogctrlInterface_callbacks g_meta2mnl_logctrl_callbacks = {
    meta_logctrl_start_log,
    meta_logctrl_stop_log,
    meta_logctrl_pull_log_start,
    meta_logctrl_pull_log_stop,
};
int Meta2Mnld_logctrl_hdlr(int fd, Meta2MnldLogctrlInterface_callbacks* hdlr)
{
    char buff[META2MNLD_LOGCTRL_INTERFACE_BUFF_SIZE] = {0};
    int read_len;
    int ret = 0;

    read_len = read(fd, buff, sizeof(buff)-1);
    if (read_len <= 0) {
        usleep(1000);
        SOCK_LOGE("Meta2Mnld_logctrl_hdlr() read_len<=0,read_len = %d\n", read_len);
        ret = -1;
    }

    if (!strcmp(buff, GPSLOG_START)) {
        if (hdlr->Meta2MnldInterface_start_log_handler) {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_START");
            hdlr->Meta2MnldInterface_start_log_handler();
        } else {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_START is NULL");
            ret = -1;
        }
    } else if (!strcmp(buff, GPSLOG_STOP)) {
        if (hdlr->Meta2MnldInterface_stop_log_handler) {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_STOP");
            hdlr->Meta2MnldInterface_stop_log_handler();
        } else {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_STOP is NULL");
            ret = -1;
        }
    } else if (!strcmp(buff, GPSLOG_PULL_START)) {
        if (hdlr->Meta2MnldInterface_pull_log_start_handler) {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_PULL_START");
            hdlr->Meta2MnldInterface_pull_log_start_handler();
        } else {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_PULL_START is NULL");
            ret = -1;
        }
    } else if (!strcmp(buff, GPSLOG_PULL_STOP)) {
        if (hdlr->Meta2MnldInterface_pull_log_stop_handler) {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_PULL_STOP");
            hdlr->Meta2MnldInterface_pull_log_stop_handler();
        } else {
            SOCK_LOGE("Meta2Mnld_logctrl_hdlr() GPSLOG_PULL_STOP is NULL");
            ret = -1;
        }
    } else {
        SOCK_LOGE("Meta2Mnld_logctrl_hdlr() unknown cmd=%s", buff);
    }

    return ret;

}

void *mtk_tcp_listener() {
    #define MAX_EPOLL_EVENT 50
    int maxFd = 0;
    int ret = 0;
    struct epoll_event events[MAX_EPOLL_EVENT];

    int epfd = epoll_create(MAX_EPOLL_EVENT);
    if (epfd == -1) {
        SOCK_LOGE("mtk_tcp_listener() epoll_create failure reason=[%s]%d",
            strerror(errno), errno);
    }
    if (epoll_add_fd(epfd, mSockListenId) == -1) {
        SOCK_LOGE("mtk_tcp_listener() epoll_add_fd() failed for fd_agps failed");
    }
    while (1) {
        int n = 0;
        int i = 0;
        n = epoll_wait(epfd, events, MAX_EPOLL_EVENT , -1);
        if (n > 1) {
            SOCK_LOGD("n=%d\n", n);
        } else if (n == -1) {
            if (errno == EINTR) {
                continue;
            } else {
                SOCK_LOGE("mtk_tcp_listener() epoll_wait failure reason=[%s]%d",
                    strerror(errno), errno);
                continue;
            }
        }
        for (i = 0; i < n; i++) {
            if (events[i].data.fd == mSockListenId) {
                // deal with new connection
                if (events[i].events & EPOLLIN) {
                    struct sockaddr addr;
                    socklen_t alen = sizeof(addr);
                    int connectfd = -1;
                    if ((connectfd = accept(mSockListenId, &addr, &alen)) < 0) {
                        SOCK_LOGE("accept failed (%s) , errno = %d", strerror(errno), errno);
                        sleep(1);
                        continue;
                    }

                    SOCK_LOGD("consyslgger accept connection done connectfd=%d",connectfd);

                    if (connectfd != clientConnect) {
                        if(clientConnect > 0) {
                            epoll_del_fd(epfd, clientConnect);
                            close(clientConnect);
                        }
                        clientConnect = connectfd;

                        if (clientConnect > 0) {
                            if (epoll_add_fd(epfd, clientConnect) == -1) {
                                SOCK_LOGE("mtk_tcp_listener() epoll_add_fd() failed for fd_agps failed");
                                continue;
                            }
                        }
                    }
                }
            } else if (events[i].data.fd == clientConnect) {
                // socket channel command
                if (events[i].events & EPOLLIN) {
                    if (Meta2Mnld_logctrl_hdlr(clientConnect, &g_meta2mnl_logctrl_callbacks) == -1) {
                        epoll_del_fd(epfd, clientConnect);
                        close(clientConnect);
                        clientConnect = -1;
                        continue;
                    }
                    continue;
                }
            } else {
                LOGE("mnld_main_thread() unknown fd=%d",
                    events[i].data.fd);
            }
        }
    }

    return 0;
}

int mtk_socket_tcp_startListening(const char* path, mtk_socket_namespace sock_namespace) {
    int ret;
    pthread_t pthread_tcp_listener;
    UNUSED(sock_namespace);
    do {
        mSockListenId = socket_local_server(path,
                SOCK_STREAM);

        if (mSockListenId < 0) {
            SOCK_LOGE("mSockListenId<0 ,errno=%d",errno);
            break;
        }
        SOCK_LOGE("mSockListenId ok\n");

        ret = listen(mSockListenId, 4);
        if (ret < 0) {
            SOCK_LOGE("listen error.errno=%d",errno);
            break;
        }
        pthread_create(&pthread_tcp_listener, NULL, mtk_tcp_listener, NULL);
        SOCK_LOGD("Success to setup socket local server");
        return 1;
    } while (0);
    SOCK_LOGD("Fail to setup socket local server, exit");
    if (mSockListenId > 0) {
          shutdown(mSockListenId, 2);
          close(mSockListenId);
          mSockListenId = -1;
    }
    return 0;
}

