#ifndef __MNL2HAL_BASIC_INTERFACE_H__
#define __MNL2HAL_BASIC_INTERFACE_H__

#include "hal_mnl_interface_common.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DUMP_BASIC_SERVER_CAP(pcap) do {\
    LOGD("[%s]:mnl_hal_basic_server_cap size:%lu, gnss_support=%d", __func__, sizeof(mnl_hal_basic_server_cap), (pcap)->support_gnss);\
} while(0)

#define DUMP_BASIC_CLIENT_CAP(pcap) do {\
    LOGD("[%s]:mnl_hal_basic_client_cap size:%lu, gnss_support=%d", __func__, sizeof(mnl_hal_basic_client_cap), (pcap)->support_gnss);\
} while(0)

typedef struct {
    void (*gnss_init)(int fd);
    void (*gnss_start)(int fd);
    void (*gnss_stop)(int fd);
    void (*gnss_cleanup)(int fd);
    void (*set_measurement_enable)(bool enabled, int fd);
    void (*client_capability_update)(int fd, mnl_hal_basic_client_cap *cap);
} hal2mnl_basic_interface;

int mnl2hal_location(gps_location location);
int mnl2hal_gnss_status(gps_status status);
int mnl2hal_gnss_status_one_client(gps_status status, int fd);
int mnl2hal_gnss_sv(gnss_sv_info *sv);
int mnl2hal_nmea(int64_t timestamp, const char* nmea, int length);
int mnl2hal_nmea_done(void);
int mnl2hal_gnss_measurements(gnss_data *data);

int create_hal2mnl_basic_fd();

int create_hal2mnl_ext_fd();

void hal2mnl_basic_server_hdlr(int fd, int epfd);
void hal2mnl_ext_server_hdlr(int fd, int epfd);
void hal2mnl_basic_client_hdlr(int fd, hal2mnl_basic_interface* hdlr);

void mnl_hal_basic_client_capability_query(int fd, mnl_hal_basic_client_cap *cap);
void mnl_hal_basic_server_capability_query(int fd, mnl_hal_basic_server_cap *cap);

#ifdef __cplusplus
}
#endif

#endif
