/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __MTKEXPAT_H__
#define __MTKEXPAT_H__

#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _mtk_expat_attribute {
    //data
    char* key;
    char* value;
    //link
    struct _mtk_expat_attribute* next;
} mtk_expat_attribute;

typedef struct _mtk_expat_element {
    //data
    char* name;
    mtk_expat_attribute* attr;
    //link
    struct _mtk_expat_element* next;
} mtk_expat_element;

typedef struct {
    mtk_expat_element* element;

    //to speed up mtk_expat_add_element()
    mtk_expat_element** last_element;

    //to speed up mtk_expat_add_attr()
    mtk_expat_attribute** last_attr;

    char error_string[128];
} mtk_expat_context;

void mtk_expat_init(mtk_expat_context* ctx);
void mtk_expat_cleanup(mtk_expat_context* ctx);
void mtk_expat_dump(mtk_expat_context* ctx);
void mtk_expat_dump_element(mtk_expat_element* element);

mtk_expat_element* mtk_expat_add_element(mtk_expat_context* ctx, const char* name);
void mtk_expat_add_attr_bool(mtk_expat_context* ctx, const char* key, bool value);
void mtk_expat_add_attr_int(mtk_expat_context* ctx, const char* key, int value);
void mtk_expat_add_attr_string(mtk_expat_context* ctx, const char* key, const char* value);

int mtk_expat_get_element_num(mtk_expat_context* ctx, const char* name);
mtk_expat_element* mtk_expat_get_element(mtk_expat_context* ctx, const char* name);
mtk_expat_element* mtk_expat_get_element_index(mtk_expat_context* ctx, const char* name, int index);
bool mtk_expat_get_attr_bool(mtk_expat_element* element, const char* key, bool default_value);
int mtk_expat_get_attr_int(mtk_expat_element* element, const char* key, int default_value);
const char* mtk_expat_get_attr_string(mtk_expat_element* element, const char* key, const char* default_value);

const char* mtk_expat_strerror(mtk_expat_context* ctx);

// return false means error and can use mtk_expat_strerror(ctx) to get the error info in the string format
bool mtk_expat_xml_save(mtk_expat_context* ctx, const char* file);

// this is non-reentrant API, do not call this API from different thread in the same time
// return false means error and can use mtk_expat_strerror(ctx) to get the error info in the string format
bool mtk_expat_xml_load(mtk_expat_context* ctx, const char* file);

char *safe_strncpy(char *dest, const char *src, size_t n);

#ifdef __cplusplus
}
#endif

#endif
