/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2019
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>

#include "mtkexpat.h"
#include "agpsprofile.h"
//#include "utility.h"
#if defined(__ANDROID_OS__) | defined(__KAIOS__)
#include <android/log.h>
#endif

#define AGPS_XML_NODE_MTK_AGPS_PROFILE          "mtk_agps_profiles"
#define AGPS_XML_NODE_SUPL_PROFILE              "supl_profile"

char *safe_strncpy(char *dest, const char *src, size_t n) {
    if (dest && n > 0) {
        // Use strncat for performance because strncpy will always fill n bytes in dest
        dest[0] = '\0';            // Let dest be an empty string
        strncat(dest, src, --n);   // n-1 because strncat may fill n+1 bytes
    }
    return dest;
}

#if defined(__ANDROID_OS__) || defined(__KAIOS__)
static void _LOGD(const char* message) {
    __android_log_print(ANDROID_LOG_DEBUG, "[agpsprofile]", "%s", message);
}

static void _LOGW(const char* message) {
    __android_log_print(ANDROID_LOG_DEBUG, "[agpsprofile] WRN:", "%s", message);
}

#elif defined(__LINUX_OS__) || defined(__YOCTO_OS__)
static void _LOGD(const char* message) {
    printf("%s\n", message);
    fflush(stdout);
}

static void _LOGW(const char* message) {
    printf("%s\n", message);
    fflush(stdout);
}
#endif

static void LOGD(const char *fmt, ...) {
    char out_buf[1100] = {0};
    char buf[1024] = {0};
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);

    sprintf(out_buf, "%s", buf);
    _LOGD(out_buf);
}

static void LOGW(const char *fmt, ...) {
    char out_buf[1100] = {0};
    char buf[1024] = {0};
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);

    sprintf(out_buf, "%s", buf);
    _LOGW(out_buf);
}

static void agps_xml_init(agps_mgr_agps_config* xml) {
    memset(xml, 0, sizeof(*xml));
}

static void agps_xml_get_supl_profile(mtk_expat_element* element, agps_mgr_supl_profile* p) {
    safe_strncpy(p->name,           mtk_expat_get_attr_string(element, "name", ""), sizeof(p->name));
    safe_strncpy(p->addr,           mtk_expat_get_attr_string(element, "addr", ""), sizeof(p->addr));
    p->port                   = mtk_expat_get_attr_int(element, "port", 0);
    p->tls                    = mtk_expat_get_attr_bool(element, "tls", true);
}

bool agps_xml_load(agps_mgr_agps_config* xml, const char* path) {
    int i;
    int count;
    bool ret;
    mtk_expat_context expat_ctx;
    mtk_expat_element* element = NULL;

    agps_xml_init(xml);
    mtk_expat_init(&expat_ctx);
    ret = mtk_expat_xml_load(&expat_ctx, path);
    if(ret == false) {
        LOGW("mtk_expat_xml_load() failed reason=[%s]\n", mtk_expat_strerror(&expat_ctx));
        return false;
    }

    element = mtk_expat_get_element(&expat_ctx, AGPS_XML_NODE_MTK_AGPS_PROFILE);
    if(element) {
        xml->maj_ver        = mtk_expat_get_attr_int(element, "maj_ver", 1);
        xml->min_ver        = mtk_expat_get_attr_int(element, "min_ver", 0);
    }

    count = mtk_expat_get_element_num(&expat_ctx, AGPS_XML_NODE_SUPL_PROFILE);
    xml->supl_profiles_num = count;
    xml->supl_profiles = malloc(count * sizeof(agps_mgr_supl_profile));
    for(i = 0; i < count; i++) {
        element = mtk_expat_get_element_index(&expat_ctx, AGPS_XML_NODE_SUPL_PROFILE, i);
        agps_xml_get_supl_profile(element, &xml->supl_profiles[i]);
    }

    mtk_expat_cleanup(&expat_ctx);

    return true;
}

#ifdef UNUSED_PLACE
static void agps_xml_dump_supl_profiles(agps_mgr_agps_config* agps_config) {
    int i = 0;
    for(i = 0; i < agps_config->supl_profiles_num; i++) {
        agps_mgr_supl_profile* profile = &agps_config->supl_profiles[i];
        LOGD("profile  i=%d  name=[%s] addr=[%s] port=[%d] tls=[%d]\n",
            i,
            profile->name,
            profile->addr,
            profile->port,
            profile->tls);
    }
}

void agps_xml_dump(agps_mgr_agps_config* config) {
    LOGW(" =================== agps_xml_dump ===================\n");
    agps_xml_dump_supl_profiles(config);
}
#endif
