/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 *
 * Filename:
 * ---------
 *   agps_interface.h
 *
 * Description:
 * ------------
 *   Use this interface to do the communication with mtk_agpsd to
 *   get/set the AGPS configurations with mtk_agpsd
 *
 ****************************************************************************/
#ifndef __AGPS_INTERFACE_H__
#define __AGPS_INTERFACE_H__

#ifdef __cplusplus
extern "C" {
#endif

#define agps_bool char

#define AGPS_INTF_STRING_LEN 64
#define AGPS_SUPL_ADDR_LEN 128
#define MNL_MCC_STRING_LEN 16
#define EXTERNAL_ADD_LEN 20
#define MLC_NUMBER_LEN 20
#define EPC_MOLR_LPP_PAYLOAD_LEN 300
#define SUPL_PROFILES_NUM 30
#define PROFILING_MESSAGE_LEN 64
#define PROFILING_ELEMENT_NUM 20

// Bits for TC10 CP Capability Control
#define AGPS_INTF_TC10_CP_CAPABILITY_AGNSS 0x01
#define AGPS_INTF_TC10_CP_CAPABILITY_OTDOA 0x02
#define AGPS_INTF_TC10_CP_CAPABILITY_ECID  0x04
#define AGPS_INTF_TC10_CP_CAPABILITY_CONVENTIONAL_GPS 0x08
//#define AGPS_INTF_TC10_CP_CAPABILITY_LPP_EXTENSION    0x10      // Use MTK's cp_lppe_enable instead
#define AGPS_INTF_TC10_CP_CAPABILITY_INTER_FREQ_OTDOA 0x20

// Mode values for TC10 SSL method
#define AGPS_INTF_TC10_SUPL_SSL_METHOD_NEGOTIATION  0 // Default
#define AGPS_INTF_TC10_SUPL_SSL_METHOD_SSLV3    1
#define AGPS_INTF_TC10_SUPL_SSL_METHOD_SSLV23   2
#define AGPS_INTF_TC10_SUPL_SSL_METHOD_TLSV1    3
#define AGPS_INTF_TC10_SUPL_SSL_METHOD_TLSV1_1  4
#define AGPS_INTF_TC10_SUPL_SSL_METHOD_TLSV1_2  5

// Bits for UP_PRIVACY_OVERRIDE_MODE. You can also use a combined value of them
#define AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_DEFAULT           0 // no privacy will be overridden
#define AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_HIDING_ICON 1 // allow po-supl to hide location icon
#define AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_LOCATIONING 2 // accept po-supl even if GVC does not allow locationing
#define AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_ESUPL       4 // accept e-supl even if GVC does not allow locationing
#define AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_ALL         8 // accept all (Ignore GVC)
#define AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_TC10        16 // accept all for TC10 (Ignore GVC, and GPS / AGPS settings)

typedef enum {
    AGPS_INTF_PDE_IP_TYPE_IPV4 = 0,
    AGPS_INTF_PDE_IP_TYPE_IPV6 = 1,
} agps_intf_pde_ip_type;

typedef enum {
    AGPS_INTF_CDMA_PREFERRED_WCDMA = 0,
    AGPS_INTF_CDMA_PREFERRED_CDMA = 1,
    AGPS_INTF_CDMA_PREFERRED_CDMA_FORCE = 2,
} agps_intf_cdma_preferred;

typedef enum {
    AGPS_INTF_PREF_METHOD_MSA = 0,
    AGPS_INTF_PREF_METHOD_MSB = 1,
    AGPS_INTF_PREF_METHOD_NO_PREF = 2,
} agps_intf_pref_method;

typedef enum {
    AGPS_INTF_MOLR_POS_METHOD_LOC_EST = 0,
    AGPS_INTF_MOLR_POS_METHOD_ASSIST_DATA = 1,
} agps_intf_molr_pos_method;

typedef enum {
    AGPS_INTF_AGPS_PROTOCOL_UP = 0,
    AGPS_INTF_AGPS_PROTOCOL_CP = 1,
} agps_intf_agps_protocol;

typedef enum {
    AGPS_INTF_SUPL_VERSION_1 = 1,
    AGPS_INTF_SUPL_VERSION_2 = 2,
} agps_intf_supl_version;

typedef enum {
    AGPS_INTF_TLS_VERSION_1_0 = 0,
    AGPS_INTF_TLS_VERSION_1_1 = 1,
    AGPS_INTF_TLS_VERSION_1_2 = 2,
} agps_intf_tls_version;

typedef enum {
    agps_intf_area_event_type_entering = 0,
    agps_intf_area_event_type_inside = 1,
    agps_intf_area_event_type_outside = 2,
    agps_intf_area_event_type_leaving = 3,
} agps_intf_area_event_type;

typedef enum {
    AGPS_INTF_PROFILING_TYPE_NORMAL = 0,
    AGPS_INTF_PROFILING_TYPE_WARNING = 1,
    AGPS_INTF_PROFILING_TYPE_ERROR = 2,
} agps_intf_profiling_type;

typedef enum {
    AGPS_INTF_ESUPL_APN_EIMS_IMS = 0,
    AGPS_INTF_ESUPL_APN_EIMS = 1,
    AGPS_INTF_ESUPL_APN_IMS = 2,
    AGPS_INTF_ESUPL_APN_AS_NORMAL = 3,
} agps_intf_esupl_apn;

typedef enum {
    AGPS_INTF_SUPL_IP_VERSION_IPV6 = 0,
    AGPS_INTF_SUPL_IP_VERSION_IPV4 = 1,
} agps_supl_ip_version_type;

typedef struct {
    char name[AGPS_INTF_STRING_LEN];
    char addr[AGPS_SUPL_ADDR_LEN];
    int port;
    agps_bool tls;
    char mcc_mnc[MNL_MCC_STRING_LEN];
    char app_id[AGPS_INTF_STRING_LEN];
    char provider_id[AGPS_INTF_STRING_LEN];
    char default_apn[AGPS_INTF_STRING_LEN];
    char optional_apn[AGPS_INTF_STRING_LEN];
    char optional_apn_2[AGPS_INTF_STRING_LEN];
    char address_type[AGPS_INTF_STRING_LEN];
} agps_intf_supl_profile;

typedef struct {
    char name[AGPS_INTF_STRING_LEN];
    agps_bool mcp_enable;
    char mcp_addr[AGPS_INTF_STRING_LEN];
    int mcp_port;
    agps_bool pde_addr_valid;
    agps_intf_pde_ip_type pde_ip_type;    //0=IPV4 1=IPV6
    char pde_addr[AGPS_INTF_STRING_LEN];
    int pde_port;
    agps_bool pde_url_valid;
    char pde_url_addr[AGPS_INTF_STRING_LEN];
} agps_intf_cdma_profile;

typedef struct {
    agps_bool agps_enable;
    agps_intf_agps_protocol agps_protocol;
    agps_bool gpevt;
    agps_bool e911_gps_icon_enable;
    agps_bool e911_open_gps;
    agps_bool tc10_ignore_fw_config;
    agps_bool lppe_hide_wifi_bt_status;
    agps_bool lppe_network_location_disable;
    agps_bool agps_nvram_enable;
    agps_bool lbs_log_enable;
    int lppe_crowd_source_confident;
    agps_bool ignore_si_for_e911; // North America operator 'V' asks us to ignore SI triggered by GMS
    agps_bool use_tc10_config;
    agps_bool lppe_def_nlp_enable;
    int emergency_ext_secs;
} agps_intf_agps_setting;

typedef struct {
    agps_intf_molr_pos_method molr_pos_method;
    agps_bool external_addr_enable;
    char external_addr[EXTERNAL_ADD_LEN];
    agps_bool mlc_number_enable;
    char mlc_number[MLC_NUMBER_LEN];
    agps_bool cp_auto_reset;
    agps_bool epc_molr_lpp_payload_enable;
    int epc_molr_lpp_payload_len;
    char epc_molr_lpp_payload[EPC_MOLR_LPP_PAYLOAD_LEN];
    agps_bool cp_lppe_enable;
    agps_bool support_cp_lppe;
    agps_bool reject_non911_nilr_enable;
    agps_bool cp_2g_disable;
    agps_bool cp_3g_disable;
    agps_bool cp_4g_disable;
    agps_bool cp_lppe_wlan_enable;
    agps_bool cp_lppe_srn_enable;
    agps_bool cp_lppe_sensor_enable;
    agps_bool cp_lppe_dbh_enable;
} agps_intf_cp_setting;

typedef struct {
    agps_bool ca_enable;
    agps_bool ni_request;
    agps_bool roaming;
    agps_intf_cdma_preferred cdma_preferred;
    agps_intf_pref_method pref_method;
    agps_intf_supl_version supl_version;
    agps_intf_tls_version tls_version;
    agps_bool supl_log;
    agps_bool msa_enable;
    agps_bool msb_enable;
    agps_bool ecid_enable;
    agps_bool otdoa_enable;
    int qop_hacc;
    int qop_vacc;
    int qop_loc_age;
    int qop_delay;
    agps_bool lpp_enable;
    agps_bool cert_from_sdcard;
    agps_bool auto_profile_enable;
    char ut2;
    char ut3;
    agps_bool apn_enable;
    agps_bool sync_to_slp;
    agps_bool udp_enable;
    agps_bool autonomous_enable;
    agps_bool aflt_enable;
    agps_bool imsi_enable;
    char supl_ver_minor;
    char supl_ver_ser_ind;
    int sha_version;    // 0: SHA1 for SUPL1.0 and SHA256 for SUPL2.0, 1: SHA1 for SUPL1.0 and SUPL2.0, 2: SHA256 for SUPL1.0 and SUPL2.0
    int preferred_2g3g_cell_age;
    char ut1;
    agps_bool no_sensitive_log;
    agps_bool tls_reuse_enable;
    agps_bool imsi_cache_enable;
    agps_bool supl_raw_data_enable;
    agps_bool tc10_enable;
    agps_bool tc10_use_apn;
    agps_bool tc10_use_fw_dns;
    agps_bool allow_ni_for_gps_off;
    agps_bool force_otdoa_assist_req;
    agps_bool up_lppe_enable;
    agps_intf_esupl_apn esupl_apn_mode;
    int tcp_keepalive;
    agps_bool aosp_profile_enable;
    agps_bool bind_nlp_setting_to_supl;
    agps_bool up_lppe_wlan_enable;
    agps_bool up_lppe_srn_enable;
    agps_bool up_lppe_sensor_enable;
    agps_bool up_lppe_dbh_enable;
    int ip_version_prefer;            //0=IPv6 prefer   1=IPv4 prefer
    agps_bool up_lppe_in_2g3g_disable; // For ATT SUPL server
    agps_bool up_rrlp_in_4g_disable;  // For ATT SUPL server
    agps_bool up_si_disable;          // For Sprint
    agps_bool use_ni_slp;             // tc10 (ALPS04423530)
    agps_bool aosp_pos_mode_enable;
    int privacy_override_mode;
} agps_intf_up_setting;

typedef struct {
    agps_bool sib8_sib16_enable;
    agps_bool gps_satellite_enable;
    agps_bool glonass_satellite_enable;
    agps_bool beidou_satellite_enable;
    agps_bool galileo_satellite_enable;
    agps_bool a_glonass_satellite_enable;

    agps_bool gps_satellite_support;
    agps_bool glonass_satellite_support;
    agps_bool beidou_satellite_support;
    agps_bool galileo_satellite_support;

    agps_bool a_gps_satellite_enable;
    agps_bool a_beidou_satellite_enable;
    agps_bool a_galileo_satellite_enable;

    agps_bool mnl_support_lppe;
} agps_intf_gnss_setting;

typedef struct {
    int supl_profiles_num;
    agps_intf_supl_profile supl_profiles[SUPL_PROFILES_NUM];
    agps_intf_supl_profile cur_supl_profile;
    agps_intf_cdma_profile cdma_profile;
    agps_intf_agps_setting agps_setting;
    agps_intf_cp_setting cp_setting;
    agps_intf_up_setting up_setting;
    agps_intf_gnss_setting gnss_setting;
    agps_bool valid;
} agps_intf_agps_config;

typedef struct {
    agps_intf_profiling_type type;
    long long timestamp;
    char message[PROFILING_MESSAGE_LEN];
} agps_intf_profiling_element;

typedef struct {
    int element_num;
    agps_intf_profiling_element elements[PROFILING_ELEMENT_NUM];
} agps_intf_profiling_info;

typedef struct {
    agps_bool valid;
    char agpsd_version_string[AGPS_INTF_STRING_LEN];
} agps_intf_agpsd_version;

typedef struct {
    agps_bool valid;
    char imsi[AGPS_INTF_STRING_LEN];
    agps_bool is_2_digit_mnc;
} agps_intf_imsi;

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v3
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill supl_profiles.
 *  fill cur_supl_profile.
 *  fill agps_setting.
 *  fill cp_setting.
 *  fill up_setting to cert_from_sdcard.
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v3();

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v14
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill agps_intf_up_setting to supl_ver_ser_ind.
 *  fill agps_intf_gnss_setting to galileo_satellite_support.
 *  fill cdma_profile
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v14();

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v20
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill sib8_16_enable, gnss_enable, and gnss_support.
 *  fill supl_ver_minor, supl_ver_ser_ind.
 *  fill a_glonass_satellite_enable
 *  fill cdma profiles
 *  fill e911_gps_icon_enable
 *  fill e911_open_gps
 *  fill a_beidou_satellite_enable, a_galileo_satellite_enable
 *  fill supl_raw_data_enable, allow_ni_for_gps_off, force_otdoa_assist_req
 *  fill lppe_network_location_disable, cp_lppe_enable, up_lppe_enable
 *  fill support_cp_lppe and mnl_support_lppe
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v20();

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v21
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill agps_nvram_enable, lbs_log_enable, lppe_crowd_source_confident
 *  fill esupl_apn_mode, tcp_keepalive, aosp_profile_enable, bind_nlp_setting_to_supl
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v21();

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v22
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill ignore_si_for_e911, cp_lppe_wlan_enable, cp_lppe_srn_enable, cp_lppe_sensor_enable,
 *  fill cp_lppe_dbh_enable, up_lppe_wlan_enable, up_lppe_srn_enable, up_lppe_sensor_enable,
 *  fill up_lppe_dbh_enable, ip_version_prefer, up_lpp_in_2g3g_disable, up_rrlp_in_4g_disable,
 *  fill up_si_disable,
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v22();

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v23
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill use_ni_slp, use_tc10_config, lppe_def_nlp_enable
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v23();

/*****************************************************************************
 * FUNCTION
 *  get_agps_config_v24
 * DESCRIPTION
 *  get the current agps configuration from mtk_agpsd.
 *  fill emergency_ext_secs, aosp_pos_mode_enable, privacy_override_mode
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agps_config
 *****************************************************************************/
agps_intf_agps_config get_agps_config_v24();

/*****************************************************************************
 * FUNCTION
 *  get_cdma_profile
 * DESCRIPTION
 *  get the cdma profiles.
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_cdma_profile
 *****************************************************************************/
agps_intf_cdma_profile get_cdma_profile();

/*****************************************************************************
 * FUNCTION
 *  get_supl_profile
 * DESCRIPTION
 *  get the current agps supl profile from mtk_agpsd.
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_supl_profile
 *****************************************************************************/
agps_intf_supl_profile get_supl_profile();

/*****************************************************************************
 * FUNCTION
 *  get_agps_profiling_info
 * DESCRIPTION
 *  get the current agps profiling information from mtk_agpsd.
 *      (just for debugging)
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_supl_profile
 *****************************************************************************/
agps_intf_profiling_info get_agps_profiling_info();

/*****************************************************************************
 * FUNCTION
 *  get_emulator_mode
 * DESCRIPTION
 *  get the current agps emulator mode from mtk_agpsd.
 * PARAMETERS
 *  none
 * RETURNS
 *  normal mode (0), emulator mode (1)
 *****************************************************************************/
int get_emulator_mode();

/*****************************************************************************
 * FUNCTION
 *  get_agpsd_version
 * DESCRIPTION
 *  get the current mtk_agpsd version
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_agpsd_version
 *****************************************************************************/
agps_intf_agpsd_version get_agpsd_version();

/*****************************************************************************
 * FUNCTION
 *  get_imsi_from_agpsd
 * DESCRIPTION
 *  get the current imsi stored in the state of mtk_agpsd
 * PARAMETERS
 *  none
 * RETURNS
 *  agps_intf_imsi
 *****************************************************************************/
agps_intf_imsi get_imsi_from_agpsd();

/*****************************************************************************
 * FUNCTION
 *  set_agps_enabled
 * DESCRIPTION
 *  enable/disable AGPS status.
 * PARAMETERS
 *  enabled    [INPUT] 0: SUPL SET Initiated will not be triggered anymore.
 *                     1: SUPL SET Initiated will be triggered if MNLD need help from mtk_agpsd.
 * RETURNS
 *  none
 *****************************************************************************/
void set_agps_enabled(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_protocol
 * DESCRIPTION
 *  change AGPS protocol to CP or UP only for SET Initiated session.
 * PARAMETERS
 *  protocol    [INPUT] AGPS_INTF_AGPS_PROTOCOL_UP: UP (SUPL) SET Initiated will be triggered if MNLD need help from mtk_agpsd.
 *                      AGPS_INTF_AGPS_PROTOCOL_CP: CP MOLR session will be triggered if MNLD need help from mtk_agpsd.
 * RETURNS
 *  none
 *****************************************************************************/
void set_protocol(agps_intf_agps_protocol protocol);

/*****************************************************************************
 * FUNCTION
 *  set_cdma_pref
 * DESCRIPTION
 *  change CDMA preferred setting only for SET Initiated session.
 * PARAMETERS
 *  cdma_preferred    [INPUT] AGPS_INTF_CDMA_PREFERRED_WCDMA: mtk_agpsd prefers to use SUPL under Wi-Fi connection or WCDMA connection, otherwise use AGPS EVDO sesion.
 *                            AGPS_INTF_CDMA_PREFERRED_CDMA: mtk_agpsd prefers to use SUPL under Wi-Fi connection or WCDMA connection, otherwise use AGPS EVDO sesion.
 *                            AGPS_INTF_CDMA_PREFERRED_CDMA_FORCE: mtk_agpsd always choose to use AGPS EVDO session.
 * RETURNS
 *  none
 *****************************************************************************/
void set_cdma_pref(agps_intf_cdma_preferred cdma_preferred);

/*****************************************************************************
 * FUNCTION
 *  set_up_pref_method
 * DESCRIPTION
 *  change UP prefer method only for SET Initiated session.
 * PARAMETERS
 *  pref_method    [INPUT] AGPS_INTF_PREF_METHOD_MSA: set SETCapabilities.prefMethod to agpsSETassistedPreferred in SUPL_START message.
 *                            AGPS_INTF_PREF_METHOD_MSB: set SETCapabilities.prefMethod to agpsSETBasedPreferred in SUPL_START message.
 *                            AGPS_INTF_PREF_METHOD_NO_PREF: set SETCapabilities.prefMethod to noPreference in SUPL_START message.
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_pref_method(agps_intf_pref_method pref_method);

/*****************************************************************************
 * FUNCTION
 *  set_pos_technology_msa
 * DESCRIPTION
 *  enable/disable SETCapabilities.PosTechnology.agpsSETassisted in SUPL messages.
 * PARAMETERS
 *  enabled    [INPUT] 0: SETCapabilities.PosTechnology.agpsSETassisted is disabled.
 *                     1: SETCapabilities.PosTechnology.agpsSETassisted is enabled.
 * RETURNS
 *  none
 *****************************************************************************/
void set_pos_technology_msa(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_pos_technology_msb
 * DESCRIPTION
 *  enable/disable SETCapabilities.PosTechnology.agpsSETBased in SUPL messages.
 * PARAMETERS
 *  enabled    [INPUT] 0: SETCapabilities.PosTechnology.agpsSETBased is disabled.
 *                     1: SETCapabilities.PosTechnology.agpsSETBased is enabled.
 * RETURNS
 *  none
 *****************************************************************************/
void set_pos_technology_msb(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_pos_technology_ecid
 * DESCRIPTION
 *  enable/disable SETCapabilities.PosTechnology.eCID in SUPL messages.
 * PARAMETERS
 *  enabled    [INPUT] 0: SETCapabilities.PosTechnology.eCID is disabled.
 *                     1: SETCapabilities.PosTechnology.eCID is enabled.
 * RETURNS
 *  none
 *****************************************************************************/
void set_pos_technology_ecid(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_pos_technology_otdoa
 * DESCRIPTION
 *  enable/disable SETCapabilities.PosTechnology.oTDOA in SUPL messages.
 * PARAMETERS
 *  enabled    [INPUT] 0: SETCapabilities.PosTechnology.oTDOA is disabled.
 *                     1: SETCapabilities.PosTechnology.oTDOA is enabled.
 * RETURNS
 *  none
 *****************************************************************************/
void set_pos_technology_otdoa(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_supl_version
 * DESCRIPTION
 *  change SUPL version.
 * PARAMETERS
 *  supl_version    [INPUT] AGPS_INTF_SUPL_VERSION_1: change to SUPL1.0.
 *                          AGPS_INTF_SUPL_VERSION_2: change to SUPL2.0.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_version(agps_intf_supl_version supl_version);

/*****************************************************************************
 * FUNCTION
 *  set_tls_version
 * DESCRIPTION
 *  change TLS version.
 * PARAMETERS
 *  tls_version    [INPUT] AGPS_INTF_TLS_VERSION_1_0: change to TLS 1.0.
 *                         AGPS_INTF_TLS_VERSION_1_1: change to TLS 1.1.
 *                         AGPS_INTF_TLS_VERSION_1_2: change to TLS 1.2.
 * RETURNS
 *  none
 *****************************************************************************/
void set_tls_version(agps_intf_tls_version tls_version);

/*****************************************************************************
 * FUNCTION
 *  set_cert_verify
 * DESCRIPTION
 *  enable/disable AGPS certification verificaton procedure.
 * PARAMETERS
 *  enabled    [INPUT] 0: do not check certificate chain sent by server.
 *                     1: check certificate chain sent by server.
 * RETURNS
 *  none
 *****************************************************************************/
void set_cert_verify(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_udp_enable
 * DESCRIPTION
 *  enable mtk_agpsd to bind the port, 7275, for listening SUPL_INIT message from UDP.
 * PARAMETERS
 *  none
 * RETURNS
 *  none
 *****************************************************************************/
void set_udp_enable();

/*****************************************************************************
 * FUNCTION
 *  set_lpp_enable
 * DESCRIPTION
 *  enable/disable SETCapabilities.PosProtocol.Ver2-PosProtocol-extension.lpp in SUPL messages.
 * PARAMETERS
 *  enabled    [INPUT] 0: SETCapabilities.PosProtocol.Ver2-PosProtocol-extension.lpp is disabled.
 *                     1: SETCapabilities.PosProtocol.Ver2-PosProtocol-extension.lpp is enabled.
 * RETURNS
 *  none
 *****************************************************************************/
void set_lpp_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_cert_from_sdcard
 * DESCRIPTION
 *  enable/disable mtk_agpsd to load the extra AGPS certfications from /sdcard/agps/cacerts/,
 *  the certification file format must be PEM or ASN1.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable to load extra AGPS certfications from /sdcard/agps/cacerts/.
 *                     1: enable to load extra AGPS certfications from /sdcard/agps/cacerts/.
 * RETURNS
 *  none
 *****************************************************************************/
void set_cert_from_sdcard(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_supl_profile
 * DESCRIPTION
 *  change SUPL profile.
 * PARAMETERS
 *  addr    [INPUT] Server address, it can be IP address or FQDN.
 *  port    [INPUT] Server Port.
 *  tls_enabled    [INPUT] 0: disable TLS connection with this Server.
 *                         1: enable TLS connection with this Server.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_profile(const char* addr, int port, agps_bool tls_enabled);

/*****************************************************************************
 * FUNCTION
 *  set_qop
 * DESCRIPTION
 *  change SUPL QoP only for SET Initiated session.
 * PARAMETERS
 *  hacc    [INPUT] change QoP.horacc (K value).
 *  vacc    [INPUT] change QoP.veracc (K value).
 *  loc_age    [INPUT] change QoP.maxLocAge, seconds from 0 to 65535.
 *  delay    [INPUT] change QoP.delay, 2^N, N from (0..7), unit is seconds.
 * RETURNS
 *  none
 *****************************************************************************/
void set_qop(int hacc, int vacc, int loc_age, int delay);

/*****************************************************************************
 * FUNCTION
 *  set_molr_pos_methd
 * DESCRIPTION
 *  change AGPS CP position method only for MOLR session.
 * PARAMETERS
 *  molr_pos_method    [INPUT] AGPS_INTF_MOLR_POS_METHOD_LOC_EST: change to LocationEstimate.
 *                             AGPS_INTF_MOLR_POS_METHOD_ASSIST_DATA: change to AssistanceData.
 * RETURNS
 *  none
 *****************************************************************************/
void set_molr_pos_methd(agps_intf_molr_pos_method molr_pos_method);

/*****************************************************************************
 * FUNCTION
 *  set_external_addr
 * DESCRIPTION
 *  enable/disable AGPS CP external address only for MOLR session.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable AGPS CP external address only for MOLR session.
 *                     1: enable AGPS CP external address only for MOLR session.
 * external_addr    [INPUT] external address
 * RETURNS
 *  none
 *****************************************************************************/
void set_external_addr(agps_bool enabled, const char* external_addr);

/*****************************************************************************
 * FUNCTION
 *  set_mlc_number
 * DESCRIPTION
 *  enable/disable AGPS CP MLC number only for MOLR session.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable AGPS CP MLC number only for MOLR session.
 *                     1: enable AGPS CP MLC number only for MOLR session.
 * mlc_number    [INPUT] MLC number
 * RETURNS
 *  none
 *****************************************************************************/
void set_mlc_number(agps_bool enabled, const char* mlc_number);

/*****************************************************************************
 * FUNCTION
 *  set_cp_auto_reset
 * DESCRIPTION
 *  enable/disable CP automatically reset funcationlity.
 *  In some test scenario, there is no GPS_RESET command from NW, then we need to enable this feature.
 *  After enabling this feature, MD AGPS will issue GPS_RESET by itself when AGPS session is finished
 *  to make sure there is a GPS_RESET between each AGPS session
 * PARAMETERS
 *  enabled    [INPUT] 0: disable CP automatically reset funcationlity.
 *                     1: enable CP automatically reset funcationlity.
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_auto_reset(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_allow_ni
 * DESCRIPTION
 *  enable/disable AGPS UP Network Initiated session.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable AGPS UP Network Initiated session.
 *                     1: eable AGPS UP Network Initiated session.
 * RETURNS
 *  none
 *****************************************************************************/
void set_allow_ni(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_allow_roaming
 * DESCRIPTION
 *  enable/disable AGPS UP session when DUT is under roaming.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable AGPS UP session when DUT is under roaming.
 *                     1: enable AGPS UP session when DUT is under roaming.
 * RETURNS
 *  none
 *****************************************************************************/
void set_allow_roaming(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_supl_to_file
 * DESCRIPTION
 *  enable/disable SUPL log to /sdcard/A-GPS.LOG or /data/agps_supl/log/A-GPS.LOG.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SUPL log to /sdcard/A-GPS.LOG or /data/agps_supl/log/A-GPS.LOG.
 *                     1: enable SUPL log to /sdcard/A-GPS.LOG or /data/agps_supl/log/A-GPS.LOG.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_to_file(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_reset_to_default
 * DESCRIPTION
 *  reset all AGPS configurations to the default setting.
 * PARAMETERS
 *  none
 * RETURNS
 *  none
 *****************************************************************************/
void set_reset_to_default();

/*****************************************************************************
 * FUNCTION
 *  set_supl_profile_full
 * DESCRIPTION
 *  change SUPL profile.
 * PARAMETERS
 *  supl_profile    [INPUT] specify SUPL profile in detail.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_profile_full(agps_intf_supl_profile supl_profile);

/*****************************************************************************
 * FUNCTION
 *  set_epc_molr_pdu_enable
 * DESCRIPTION
 *  enable/disable AGPS CP EPC MOLR PDU only for MOLR session in LTE network.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable AGPS CP EPC MOLR PDU only for MOLR session in LTE network.
 *                     1: enable AGPS CP EPC MOLR PDU only for MOLR session in LTE network.
 * RETURNS
 *  none
 *****************************************************************************/
void set_epc_molr_pdu_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_epc_molr_pdu
 * DESCRIPTION
 *  change AGPS CP EPC MOLR PDU only for MOLR session in LTE network.
 * PARAMETERS
 *  data    [INPUT] AGPS CP EPC MOLR PDU.
 *  data_len    [INPUT] length of data.
 * RETURNS
 *  none
 *****************************************************************************/
void set_epc_molr_pdu(const char* data, int data_len);

/*****************************************************************************
 * FUNCTION
 *  set_imsi_enable
 * DESCRIPTION
 *  enable/disable the valid IMSI in SUPL messages.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the valid IMSI in SUPL messages.
 *                     1: enable the valid IMSI in SUPL messages, this follows the OMA spec.
 * RETURNS
 *  none
 *****************************************************************************/
void set_imsi_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_supl_sha_version
 * DESCRIPTION
 *  change the SUPL SHA version.
 * PARAMETERS
 *  enabled    [INPUT] 0: SHA1 for SUPL1.0 and SHA256 for SUPL2.0.
 *                     1: SHA1 for SUPL1.0 and SUPL2.0.
 *                     2: SHA256 for SUPL1.0 and SUPL2.0.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_sha_version(int version);

/*****************************************************************************
 * FUNCTION
 *  set_supl_tls_version
 * DESCRIPTION
 *  change the SUPL TLS version.
 * PARAMETERS
 *  enabled    [INPUT] 0: TLS1.0.
 *                     1: TLS1.1.
 *                     2: TLS1.2.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_tls_version(int version);

/*****************************************************************************
 * FUNCTION
 *  set_supl_ut1
 * DESCRIPTION
 *  change the SUPL UT1 Timer.
 * PARAMETERS
 *  timeout_in_second    [INPUT] 11 (default) ~ 127
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_ut1(int timeout_in_second);

/*****************************************************************************
 * FUNCTION
 *  set_supl_ut2
 * DESCRIPTION
 *  change the SUPL UT2 Timer.
 * PARAMETERS
 *  timeout_in_second    [INPUT] 11 (default) ~ 127
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_ut2(int timeout_in_second);

/*****************************************************************************
 * FUNCTION
 *  set_supl_ut3
 * DESCRIPTION
 *  change the SUPL UT3 Timer.
 * PARAMETERS
 *  timeout_in_second    [INPUT] 10 (default) ~ 127
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_ut3(int timeout_in_second);

/*****************************************************************************
 * FUNCTION
 *  set_supl_ver_minor
 * DESCRIPTION
 *  change the SUPL minor version.
 * PARAMETERS
 *  version    [INPUT] 0 (default) ~ 255
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_ver_minor(int version);

/*****************************************************************************
 * FUNCTION
 *  set_supl_ver_ser_ind
 * DESCRIPTION
 *  change the SUPL servind version.
 * PARAMETERS
 *  version    [INPUT] 0 (default) ~ 255
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_ver_ser_ind(int version);

/*****************************************************************************
 * FUNCTION
 *  set_sib8_16_enable
 * DESCRIPTION
 *  enable/disable SIB8/SIB16.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SIB8/SIB16.
 *                     1: enable SIB8/SIB16. (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_sib8_16_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_glonass_enable
 * DESCRIPTION
 *  enable/disable Glonass.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable Glonass.
 *                     1: enable Glonass. (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_glonass_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_a_glonass_enable
 * DESCRIPTION
 *  enable/disable A-Glonass.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable A-Glonass.
 *                     1: enable A-Glonass. (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_a_glonass_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_beidou_enable
 * DESCRIPTION
 *  enable/disable Beidou.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable Beidou.
 *                     1: enable Beidou. (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_beidou_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_galileo_enable
 * DESCRIPTION
 *  enable/disable Galileo.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable Gelileo.
 *                     1: enable Gelileo. (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_galileo_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_supl_apn_enable
 * DESCRIPTION
 *  enable/disable SUPL APN.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SUPL APN. (default)
 *                     1: enable SUPL APN.
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_apn_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_pde_profile
 * DESCRIPTION
 *  set pde profile.
 * PARAMETERS
 *  addr    [INPUT] Server IP as "11.11.11.11".
 *  port    [INPUT] Server Port.
 * RETURNS
 *  none
 *****************************************************************************/
void set_pde_profile(const char* addr, int port);

/*****************************************************************************
 * FUNCTION
 *  set_reject_non911_nilr_enable
 * DESCRIPTION
 *  set reject NILR if there is no E911 call and GPS setting is OFF.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable to reject NILR if there is no E911 call
 *                        and GPS setting is OFF (default)
 *                     1: enable to reject NILR if there is no E911 call
 *                        and GPS setting is OFF
 * RETURNS
 *  none
 *****************************************************************************/
void set_reject_non911_nilr_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_allow_ni_for_gps_off
 * DESCRIPTION
 *  set allow SUPL NI if GPS setting is OFF
 * PARAMETERS
 *  enabled    [INPUT] 0: disable to SUPL NI if GPS setting is OFF (default)
 *                     1: enable to SUPL NI if GPS setting is OFF
 * RETURNS
 *  none
 *****************************************************************************/
void set_allow_ni_for_gps_off(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_force_otdoa_assist_req
 * DESCRIPTION
 *   set if forcing filling otdoa assist request in SUPL LPP in a SET-assisted
 *   session
 * PARAMETERS
 *   enabled    [INPUT] 0: do not fill otdoa assist request in SUPL LPP in a
 *                         SET-assisted session (default)
 *                      1: fill otdoa assist request in SUPL LPP in a
 *                         SET-assisted session
 * RETURNS
 *  none
 *****************************************************************************/
void set_force_otdoa_assist_req(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_cp_2g_disable
 * DESCRIPTION
 *   set if we need to disable Control Plane AGPS for GSM network
 * PARAMETERS
 *   enabled    [INPUT] 0: do not disable CP AGPS for GSM
 *                      1: disable CP AGPS for GSM
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_2g_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_cp_3g_disable
 * DESCRIPTION
 *   set if we need to disable Control Plane AGPS for WCDMA network
 * PARAMETERS
 *   enabled    [INPUT] 0: do not disable CP AGPS for WCDMA
 *                      1: disable CP AGPS for WCDMA
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_3g_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_cp_4g_disable
 * DESCRIPTION
 *   set if we need to disable Control Plane AGPS for LTE network
 * PARAMETERS
 *   enabled    [INPUT] 0: do not disable CP AGPS for LTE
 *                      1: disable CP AGPS for LTE
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_4g_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_tc10_ignore_fw_config
 * DESCRIPTION
 *   set if we need to ignore configuration from TC10 Location Framework
 * PARAMETERS
 *   enabled    [INPUT] 0: do not ignore configuration from TC10 Location Framework
 *                      1: ignore configuration from TC10 Location Framework
 * RETURNS
 *  none
 *****************************************************************************/
void set_tc10_ignore_fw_config(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_hide_wifi_bt_status
 * DESCRIPTION
 *  decide if lppe needs to hide the wifi/bt icon when users disable the wifi/bt in settings
 *  (This may not work if the platfrom does not support it)
 * PARAMETERS
 *  enabled    [INPUT] 0: disable  lppe to hide icon
 *                     1: enable  lppe to hide icon
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_hide_wifi_bt_status(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_network_location_disable
 * DESCRIPTION
 *  tell lppe if it is not allowed to use the network location
 * PARAMETERS
 *  enabled    [INPUT] 0: allowed to use the network location
 *                     1: not allowed to use the network location
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_network_location_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_e911_open_gps_enable
 * DESCRIPTION
 *  enable/disable opening GPS earlier when E911 call is dialed
 * PARAMETERS
 *  enabled    [INPUT] 0: do not need to open GPS earlier for e911
 *                     1: allowed to open GPS earlier for e911
 * RETURNS
 *  none
 *****************************************************************************/
void set_e911_open_gps_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_cp_enable
 * DESCRIPTION
 *  enable/disable lppe for cp (control plane)
 * PARAMETERS
 *  enabled    [INPUT] 0: disable  lppe for cp
 *                     1: enable  lppe for cp (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_cp_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_up_enable
 * DESCRIPTION
 *  enable/disable lppe for up (user plane)
 * PARAMETERS
 *  enabled    [INPUT] 0: disable  lppe for up
 *                     1: enable  lppe for up (default)
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_up_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_vzw_debug_screen_enable
 * DESCRIPTION
 *   enable/disable showing debug info in LocationEM as per VZW's request
 * PARAMETERS
 *   enabled    [INPUT] 0: disable showing debug info in LocationEM as per
 *                         VZW's request
 *                      1: enable showing debug info in LocationEM as per
 *                         VZW's request
 * RETURNS
 *  none
 *****************************************************************************/
void set_vzw_debug_screen_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_crowd_source_confident
 * DESCRIPTION
 *  specify the value of lppe crowd source confidence
 * PARAMETERS
 *  confident    [INPUT] 0 ~ 99
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_crowd_source_confident(int confident);

/*****************************************************************************
 * FUNCTION
 *  start_supl_2_periodic_session
 * DESCRIPTION
 *  start SUPL2.0 periodic session.
 * PARAMETERS
 *  none
 * RETURNS
 *  none
 *****************************************************************************/
void start_supl_2_periodic_session();

/*****************************************************************************
 * FUNCTION
 *  stop_supl_2_periodic_session
 * DESCRIPTION
 *  stop SUPL2.0 periodic session.
 * PARAMETERS
 *  none
 * RETURNS
 *  none
 *****************************************************************************/
void stop_supl_2_periodic_session();

/*****************************************************************************
 * FUNCTION
 *  start_supl_2_area_event_session
 * DESCRIPTION
 *  start SUPL2.0 area event session.
 * PARAMETERS
 *  type    [INPUT] agps_intf_area_event_type_entering: area event type is entering.
 *                  agps_intf_area_event_type_inside: area event type is inside.
 *                  agps_intf_area_event_type_outside: area event type is outside.
 *                  agps_intf_area_event_type_leaving: area event type is leaving.
 * RETURNS
 *  none
 *****************************************************************************/
void start_supl_2_area_event_session(agps_intf_area_event_type type);

/*****************************************************************************
 * FUNCTION
 *  stop_supl_2_area_event_session
 * DESCRIPTION
 *  stop SUPL2.0 area event session.
 * PARAMETERS
 *  none
 * RETURNS
 *  none
 *****************************************************************************/
void stop_supl_2_area_event_session();

/*****************************************************************************
 * FUNCTION
 *  start_test_case
 * DESCRIPTION
 *  start the test case, just for debugging
 * PARAMETERS
 *  i    [INPUT] 0: All TC Loop 1
 *               1: All TC Loop 2
 *               2: All TC Loop 1000
 *               3: All Common TC
 *               4: All UP TC
 *               5: All UP TC
 *               6: All EVDO TC
 *               7: Partial TC 1
 *               8: pARTIAL TC 2
 * RETURNS
 *  none
 *****************************************************************************/
void start_test_case(int i);

/*****************************************************************************
 * FUNCTION
 *  start_test_button
 * DESCRIPTION
 *  start the test button, just for debugging
 * PARAMETERS
 *  i    [INPUT] 0: agps2mnl_agps_open_gps_req(1);
 *               1: agps2mnl_agps_close_gps_req();
 *               2: agps2mnl_agps_reset_gps_req(0xffff);
 *               3: agps2mnl_ni_notify(2, MNL_AGPS_NOTIFY_TYPE_NOTIFY_ONLY, "hugo_requestor2", "hugo_client")
 *               4: agps2mnl_ni_notify(3, MNL_AGPS_NOTIFY_TYPE_NOTIFY_ALLOW_NO_ANSWER, "hugo_requestor3", "hugo_client");
 *               5: agps2mnl_ni_notify2(123, MNL_AGPS_NOTIFY_TYPE_NOTIFY_ONLY, "4875676F526571756573746F72", "4875676F436C69656E74", MNL_AGPS_NI_ENCODING_TYPE_UTF8, MNL_AGPS_NI_ENCODING_TYPE_UTF8);
 *               6: agps2mnl_ni_notify2(123, MNL_AGPS_NOTIFY_TYPE_NOTIFY_DENY_NO_ANSWER, "FEFF004800750067006F0052006500710075006500730074006F0072", "FEFF004800750067006F0043006C00690065006E0074", MNL_AGPS_NI_ENCODING_TYPE_UCS2, MNL_AGPS_NI_ENCODING_TYPE_UCS2);
 *               7: agps2mnl_data_conn_req(0x12345678, 0)
 *               8: agps2mnl_data_conn_release()
 *               9: cp2_util_send_sim_info_req(get_cp2_ctx()->fds.mdfd1)
 *              10: cp2_util_send_data_connection_state_req(get_cp2_ctx()->fds.mdfd1)
 * RETURNS
 *  none
 *****************************************************************************/
void start_test_button(int i);

/*****************************************************************************
 * FUNCTION
 *  do_reset_agpsd
 * DESCRIPTION
 *  reboot mtk_agpsd, it is only for debugging.
 * PARAMETERS
 *  none
 * RETURNS
 *  none
 *****************************************************************************/
void do_reset_agpsd();

/*****************************************************************************
 * FUNCTION
 *  start_emualator_mode
 * DESCRIPTION
 *  enable/disable mtk_agpsd emualtor mode, it will also cause reboot mtk_agpsd.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable mtk_agpsd emualtor mode, it will also cause reboot mtk_agpsd.
 *                     1: enable mtk_agpsd emualtor mode, it will also cause reboot mtk_agpsd.
 * RETURNS
 *  none
 *****************************************************************************/
void start_emualator_mode(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  dump_agps_intf_supl_profile
 * DESCRIPTION
 *  dump dump_agps_intf_supl_profile, just for debugging
 * PARAMETERS
 *  profile    [INPUT] dump all parameters to log
 * RETURNS
 *  none
 *****************************************************************************/
void dump_agps_intf_supl_profile(agps_intf_supl_profile profile);

/*****************************************************************************
 * FUNCTION
 *  dump_agps_intf_agps_config
 * DESCRIPTION
 *  dump dump_agps_intf_agps_config, just for debugging
 * PARAMETERS
 *  agps_intf_agps_config    [INPUT] dump all parameters to log
 * RETURNS
 *  none
 *****************************************************************************/
void dump_agps_intf_agps_config(agps_intf_agps_config config);

/*****************************************************************************
 * FUNCTION
 *  dump_agps_intf_profiling_info
 * DESCRIPTION
 *  dump dump_agps_intf_profiling_info, just for debugging
 * PARAMETERS
 *  profiling    [INPUT] dump all parameters to log
 * RETURNS
 *  none
 *****************************************************************************/
void dump_agps_intf_profiling_info(agps_intf_profiling_info profiling);

/*****************************************************************************
 * FUNCTION
 *  set_pos_technology_autonomous
 * DESCRIPTION
 *  enable/disable the Autonomous capability
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the autonomous capability
 *                     1: enable the autonomous capability
 * RETURNS
 *  none
 *****************************************************************************/
void set_pos_technology_autonomous(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_pos_technology_aflt
 * DESCRIPTION
 *  enable/disable the AFLT capability
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the AFLT capability
 *                     1: enable the AFLT capability
 * RETURNS
 *  none
 *****************************************************************************/
void set_pos_technology_aflt(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_preferred_2g3g_cell_age
 * DESCRIPTION
 *   set the max age of preferred cell
 *   RAT of cell info: (older, preferred) 2G, 3G, 4G, 5G (newer, not preferred)
 * PARAMETERS
 *  age    [INPUT] 0 ~ 1800 in seconds
 *                 0: do not use preferred cell info. Use the latest cell info
 * RETURNS
 *  none

 *****************************************************************************/
void set_preferred_2g3g_cell_age(int age);

/*****************************************************************************
 * FUNCTION
 *  set_no_sensitive_log
 * DESCRIPTION
 *  remove/allow agps daemon's log with sensitive info (e.g., the current location)
 * PARAMETERS
 *  enabled    [INPUT] 0: allow agps daemon's to log with sensitive info (e.g., the current location)
 *                     1: Agps not to log sensitive logs.
 * RETURNS
 *  none
 *****************************************************************************/
void set_no_sensitive_log(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_tls_reuse_enable
 * DESCRIPTION
 *   enable/disable TLS reuse
 * PARAMETERS
 *   enabled    [INPUT] 0: disable TLS reuse (default)
 *                      1: ensable TLS reuse
 * RETURNS
 *  none
 *****************************************************************************/
void set_tls_reuse_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_imsi_cache_enable
 * DESCRIPTION
 *   enable/disable cached IMSI
 * PARAMETERS
 *   enabled    [INPUT] 0: disable cached IMSI (default)
 *                         do not update IMSI for each SUPL session
 *                      1: enable cached IMSI
 *                         update IMSI for each SUPL session
 * RETURNS
 *  none
 *****************************************************************************/
void set_imsi_cache_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_supl_raw_data_enable
 * DESCRIPTION
 *   enable/disable SUPL raw data log in main log
 * PARAMETERS
 *   enabled    [INPUT] 0: disable SUPL raw data log in main log
 *                      1: enable SUPL raw data log in main log
 * RETURNS
 *  none
 *****************************************************************************/
void set_supl_raw_data_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_tc10_enable
 * DESCRIPTION
 *   enable/disable TC10 mode
 * PARAMETERS
 *   enabled    [INPUT] 0: disable TC10 mode
 *                      1: enable TC10 mode
 * RETURNS
 *  none
 *****************************************************************************/
void set_tc10_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_auto_profile_enable
 * DESCRIPTION
 *  enable/disable the auto profile configuration based on current mcc or mcc_mnc specified in cur_supl_profile or supl_profile
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the auto profile configuration feature
 *                     1: enable the auto profile configuration feature
 * RETURNS
 *  none
 *****************************************************************************/
void set_auto_profile_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_sync_to_slp_enable
 * DESCRIPTION
 *  sync the AGPS setting (ex: SUPL profile, SUPL version, TLS version) from AGPSD to SLPD in runtime
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the AGPS settings sync to SPLD function
 *                     1: enable the AGPS settings sync to SPLD function
 * RETURNS
 *  none
 *****************************************************************************/
void set_sync_to_slp_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_e911_gps_icon_enable
 * DESCRIPTION
 *  enable/disable showing GPS icon during E911 location
 * PARAMETERS
 *  enabled    [INPUT] 0: disable showing the GPS icon
 *                     1: enable showing the GPS icon
 * RETURNS
 *  none
 *****************************************************************************/
void set_e911_gps_icon_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_aosp_profile_enable
 * DESCRIPTION
 *  enable/disable the supl profile configuration from GnssLocationProvider via native_set_agps_server
 *  auto_profile_enable will be ignored when aosp_profile_enable is true because AOSP Location Framework
 *  can load SUPL_HOST and SUPL_PORT from framework resource for different MCC/MNC
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the supl profile configuration from AOSP framework
 *                     1: enable the supl profile configuration from AOSP framework
 * RETURNS
 *  none
 *****************************************************************************/
void set_aosp_profile_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_bind_nlp_setting_to_supl
 * DESCRIPTION
 *  enable/disable to bind nlp setting to SUPL SI flow.
 *  If it is enabled, the SUPL SI is enabled only if network location setting is enabled by user.
 *  If it is disabled, agps_enable will be used and it's same as previous design.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the SUPL SI by network location settings, check agps_enable option
 *                     1: enable the SUPL SI by network location settings
 * RETURNS
 *  none
 *****************************************************************************/
void set_bind_nlp_setting_to_supl(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_esupl_apn_mode
 * DESCRIPTION
 *   select the APN mode for E-SUPL
 * PARAMETERS
 *   time    [INPUT] 0: use Emergency / IMS APN if they are available as GSMA
 *                      IR92 (default)
 *                   1: use Emergency APN if it is available
 *                   2: use IMS APN if it is available
 *                   3: do not use Emergency / IMS APN (just as a normal supl)
 * RETURNS
 *  none
 *****************************************************************************/
void set_esupl_apn_mode(int mode);

/*****************************************************************************
 * FUNCTION
 *  set_lbs_log_enable
 * DESCRIPTION
 *  enable/disable tc10 lbs log to the debugging port
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the tc10 lbs log to the debugging port
 *                     1: enable the tc10 lbs log to the debugging port
 * RETURNS
 *  none
 *****************************************************************************/
void set_lbs_log_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_a_beidou_enable
 * DESCRIPTION
 *  enable/disable the Beidou aiding if hardware can support A-Beidou
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the A-Beidou function
 *                     1: enable the A-Beidou function
 * RETURNS
 *  none
 *****************************************************************************/
void set_a_beidou_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_a_galileo_enable
 * DESCRIPTION
 *  enable/disable the Galileo aiding if hardware can support A-Galileo
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the A-Galileo function
 *                     1: enable the A-Galileo function
 * RETURNS
 *  none
 *****************************************************************************/
void set_a_galileo_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_tcp_keep_alive
 * DESCRIPTION
 *  enable/disable TCP Keepalive functionality for SUPL
 * PARAMETERS
 *  time    [INPUT] 0: disable the TCP keepalive function
 *                     >0: enable to send TCP keepalive packetets and interval value is tcp_keepalive in second
 * RETURNS
 *  none
 *****************************************************************************/
void set_tcp_keep_alive(int time);

/*****************************************************************************
 * FUNCTION
 *   set_agps_nvram_enable
 * DESCRIPTION
 *   set if we can save configuration of suppl profile and GNSS capabilities
 *   into NVRAM for VZW requirement
 * PARAMETERS
 *   enabled  [INPUT] 0: do not save the configuration into NVRAM
 *                    1: save the configuration into NVRAM
 * RETURNS
 *  none
 *****************************************************************************/
void set_agps_nvram_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_udp_enable_v2
 * DESCRIPTION
 *  enable/disable the UDP 7275 port by default, if you enable it, you may cause
 *  Android Compatible Test Suit failure for checking netstat.
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the UDP 7275 port
 *                     1: enable the UDP 7275 port
 * RETURNS
 *  none
 *****************************************************************************/
void set_udp_enable_v2(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  get_agps_supl_profiles
 * DESCRIPTION
 *  get_agps_supl_profiles from xml parser
 * PARAMETERS
 *  none
 * RETURNS
 *  Agps config data structure with supl_profiles data member.
 *****************************************************************************/
agps_intf_agps_config get_agps_supl_profiles();

/*****************************************************************************
 * FUNCTION
 *  set_ingore_si_for_e911
 * DESCRIPTION
 *  enable/disable to ignore MOLR / SI for Emergency Call
 * PARAMETERS
 *  enabled    [INPUT] 0: disable to ignore
 *                     1: enable to ignore MOLR /SI for emergency call
 * RETURNS
 *  none
 *****************************************************************************/
void set_ingore_si_for_e911(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_cp_wlan_enable
 * DESCRIPTION
 *  enable/disable for LPPe CP wlan function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe cp wlan function
 *                     1: enable the LPPe cp wlan function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_cp_wlan_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_cp_srn_enable
 * DESCRIPTION
 *  enable/disable for LPPe CP srn function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe cp srn function
 *                     1: enable the LPPe cp srn function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_cp_srn_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_cp_sensor_enable
 * DESCRIPTION
 *  enable/disable the LPPe CP sensor function
 * PARAMETERS
 *  enabled    [INPUT] 0: disalbe the LPPe CP sensor function
 *                     1: enable the LPPe CP sensor function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_cp_sensor_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_cp_dbh_enable
 * DESCRIPTION
 *  enable/disable the LPPe CP DBH function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe CP DBH function
 *                     1: enable the LPPe CP DBH function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_cp_dbh_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_up_wlan_enable
 * DESCRIPTION
 *  enable/disable the LPPe UP wlan function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe UP wlan function
 *                     1: enable the LPPe UP wlan function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_up_wlan_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_up_srn_enable
 * DESCRIPTION
 *  enable/disable the LPPe UP srn function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe UP srn function
 *                     1: enable the LPPe UP srn function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_up_srn_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_up_sensor_enable
 * DESCRIPTION
 *  enable/disable the LPPe UP sensor function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe UP sensor function
 *                     1: enable the LPPe UP sensor function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_up_sensor_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_lppe_up_dbh_enable
 * DESCRIPTION
 *  enable/disable the LPPe UP DBH function
 * PARAMETERS
 *  enabled    [INPUT] 0: disable the LPPe UP DBH function
 *                     1: enable the LPPe UP DBH function
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_up_dbh_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_ip_version_prefer
 * DESCRIPTION
 *  select the preferred mode for IP version when connnecting to the SUPL server
 * PARAMETERS
 *  ip_version_type    [INPUT] AGPS_INTF_SUPL_IP_VERSION_IPV6 ,
 *                             AGPS_INTF_SUPL_IP_VERSION_IPV4
 * RETURNS
 *  none
 *****************************************************************************/
void set_ip_version_prefer(agps_supl_ip_version_type ip_version_type);

/*****************************************************************************
 * FUNCTION
 *  set_up_lpp_in_2g3g_disable
 * DESCRIPTION
 * decide if we need to turn off lpp in 2G / 3G network
 * US ATT SUPL server may not provide assistance data if we have the lpp capability in 2G / 3G network
 * PARAMETERS
 *  enabled    [INPUT] 0: Not to turn off the LPP in 2G /3G network
 *                     1: Trun off the LPP in 2G /3G network
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_lpp_in_2g3g_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_up_rrlp_in_4g_disable
 * DESCRIPTION
 * Decide if we need to turn off RRLP in 4G network when we have SUPL 2.0 and LPP
 * US ATT SUPL server may not provide assistance data if we have the rrlp capability in 4G network
 * PARAMETERS
 *  enabled    [INPUT] 0: Not to turn off the RRLP in 4G network
 *                     1: Turn off RRLP in 4G network
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_rrlp_in_4g_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *  set_up_si_disable
 * DESCRIPTION
 * Decide if we need to reject SUPL SI request
 * Sprint_2019Feb_GTR-LBS-00219 asks us not to trigger SUPL SI.
 * Sprint_2019Feb_GTR-LBS-00222 asks us to support NI including normal and emergency
 * Sprint_2019Feb_GTR-LBS-00223 asks us to use Sprint SLP in our configuration
 * If we turn off agps_enable, we will allow Emergency NI only (reject SI and normal NI)
 * If we turn on up_si_disable, we will allow both normal NI and Emergency NI (reject SI only)
 * So this option is more suitable for Sprint requirements.
 * PARAMETERS
 *  enabled    [INPUT] 0: Not to disable UP SI functions
 *                     1: Disable UP SI functions
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_si_disable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_up_use_ni_slp
 * DESCRIPTION
 *   Decide if we can use the SLP Address or E-SPL Address in SUPL INIT
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use the SLP Address or E-SPL Address in SUPL INIT
 *                      1: Allow using the SLP Address or E-SPL Address in SUPL INIT
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_use_ni_slp(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_use_tc10_config
 * DESCRIPTION
 *   Decide if we can use TC10's secgps configuration file
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use TC10's secgps configuration file
 *                      1: Allow using TC10's secgps configuration file
 * RETURNS
 *  none
 *****************************************************************************/
void set_use_tc10_config(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_lppe_def_nlp_enable
 * DESCRIPTION
 *   Decide if we can provide a default NLP measurement for LPPe
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to provide a default NLP measurement for LPPe
 *                      1: Allow providing a default NLP measurement for LPPe
 * RETURNS
 *  none
 *****************************************************************************/
void set_lppe_def_nlp_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_up_aosp_pos_mode_enable
 * DESCRIPTION
 *   Decide if we can use the position mode from Location Framework to decide
 *   the Pref Method in SET capabilities in SUPL START , SUPL POS INIT, SUPL
 *   TRIGGERED START
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use the position mode from Location Framework
 *                         We will use the pref_method in agps configuration
 *                      1: Allow using the position mode from Location Framework
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_aosp_pos_mode_enable(agps_bool enabled);

/*****************************************************************************
 * FUNCTION
 *   set_privacy_override_mode
 * DESCRIPTION
 *   From Android 10, GVC(Gnss Visibility Control) defines some rules to
 *   show location status or to disable sending location info to the network.
 *   We provide this option to allow OEM / ODM to break rules of GVC.
 *   For older Android or non-Android, this option will be ignored.
 * PARAMETERS
 *   i    [INPUT] 0 = AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_DEFAULT:
 *                      No privacy will be overridden
 *                1 = AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_HIDING_ICON:
 *                      Allow hiding the location icon for the privacy
 *                      override SUPL INIT
 *                      We need this to pass SUPL-2.0-con-023 when GVC
 *                      allows non-framework locationing
 *                2 = AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_LOCATIONING:
 *                      Allow locationing for the privacy override SUPL INIT
 *                      even if GVC does not allow non-framework locationing
 *                4 = AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_ESUPL:
 *                      Allow locationing for the emergency SUPL INIT without
 *                      emergency call even if GVC does not allow non-framework
 *                      locationing
 *                      (Known operators may need this:  1. Claro Colomiba   2. LG U+)
 *                      (Please discuss this with Google before getting GMS License)
 *                8 = AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_ALL:
 *                      Ignore GVC for SUPL (AGPS OTA test uses normal supl.
 *                      And AOSP power manager may turn off GPS when screen off)
 *               16 = AGPS_INTF_UP_PRIVACY_OVERRIDE_MODE_ALLOW_TC10:
 *                      Ignore GVC and GPS / AGPS settings to accept the
 *                      network-initiated session
 *               [*] You can also mix them with bitwise-OR
 * RETURNS
 *  none
 *****************************************************************************/
void set_privacy_override_mode(int i);

/*****************************************************************************
 * FUNCTION
 *   set_emergency_ext_secs
 * DESCRIPTION
 *   Set the extension time in seconds to accept network-initiated AGPS session
 *   after an emergency call
 * PARAMETERS
 *   i    [INPUT] 0 (default) ~ 300
 * RETURNS
 *  none
 *****************************************************************************/
void set_emergency_ext_secs(int i);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_supl_ssl_method
 * DESCRIPTION
 *   Set the SUPL SSL Method for TC10
 * PARAMETERS
 *   m    [INPUT] 0 = AGPS_INTF_TC10_SUPL_SSL_METHOD_NEGOTIATION (default)
 *                1 = AGPS_INTF_TC10_SUPL_SSL_METHOD_SSLV3
 *                2 = AGPS_INTF_TC10_SUPL_SSL_METHOD_SSLV23
 *                3 = AGPS_INTF_TC10_SUPL_SSL_METHOD_TLSV1
 *                4 = AGPS_INTF_TC10_SUPL_SSL_METHOD_TLSV1_1
 *                5 = AGPS_INTF_TC10_SUPL_SSL_METHOD_TLSV1_2
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_tc10_supl_ssl_method(int m);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_auto_supl_ver_for_ni
 * DESCRIPTION
 *   Decide if we can fill same SUPL version as the SUPL version in the SUPL
 *   INIT from the SUPL server
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use the SUPL version in the SUPL INIT.
 *                      1: Allow using the SUPL version in the SUPL INIT
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_tc10_auto_supl_ver_for_ni(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_supl_ver_skt_ni
 * DESCRIPTION
 *   Decide if we can fill SUPL 2.0.1 in NI sessions for SK Telecom requirement
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use.
 *                      1: Allow using SUPL 2.0.1 in network-initiated sessions
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_tc10_supl_ver_skt_ni(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_use_apn_si
 * DESCRIPTION
 *   Decide if we can call APIs provided by TC10 to request APN for both of
 *   SUPL SI and NI sessions
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use TC10 APIs.
 *                      1: Allow using TC10 APIs to request APN.
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_tc10_use_apn_si(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_use_apn_ni
 * DESCRIPTION
 *   Decide if we can call APIs provided by TC10 to request APN for SUPL
 *   NI sessions even if up_tc10_use_apn_si = 0
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use TC10 APIs.
 *                      1: Allow using TC10 APIs to request APN for
 *                         network-initiated sessions
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_tc10_use_apn_ni(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_use_apn_ni
 * DESCRIPTION
 *   From Android 10, GVC(Gnss Visibility Control) allows users to reject
 *   network-initiated sessions if it is not in an emergency call.
 *
 *   For TC10, GVC can reject network-initiated sessions even for control plane
 *
 *   Decide if we can ignore GVC for control plane
 *
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to ignore GVC in TC10 projects
 *                      1: Allow ignoring GVC for CP NILR in TC10 projects
 *                         (debug purpose)
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_tc10_privacy_override(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_supl_addr_ni
 * DESCRIPTION
 *   Set the SLP address for network-initiated sessions
 * PARAMETERS
 *   addr    [INPUT] Server address for NI, it can be IP address or FQDN.
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_supl_addr_ni(const char* addr);

/*****************************************************************************
 * FUNCTION
 *   set_up_rrlp_google_supl
 * DESCRIPTION
 *   Decide if we can force using RRLP in SET-Initiated sessions when using
 *   Google SLP
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to force using RRLP in SET-Initiated sessions
 *                         when using Google SLP
 *                      1: Force using RRLP in SET-Initiated sessions when
 *                         using Google SLP
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_rrlp_google_supl(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_supl2_cap_ext_disable
 * DESCRIPTION
 *   Decide if we can fill ver2_SETCapabilities_extension in ULP_SETCapabilities
 *   Google SLP
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to fill the info
 *                      1: Allow filling the info
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_supl2_cap_ext_disable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_ni_statistic_enable
 * DESCRIPTION
 *   Decide if we can collect statistics of network-initiated sessions.
 *
 *   We can read/clean the info in MTK LocationEM when do mass testing
 *   with tools like auto-dialer (e.g, North America Field Trial)
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to fill the info
 *                      1: Allow filling the info
 * RETURNS
 *  none
 *****************************************************************************/
void set_ni_statistic_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_operation_mode
 * DESCRIPTION
 *   Set the SUPL SSL Method for TC10
 * PARAMETERS
 *   m    [INPUT] 0: common for most standards (default)
 *                1: for DoCoMo requirements (disable capabilities not
 *                   supported by DoCoMo SLP)
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_operation_mode(int m);

/*****************************************************************************
 * FUNCTION
 *  set_up_glonass_msa_enable
 * DESCRIPTION
 *  enable/disable SET-Assisted capability of GLONASS
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SET-Assisted capability of GLONASS
 *                     1: enable SET-Assisted capability of GLONASS
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_glonass_msa_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *  set_up_glonass_msb_enable
 * DESCRIPTION
 *  enable/disable SET-Based capability of GLONASS
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SET-Based capability of GLONASS
 *                     1: enable SET-Based capability of GLONASS
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_glonass_msb_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *  set_up_glonass_msa_enable
 * DESCRIPTION
 *  enable/disable SET-Assisted capability of Beidou
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SET-Assisted capability of Beidou
 *                     1: enable SET-Assisted capability of Beidou
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_beidou_msa_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *  set_up_glonass_msb_enable
 * DESCRIPTION
 *  enable/disable SET-Based capability of Beidou
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SET-Based capability of Beidou
 *                     1: enable SET-Based capability of Beidou
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_beidou_msb_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *  set_up_glonass_msa_enable
 * DESCRIPTION
 *  enable/disable SET-Assisted capability of Galileo
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SET-Assisted capability of Galileo
 *                     1: enable SET-Assisted capability of Galileo
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_galileo_msa_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *  set_up_glonass_msb_enable
 * DESCRIPTION
 *  enable/disable SET-Based capability of Galileo
 * PARAMETERS
 *  enabled    [INPUT] 0: disable SET-Based capability of Galileo
 *                     1: enable SET-Based capability of Galileo
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_galileo_msb_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_auto_supl_ver_for_eni
 * DESCRIPTION
 *   Decide if we can fill same SUPL version as the SUPL version in the SUPL
 *   INIT with the Emergency Flag from the SUPL server
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use the SUPL version in the SUPL INIT.
 *                      1: Allow using the SUPL version in the SUPL INIT
 * RETURNS
 *  none
 *****************************************************************************/
void set_up_tc10_auto_supl_ver_for_eni(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *  set_cp_tc10_lpp_guard_time_sec
 * DESCRIPTION
 *  Set the LPP guard time.
 *  After providing assistance data, location server will specify a response
 *  time N for UE to provide location estimate or satellite measurement.
 *  TMO-US asks UE using (N - t) to be the actual response time for control
 *  plane sessions where t is called LPP Guard Time.
 *  By default, MTK modem will decide t automatically by checking IMSI and
 *  the serving cell.
 *  TC10 may change this value.
 * PARAMETERS
 *  t    [INPUT] -1 (default): auto configured by MTK modem
 *               0 ~ 127
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_tc10_lpp_guard_time_sec(int t);

/*****************************************************************************
 * FUNCTION
 *   set_cp_tc10_capability_control_enable
 * DESCRIPTION
 *   Decide if we can use CP capability control flags for TC10
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to use it
 *                      1: Allow using it
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_tc10_capability_control_enable(agps_bool enable);

/*****************************************************************************
 * FUNCTION
 *   set_up_tc10_supl_ssl_method
 * DESCRIPTION
 *   Set the SUPL SSL Method for TC10
 * PARAMETERS
 *   flags [INPUT] 1 = AGPS_INTF_TC10_CP_CAPABILITY_AGNSS
 *                 2 = AGPS_INTF_TC10_CP_CAPABILITY_OTDOA
 *                 4 = AGPS_INTF_TC10_CP_CAPABILITY_ECID
 *                 8 = AGPS_INTF_TC10_CP_CAPABILITY_CONVENTIONAL_GPS
 *                16 = N/A
 *                32 = AGPS_INTF_TC10_CP_CAPABILITY_INTER_FREQ_OTDOA
 * RETURNS
 *  none
 *****************************************************************************/
void set_cp_tc10_capability_control(int flags);

/*****************************************************************************
 * FUNCTION
 *   set_ignore_emergency_ext_secs_from_framework
 * DESCRIPTION
 *   Decide if we can ignore the change of emergency_ext_secs from Android
 *   GNSS HIDL.
 *   Several customer prefers to specify the value of emergency_ext_secs
 *   in MTK's agps_profiles_conf2.xml
 * PARAMETERS
 *   enabled    [INPUT] 0: Not to ignore the change of emergency_ext_secs from
 *                         Android (default)
 *                      1: Ignore the change of emergency_ext_secs from Android
 * RETURNS
 *  none
 *****************************************************************************/
void set_ignore_emergency_ext_secs_from_framework(agps_bool does_ignore);


#ifdef __cplusplus
}
#endif

#endif
