#ifndef __MNLDINF_BASIC_INTERFACE_H__
#define __MNLDINF_BASIC_INTERFACE_H__

#include "mnldinf_common.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MNLDINF_BASIC_TCP  "mnldinf_basic"

typedef struct {
    void (*mnldinf_connection_broken)();
    void (*mnldinf_location)(gps_location location);
    void (*mnldinf_gnss_status)(gps_status status);
    void (*mnldinf_gnss_sv)(gnss_sv_info sv);
    void (*mnldinf_nmea)(int64_t timestamp, const char* nmea, int length);
    void (*mnldinf_nmea_done)(void);
    void (*mnldinf_gnss_measurements)(gnss_data *data);

    void (*mnldinf_capability_update)(mnldinf_basic_server_cap *cap);
} mnldinf_basic;

int mnldinf_basic_gnss_init(int fd);
int mnldinf_basic_gnss_start(int fd);
int mnldinf_basic_gnss_stop(int fd);
int mnldinf_basic_gnss_cleanup(int fd);

int mnldinf_basic_gnss_measurement_enable(int fd, bool enable);

// -1 means failure
int mnldinf_basic_cmd_hdlr(int fd, mnldinf_basic* hdlr);

int mnldinf_basic_register(char *client_name);

void mnldinf_basic_capability_config(int fd, mnldinf_basic_client_cap *cap);

#ifdef __cplusplus
}
#endif

#endif

