#include "mtk_gnss_at_command.h"
#include "mtk_gnss_at_client.h"
#include "mtk_gnss_at_log.h"

bool mtk_at_send_gnss_start_request(int fd) {
    char buff[128] = {0};
    mtk_at_gen_gnss_start_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_stop_request(int fd) {
    char buff[128] = {0};
    mtk_at_gen_gnss_stop_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_host_reset_notify(int fd) {
    char buff[128] = {0};
    mtk_at_gen_gnss_host_reset_notify(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_status_request(int fd) {
    char buff[128] = {0};
    mtk_at_gen_gnss_status_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_enable_set(int fd, bool enabled) {
    char buff[128] = {0};
    mtk_at_gen_gnss_enable_set(buff, sizeof(buff), enabled);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_ni_enable_set(int fd, bool enabled) {
    char buff[128] = {0};
    mtk_at_gen_gnss_ni_enable_set(buff, sizeof(buff), enabled);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_agps_mode_set(int fd, mtk_gnss_agps_mode* mode) {
    char buff[128] = {0};
    mtk_at_gen_gnss_agps_mode_set(buff, sizeof(buff), mode);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_supl_version_set(int fd, int maj, int min, int ser_ind) {
    char buff[128] = {0};
    mtk_at_gen_gnss_supl_version_set(buff, sizeof(buff), maj, min, ser_ind);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_supl_addr_set(int fd, const char* addr, int port, bool tls_enabled) {
    char buff[512] = {0};
    mtk_at_gen_gnss_supl_addr_set(buff, sizeof(buff), addr, port, tls_enabled);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_delete_aiding_data_request(int fd, mtk_gnss_aiding_data* flags) {
    char buff[128] = {0};
    mtk_at_gen_gnss_delete_aiding_data_request(buff, sizeof(buff), flags);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_ni_notify_response(int fd, int id, mtk_gnss_ni_response_type response) {
    char buff[128] = {0};
    mtk_at_gen_gnss_ni_notify_response(buff, sizeof(buff), id, response);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_ref_location_response(int fd, int age, double lat, double lng, float acc) {
    char buff[128] = {0};
    mtk_at_gen_gnss_ref_location_response(buff, sizeof(buff), age, lat, lng, acc);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_ref_time_response(int fd, long long time, int uncertainty) {
    char buff[128] = {0};
    mtk_at_gen_gnss_ref_time_response(buff, sizeof(buff), time, uncertainty);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_nmea_config_set(int fd, bool enabled) {
    char buff[128] = {0};
    mtk_at_gen_gnss_nmea_config_set(buff, sizeof(buff), enabled);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_ttff_qop_set(int fd, int mode) {
    char buff[128] = {0};
    mtk_at_gen_gnss_ttff_qop_set(buff, sizeof(buff), mode);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_loopback_request(int fd, const char* msg) {
    char buff[5000] = {0};
    mtk_at_gen_gnss_loopback_request(buff, sizeof(buff), msg);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_cert_set(int fd, mtk_gnss_cert* cert) {
    char buff[2000] = {0};
    mtk_at_gen_gnss_cert_set(buff, sizeof(buff), cert);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_cert_name_request(int fd) {
    char buff[128] = {0};
    mtk_at_gen_gnss_cert_name_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_cert_delete_request(int fd, const char* name) {
    char buff[128] = {0};
    mtk_at_gen_gnss_cert_delete_request(buff, sizeof(buff), name);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_gnss_cert_delete_all_request(int fd) {
    char buff[128] = {0};
    mtk_at_gen_gnss_cert_delete_all_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_geo_max_num_request(int fd) {
    char buff[64] = {0};
    mtk_at_gen_geo_max_num_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_geo_add_circle_request(int fd, mtk_geo_add_circle* circle) {
    char buff[128] = {0};
    mtk_at_gen_geo_add_circle_request(buff, sizeof(buff), circle);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_geo_delete_request(int fd, int id) {
    char buff[64] = {0};
    mtk_at_gen_geo_delete_request(buff, sizeof(buff), id);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_geo_delete_all_request(int fd) {
    char buff[64] = {0};
    mtk_at_gen_geo_delete_all_request(buff, sizeof(buff));
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

bool mtk_at_send_test_request(int fd, int num1, int num2, double d1, double d2, const char* str1, const char* str2) {
    char buff[3000] = {0};
    mtk_at_gen_test_request(buff, sizeof(buff), num1, num2, d1, d2, str1, str2);
    int ret = write(fd, buff, strlen(buff));
    if(ret == -1) {
        LOGE("write() failed, reason=[%s]%d", strerror(errno), errno);
        return false;
    }
    return true;
}

static bool mtk_at_is_ok_parser(const char* at_cmd) {
    char ok[] = "\r\nOK\r\n";
    if(strcmp(at_cmd, ok) == 0) {
        return true;
    } else {
        return false;
    }
}

static bool mtk_at_is_error_parser(const char* at_cmd) {
    char error[] = "\r\nERROR\r\n";
    if(strcmp(at_cmd, error) == 0) {
        return true;
    } else {
        return false;
    }
}

static bool mtk_at_ok_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    if(callbacks->_mtk_at_result) {
        callbacks->_mtk_at_result(fd, true, at_cmd);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_error_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    if(callbacks->_mtk_at_result) {
        callbacks->_mtk_at_result(fd, false, at_cmd);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_nmea_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    char nmea[512] = {0};
    if(!mtk_at_parse_string(&at_cmd, nmea, sizeof(nmea))) {
        LOGE("MTK_GNSS_AT_NMEA failed 1");
        return false;
    }

    if(callbacks->_mtk_at_gnss_nmea_notify) {
        callbacks->_mtk_at_gnss_nmea_notify(fd, nmea);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_nmea_end_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    if(callbacks->_mtk_at_gnss_nmea_end_notify) {
        callbacks->_mtk_at_gnss_nmea_end_notify(fd);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_satellite_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_gnss_satellite_list list;
    memset(&list, 0, sizeof(list));

    if(!mtk_at_parse_int32(&at_cmd, &list.num)) {
        LOGE("MTK_GNSS_AT_SATELLITE failed 1");
        return false;
    }
    if(list.num > 64) {
        LOGE("MTK_GNSS_AT_SATELLITE failed 2, num=%d > 64", list.num);
        return false;
    }

    bool decode_ok = true;
    int i = 0;
    for(i = 0; i < list.num; i++) {
        if(!mtk_at_parse_int32(&at_cmd, &list.satellites[i].svid)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 3 i=%d", i);
            decode_ok = false;
            return false;
        }
        if(!mtk_at_parse_int32(&at_cmd, &list.satellites[i].constellation)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 4 i=%d", i);
            decode_ok = false;
            return false;
        }
        if(!mtk_at_parse_float(&at_cmd, &list.satellites[i].cn0)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 5 i=%d", i);
            decode_ok = false;
            return false;
        }
        if(!mtk_at_parse_float(&at_cmd, &list.satellites[i].elevation)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 6 i=%d", i);
            decode_ok = false;
            return false;
        }
        if(!mtk_at_parse_float(&at_cmd, &list.satellites[i].azimuth)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 7 i=%d", i);
            decode_ok = false;
            return false;
        }
        if(!mtk_at_parse_int32(&at_cmd, &list.satellites[i].flags)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 8 i=%d", i);
            decode_ok = false;
            return false;
        }
        if(!mtk_at_parse_float(&at_cmd, &list.satellites[i].carrier_frequency)) {
            LOGE("MTK_GNSS_AT_SATELLITE failed 9 i=%d", i);
            decode_ok = false;
            return false;
        }
    }

    if(decode_ok) {
        if(callbacks->_mtk_at_gnss_satellite_notify) {
            callbacks->_mtk_at_gnss_satellite_notify(fd, &list);
            return true;
        } else {
            LOGE("callbacks is NULL");
        }
    }
    return false;
}

static bool mtk_at_gnss_location_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_gnss_location location;
    memset(&location, 0, sizeof(location));
    location.lat_valid = mtk_at_parse_double(&at_cmd, &location.lat);
    location.lng_valid = mtk_at_parse_double(&at_cmd, &location.lng);
    location.alt_valid = mtk_at_parse_float(&at_cmd, &location.alt);
    location.speed_valid = mtk_at_parse_float(&at_cmd, &location.speed);
    location.bearing_valid = mtk_at_parse_float(&at_cmd, &location.bearing);
    location.h_acc_valid = mtk_at_parse_float(&at_cmd, &location.h_acc);
    location.v_acc_valid = mtk_at_parse_float(&at_cmd, &location.v_acc);
    location.s_acc_valid = mtk_at_parse_float(&at_cmd, &location.s_acc);
    location.b_acc_valid = mtk_at_parse_float(&at_cmd, &location.b_acc);
    location.timestamp_valid = mtk_at_parse_int64(&at_cmd, &location.timestamp);
    location.date_time_valid = mtk_at_parse_string(&at_cmd, location.date_time, sizeof(location.date_time));
    location.pdop_valid = mtk_at_parse_float(&at_cmd, &location.pdop);
    location.hdop_valid = mtk_at_parse_float(&at_cmd, &location.hdop);
    location.vdop_valid = mtk_at_parse_float(&at_cmd, &location.vdop);

    if(callbacks->_mtk_at_gnss_location_notify) {
        callbacks->_mtk_at_gnss_location_notify(fd, &location);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;

}

static bool mtk_at_gnss_agnss_location_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_agnss_location location;
    memset(&location, 0, sizeof(location));
    mtk_at_parse_double(&at_cmd, &location.lat);
    mtk_at_parse_double(&at_cmd, &location.lng);
    location.alt_valid = mtk_at_parse_float(&at_cmd, &location.alt);
    location.speed_valid = mtk_at_parse_float(&at_cmd, &location.speed);
    location.bearing_valid = mtk_at_parse_float(&at_cmd, &location.bearing);
    location.h_acc_valid = mtk_at_parse_float(&at_cmd, &location.h_acc);
    location.timestamp_valid = mtk_at_parse_int64(&at_cmd, &location.timestamp);
    location.date_time_valid = mtk_at_parse_string(&at_cmd, location.date_time, sizeof(location.date_time));
    location.type_valid = mtk_at_parse_int32(&at_cmd, &location.type);
    
    if(callbacks->_mtk_at_gnss_agnss_location_notify) {
        callbacks->_mtk_at_gnss_agnss_location_notify(fd, &location);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_reset_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    char reason[1024] = {0};
    mtk_at_parse_string(&at_cmd, reason, sizeof(reason));
    if(callbacks->_mtk_at_gnss_device_reset_notify) {
        callbacks->_mtk_at_gnss_device_reset_notify(fd, reason);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_status_response_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_gnss_status status;
    memset(&status, 0, sizeof(status));
    mtk_at_parse_bool(&at_cmd, &status.gnss_status);
    mtk_at_parse_bool(&at_cmd, &status.ni_status);
    mtk_at_parse_int32(&at_cmd, &status.supl_maj_ver);
    mtk_at_parse_int32(&at_cmd, &status.supl_min_ver);
    mtk_at_parse_string(&at_cmd, status.gnss_version, sizeof(status.gnss_version));
    mtk_at_parse_string(&at_cmd, status.agps_version, sizeof(status.agps_version));
    mtk_at_parse_int32(&at_cmd, &status.supl_ser_ind);
    mtk_at_parse_string(&at_cmd, status.supl_addr, sizeof(status.supl_addr));
    mtk_at_parse_int32(&at_cmd, &status.supl_port);
    mtk_at_parse_bool(&at_cmd, &status.supl_tls_enabled);
    status.imsi_valid = mtk_at_parse_string(&at_cmd, status.imsi, sizeof(status.imsi));
    status.num_digital_mnc_in_imsi_valid = mtk_at_parse_int32(&at_cmd, &status.num_digital_mnc_in_imsi);

    if(callbacks->_mtk_at_gnss_status_response) {
        callbacks->_mtk_at_gnss_status_response(fd, &status);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_ni_notify_request_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_gnss_ni_notify notify;
    memset(&notify, 0, sizeof(notify));
    mtk_at_parse_int32(&at_cmd, &notify.id);
    mtk_at_parse_int32(&at_cmd, &notify.type);
    mtk_at_parse_int32(&at_cmd, &notify.notify_type);
    mtk_at_parse_string(&at_cmd, notify.request_id, sizeof(notify.request_id));
    mtk_at_parse_int32(&at_cmd, &notify.request_id_encode_type);
    mtk_at_parse_string(&at_cmd, notify.text, sizeof(notify.text));
    mtk_at_parse_int32(&at_cmd, &notify.text_encode_type);

    if(callbacks->_mtk_at_gnss_ni_notify_request) {
        callbacks->_mtk_at_gnss_ni_notify_request(fd, &notify);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_ref_loc_request_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    if(callbacks->_mtk_at_gnss_ref_location_request) {
        callbacks->_mtk_at_gnss_ref_location_request(fd);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_ref_time_request_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    if(callbacks->_mtk_at_gnss_ref_time_request) {
        callbacks->_mtk_at_gnss_ref_time_request(fd);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_loopback_response_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    char buff[5000] = {0};
    mtk_at_parse_string(&at_cmd, buff, sizeof(buff));

    if(callbacks->_mtk_at_gnss_loopback_response) {
        callbacks->_mtk_at_gnss_loopback_response(fd, buff);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_gnss_cert_name_response_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_gnss_cert_name_list list;
    memset(&list, 0, sizeof(list));

    bool ret = mtk_at_parse_string(&at_cmd, list.names[0], sizeof(list.names[0]));
    while(ret) {
        list.num++;
        ret = mtk_at_parse_string(&at_cmd, list.names[list.num], sizeof(list.names[0]));
    }

    if(callbacks->_mtk_at_gnss_cert_name_response) {
        callbacks->_mtk_at_gnss_cert_name_response(fd, &list);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_geo_max_num_response_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    int num = 0;
    mtk_at_parse_int32(&at_cmd, &num);
    if(callbacks->_mtk_at_geo_max_num_response) {
        callbacks->_mtk_at_geo_max_num_response(fd, num);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_geo_add_circle_response_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_geo_fence_create_state state = MTK_GEO_FENCE_CREATE_STATE_ERROR;
    int id = -1;
    mtk_at_parse_int32(&at_cmd, &state);
    mtk_at_parse_int32(&at_cmd, &id);
    if(callbacks->_mtk_at_geo_add_circle_response) {
        callbacks->_mtk_at_geo_add_circle_response(fd, state, id);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_geo_alert_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_geo_alert_notify notify;
    memset(&notify, 0, sizeof(notify));
    mtk_at_parse_int32(&at_cmd, &notify.id);
    mtk_at_parse_int32(&at_cmd, &notify.state);
    mtk_at_parse_double(&at_cmd, &notify.lat);
    mtk_at_parse_double(&at_cmd, &notify.lng);
    mtk_at_parse_double(&at_cmd, &notify.alt);
    mtk_at_parse_double(&at_cmd, &notify.speed);
    mtk_at_parse_double(&at_cmd, &notify.heading);
    mtk_at_parse_int32(&at_cmd, &notify.hacc);
    mtk_at_parse_int32(&at_cmd, &notify.h_err_maj);
    mtk_at_parse_int32(&at_cmd, &notify.h_err_min);
    mtk_at_parse_int32(&at_cmd, &notify.h_err_angle);
    mtk_at_parse_int32(&at_cmd, &notify.h_confidence);
    mtk_at_parse_float(&at_cmd, &notify.pdop);
    mtk_at_parse_float(&at_cmd, &notify.hdop);
    mtk_at_parse_float(&at_cmd, &notify.vdop);
    if(callbacks->_mtk_at_geo_alert_notify) {
        callbacks->_mtk_at_geo_alert_notify(fd, &notify);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

static bool mtk_at_geo_track_notify_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    mtk_geo_track_state state = MTK_GEO_TRACK_STATE_FAILURE;
    char date_time[128] = {0};
    mtk_at_parse_int32(&at_cmd, &state);
    mtk_at_parse_string(&at_cmd, date_time, sizeof(date_time));
    if(callbacks->_mtk_at_geo_track_notify) {
        callbacks->_mtk_at_geo_track_notify(fd, state, date_time);
        return true;
    } else {
        LOGE("callbacks is NULL");
    }
    return false;
}

bool mtk_at_client_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks) {
    assert(at_cmd != NULL);
    assert(callbacks != NULL);
    const char* at_cmd_bkup = at_cmd;

    //LOGD("mtk_at_client_parser() fd=[%d] at_cmd=[%s]", fd, at_cmd);

    bool ret = true;
    if(mtk_at_is_ok_parser(at_cmd)) {
        ret = mtk_at_ok_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_is_error_parser(at_cmd)) {
        ret = mtk_at_error_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_NMEA_NTF)) {
        ret = mtk_at_gnss_nmea_notify_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_NMEA_END_NTF)) {
        ret = mtk_at_gnss_nmea_end_notify_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_SATELLITE_NTF)) {
        ret = mtk_at_gnss_satellite_notify_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_LOCATION_NTF)) {
        ret = mtk_at_gnss_location_notify_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_AGPS_LOCATION_NTF)) {
        ret = mtk_at_gnss_agnss_location_notify_parser(fd, at_cmd, callbacks);
    } else if(mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_GNSS_RESET_NTF)) {
        ret = mtk_at_gnss_reset_notify_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_STATUS_RSP)) {
        ret = mtk_at_gnss_status_response_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_NI_NOTIFY_REQ)) {
        ret = mtk_at_gnss_ni_notify_request_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_REF_LOC_REQ)) {
        ret = mtk_at_gnss_ref_loc_request_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_REF_TIME_REQ)) {
        ret = mtk_at_gnss_ref_time_request_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_LOOPBACK_RSP)) {
        ret = mtk_at_gnss_loopback_response_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GNSS_CERT_NAME_RSP)) {
        ret = mtk_at_gnss_cert_name_response_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GEOFENCE_MAX_NUM_RSP)) {
        ret = mtk_at_geo_max_num_response_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GEOFENCE_ADD_CIRCLE_RSP)) {
        ret = mtk_at_geo_add_circle_response_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GEOFENCE_ALERT_NTF)) {
        ret = mtk_at_geo_alert_notify_parser(fd, at_cmd, callbacks);
    } else if (mtk_at_parse_cmd(&at_cmd, MTK_AT_GEOFENCE_TRACK_NTF)) {
        ret = mtk_at_geo_track_notify_parser(fd, at_cmd, callbacks);
    } else {
        LOGW("unhandled at_cmd=[%s]", at_cmd_bkup);
        return false;
    }

    if(!ret) {
        LOGW("wrong at_cmd=[%s]", at_cmd_bkup);
    }

    return ret;
}

