#ifndef __MTK_GNSS_AT_CLIENT_H__
#define __MTK_GNSS_AT_CLIENT_H__

#include "mtk_gnss_at_struct.h"

#ifdef __cplusplus
extern "C" {
#endif

//GNSS
bool mtk_at_send_gnss_start_request(int fd);
bool mtk_at_send_gnss_stop_request(int fd);
bool mtk_at_send_gnss_host_reset_notify(int fd);
bool mtk_at_send_gnss_status_request(int fd);
bool mtk_at_send_gnss_enable_set(int fd, bool enabled);
bool mtk_at_send_gnss_ni_enable_set(int fd, bool enabled);
bool mtk_at_send_gnss_agps_mode_set(int fd, mtk_gnss_agps_mode* mode);
bool mtk_at_send_gnss_supl_version_set(int fd, int maj, int min, int ser_ind);
bool mtk_at_send_gnss_supl_addr_set(int fd, const char* addr, int port, bool tls_enabled);
bool mtk_at_send_gnss_delete_aiding_data_request(int fd, mtk_gnss_aiding_data* flags);
bool mtk_at_send_gnss_ni_notify_response(int fd, int id, mtk_gnss_ni_response_type response);
bool mtk_at_send_gnss_ref_location_response(int fd, int age, double lat, double lng, float acc);
bool mtk_at_send_gnss_ref_time_response(int fd, long long time, int uncertainty);
bool mtk_at_send_gnss_nmea_config_set(int fd, bool enabled);
bool mtk_at_send_gnss_ttff_qop_set(int fd, int mode);
bool mtk_at_send_gnss_loopback_request(int fd, const char* msg);
bool mtk_at_send_gnss_cert_set(int fd, mtk_gnss_cert* cert);
bool mtk_at_send_gnss_cert_name_request(int fd);
bool mtk_at_send_gnss_cert_delete_request(int fd, const char* name);
bool mtk_at_send_gnss_cert_delete_all_request(int fd);
//Geofence
bool mtk_at_send_geo_max_num_request(int fd);
bool mtk_at_send_geo_add_circle_request(int fd, mtk_geo_add_circle* circle);
bool mtk_at_send_geo_delete_request(int fd, int id);
bool mtk_at_send_geo_delete_all_request(int fd);
//Test
bool mtk_at_send_test_request(int fd, int num1, int num2, double d1, double d2, const char* str1, const char* str2);


typedef struct {
    void (*_mtk_at_result) (int fd, bool is_ok, const char* msg);
    void (*_mtk_at_gnss_nmea_notify) (int fd, const char* nmea);
    void (*_mtk_at_gnss_nmea_end_notify) (int fd);
    void (*_mtk_at_gnss_satellite_notify) (int fd, mtk_gnss_satellite_list* list);
    void (*_mtk_at_gnss_location_notify) (int fd, mtk_gnss_location* location);
    void (*_mtk_at_gnss_agnss_location_notify) (int fd, mtk_agnss_location* location);
    void (*_mtk_at_gnss_device_reset_notify) (int fd, const char* reason);
    void (*_mtk_at_gnss_status_response) (int fd, mtk_gnss_status* status);
    void (*_mtk_at_gnss_ni_notify_request) (int fd, mtk_gnss_ni_notify* notify);
    void (*_mtk_at_gnss_ref_location_request) (int fd);
    void (*_mtk_at_gnss_ref_time_request) (int fd);
    void (*_mtk_at_gnss_loopback_response) (int fd, const char* msg);
    void (*_mtk_at_gnss_cert_name_response) (int fd, mtk_gnss_cert_name_list* list);
    void (*_mtk_at_geo_max_num_response) (int fd, int num);
    void (*_mtk_at_geo_add_circle_response) (int fd, mtk_geo_fence_create_state state, int id);
    void (*_mtk_at_geo_alert_notify) (int fd, mtk_geo_alert_notify* notify);
    void (*_mtk_at_geo_track_notify) (int fd, mtk_geo_track_state state, const char* date_time);
} mtk_gnss_at_client_callbacks;

/**
 fd: will be forwarded to callbacks directly
 at_cmd: single AT command with \r\n at the end of at command
 callbacks: your handlers
 */
bool mtk_at_client_parser(int fd, const char* at_cmd, mtk_gnss_at_client_callbacks* callbacks);

#ifdef __cplusplus
}
#endif

#endif

