#ifndef __MTK_GNSS_AT_COMMAND_H__
#define __MTK_GNSS_AT_COMMAND_H__

#ifdef __cplusplus
extern "C" {
#endif

/*
MTK GNSS AT Command
ensure that you have at least 3456 bytes of buffer size for sending and receiving one AT command

[Users]
1. GNSS Adaptor
2. LBS EM
3. Host GNSS auto test tool

[Documents]
LBS Customer Release Notes

[Version History]
001: first version
002: add MTK_AT_GNSS_AGPS_LOCATION_NTF
*/
#define MTK_AT_GNSS_VERSION = "002"


/*
AT+ELCSSTART=\r\n

[Description]
turn on GNSS engine and start reporting NMEA, Location and satellite in 1 Hz.
please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.

[Return]
\r\nOK\r\n or \r\nERROR\r\n
if GNSS is already started and the host sends AT+ELCSSTART again, the device will return OK to the host.
 */
#define MTK_AT_GNSS_START_REQ           "AT+ELCSSTART"


/*
AT+ELCSSTOP=\r\n

[Description]
turn off GNSS engine and stop reporting NMEA, Location and satellite in 1 Hz.
please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.

[Return]
\r\nOK\r\n or \r\nERROR\r\n
if GNSS is already stopped and the host sends AT+ELCSSTOP again, the device will return OK to the host.
*/
#define MTK_AT_GNSS_STOP_REQ            "AT+ELCSSTOP"


/*
\r\n+ELCSNMEA: <nmea_string>\r\n

[Description]
this is an unsolicited response and report in 1 Hz while GNSS is on.
report NMEA is default enabled. If you want to disable it, please use AT+ELCSCFGNMEA to disable it before starting GNSS.
please be noted that calling read() API once can only get one +ELCSNMEA AT command, you need to call multiple read() to get all NMEA per second.

[Parameters]
<nmea_string> (string)
  one NMEA sentence

[Example]
\r\n+ELCSNMEA: "$GNGGA,000344.011,2503.4068,N,12134.4490,E,0,0,,134.8,M,15.2,M,,*54"\r\n
\r\n+ELCSNMEA: "$GPGSA,A,1,,,,,,,,,,,,,99.99,99.99,99.99*30"\r\n
\r\n+ELCSNMEA: "$GLGSA,A,1,,,,,,,,,,,,,99.99,99.99,99.99*2C"\r\n
\r\n+ELCSNMEA: "$GPGSV,1,1,0*49"\r\n
\r\n+ELCSNMEA: "$GLGSV,1,1,0*55"\r\n
\r\n+ELCSNMEA: "$GNRMC,000344.011,V,2503.4068,N,12134.4490,E,0.000,0.00,010110,,,N*58"\r\n
\r\n+ELCSNMEA: "$GNVTG,0.00,T,,M,0.000,N,0.000,K,N*2C"\r\n
\r\n+ELCSNMEAEND\r\n
*/
#define MTK_AT_GNSS_NMEA_NTF            "\r\n+ELCSNMEA"


/*
\r\n+ELCSNMEAEND\r\n

[Description]
to indicate the end of last NMEA sentence

[Parameters]
none

[Example]
\r\n+ELCSNMEA: "$GNGGA,000344.011,2503.4068,N,12134.4490,E,0,0,,134.8,M,15.2,M,,*54"\r\n
\r\n+ELCSNMEA: "$GPGSA,A,1,,,,,,,,,,,,,99.99,99.99,99.99*30"\r\n
\r\n+ELCSNMEA: "$GLGSA,A,1,,,,,,,,,,,,,99.99,99.99,99.99*2C"\r\n
\r\n+ELCSNMEA: "$GPGSV,1,1,0*49"\r\n
\r\n+ELCSNMEA: "$GLGSV,1,1,0*55"\r\n
\r\n+ELCSNMEA: "$GNRMC,000344.011,V,2503.4068,N,12134.4490,E,0.000,0.00,010110,,,N*58"\r\n
\r\n+ELCSNMEA: "$GNVTG,0.00,T,,M,0.000,N,0.000,K,N*2C"\r\n
\r\n+ELCSNMEAEND\r\n
*/
#define MTK_AT_GNSS_NMEA_END_NTF        "\r\n+ELCSNMEAEND"

/*
\r\n+ELCSSAT: <num>,[<svid>,<constellation>,<cn0>,<elevation>,<azimuth>,<flags>,<carrier_frequency>(repeat num times)]\r\n

[Description]
this is an unsolicited response and report in 1 Hz while GNSS is on.
please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.

[Parameters]
<num> (int)
  Number of satellite in this AT command (1~64)
<svid> (int)
<constellation> (int)
  GPS=1
  SBAS=2
  GLONASS=3
  QZSS=4
  BEIDOU=5
  Galileo=6
  IRNSS=7
<cn0> (float by using %.2f)
  0~60
<elevation> (float by using %.2f)
  0~90
<azimuth> (float by using %.2f)
  0~360
<flags> (int)
  indicate the extra info of this satellite
  None=0x00
  Has_ephemeris=0x01
  Has_almance=0x02
  Used_in_fix=0x04
<carrier_frequency> (float by using %.2f)
  Carrier frequency of the signal tracked in MHz. GPS central frequency for L1 = 1575.45 MHz or L5 = 1176.45 MHz.

[Example]
\r\n+ELCSSAT: 2,1,1,40.00,10.00,20.00,7,1575.45,2,3,50.00,20.00,30.00,1,1176.45\r\n
  num=2
  svid=1, constellation=GPS=1, cn0=40.00, elevation=10.00, azimuth=20.00, flag=has_ephemeris + has_almance + user_in_fix=7, carrier_requency=1575.45
  svid=2, constellation=GLONASS=3, cn0=50.00, elevation=20.00, azimuth=30.00, flag=has_ephemeris=1, carrier_requency=1176.45
*/
#define MTK_AT_GNSS_SATELLITE_NTF       "\r\n+ELCSSAT"


/*
\r\n+ELCSLOC: <lat>,<lng>,<alt>,<speed>,<bearing>,<h_acc>,<v_acc>,<s_acc>,<b_acc>,<timestamp>,<date_time>,<pdop>,<hdop>,<vdop>\r\n

[Description]
this is an unsolicited response and report in 1 Hz while GNSS is on and the location is calculated by GNSS.
Please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.

[Parameters]
<lat> (double by using %.6f)
  in degrees, WGS84 coordinate system.
<lng> (double by using %.6f)
  In degrees, WGS84 coordinate system.
<alt> (could be empty, float by using %.2f)
  in meters with respect to sea level.
<speed> (could be empty, float by using %.2f)
  meters per second.
<bearing> (could be empty, float by using %.2f)
  in degrees.
<h_acc> (could be empty, float by using %.2f)
  Represents expected horizontal position accuracy, radial, in meters (68% confidence).
<v_acc> (could be empty, float by using %.2f)
  Represents expected vertical position accuracy in meters (68% confidence).
<s_acc> (could be empty, float by using %.2f)
  Represents expected speed accuracy in meter per seconds (68% confidence).
<b_acc> (could be empty, float by using %.2f)
  Represents expected bearing accuracy in degrees (68% confidence).
<timestamp> (int64_t)
  Milliseconds since January 1, 1970.
<date_time> (string)
  convert timestamp to human readable format. ex: 2019/11/13,10:17:10, max. to 31 characters
<pdop> (could be empty, float by using %.2f)
  Satellite-based positions with a dilution of precision (DOP) value of 0 or a DOP value higher than 10 may be filtered by the GNSS adapter.
<hdop> (could be empty, float by using %.2f)
  Horizontal dilution of precision (HDOP)
<vdop> (could be empty, float by using %.2f)
  Vertical dilution of precision (VDOP).

[Example]
\r\n+ELCSLOC: -77.508333,164.754167,10.00,20.00,30.00,40.00,50.00,60.00,70.00,0,"1970/1/1,00:00:00",1.00,2.00,3.00\r\n
  Latitude=-77.508333, Longitude=164.754167
  alt=10.00
  bear=20.00
  speed=30.00
  h_acc=40.00
  v_acc=50.00
  s_acc=60.00
  b_acc=70.00
  timestamp=0
  timestamp="1970/1/1,00:00:00"
  pdop=1.00
  hdop=2.00
  vdop=3.00

\r\n+ELCSLOC: -77.508333,164.754167,,,,,,,,1000,"1970/1/1,00:00:01",,,\r\n
  Latitude=-77.508333, Longitude=164.754167
  alt=unknown
  bear=unknown
  h_acc=unknown
  v_acc=unknown
  s_acc=unknown
  b_acc=unknown
  timestamp=1000
  timestamp="1970/1/1,00:00:01"
  pdop=unknown
  hdop=unknown
  vdop=unknown
*/
#define MTK_AT_GNSS_LOCATION_NTF        "\r\n+ELCSLOC"


/*
\r\n+ELCSAGPSLOC: <lat>,<lng>,<alt>,<speed>,<bearing>,<h_acc>,<timestamp>,<date_time>,<type>\r\n

[Description]
this is an unsolicited response for non-GNSS location (ex: AFLT, SUPL Reference Location, ...etc.) while GNSS session is ongoing.
Please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.

[Parameters]
<lat> (double by using %.6f)
  in degrees, WGS84 coordinate system.
<lng> (double by using %.6f)
  In degrees, WGS84 coordinate system.
<alt> (could be empty, float by using %.2f)
  in meters above the WGS 84 ellipsoid
<speed> (could be empty, float by using %.2f)
  meters per second.
<bearing> (could be empty, float by using %.2f)
  in degrees.
<h_acc> (could be empty, float by using %.2f)
  Represents expected horizontal position accuracy, radial, in meters (68% confidence).
<timestamp> (could be empty, int64_t)
  Milliseconds since January 1, 1970.
<date_time> (could be empty, string)
  convert timestamp to human readable format. ex: 2019/11/13,10:17:10, max. to 31 characters
<type> (int)
  AFLT=0
  CDMA_CELL=1
  CP_MOLR=2
  SUPL_END=3
  SUPL_REFERENCE_LOCATION=4
  CP_REFERENCE_LOCATION=5

[Example]
\r\n+ELCSAGPSLOC: 77.508333,164.754167,10.00,20.00,30.00,40.00,31536000000,"1971/01/01,00:00:00",4\r\n
  Latitude=-77.508333, Longitude=164.754167
  alt=10.00
  bear=20.00
  speed=30.00
  h_acc=40.00
  timestamp=31536000000
  timestamp="1971/1/1,00:00:00"
  type=SUPL_REFERENCE_LOCATION=4
*/
#define MTK_AT_GNSS_AGPS_LOCATION_NTF   "\r\n+ELCSAGPSLOC"


/*
\r\n+ELCSREFLOCREQ\r\n

[Description]
this is an unsolicited response if GNSS lacks the reference location and issue this AT command to the host when GPS is starting,
and if there is no 3D fix for more than 300 sec, the AT command will be issued again.
if the host cannot get the valid reference location, the host can simply ignore this message and no need to reply anything.
*/
#define MTK_AT_GNSS_REF_LOC_REQ         "\r\n+ELCSREFLOCREQ"


/*
AT+ELCSREFLOCRSP=<age>,<lat>,<lng>,<acc>\r\n

[Description]
to reply +ELCSREFLOCREQ.
the host updates the reference location to GNSS to improve GNSS performance in some circumstance.
only use this AT command when GNSS is started or this command will be ignored by GNSS.

[Parameters]
<age> (int)
  Indicates how long the position has been aged in seconds
<lat> (double by using %.6f)
  latitude in degrees, WGS84 coordinate system.
<lng> (double by using %.6f)
  longitude in degrees, WGS84 coordinate system.
<acc> (float by using %.2f)
  Represents expected horizontal position accuracy, radial, in meters (68% confidence).

[Return]
\r\nOK\r\n or \r\nERROR\r\n

[Example]
AT+ELCSREFLOCRSP=60,-77.508333,164.754167,30.00\r\n
  age=60 s
  Latitude=-77.508333, Longitude=164.754167
  acc=30.00 m
*/
#define MTK_AT_GNSS_REF_LOC_RSP         "AT+ELCSREFLOCRSP"


/*
\r\n+ELCSREFTIMEREQ\r\n

[Description]
this is an unsolicited response if GNSS lacks the reference time and only issue this AT command to the host once when GPS is starting.
if the host cannot get the valid reference time, the host can simply ignore this message and no need to reply anything.
*/
#define MTK_AT_GNSS_REF_TIME_REQ        "\r\n+ELCSREFTIMEREQ"


/*
AT+ELCSREFTIMERSP=<time>,<uncertainty>\r\n

[Description]
to reply +ELCSREFTIMEREQ.
the host updates the reference time to GNSS to improve GNSS performance in some circumstance.
only use this AT command when GNSS is started or this command will be ignored by GNSS.

[Parameters]
<time> (int64_t)
  Milliseconds since January 1, 1970.
<uncertainty> (int)
  Uncertainty in milliseconds.

[Return]
\r\nOK\r\n or \r\nERROR\r\n

[Example]
AT+ELCSREFTIMERSP=0,1000\r\n
  time=1970/1/1,00:00:00=0
  uncertainty=1000 ms
*/
#define MTK_AT_GNSS_REF_TIME_RSP        "AT+ELCSREFTIMERSP"


/*
AT+ELCSHOSTRST\r\n

[Description]
to notify the device that host has been reboot, GNSS will close all ongoing sessions and enter the idle mode at the device side.

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_HOST_RESET_NTF      "AT+ELCSHOSTRST"


/*
\r\n+ELCSGNSSRST: <reason_msg>\r\n

[Description]
this is an unsolicited response while GNSS has been reboot due to some problems happens (ex: software assert).
to notify the host that GNSS has been reboot and need the host to restart the session if GNSS related sessions are ongoing.

[Parameters]
<reason_msg> (string)
  the reason of sending this AT command

[Example]
\r\n+ELCSGNSSRST: "GNSS adaptor reboot done"\r\n
  scenario 1: GNSS adaptor starts at the boot up time, its a normal case.
  scenario 2: GNSS adaptor is crash and re-started done, its an error case.

\r\n+ELCSGNSSRST: "MNLD exception happen and reconnection done"\r\n
  scenario 1: MNLD is crash and GNSS adaptor re-connect to MNLD done, its an error case.
*/
#define MTK_AT_GNSS_GNSS_RESET_NTF      "\r\n+ELCSGNSSRST"


/*
AT+ELCSSTATUS?\r\n

[Description]
ask GNSS capability.

[Return]
\r\n+ELCSSTATUS...\r\n
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_STATUS_REQ          "AT+ELCSSTATUS?"


/*
\r\n+ELCSSTATUS: <gnss_status>,<ni_status>,<supl_maj_ver>,<supl_min_ver>,<gnss_version>,<agps_version>,<supl_ser_ind>,<supl_addr>,<supl_port>,<supl_tls_enabled>,<imsi>,<num_digital_mnc_in_imsi>\r\n

[Description]
reply AT+ELCSSTATUS to provide GNSS capability.
please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.

[Parameters]
<gnss_status> (int)
  0=disabled
  1=enabled
<ni_status> (int)
  0=disabled
  1=enabled
<supl_maj_ver> (int)
  SUPL major version
<supl_min_ver> (int)
  SUPL minor version
<gnss_version> (string)
  the version of MNLD + libmnl.so, max. to 255 characters.
<agps_version> (string)
  the version of AGPSD, max. to 127 characters.
<supl_ser_ind> (int)
  SUPL service indicator version
<supl_addr> (string)
  can be FQDN (ex: supl.xxxx.com) or IPv4 address (ex: 111.222.1.2) or IPv6 address, max. to 127 characters.
<supl_port> (int)
  SUPL server port (ex: 7275)
<supl_tls_enabled> (int)
  0=SUPL TLS enabled
  1=SUPL TLS disabled
<imsi> (could be empty, string)
  provide the IMSI if available.
  the max string size is 32.
<num_digital_mnc_in_imsi> (could be empty, int)
  provide the number of digital for MNC in IMSI if available.

[Example]
\r\n+ELCSSTATUS: 1,0,2,0,"MTK_MNLD_5_0_0_19080901,MNL_VER_19112002ALPS05_6.00_99","3.255",0,"supl.xxx.com",7275,1,"3100121234567890",3\r\n
  gnss_status=ON
  ni_status=OFF
  SUPL 2.0
  mnld_version="MTK_MNLD_5_0_0_19080901,MNL_VER_19112002ALPS05_6.00_99"
  agps_version="3.255"
  supl_ser_ind=0
  supl_addr="supl.xxx.com"
  supl_port=7275
  supl_tle_enabled=1
  imsi="3100121234567890"
  num_digital_mnc_in_imsi=3
  
\r\n+ELCSSTATUS: 1,0,2,0,"MTK_MNLD_5_0_0_19080901,MNL_VER_19112002ALPS05_6.00_99","3.255",0,"supl.xxx.com",7275,1,,\r\n
  gnss_status=ON
  ni_status=OFF
  SUPL 2.0
  mnld_version="MTK_MNLD_5_0_0_19080901,MNL_VER_19112002ALPS05_6.00_99"
  agps_version="3.255"
  supl_ser_ind=0
  supl_addr="supl.xxx.com"
  supl_port=7275
  supl_tle_enabled=1
  imsi=not available
  num_digital_mnc_in_imsi=not available
*/
#define MTK_AT_GNSS_STATUS_RSP          "\r\n+ELCSSTATUS"


/*
AT+ELCSGNSSENABLE=<enabled>\r\n

[Description]
to set GNSS status.
the changed value is persistent even reboot the device.

[Parameters]
<enabled> (int)
  0=disabled
  1=enabled

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_GNSS_ENABLE_SET     "AT+ELCSGNSSENABLE"


/*
AT+ELCSNIENABLE=<enabled>\r\n

[Description]
to set NI allowed configuration.
the changed value is persistent even reboot the device.

[Parameters]
<enabled> (int)
  0=disabled
  1=enabled

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_NI_ENABLE_SET       "AT+ELCSNIENABLE"


/*
AT+ELCSAGPSMODE=[<msa>],[<msb>],[<mss>],[<cid>],[<aflt>],[<otdoa>],[<supl_pref_method>],[<supl>],[<epo>]\r\n

[Description]
to set AGNSS operation mode.
the changed value is persistent even reboot the device.

[Parameters]
<msa> (int)
  0=disabled
  1=enabled
<msb> (int)
  0=disabled
  1=enabled
<mss> (int)
  0=disabled
  1=enabled
<cid> (int)
  0=disabled
  1=enabled
<aflt> (int)
  0=disabled
  1=enabled
<otdoa> (int)
  0=disabled
  1=enabled
<supl_pref_method> (int)
  0=SET Assisted Preferred
  1=SET Based Preferred
  2=no Preference
<supl> (int)
  0=disable SUPL including SET initiated and Network Initiated
  1=enable SUPL including SET initiated and Network Initiated
<epo> (int)
  0=disable EPO and QEPO including download procedure and used by GPS algo. for next GNSS session
  1=enable EPO and QEPO including download procedure and used by GPS algo. for next GNSS session

[Return]
\r\nOK\r\n or \r\nERROR\r\n

[Example]
AT+ELCSAGPSMODE=1,1,1,0,0,0,2
set MSA, MSB, MSS to enabled
set CID, AFLT, OTDOA to disabled
set supl_pref_method to "no Preference"

AT+ELCSAGPSMODE=,,,,,,1
set supl_pref_method to SET Based Preferred
others are not changed
*/
#define MTK_AT_GNSS_AGPS_MODE_SET       "AT+ELCSAGPSMODE"


/*
AT+ELCSSUPLVER=<maj_ver>,<min_ver>,<ser_ind>\r\n

[Description]
to set SUPL version.
the changed value is persistent even reboot the device.

[Parameters]
<maj_ver> (int)
  SUPL major version
<min_ver> (int)
  SUPL minor version
<ser_ind> (int)
  SUPL service indicator version

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_SUPL_VERSION_SET    "AT+ELCSSUPLVER"


/*
AT+ELCSSUPLADDR=<addr>,<port>,<tls_enable>\r\n

[Description]
to set SUPL SLP address.
the changed value is persistent even reboot the device.

[Parameters]
<addr> (string)
  can be FQDN (ex: supl.xxxx.com) or IPv4 address (ex: 111.222.1.2) or IPv6 address, max. to 127 characters.
<port> (int)
  SUPL server port (ex: 7275)
<tls_enable> (int)
  0=disabled
  1=enabled

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_SUPL_ADDRESS_SET    "AT+ELCSSUPLADDR"


/*
AT+ELCSDELAIDING=[<eph>,<alm>,<pos>,<time>,<iono>,<utc>,<svdir>,<rti>,<celldb>]\r\n

[Description]
to delete GNSS aiding data.
please be noted this AT command could add more arguments in the future, please make sure your AT command parser can support it.
if no parameter (ex: AT+ELCSDELAIDING=\r\n), it means to delete all aiding data.

[Parameters]
<eph> (int)
  0=don't delete ephemeris
  1=delete ephemeris
<alm> (int)
  0=don' delete almanac
  1=delete almanac
<pos> (int)
  0=don't delete position
  1=delete position
<time> (int)
  0=don't delete time
  1=delete time
<iono> (int)
  0=don't delete iono
  1=delete iono
<utc> (int)
  0=don't delete UTC
  1=delete UTC
<svdir> (int)
  0=don't delete SVDIR
  1=delete SVDIR
<rti> (int)
  0=don't delete RTI
  1=delete RTI
<celldb> (int)
  0=don't delete cell database info
  1=delete cell database info

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_DELETE_AIDING_REQ   "AT+ELCSDELAIDING"


/*
AT+ELCSNMEACFG=<enable>\r\n

[Description]
to configure NMEA related settings.
the NMEA report is default enabled.

[Parameters]
<enable> (int)
  0: disable reporting NMEA strings via +ELCSNMEA while GPS is ON
  1: enable reporting NMEA strings via +ELCSNMEA while GPS is ON

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_NMEA_CFG_SET        "AT+ELCSNMEACFG"


/*
AT+ELCSTTFFQOP=<mode>\r\n

[Description]
to configure the Quality of Position (QoP) for first fix location.
The position accuracy (1-sigma) will be around 3000m/200m/50m (mode=0/1/2) at open sky environment.
the changed value is persistent even reboot the device.

[Parameters]
<mode> (int)
  0: quick response time, low Accuracy
  1: medium response time, medium Accuracy
  2: slow response time, high Accuracy

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_TTFF_QOP_SET            "AT+ELCSTTFFQOP"


/*
\r\n+ELCSNINTF: <id>,<type>,<notify_type>,<requestor_id>,<requestor_id_encode_type>,<text>,<text_encode_type>\r\n

[Description]
this is an unsolicited response while Network Initiated is coming and request to show UI for user.
GNSS requests the host to show NI notification/verification for user.

[Parameters]
<id> (int)
<type> (int)
  1=voice
  2=SUPL
  3=CP
  4=Emergency SUPL
<notify_type> (int)
  0=none
  1=notification only
  2=notification and verification, allowed if no answer
  3=notification and verification, denied if no answer
  4=privacy override
<requestor_id> (string)
  max. to 1023 characters
<requestor_id_encode_type> (int)
  0=none
  1=GSM7
  2=UTF8
  3=UCS2
<text> (string)
  max. to 1023 characters
<text_encode_type> (int)
  0=none
  1=GSM7
  2=UTF8
  3=UCS2

[Example]
\r\n+ELCSNINTF: 1,2,1,"4875676F526571756573746F72",2,"4875676F436C69656E74",2\r\n
  id=1
  type=SUPL=2
  notify_type=notification only=1
  requestor_id="HugoRequestor"=4875676F526571756573746F72 (UTF8 hex string)
  requestor_id_encode_type=UTF8=2
  text="HugoClient"=4875676F436C69656E74 (UTF8 hex string)
  text_encode_type=UTF8=2

\r\n+ELCSNINTF: 2,3,3,"FEFF004800750067006F0052006500710075006500730074006F0072",3,"FEFF004800750067006F0043006C00690065006E0074",3\r\n
  id=2
  type=CP=3
  notify_type=notification and verification, denied if no answer=3
  requestor_id="HugoRequestor"="FEFF004800750067006F0052006500710075006500730074006F0072" (UCS2 hex string)
  requestor_id_encode_type=UCS2=3
  text="HugoClient"="FEFF004800750067006F0043006C00690065006E0074" (UCS2 hex string)
  text_encode_type=UCS2=3
*/
#define MTK_AT_GNSS_NI_NOTIFY_REQ       "\r\n+ELCSNINTF"


/*
AT+ELCSNIRSP=<id>,<response>\r\n

[Description]
to reply +ELCSNINTF.
the host updates user response for NI notification.

[Parameters]
<id> (int)
<response> (int)
  1=accept
  2=deny
  3=no response

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_NI_NOTIFY_RSP       "AT+ELCSNIRSP"


/*
AT+ELCSLOOPBACK=<msg>\r\n

[Description]
this is loopback testing command to ensure the channel between the host and the device is ok or not.

[Parameters]
<msg> (string)
  testing message

[Return]
\r\n+ELCSLOOPBACK...\r\n
\r\nOK\r\n or \r\nERROR\r\n

[Example]
AT+ELCSLOOPBACK="hello world"\r\n
\r\n+ELCSLOOPBACK: "hello world"\r\n
\r\nOK\r\n
*/
#define MTK_AT_GNSS_LOOPBACK_REQ        "AT+ELCSLOOPBACK"


/*
\r\n+ELCSLOOPBACK: <msg>\r\n

[Description]
reply for AT+ELCSLOOPBACK sent by the host.

[Parameters]
<msg> (string)
  this message is copied from AT+ELCSLOOPBACK
*/
#define MTK_AT_GNSS_LOOPBACK_RSP        "\r\n+ELCSLOOPBACK"


/*
AT+ELCSCERT=<total_message_length>,<seq_no>,<cert_name>,<cert_data>\r\n

[Description]
for host to inject the SUPL certificate to the device.
the injected certificates are persistent even reboot the device.
the maximum number of injected certificate cannot be over 10, you can use AT+ELCSCERTDEL/AT+ELCSCERTDELALL to delete the unused certificate.

[Parameters]
<total_message_length> (int)
  The total size of the certificate to be received from 1-64000 bytes
<seq_no> (int)
  The sequence number of the segment from 1-64
<cert_name> (string)
   name of the certificate of max 128 chars acceptable chars: []()-._0-9a-zA-Z including the space
<cert_data> (string)
  certificate data in PEM format (Base64) of max 1000 chars, if certificate is more than 1000 char, it should be split into multiple AT commands with sequence number.

[Example]
AT+ELCSCERT=2000,1,"DigiCert Global Root CA","ggEBAJEVOQMB..."\r\n
\r\nOK\r\n
AT+ELCSCERT=2000,2,"DigiCert Global Root CA","G2f7Shz5CmBb..."\r\n
\r\nOK\r\n
*/
#define MTK_AT_GNSS_CERT_SET            "AT+ELCSCERT"


/*
AT+ELCSCERT?\r\n

[Description]
for host to query the injected certificate name list.

[Example]
case 1: there is NO injected certificate in the device.
AT+ELCSCERT?\r\n
\r\n+ELCSCERT: \r\n
\r\nOK\r\n

case 1: there is one injected certificate in the device.
AT+ELCSCERT?
\r\n+ELCSCERT: "cert 1"\r\n
\r\nOK\r\n

case 2: there are three injected certificate in the device.
AT+ELCSCERT?
\r\n+ELCSCERT: "cert 1","cert 2","cert 3"\r\n
\r\nOK\r\n
*/
#define MTK_AT_GNSS_CERT_NAME_REQ       "AT+ELCSCERT?"


/*
\r\n+ELCSCERT: [<cert_name>,[<cert_name>,...]...]\r\n

[Description]
reply AT+ELCSCERT? to provide the injected certificate name list.

[Parameters]
<cert_name> (string)
  name of the certificate of max 128 chars
*/
#define MTK_AT_GNSS_CERT_NAME_RSP       "\r\n+ELCSCERT"


/*
AT+ELCSCERTDEL=<cert_name>\r\n

[Description]
to delete the specific injected certificate from the device.

[Parameters]
<cert_name> (string)
  name of the certificate of max 128 chars

[Return]
case 1: if the certificate exists and delete successful
\r\nOK\r\n

case 2: if the certificate does not exist or delete failed
\r\nERROR\r\n
*/
#define MTK_AT_GNSS_CERT_DEL_REQ        "AT+ELCSCERTDEL"


/*
AT+ELCSCERTDELALL\r\n

[Description]
to delete all injected certificate from the device.

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GNSS_CERT_DEL_ALL_REQ    "AT+ELCSCERTDELALL"


/*
AT+EGEOMAX?\r\n

[Description]
Query for maximum fence supported

[Return]
\r\n+EGEOMAX...\r\n
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GEOFENCE_MAX_NUM_REQ     "AT+EGEOMAX?"


/*
\r\n+EGEOMAX: <maxfence>\r\n

[Description]
return maximum supported fence

[Exmaple]
\r\n+EGEOMAX: 100\r\n
  maxfence = 100
*/
#define MTK_AT_GEOFENCE_MAX_NUM_RSP     "\r\n+EGEOMAX"


/*
AT+EGEOADDCIRCLE=<AlertTypes>,<InitialState>,<lat1>,<lon1>,<radius>,<unknowntimerms>\r\n

[Description]
Create a geofence, given the fence initial state, fence type, fence descriptions (latitude,longitude, radius), and its initial condition

[Parameter]
<AlertTypes> (int)
  GNSS_GEOFENCEALERTTYPE_ENTRY = (1<<0)
  GNSS_GEOFENCEALERTTYPE_EXIT  = (1<<1)
<InitialState> (int)
  GNSS_GeofenceState_Unknown = 0
  GNSS_GeofenceState_Entered = 1
  GNSS_GeofenceState_Exited  = 2
<lat1> (double by using %.6f)
  in degree, valid range from -180.000000 to +180.000000, NaN indicates unavailable, WGS84 coordinate system
<lon1> (double by using %.6f)
  in degree, valid range from -90.000000 to +90.000000, NaN indicates unavailable, WGS84 coordinate system
<radius> (double by using %.6f)
  in meters
<unknowntimerms> (int)
  The time limit after which the UNCERTAIN transition should be triggered. This paramter is defined in milliseconds. Range <0~100000> milliseconds

[Return]
\r\n+EGEOADDCIRCLE...\r\n
\r\nOK\r\n or \r\nERROR\r\n

[Example]
AT+EGEOADDCIRCLE=3,0,24.123456,121.012345,200.000000,10000\r\n
  AlertTypes = 3, alert for both geofence entry and exit
  InitialState = GNSS_GeofenceState_Unknown
  lat1 = 24.123456 deg
  lon1 = 121.012345 deg
  radius = 200.000000 meters
  unknowntimerms = 10000milliseconds
*/
#define MTK_AT_GEOFENCE_ADD_CIRCLE_REQ      "AT+EGEOADDCIRCLE"


/*
\r\n+EGEOADDCIRCLE: <createstatus>[,<id>]\r\n

[Description]
Response from gnss service when a new geofence is created

[Parameter]
<createstatus> (int)
  success             = 0
  error               = -1
  insufficient_memory = -2
  too many fences     = -3
<id> (int)
  geofence id generated by gnss service if add fence success

[Example]
\r\n+EGEOADDCIRCLE: 0,1\r\n
  createstatus = success
  id = 1

\r\n+EGEOADDCIRCLE: -1\r\n
  createstatus = failed
*/
#define MTK_AT_GEOFENCE_ADD_CIRCLE_RSP     "\r\n+EGEOADDCIRCLE"


/*
AT+EGEODEL=<id>\r\n
[Description]
delete existing geofence

[Parameter]
<id> (int)
  geofence id generated by gnss service

[Return]
\r\nOK\r\n or \r\nERROR\r\n

[Example]
AT+EGEODEL=1\r\n
  delete fence which id is 1
*/
#define MTK_AT_GEOFENCE_DEL_REQ         "AT+EGEODEL"


/*
AT+EGEODELALL=\r\n

[Description]
delete all existing geofence

[Return]
\r\nOK\r\n or \r\nERROR\r\n
*/
#define MTK_AT_GEOFENCE_DEL_ALL_REQ    "AT+EGEODELALL"


/*
\r\n+EGEORESP: <id>,<state>,<lat>,<lon>,<alt>,<speed>,<heading>,<HACC>,<HErrMajorAxis>,<HErrMinorAxis>,<HErrAngle>,<HorConf>,<PDOP>,<HDOP>,<VDOP>\r\n

[Description]
Alert from gnss service to notify a geofence breach

[Parameter]
<id> (int)
  geofence id generated by gnss service
<state> (int)
  GNSS_GeofenceState_Unknown = 0, when gnss service isn't confident enough that the user is either enter or exit the Geofence
  GNSS_GeofenceState_Entered = 1, when gnss service has 95% confident that the user is inside the geofence
  GNSS_GeofenceState_Exited  = 2, when gnss service has 95% confident that the user is outside the geofence
<lat> (double by using %.6f)
  in degree, valid range from -180.000000 to +180.000000, NaN indicates unavailable, WGS84 coordinate system
<lon> (double by using %.6f)
  in degree, valid range from -180.000000 to +180.000000, NaN indicates unavailable, WGS84 coordinate system
<alt> (double by using %.2f)
  in meters with respect to sea level
<speed> (double by using %.2f)
  in m/s, zero or positive value, NaN indicates unavailable
<heading> (double by using %.2f)
  in degrees,valid range from 0 to 360. zero indicates true north, NaN indicates unavailable
<HACC> (int)
  Represents expected horizontal position accuracy, radial, in meters (68% confidence).
<HErrMajorAxis> (int)
  in meters
<HErrMinorAxis> (int)
  in meters
<HErrAngle> (int)
  in degree, valid range from 0 to 360, NaN indicates unavailable
<HorConf> (int)
  horizontal confidence horizontal confidence in meter with 1-sigma accuracy
<PDOP> (float by using %.2f)
  position dilution of precision
<HDOP> (float by using %.2f)
  horizontal dilution of precision
<VDOP> (float by using %.2f)
  vertical dilution of precision

[Example]
\r\n+EGEORESP: 1,1,24.125465,121.365496,100.23,1.23,3.54,3,6,2,6,3,2.52,1.32,2.12\r\n
  id = 1
  state = GNSS_GeofenceState_Entered
  lat = 24.125465 deg
  lon = 121.365496 deg
  altitude = 100.23 meters
  speed = 1.23 m/s
  heading = 3.54 degree
  HACC = 3 meters
  Horizontal error major axis = 6 meters
  Horizontal error minor axis = 2 meters
  Horizontal error angle = 6 deg
  Horizontal confidence = 3 meters
  PDOP = 2.52
  HDOP = 1.32
  VDOOP = 2.12

\r\n+EGEORESP: 1,0,24.125465,121.365496,100.23,1.23,3.54,100,100,100,6,3,10.23,10.32,12.12\r\n
  if less than 95% confident that the user is either inside or outside the fence, gnss service will consider the particular fence is in unknown state
  response of the unknown state will be sent after the expiry of unknowntimerms.
  id = 1
  state = GNSS_GeofenceState_Unknown
  lat = 24.125465 deg
  lon = 121.365496 deg
  altitude = 100.23 meters
  speed = 1.23 m/s
  heading = 3.54 degree
  HACC = 100 meters
  Horizontal error major axis = 100 meters
  Horizontal error minor axis = 100 meters
  Horizontal error angle = 6 deg
  Horizontal confidence = 3 meters
  PDOP = 10.23
  HDOP = 10.32
  VDOOP = 12.12
*/
#define MTK_AT_GEOFENCE_ALERT_NTF    "\r\n+EGEORESP"


/*
\r\n+EGEOTRACK: <status>,<date_time>\r\n

[Description]
notification of any changes in tracking status while tracking a set of previously created geofences

[Parameter]
<status> (int)
  GNSS service tracking OK       = 0
  GNSS service tracking failure  = -1
<date_time> (string)
  UTC time in human readable format. ex: 2019/11/13,10:17:10

[Example]
\r\n+EGEOTRACK: 0,"2019/12/1,21:06:23"\r\n
  status = tracking OK
  date_time = 2019/12/1,21:06:23
*/
#define MTK_AT_GEOFENCE_TRACK_NTF   "\r\n+EGEOTRACK"


/*
AT+ELCSTEST=<test_num1>,<test_num2>,<test_double1>,<test_double2>,<test_str1>,<test_str2>\r\n

[Description]
This is a test command and should be used in end product

[Parameter]
<test_num1> (int)
<test_num2> (int)
<test_double1> (double by using %.6f)
<test_double2> (double by using %.6f)
<test_str1> (string)
<test_str2> (string)

[Return]
OK\r\n or ERROR\r\n

[Example]
AT+ETEST: 1,0,0,0,"",""\r\n
cause GNSS Adaptor crash immediately

AT+ETEST: 2,10,0,0,"hello",""\r\n
delay 10 seconds and then send +ELCSLOOPBACK: "hello"\r\n to the host for PCIe wake up testing
please note that +ELCSLOOPBACK: "hello"\r\n will be sent to all available channels (ex: PCIe, USB, ...etc.)

AT+ETEST: 3,5,0,0,"world",""\r\n
send +ELCSLOOPBACK: "world"\r\n to the host for 5 times
*/
#define MTK_AT_TEST_REQ   "AT+ELCSTEST"


#ifdef __cplusplus
}
#endif

#endif

