#ifndef __MTK_GNSS_AT_LOG_H__
#define __MTK_GNSS_AT_LOG_H__

#include <stdio.h>
#include <stdbool.h>
#include <stdint.h> //uint64_t, int64_t
#include <unistd.h> //usleep
#include <stdlib.h> //exit
#include <string.h> //strerror()
#include <errno.h>
#include <sys/time.h> //gettimeofday, localtime
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#define LOGD(...)   {\
    struct timeval tv;\
    struct timezone tz;\
    struct tm* tm;\
    gettimeofday(&tv, &tz);\
    tm = localtime(&tv.tv_sec);\
    printf("%04d/%02d/%02d %02d:%02d:%02d.%03d ",\
        tm->tm_year+ 1900, 1 + tm->tm_mon, tm->tm_mday, tm->tm_hour,\
        tm->tm_min, tm->tm_sec, (int)(tv.tv_usec/1000));\
    printf("[GNSS AT][D] %s() %d  ", __FUNCTION__, __LINE__); printf(__VA_ARGS__); printf("\n"); fflush(stdout); }
#define LOGW(...)   {\
    struct timeval tv;\
    struct timezone tz;\
    struct tm* tm;\
    gettimeofday(&tv, &tz);\
    tm = localtime(&tv.tv_sec);\
    printf("%04d/%02d/%02d %02d:%02d:%02d.%03d ",\
        tm->tm_year+ 1900, 1 + tm->tm_mon, tm->tm_mday, tm->tm_hour,\
        tm->tm_min, tm->tm_sec, (int)(tv.tv_usec/1000));\
    printf("\E[1;35;40m"); printf("[GNSS AT][W] %s() %d  ", __FUNCTION__, __LINE__); printf(__VA_ARGS__); printf("\E[0m"); printf("\n"); fflush(stdout); }
#define LOGE(...)   {\
    struct timeval tv;\
    struct timezone tz;\
    struct tm* tm;\
    gettimeofday(&tv, &tz);\
    tm = localtime(&tv.tv_sec);\
    printf("%04d/%02d/%02d %02d:%02d:%02d.%03d ",\
        tm->tm_year+ 1900, 1 + tm->tm_mon, tm->tm_mday, tm->tm_hour,\
        tm->tm_min, tm->tm_sec, (int)(tv.tv_usec/1000));\
    printf("\E[1;31;40m"); printf("[GNSS AT][E] %s() %d  ", __FUNCTION__, __LINE__); printf(__VA_ARGS__); printf("\E[0m"); printf("\n"); fflush(stdout); }

#define assert(expr) {\
    if(!(expr)) {\
        LOGE("assert(%s) failed, %s %s() line=%d", #expr, __FILE__, __FUNCTION__, __LINE__);\
        exit(1);\
    }\
}

#ifdef __cplusplus
}
#endif

#endif // __UTILS_H__
