#ifndef __MTK_TREE_H__
#define __MTK_TREE_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*traversal_handler)();

typedef struct _tree_child {
    struct _tree_child* next_child;
    int id;
    struct _tree_node* child;
} tree_child;

typedef struct _tree_node {
    struct _tree_node* parent;
    tree_child children_header;
    traversal_handler handler;
} tree_node;

void tree_init(tree_node* root, traversal_handler handler);
tree_node* tree_add_child(tree_node* node, int id, traversal_handler handler);
void tree_remove_children(tree_node* node);
int tree_children_size(tree_node* node);
tree_node* tree_get_node(tree_node* node, int id);
void tree_dump(tree_node* node);

typedef struct _traversal_path {
    struct _traversal_path* previous;
    struct _traversal_path* next;
    int path_id;
} traversal_path;

void traversal_path_init(traversal_path* header);
void traversal_path_go(traversal_path* header, int next_path_id);
void traversal_path_back(traversal_path* header);
void traversal_path_cleanup(traversal_path* header);
void traversal_path_dump(traversal_path* header);

int tree_traversal(tree_node* root, traversal_path* header);

#ifdef __cplusplus
}
#endif

#endif

