#include <stdio.h>
#include <stdlib.h>

#include "mtk_tree.h"

void tree_init(tree_node* root, traversal_handler handler) {
    root->parent = NULL;
    root->children_header.id = 0;
    root->children_header.child = NULL;
    root->children_header.next_child = NULL;
    root->handler = handler;
}

tree_node* tree_add_child(tree_node* node, int id, traversal_handler handler) {
    tree_child* c = &node->children_header;
    while(c->next_child != NULL) {
        c = c->next_child;
    }
    c->next_child = (tree_child*)malloc(sizeof(tree_child));

    c = c->next_child;
    c->next_child = NULL;
    c->id = id;
    c->child = (tree_node*)malloc(sizeof(tree_node));

    tree_node* n = c->child;
    n->parent = node;
    n->children_header.id = 0;
    n->children_header.child = NULL;
    n->children_header.next_child = NULL;
    n->handler = handler;
    return n;
}

void tree_remove_children(tree_node* node) {
    tree_child* c = node->children_header.next_child;
    while(c != NULL) {
        tree_remove_children(c->child);
        free(c->child);
        tree_child* c2 = c;
        c = c->next_child;
        free(c2);
    }
    node->children_header.next_child = NULL;
}

tree_node* tree_get_node(tree_node* node, int id) {
    tree_child* c = node->children_header.next_child;
    while(c != NULL) {
        if(c->id == id) {
            return c->child;
        }
        c = c->next_child;
    }
    return NULL;
}

int tree_children_size(tree_node* node) {
    int i = 0;
    tree_child* c = node->children_header.next_child;
    while(c != NULL) {
        i++;
        c = c->next_child;
    }
    return i;
}

void tree_dump(tree_node* node) {
    int size = tree_children_size(node);
    printf("parent=[%p] me=[%p] handler=[%p] size=[%d]\n",
        node->parent, node, node->handler, size);
    tree_child* c = node->children_header.next_child;
    while(c != NULL) {
        size = tree_children_size(c->child);
        printf("  id=[%d] size=[%d] child_ptr=[%p] next_child=[%p]\n", c->id, size, c->child, c->next_child);
        c = c->next_child;
    }
}

void traversal_path_init(traversal_path* header) {
    header->previous = NULL;
    header->next = NULL;
    header->path_id = 0;
}

void traversal_path_go(traversal_path* header, int next_path_id) {
    traversal_path* p = header;
    while(p->next != NULL) {
        p = p->next;
    }
    p->next = (traversal_path*)malloc(sizeof(traversal_path));
    p->next->previous = p;
    p = p->next;
    p->next = NULL;
    p->path_id = next_path_id;
}

void traversal_path_back(traversal_path* header) {
    if(header->next == NULL) {
        //no element, do nothing
        return;
    }
    traversal_path* p = header;
    while(p->next != NULL) {
        p = p->next;
    }
    p->previous->next = NULL;
    free(p);
}

void traversal_path_cleanup(traversal_path* header) {
    if(header->next == NULL) {
        //no element, do nothing
        return;
    }
    traversal_path* p = header->next;
    while(p != NULL) {
        traversal_path* p2 = p;
        p = p->next;
        free(p2);
    }
    header->next = NULL;
}

void traversal_path_dump(traversal_path* header) {
    traversal_path* p = header;
    int i = 0;
    printf("traversal_path_dump()\n");
    while(p->next != NULL) {
        p = p->next;
        i++;
        printf("  index=[%02d] path_id=[%d]\n", i, p->path_id);
    }
}

// -1 means traversal is going to a unknown handler
int tree_traversal(tree_node* root, traversal_path* header) {
    tree_node* n = root;
    traversal_path* p = header;
    while(p->next != NULL) {
        p = p->next;
        n = tree_get_node(n, p->path_id);
        if(n == NULL) {
            return -1;
        }
    }
    n->handler();
    return 0;
}

