// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#ifndef __MtkNlp_H__
#define __MtkNlp_H__

#include "mtk_socket_utils.h"

#ifdef __cplusplus
extern "C" {
#endif

#define NLP_SERVICE_CHANNEL            "mtk_nlp_service_socket"

#define MTK_NLP_PROTOCOL_TYPE 300
#define MTK_NLP_BUFF_SIZE 65

/**
 * Definition of location source that NLP service generates the location.
 * This parameter indicates the positioning technologies involved in calculating position.
 */
typedef short MtkNlpLocationSource;
/**
 * Assisted-GNSS.
 */
#define MTKNLP_LOCATION_SOURCE_AGNSS        0x01
/**
 * Sensors including gyroscope and accelerometer sensors.
 */
#define MTKNLP_LOCATION_SOURCE_SENSOR       0x02
/**
 * E-CID on LTE.
 */
#define MTKNLP_LOCATION_SOURCE_ECIDLTE      0x04
/**
 * E-CID on GSM.
 */
#define MTKNLP_LOCATION_SOURCE_ECIDGSM      0x08
/**
 * E-CID on UMTS.
 */
#define MTKNLP_LOCATION_SOURCE_ECIDUMTS     0x10
/**
 * WLAN AP.
 */
#define MTKNLP_LOCATION_SOURCE_WLANAP       0x20
/**
 * Short Range Node Positioning.
 */
#define MTKNLP_LOCATION_SOURCE_SRN          0x40
/**
 * E-CID on 5G NR.
 */
#define MTKNLP_LOCATION_SOURCE_ECIDNR       0x80


/**
 * This is an MtkNlp interface between NlpCleint and NlpService
 * version 1 for init development
 */
typedef enum {
    /**
     * Request NLP location updates. NLP applications request NLP service start to return locations.
     * param min_interval: minimum time interval between location updates, in milliseconds. NLP service
     * would do its best to return locations according to this interval parameter.
     */
    MTK_NLP_START_LOCATION_UPDATES = 0,
    /**
     * Stop NLP location updates.
     */
    MTK_NLP_STOP_LOCATION_UPDATES = 1,
    /**
     * Get last cached location from NLP service. After this function is called, NLP application
     * may wait for fd epoll events to parse the returned location. NLP service may not return
     * the location, if NLP service doesn't have cached location.
     */
    MTK_NLP_GET_LAST_LOCATION = 2,
    /**
     * Request single NLP location update. After this function is called, NLP application may
     * wait for fd epoll events to parse the returned location.
     */
    MTK_NLP_GET_SINGLE_UPDATE = 3,
    /**
     * Nlp Service send location to Nlp client
     */
    MTK_NLP_PROVIDE_LOCATION = 4,
} MtkNlp_message_id;


typedef struct {
    /**
     * UTC time of this fix, in milliseconds since January 1, 1970
     */
    int64_t time;

    /**
     * The time of this fix, in elapsed real-time nanosecond since system boot.
     */
    int64_t elapsed_real_time_nanos;

    /**
     * Represents latitude in degrees.
     */
    double latitude;

    /**
     * Represents longitude in degrees.
     */
    double longitude;

    /**
     * Flag to indicate altitude field is valid.
     */
    bool altitude_valid;

    /**
     * Represents altitude in meters above the WGS 84 reference ellipsoid.
     */
    double altitude;

    /**
     * Flag to indicate horizontal_accuracy field is valid.
     */
    bool horizontal_accuracy_valid;

    /**
     * The estimated horizontal accuracy of this location, radial, in meters.
     * We define horizontal accuracy as the radius of 68% confidence. In other words, if you draw
     * a circle centered at this location's latitude and longitude, and with a radius equal to the
     * accuracy, then there is a 68% probability that the true location is inside the circle.
     * In the case where the underlying distribution is assumed Gaussian normal, this would be
     * considered 1 standard deviation.
     */
    float horizontal_accuracy;

    /**
     * Flag to indicate vertical_accuracy field is valid.
     */
    bool vertical_accuracy_valid;

    /**
     * The estimated vertical accuracy of this location, in meters.
     * We define vertical accuracy at 68% confidence, within which there is a 68% probability
     * of finding the true altitude. In the case where the underlying distribution is assumed
     * Gaussian normal, this would be considered 1 standard deviation.
     */
    float vertical_accuracy;

    /**
     * Flag to indicate location_source field is valid.
     */
    bool location_source_valid;

    /**
     * location source bit array for MtkNlpImplLocationSource.
     */
    int location_source;

} MtkNlp_location;

typedef struct {
    /**
     * Flag to indicate location_source field is valid.
     */
    bool nlp_location_valid;

    /**
     * Decoded location data structure.
     */
    MtkNlp_location nlp_location;

} MtkNlp_decoded_location;


// MtkNlp_location
void MtkNlp_location_dump(MtkNlp_location* data);
void MtkNlp_location_array_dump(MtkNlp_location data[], int size);

void MtkNlp_location_init(MtkNlp_location* output);
void MtkNlp_location_array_init(MtkNlp_location output[], int max_size);

bool MtkNlp_location_is_equal(MtkNlp_location* data1, MtkNlp_location* data2);
bool MtkNlp_location_array_is_equal(MtkNlp_location data1[], int size1, MtkNlp_location data2[], int size2);

bool MtkNlp_location_encode(char* buff, int* offset, MtkNlp_location* data);
bool MtkNlp_location_array_encode(char* buff, int* offset, MtkNlp_location data[], int size);

void MtkNlp_location_decode(char* buff, int* offset, MtkNlp_location* output);
int MtkNlp_location_array_decode(char* buff, int* offset, MtkNlp_location output[], int max_size);

// MtkNlp_decoded_location
void MtkNlp_decoded_location_dump(MtkNlp_decoded_location* data);
void MtkNlp_decoded_location_array_dump(MtkNlp_decoded_location data[], int size);

void MtkNlp_decoded_location_init(MtkNlp_decoded_location* output);
void MtkNlp_decoded_location_array_init(MtkNlp_decoded_location output[], int max_size);

bool MtkNlp_decoded_location_is_equal(MtkNlp_decoded_location* data1, MtkNlp_decoded_location* data2);
bool MtkNlp_decoded_location_array_is_equal(MtkNlp_decoded_location data1[], int size1, MtkNlp_decoded_location data2[], int size2);

bool MtkNlp_decoded_location_encode(char* buff, int* offset, MtkNlp_decoded_location* data);
bool MtkNlp_decoded_location_array_encode(char* buff, int* offset, MtkNlp_decoded_location data[], int size);

void MtkNlp_decoded_location_decode(char* buff, int* offset, MtkNlp_decoded_location* output);
int MtkNlp_decoded_location_array_decode(char* buff, int* offset, MtkNlp_decoded_location output[], int max_size);

// Sender
/**
 * Request NLP location updates. NLP applications request NLP service start to return locations.
 * If the caller application no longer need NLP updates, it should call
 * MtkNlp_stop_location_updates() to stop the location updates to avoid power consumption.
 * Because network positioning function will provide the third party package with WiFi scan results
 * and Cell Info, it may disclose the user's location information to NLP vendor. The application
 * calls this API should get user grant or in emergency call cases.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * param min_interval: minimum time interval between location updates, in milliseconds. NLP service
 * would do its best to return locations according to this interval parameter.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_start_location_updates(mtk_socket_fd* client_fd, int min_interval);

/**
 * Stop NLP location updates.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_stop_location_updates(mtk_socket_fd* client_fd);

/**
 * Get last cached location from NLP service. After this function is called, NLP application
 * may wait for fd epoll events to parse the returned location. NLP service may not return
 * the location, if NLP service doesn't have cached location.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_get_last_location(mtk_socket_fd* client_fd);

/**
 * Request single NLP location update. After this function is called, NLP application may
 * wait for fd epoll events to parse the returned location. NLP request session will be finished
 * after a location is reported. If NLP service failed to report location, the caller application
 * should call MtkNlp_stop_location_updates() to stop the request to avoid power consumption.
 * Because network positioning function will provide the third party package with WiFi scan results
 * and Cell Info, it may disclose the user's location information to NLP vendor. The application
 * calls this API should get user grant or in emergency call cases.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_get_single_update(mtk_socket_fd* client_fd);

/**
 * NlP Service send location to NlP client
 * param client_fd: client_fd is used to receive messages from NLP service.
 * param dec_loc: NLP Service reported location data structure.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_provide_location(mtk_socket_fd* client_fd, MtkNlp_decoded_location* dec_loc);

// Receiver
typedef struct {
    /**
     * Request NLP location updates. NLP applications request NLP service start to return locations.
     * param min_interval: minimum time interval between location updates, in milliseconds. NLP service
     * would do its best to return locations according to this interval parameter.
     */
    void (*MtkNlp_start_location_updates_handler) (int fd, int min_interval);
    /**
     * Stop NLP location updates.
     */
    void (*MtkNlp_stop_location_updates_handler) (int fd);
    /**
     * Get last cached location from NLP service. After this function is called, NLP application
     * may wait for fd epoll events to parse the returned location. NLP service may not return
     * the location, if NLP service doesn't have cached location.
     */
    void (*MtkNlp_get_last_location_handler) (int fd);
    /**
     * Request single NLP location update. After this function is called, NLP application may
     * wait for fd epoll events to parse the returned location.
     */
    void (*MtkNlp_get_single_update_handler) (int fd);
    /**
     * Nlp Service send location to Nlp client
     */
    void (*MtkNlp_provide_location_handler) (MtkNlp_decoded_location* dec_loc);
} MtkNlp_callbacks;

bool MtkNlp_receiver_decode(int fd, char* _buff,
        MtkNlp_decoded_location *decLoc, MtkNlp_callbacks* callbacks);


//////////////////////////// Client Interface /////////////////////////////////

/**
 * Create a fd and connect to NLP service. NLP applications may add this fd to epoll events.
 * Once an event is triggered on this fd, NLP applications can call mtknlp_read_and_decode()
 * to get locations.
 * return fd if successfully connect to NLP service, -1 means fail.
 */
int MtkNlp_get_fd();

/**
 * Release fd. When a NLP application doesn't need any NLP location from NLP service,
 * fd can be released by this API.
 */
void MtkNlp_release_fd(int fd);


/**
 * When NLP application detects epoll event on fd, NLP application should call this function.
 * This is a helper function to read the raw data and decode the raw data as MtkNlp_decoded_location.
 * param fd: fd is used to receive messages from NLP service.
 * param buff: received data from NLP service.
 * return value: a decoded location data structure is returned. NLP application should check the
 *     nlp_location_valid flag in MtkNlpDecodedLocation. If the flag is false it indicates the
 *     message is parsing fail, and no nlp location is correctly parsed from NLP service.
 */
MtkNlp_decoded_location MtkNlp_receiver_decode_location(int fd, char* buff);



#ifdef __cplusplus
}
#endif

#endif

