// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "MtkNlp.h"
#include "mtk_lbs_utility.h"
#include "mtk_socket_data_coder.h"

// MtkNlp_location
void MtkNlp_location_dump(MtkNlp_location* data) {
    SOCK_LOGD("MtkNlp_location_dump()");
    SOCK_LOGD("  time=[%lld]", data->time);
    SOCK_LOGD("  elapsed_real_time_nanos=[%lld]", data->elapsed_real_time_nanos);
    SOCK_LOGD("  latitude=[%f]", data->latitude);
    SOCK_LOGD("  longitude=[%f]", data->longitude);
    SOCK_LOGD("  altitude_valid=[%d]", data->altitude_valid);
    SOCK_LOGD("  altitude=[%f]", data->altitude);
    SOCK_LOGD("  horizontal_accuracy_valid=[%d]", data->horizontal_accuracy_valid);
    SOCK_LOGD("  horizontal_accuracy=[%f]", data->horizontal_accuracy);
    SOCK_LOGD("  vertical_accuracy_valid=[%d]", data->vertical_accuracy_valid);
    SOCK_LOGD("  vertical_accuracy=[%f]", data->vertical_accuracy);
    SOCK_LOGD("  location_source_valid=[%d]", data->location_source_valid);
    SOCK_LOGD("  location_source=[%d]", data->location_source);
}
void MtkNlp_location_array_dump(MtkNlp_location data[], int size) {
    int i = 0;
    SOCK_LOGD("MtkNlp_location_array_dump() size=[%d]", size);
    for(i = 0; i < size; i++) {
        MtkNlp_location_dump(&data[i]);
    }
}

void MtkNlp_location_init(MtkNlp_location* output) {
    output->time = 0;
    output->elapsed_real_time_nanos = 0;
    output->latitude = 0;
    output->longitude = 0;
    output->altitude_valid = 0;
    output->altitude = 0;
    output->horizontal_accuracy_valid = 0;
    output->horizontal_accuracy = 0;
    output->vertical_accuracy_valid = 0;
    output->vertical_accuracy = 0;
    output->location_source_valid = 0;
    output->location_source = 0;
}
void MtkNlp_location_array_init(MtkNlp_location output[], int max_size) {
    int i = 0;
    for(i = 0; i < max_size; i++) {
        MtkNlp_location_init(&output[i]);
    }
}

bool MtkNlp_location_is_equal(MtkNlp_location* data1, MtkNlp_location* data2) {
    if(data1->time != data2->time) return false;
    if(data1->elapsed_real_time_nanos != data2->elapsed_real_time_nanos) return false;
    if(data1->latitude != data2->latitude) return false;
    if(data1->longitude != data2->longitude) return false;
    if(data1->altitude_valid != data2->altitude_valid) return false;
    if(data1->altitude != data2->altitude) return false;
    if(data1->horizontal_accuracy_valid != data2->horizontal_accuracy_valid) return false;
    if(data1->horizontal_accuracy != data2->horizontal_accuracy) return false;
    if(data1->vertical_accuracy_valid != data2->vertical_accuracy_valid) return false;
    if(data1->vertical_accuracy != data2->vertical_accuracy) return false;
    if(data1->location_source_valid != data2->location_source_valid) return false;
    if(data1->location_source != data2->location_source) return false;
    return true;
}
bool MtkNlp_location_array_is_equal(MtkNlp_location data1[], int size1, MtkNlp_location data2[], int size2) {
    int i = 0;
    if(size1 != size2) return false;
    for(i = 0; i < size1; i++) {
        if(!MtkNlp_location_is_equal(&data1[i], &data2[i])) return false;
    }
    return true;
}

bool MtkNlp_location_encode(char* buff, int* offset, MtkNlp_location* data) {
    mtk_socket_put_int64_t(buff, offset, data->time);
    mtk_socket_put_int64_t(buff, offset, data->elapsed_real_time_nanos);
    mtk_socket_put_double(buff, offset, data->latitude);
    mtk_socket_put_double(buff, offset, data->longitude);
    mtk_socket_put_bool(buff, offset, data->altitude_valid);
    mtk_socket_put_double(buff, offset, data->altitude);
    mtk_socket_put_bool(buff, offset, data->horizontal_accuracy_valid);
    mtk_socket_put_float(buff, offset, data->horizontal_accuracy);
    mtk_socket_put_bool(buff, offset, data->vertical_accuracy_valid);
    mtk_socket_put_float(buff, offset, data->vertical_accuracy);
    mtk_socket_put_bool(buff, offset, data->location_source_valid);
    mtk_socket_put_int(buff, offset, data->location_source);
    return true;
}
bool MtkNlp_location_array_encode(char* buff, int* offset, MtkNlp_location data[], int size) {
    int i = 0;
    mtk_socket_put_int(buff, offset, size);
    for(i = 0; i < size; i++) {
        if(!MtkNlp_location_encode(buff, offset, &data[i])) {
            SOCK_LOGE("MtkNlp_location_array_encode() MtkNlp_location_encode() failed at i=%d", i);
            return false;
        }
    }
    return true;
}

void MtkNlp_location_decode(char* buff, int* offset, MtkNlp_location* output) {
    output->time = mtk_socket_get_int64_t(buff, offset);
    output->elapsed_real_time_nanos = mtk_socket_get_int64_t(buff, offset);
    output->latitude = mtk_socket_get_double(buff, offset);
    output->longitude = mtk_socket_get_double(buff, offset);
    output->altitude_valid = mtk_socket_get_bool(buff, offset);
    output->altitude = mtk_socket_get_double(buff, offset);
    output->horizontal_accuracy_valid = mtk_socket_get_bool(buff, offset);
    output->horizontal_accuracy = mtk_socket_get_float(buff, offset);
    output->vertical_accuracy_valid = mtk_socket_get_bool(buff, offset);
    output->vertical_accuracy = mtk_socket_get_float(buff, offset);
    output->location_source_valid = mtk_socket_get_bool(buff, offset);
    output->location_source = mtk_socket_get_int(buff, offset);
}
int MtkNlp_location_array_decode(char* buff, int* offset, MtkNlp_location output[], int max_size) {
    int i = 0;
    int size = mtk_socket_get_int(buff, offset);
    for(i = 0; i < size; i++) {
        if(i < max_size) {
            MtkNlp_location_decode(buff, offset, &output[i]);
        } else {
            MtkNlp_location data;
            MtkNlp_location_decode(buff, offset, &data);
        }
    }
    return (size > max_size)? max_size : size;
}

// MtkNlp_decoded_location
void MtkNlp_decoded_location_dump(MtkNlp_decoded_location* data) {
    SOCK_LOGD("MtkNlp_decoded_location_dump()");
    SOCK_LOGD("  nlp_location_valid=[%d]", data->nlp_location_valid);
    MtkNlp_location_dump(&data->nlp_location);
}
void MtkNlp_decoded_location_array_dump(MtkNlp_decoded_location data[], int size) {
    int i = 0;
    SOCK_LOGD("MtkNlp_decoded_location_array_dump() size=[%d]", size);
    for(i = 0; i < size; i++) {
        MtkNlp_decoded_location_dump(&data[i]);
    }
}

void MtkNlp_decoded_location_init(MtkNlp_decoded_location* output) {
    output->nlp_location_valid = 0;
    MtkNlp_location_init(&output->nlp_location);
}
void MtkNlp_decoded_location_array_init(MtkNlp_decoded_location output[], int max_size) {
    int i = 0;
    for(i = 0; i < max_size; i++) {
        MtkNlp_decoded_location_init(&output[i]);
    }
}

bool MtkNlp_decoded_location_is_equal(MtkNlp_decoded_location* data1, MtkNlp_decoded_location* data2) {
    if(data1->nlp_location_valid != data2->nlp_location_valid) return false;
    if(!MtkNlp_location_is_equal(&data1->nlp_location, &data2->nlp_location)) return false;
    return true;
}
bool MtkNlp_decoded_location_array_is_equal(MtkNlp_decoded_location data1[], int size1, MtkNlp_decoded_location data2[], int size2) {
    int i = 0;
    if(size1 != size2) return false;
    for(i = 0; i < size1; i++) {
        if(!MtkNlp_decoded_location_is_equal(&data1[i], &data2[i])) return false;
    }
    return true;
}

bool MtkNlp_decoded_location_encode(char* buff, int* offset, MtkNlp_decoded_location* data) {
    mtk_socket_put_bool(buff, offset, data->nlp_location_valid);
    if(!MtkNlp_location_encode(buff, offset, &data->nlp_location)) {
        SOCK_LOGE("MtkNlp_decoded_location_encode() MtkNlp_location_encode() failed");
        return false;
    }
    return true;
}
bool MtkNlp_decoded_location_array_encode(char* buff, int* offset, MtkNlp_decoded_location data[], int size) {
    int i = 0;
    mtk_socket_put_int(buff, offset, size);
    for(i = 0; i < size; i++) {
        if(!MtkNlp_decoded_location_encode(buff, offset, &data[i])) {
            SOCK_LOGE("MtkNlp_decoded_location_array_encode() MtkNlp_decoded_location_encode() failed at i=%d", i);
            return false;
        }
    }
    return true;
}

void MtkNlp_decoded_location_decode(char* buff, int* offset, MtkNlp_decoded_location* output) {
    output->nlp_location_valid = mtk_socket_get_bool(buff, offset);
    MtkNlp_location_decode(buff, offset, &output->nlp_location);
}
int MtkNlp_decoded_location_array_decode(char* buff, int* offset, MtkNlp_decoded_location output[], int max_size) {
    int i = 0;
    int size = mtk_socket_get_int(buff, offset);
    for(i = 0; i < size; i++) {
        if(i < max_size) {
            MtkNlp_decoded_location_decode(buff, offset, &output[i]);
        } else {
            MtkNlp_decoded_location data;
            MtkNlp_decoded_location_decode(buff, offset, &data);
        }
    }
    return (size > max_size)? max_size : size;
}

// Sender
/**
 * Request NLP location updates. NLP applications request NLP service start to return locations.
 * If the caller application no longer need NLP updates, it should call
 * MtkNlp_stop_location_updates() to stop the location updates to avoid power consumption.
 * Because network positioning function will provide the third party package with WiFi scan results
 * and Cell Info, it may disclose the user's location information to NLP vendor. The application
 * calls this API should get user grant or in emergency call cases.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * param min_interval: minimum time interval between location updates, in milliseconds. NLP service
 * would do its best to return locations according to this interval parameter.
 */
bool MtkNlp_start_location_updates(mtk_socket_fd* client_fd, int min_interval) {
    LOGD("mtknlp_start_location_updates, fd:%d", client_fd->fd);
    pthread_mutex_lock(&client_fd->mutex);
    /*if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("MtkNlp_start_location_request() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }*/
    int _ret;
    char _buff[MTK_NLP_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_START_LOCATION_UPDATES);
    mtk_socket_put_int(_buff, &_offset, min_interval);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("MtkNlp_start_location_request() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    //mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

/**
 * Stop NLP location updates.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_stop_location_updates(mtk_socket_fd* client_fd) {
    LOGD("mtknlp_stop_location_updates, fd:%d", client_fd->fd);
    pthread_mutex_lock(&client_fd->mutex);
    /*if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("MtkNlp_stop_location_request() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }*/
    int _ret;
    char _buff[MTK_NLP_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_STOP_LOCATION_UPDATES);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("MtkNlp_stop_location_request() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    //mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

/**
 * Get last cached location from NLP service. After this function is called, NLP application
 * may wait for fd epoll events to parse the returned location. NLP service may not return
 * the location, if NLP service doesn't have cached location.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_get_last_location(mtk_socket_fd* client_fd) {
    LOGD("mtknlp_stop_location_updates, fd:%d", client_fd->fd);
    pthread_mutex_lock(&client_fd->mutex);
    /*if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("MtkNlp_get_last_location() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }*/
    int _ret;
    char _buff[MTK_NLP_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_GET_LAST_LOCATION);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("MtkNlp_get_last_location() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    //mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

/**
 * Request single NLP location update. After this function is called, NLP application may
 * wait for fd epoll events to parse the returned location. NLP request session will be finished
 * after a location is reported. If NLP service failed to report location, the caller application
 * should call MtkNlp_stop_location_updates() to stop the request to avoid power consumption.
 * Because network positioning function will provide the third party package with WiFi scan results
 * and Cell Info, it may disclose the user's location information to NLP vendor. The application
 * calls this API should get user grant or in emergency call cases.
 * param client_fd: client_fd is used to receive messages from NLP service.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_get_single_update(mtk_socket_fd* client_fd) {
    LOGD("mtknlp_stop_location_updates, fd:%d", client_fd->fd);
    pthread_mutex_lock(&client_fd->mutex);
    /*if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("MtkNlp_get_single_update() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }*/
    int _ret;
    char _buff[MTK_NLP_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_GET_SINGLE_UPDATE);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("MtkNlp_get_single_update() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    //mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

/**
 * NlP Service send location to NlP client
 * param client_fd: client_fd is used to receive messages from NLP service.
 * param dec_loc: NLP Service reported location data structure.
 * return value: true indicates the message is successfully sent, false means failed to send.
 */
bool MtkNlp_provide_location(mtk_socket_fd* client_fd, MtkNlp_decoded_location* dec_loc) {
    pthread_mutex_lock(&client_fd->mutex);
    /*if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("MtkNlp_provide_location() mtk_socket_client_connect() failed");
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }*/
    int _ret;
    char _buff[MTK_NLP_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, MTK_NLP_PROVIDE_LOCATION);
    if(!MtkNlp_decoded_location_encode(_buff, &_offset, dec_loc)) {
        SOCK_LOGE("MtkNlp_provide_location() MtkNlp_decoded_location_encode() fail on dec_loc");
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("MtkNlp_provide_location() mtk_socket_write() failed, fd=%d err=[%s]%d",
            client_fd->fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        pthread_mutex_unlock(&client_fd->mutex);
        return false;
    }
    //mtk_socket_client_close(client_fd);
    pthread_mutex_unlock(&client_fd->mutex);
    return true;
}

// Receiver
bool MtkNlp_receiver_decode(int fd, char* _buff,
        MtkNlp_decoded_location *dec_loc, MtkNlp_callbacks* callbacks) {
    int _ret = 0;
    int _offset = 0;
    _ret = mtk_socket_get_int(_buff, &_offset);
    if(_ret != MTK_NLP_PROTOCOL_TYPE) {
        SOCK_LOGE("MtkNlp_receiver_decode() protocol_type=[%d] is not equals to [%d]",
            _ret, MTK_NLP_PROTOCOL_TYPE);
        return false;
    }
    _ret = mtk_socket_get_int(_buff, &_offset);
    switch(_ret) {
    case MTK_NLP_START_LOCATION_UPDATES: {
        if(callbacks->MtkNlp_start_location_updates_handler == NULL) {
            SOCK_LOGE("MtkNlp_receiver_decode() MtkNlp_start_location_request_handler() is NULL");
            return false;
        }
        int min_interval = mtk_socket_get_int(_buff, &_offset);
        callbacks->MtkNlp_start_location_updates_handler(fd, min_interval);
        break;
    }
    case MTK_NLP_STOP_LOCATION_UPDATES: {
        if(callbacks->MtkNlp_stop_location_updates_handler == NULL) {
            SOCK_LOGE("MtkNlp_receiver_decode() MtkNlp_stop_location_request_handler() is NULL");
            return false;
        }
        callbacks->MtkNlp_stop_location_updates_handler(fd);
        break;
    }
    case MTK_NLP_GET_LAST_LOCATION: {
        if(callbacks->MtkNlp_get_last_location_handler == NULL) {
            SOCK_LOGE("MtkNlp_receiver_decode() MtkNlp_get_last_location_handler() is NULL");
            return false;
        }
        callbacks->MtkNlp_get_last_location_handler(fd);
        break;
    }
    case MTK_NLP_GET_SINGLE_UPDATE: {
        if(callbacks->MtkNlp_get_single_update_handler == NULL) {
            SOCK_LOGE("MtkNlp_receiver_decode() MtkNlp_get_single_update_handler() is NULL");
            return false;
        }
        callbacks->MtkNlp_get_single_update_handler(fd);
        break;
    }
    case MTK_NLP_PROVIDE_LOCATION: {
        /*if(callbacks->MtkNlp_provide_location_handler == NULL) {
            SOCK_LOGE("MtkNlp_receiver_decode() MtkNlp_provide_location_handler() is NULL");
            return false;
        }*/
        //MtkNlp_decoded_location dec_loc;
        MtkNlp_decoded_location_decode(_buff, &_offset, dec_loc);
        //callbacks->MtkNlp_provide_location_handler(dec_loc);
        break;
    }
    default: {
        SOCK_LOGE("MtkNlp_receiver_decode() unknown msgId=[%d]", _ret);
        return false;
    }
    }
    return true;
}



int MtkNlp_get_fd() {

    int fd = socket_tcp_client_connect_local(true, NLP_SERVICE_CHANNEL);
    if(fd < 0) {
        LOGE("mtk_socket_tcp_connect_local() failed");
        return -1;
    }
    return fd;
}

void MtkNlp_release_fd(int fd) {
    close(fd);
}


MtkNlp_decoded_location MtkNlp_receiver_decode_location(int fd, char* buff) {
    MtkNlp_decoded_location decLoc;

    decLoc.nlp_location_valid = false;
    MtkNlp_receiver_decode(fd, buff, (MtkNlp_decoded_location*)&decLoc, NULL);
    return decLoc;
}

