/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h> // for open
#include <unistd.h> // for close
#include <errno.h>
#include <stdarg.h>
#include <string.h>
#include <sys/stat.h>
#include "agps_interface.h"
#include "data_coder.h"
#include "agpsprofile.h"

#if defined(__ANDROID_OS__) | defined(__KAIOS__)
#include <cutils/sockets.h>
#include <android/log.h>

#define AGPS_INTERFACE_PATH "agpsd2"

#elif defined(__LINUX_OS__) | defined(__YOCTO_OS__)
#include <sys/socket.h>
#include <arpa/inet.h> //inet_addr
#include <sys/un.h> //struct sockaddr_un

#define AGPS_INTERFACE_PATH "agpsd2"
#endif

#define MAX_BUFF_SIZE 8192
#define ORIGINAL_AGPES_PROFILE_PATH2 "/vendor/etc/agps_profiles_conf2.xml"

#define LBS_STRNCPY(dst,src,size) do{\
                                       strncpy((char *)(dst), (src), (size - 1));\
                                      (dst)[size - 1] = '\0';\
                                     }while(0)

typedef enum {
    // Command Enum APP -> AGPSD
    APP_MGR_CMD_CODER_TEST = 0,
    APP_MGR_CMD_VERSION = 1,

    APP_MGR_CMD_GET_CONFIG = 100,    //AgpsConfig
    APP_MGR_CMD_GET_OMA_CP_SUPL_PROFILE = 101,
    APP_MGR_CMD_GET_SYSTEM_PROPERTY = 102,
    APP_MGR_CMD_GET_AGPS_PROFILING = 103,
    APP_MGR_CMD_GET_EMULATOR_MODE = 104,
    APP_MGR_CMD_GET_CONFIG_V2 = 105,
    APP_MGR_CMD_GET_CONFIG_V3 = 106,    // add cert_from_sdcard
    APP_MGR_CMD_GET_CONFIG_V14 = 117,
    APP_MGR_CMD_GET_CONFIG_V20 = 123,
    APP_MGR_CMD_GET_CONFIG_V21 = 124,
    APP_MGR_CMD_GET_CONFIG_V22 = 125,
    APP_MGR_CMD_GET_CONFIG_V23 = 126,
    APP_MGR_CMD_GET_CONFIG_V24 = 127,

    APP_MGR_CMD_SET_AGPS_ENABLE = 200,
    APP_MGR_CMD_SET_PROTOCOL,
    APP_MGR_CMD_SET_CDMA_PREF,
    APP_MGR_CMD_SET_UP_PREF_METHOD,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_MSA,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_MSB,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_ECID,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_OTDOA,
    APP_MGR_CMD_SET_SUPL_VERSION,
    APP_MGR_CMD_SET_SUPL_PROFILE,    //AgpsProfil
    APP_MGR_CMD_SET_QOP = 210,            //AgpsQoP
    APP_MGR_CMD_SET_MOLR_POS_METHDO,
    APP_MGR_CMD_SET_EXTERNAL_ADDR,
    APP_MGR_CMD_SET_MLC_NUMBER,
    APP_MGR_CMD_SET_CP_AUTO_RESET,
    APP_MGR_CMD_SET_ALLOW_NI,
    APP_MGR_CMD_SET_ALLOW_ROAMING,
    APP_MGR_CMD_SET_SUPL_2_FILE,
    APP_MGR_CMD_SET_RESET_TO_DEFAULT,
    APP_MGR_CMD_SET_OMA_CP_SUPL_PROFILE,
    APP_MGR_CMD_SET_NI_REQ = 220,  //un-implemented for test
    APP_MGR_CMD_SET_EPC_MOLR_PDU_ENABLE,
    APP_MGR_CMD_SET_EPC_MOLR_PDU,
    APP_MGR_CMD_SET_TLS_VERSION,
    APP_MGR_CMD_SET_CA_ENABLE,
    APP_MGR_CMD_SET_UDP_ENABLE,
    APP_MGR_CMD_SET_LPP_ENABLE,
    APP_MGR_CMD_SET_CERT_FROM_SDCARD_ENABLE,
    APP_MGR_CMD_SET_AUTO_PROFILE_ENABLE,
    APP_MGR_CMD_SET_UT2,
    APP_MGR_CMD_SET_UT3 = 230,
    APP_MGR_CMD_SET_SUPL_APN_ENABLE,
    APP_MGR_CMD_SET_SYNC_TO_SLP,
    APP_MGR_CMD_SET_UDP_ENABLE_V2,
    APP_MGR_CMD_SET_AUTONOMOUS_ENABLE,
    APP_MGR_CMD_SET_AFLT_ENABLE,
    APP_MGR_CMD_SET_IMSI_ENABLE,
    APP_MGR_CMD_SET_SIB8_16_ENABLE,
    APP_MGR_CMD_SET_GPS_ENABLE,
    APP_MGR_CMD_SET_GLONASS_ENABLE,
    APP_MGR_CMD_SET_BEIDOU_ENABLE = 240,
    APP_MGR_CMD_SET_GALILEO_ENABLE,
    APP_MGR_CMD_SET_SUPL_SHA_VERSION,
    APP_MGR_CMD_SET_SUPL_TLS_VERSION,
    APP_MGR_CMD_SET_SUPL_VER_MINOR,
    APP_MGR_CMD_SET_SUPL_VER_SER_IND,
    APP_MGR_CMD_SET_A_GLONASS_ENABLE,
    APP_MGR_CMD_SET_PDE_PROFILE,
    APP_MGR_CMD_SET_E911_GPS_ICON_ENABLE,
    APP_MGR_CMD_SET_E911_OPEN_GPS_ENABLE,
    APP_MGR_CMD_SET_A_GPS_ENABLE = 250,
    APP_MGR_CMD_SET_A_BEIDOU_ENABLE,
    APP_MGR_CMD_SET_A_GALILEO_ENABLE,
    APP_MGR_CMD_SET_PREF_2G3G_CELL_AGE,
    APP_MGR_CMD_SET_UT1,
    APP_MGR_CMD_SET_NO_SENSITIVE_LOG,
    APP_MGR_CMD_SET_TLS_REUSE_ENABLE,
    APP_MGR_CMD_SET_IMSI_CACHE_ENABLE,
    APP_MGR_CMD_SET_SUPL_RAW_DATA_ENABLE,
    APP_MGR_CMD_SET_TC10_ENABLE,
    APP_MGR_CMD_SET_TC10_USE_APN = 260,
    APP_MGR_CMD_SET_TC10_USE_FW_DNS,
    APP_MGR_CMD_SET_ALLOW_NI_FOR_GPS_OFF,
    APP_MGR_CMD_SET_FORCE_OTDOA_ASSIST_REQ,
    APP_MGR_CMD_SET_REJECT_NON911_NILR_ENABLE,
    APP_MGR_CMD_SET_CP_2G_DISABLE,
    APP_MGR_CMD_SET_CP_3G_DISABLE,
    APP_MGR_CMD_SET_CP_4G_DISABLE,
    APP_MGR_CMD_SET_TC10_IGNORE_FW_CONFIG,
    APP_MGR_CMD_SET_LPPE_HIDE_WIFI_BT_STATUS,
    APP_MGR_CMD_SET_LPPE_NETWORK_LOCATION_DISABLE = 270,
    APP_MGR_CMD_SET_LPPE_CP_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_ENABLE,
    APP_MGR_CMD_SET_VZW_DEBUG_SCREEN_ENABLE,
    APP_MGR_CMD_SET_AOSP_PROFILE_ENABLE,
    APP_MGR_CMD_SET_BIND_NLP_SETTING_TO_SUPL,
    APP_MGR_CMD_SET_ESUPL_APN_MODE,
    APP_MGR_CMD_SET_TCP_KEEPALIVE,
    APP_MGR_CMD_SET_AGPS_NVRAM_ENABLE,
    APP_MGR_CMD_SET_LBS_LOG_ENABLE,
    APP_MGR_CMD_SET_LPPE_CROWD_SOURCE_CONFIDENT = 280,
    APP_MGR_CMD_SET_IGNORE_SI_FOR_E911,
    APP_MGR_CMD_SET_LPPE_CP_WLAN_ENABLE,
    APP_MGR_CMD_SET_LPPE_CP_SRN_ENABLE,
    APP_MGR_CMD_SET_LPPE_CP_SENSOR_ENABLE,
    APP_MGR_CMD_SET_LPPE_CP_DBH_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_WLAN_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_SRN_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_SENSOR_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_DBH_ENABLE,
    APP_MGR_CMD_SET_IP_VERSION_PREFER = 290,
    APP_MGR_CMD_SET_UP_LPP_IN_2G3G_DISABLE,
    APP_MGR_CMD_SET_UP_RRLP_IN_4G_DISABLE,
    APP_MGR_CMD_UP_SI_DISABLE,

    // To implement
    APP_MGR_CMD_SET_USE_NI_SLP,
    APP_MGR_CMD_SET_USE_TC10_CONFIG,
    APP_MGR_CMD_SET_LPPE_DEF_NLP_ENABLE,
    APP_MGR_CMD_SET_AOSP_POS_MODE_ENABLE,
    APP_MGR_CMD_SET_PRIVACY_OVERRIDE_MODE,
    APP_MGR_CMD_SET_EMERGENCY_EXT_SECS, // 299


    APP_MGR_CMD_START_PERIODIC = 300,
    APP_MGR_CMD_ABORT_PERIODIC,
    APP_MGR_CMD_START_AREA_EVENT,
    APP_MGR_CMD_ABORT_AREA_EVENT,

    APP_MGR_CMD_START_TEST_CASE = 400,
    APP_MGR_CMD_START_TEST_BUTTON,
    APP_MGR_CMD_START_RESET_AGPSD,
    APP_MGR_CMD_START_EMULATOR_MODE,


    // To implement
    APP_MGR_CMD_SET_TC10_SUPL_SSL_METHOD = 500,
    APP_MGR_CMD_SET_TC10_AUTO_SUPL_VER_FOR_NI,
    APP_MGR_CMD_SET_TC10_SUPL_VER_SKT_NI,
    APP_MGR_CMD_SET_TC10_USE_APN_NI,
    APP_MGR_CMD_SET_TC10_USE_APN_SI,
    APP_MGR_CMD_SET_CP_PRIVACY_OVERRIDE,
    APP_MGR_CMD_SET_SUPL_ADDR_NI,
    APP_MGR_CMD_SET_RRLP_GOOGLE_SUPL,
    APP_MGR_CMD_SET_SUPL2_CAP_EXT_DISABLE,
    APP_MGR_CMD_SET_NI_STATISTIC_ENABLE,
    APP_MGR_CMD_SET_UP_OPERATION_MODE,  // 510
    APP_MGR_CMD_SET_GLONASS_MSA_ENABLE,
    APP_MGR_CMD_SET_GLONASS_MSB_ENABLE,
    APP_MGR_CMD_SET_BEIDOU_MSA_ENABLE,
    APP_MGR_CMD_SET_BEIDOU_MSB_ENABLE,
    APP_MGR_CMD_SET_GALILEO_MSA_ENABLE,
    APP_MGR_CMD_SET_GALILEO_MSB_ENABLE,
    APP_MGR_CMD_SET_TC10_AUTO_SUPL_VER_FOR_ENI,
    APP_MGR_CMD_SET_TC10_CP_LPP_GUARD_TIME_SEC,
    APP_MGR_CMD_SET_TC10_CP_CAPABILITY_VALID_ENABLE,
    APP_MGR_CMD_SET_TC10_CP_CAPABILITY_ENABLE, // 520
    APP_MGR_CMD_SET_IGNORE_EMERGENCY_EXT_SECS_FROM_FRAMEWORK,
    APP_MGR_CMD_GET_AGPSD_VERSION,
    APP_MGR_CMD_GET_IMSI,
} app_mgr_cmd_enum;

static void LOGDD(const char *fmt, ...);
static void LOGEE(const char *fmt, ...);

/******************************************************
*
*         Adaptation Layer
*
*******************************************************/
#if defined(__ANDROID_OS__) | defined(__KAIOS__)
static void _LOGD(const char* message) {
    __android_log_print(ANDROID_LOG_DEBUG, "[agps]", "%s", message);
}

static void _LOGE(const char* message) {
    __android_log_print(ANDROID_LOG_DEBUG, "[agps] ERR:", "%s", message);
}

// -1 means failure
static int socket_connect() {
    int ret;
    int fd = socket(AF_UNIX, SOCK_STREAM, 0);
    if(fd < 0) {
        LOGDD("socket() failed fd=%d\n", fd);
        return -1;
    }

    ret = socket_local_client_connect(
                fd,
                AGPS_INTERFACE_PATH,
                1,
                SOCK_STREAM);
    if(ret < 0) {
        close(fd);
        LOGDD("socket_local_client_connect() failed ret=%d\n", ret);
        return -1;
    }

    return fd;
}
#elif defined(__LINUX_OS__) | defined(__YOCTO_OS__)
static void _LOGD(const char* message) {
    printf("%s\n", message);
    fflush(stdout);
}

static void _LOGE(const char* message) {
    printf("%s\n", message);
    fflush(stdout);
}

// -1 means failure
int do_socket_connect(const char* path) {
    struct sockaddr_un addr;
    int fd = socket(PF_LOCAL, SOCK_STREAM, 0);
    if(fd < 0) {
        LOGDD("socket() failed fd=%d\n", fd);
        return -1;
    }

    memset(&addr, 0, sizeof(addr));
    addr.sun_path[0] = 0;
    memcpy(addr.sun_path + 1, path, strlen(path));
    addr.sun_family = AF_UNIX;

    if (connect(fd, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
        LOGEE("connect failed reason=[%s] path=[%s]\n", strerror(errno), path);
        close(fd);
        return -1;
    }

    return fd;
}

int socket_connect() {
    return do_socket_connect(AGPS_INTERFACE_PATH);
}

#endif

/******************************************************
*
*         Implementation Utils
*
*******************************************************/
static void LOGDD(const char *fmt, ...) {
    char out_buf[1100] = {0};
    char buf[1024] = {0};
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);

    sprintf(out_buf, "%s", buf);
    _LOGD(out_buf);
}

static void LOGEE(const char *fmt, ...) {
    char out_buf[1100] = {0};
    char buf[1024] = {0};
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);

    sprintf(out_buf, "%s", buf);
    _LOGE(out_buf);
}

//-1 means failure
static int safe_write(int fd, void* buf, int len) {
    int n, retry = 10;

    if(fd < 0 || buf == NULL || len < 0) {
        LOGEE("safe_write fd=%d buf=%p len=%d\n", fd, buf, len);
        return -1;
    }

    while((n = write(fd, buf, len)) != len) {
        if(errno == EINTR) continue;
        if(errno == EAGAIN) {
            if(retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
            goto exit;
        }
        goto exit;
    }
    return n;
exit:
    LOGEE("safe_write reason=[%s]%d\n", strerror(errno), errno);
    return -1;
}


//-1 means failure
static int safe_read(int fd, void* buf, int len) {
    int n, retry = 10;

    if(fd < 0 || buf == NULL || len < 0) {
        LOGEE("safe_read fd=%d buf=%p len=%d\n", fd, buf, len);
        return -1;
    }

    if(len == 0) {
        return 0;
    }

    while((n = read(fd, buf, len)) < 0) {
        if(errno == EINTR) continue;
        if(errno == EAGAIN) {
            if(retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
            goto exit;
        }
        goto exit;
    }
    return n;

exit:
    if(errno != EAGAIN) {
        LOGEE("safe_read reason=[%s] fd=%d len=%d buf=%p\n",
            strerror(errno), fd, len, buf);
    }
    return -1;
}

static char socket_get_byte(int fd) {
    int read_len = 0;
    char buff[1] = {0};
    int offset = 0;

    read_len = safe_read(fd, buff, sizeof(buff));
    if(read_len != sizeof(buff)) {
        LOGEE("socket_get_byte read_len=%d\n", read_len);
    }
    return get_byte(buff, &offset);
}

#if 0 // unused
static short socket_get_short(int fd) {
    int read_len = 0;
    char buff[2] = {0};
    int offset = 0;

    read_len = safe_read(fd, buff, sizeof(buff));
    if(read_len != sizeof(buff)) {
        LOGEE("socket_get_short read_len=%d\n", read_len);
    }
    return get_short(buff, &offset);
}
#endif

static int socket_get_int(int fd) {
    int read_len = 0;
    char buff[4] = {0};
    int offset = 0;

    read_len = safe_read(fd, buff, sizeof(buff));
    if(read_len != sizeof(buff)) {
        LOGEE("socket_get_int read_len=%d\n", read_len);
    }
    return get_int(buff, &offset);
}

static long long socket_get_long(int fd) {
    int read_len = 0;
    char buff[8] = {0};
    int offset = 0;

    read_len = safe_read(fd, buff, sizeof(buff));
    if(read_len != sizeof(buff)) {
        LOGEE("socket_get_long read_len=%d\n", read_len);
    }
    return get_long(buff, &offset);
}

#if 0 // unused
static float socket_get_float(int fd) {
    int read_len = 0;
    char buff[4] = {0};
    int offset = 0;

    read_len = safe_read(fd, buff, sizeof(buff));
    if(read_len != sizeof(buff)) {
        LOGEE("socket_get_float read_len=%d\n", read_len);
    }
    return get_float(buff, &offset);
}

static double socket_get_double(int fd) {
    int read_len = 0;
    char buff[8] = {0};
    int offset = 0;

    read_len = safe_read(fd, buff, sizeof(buff));
    if(read_len != sizeof(buff)) {
        LOGEE("socket_get_double read_len=%d\n", read_len);
    }
    return get_double(buff, &offset);
}
#endif

static char* socket_get_string(int fd, char* buff, int buff_len) {
    int read_len = 0;

    char ret = socket_get_byte(fd);
    if(ret == 0) {
        return NULL;
    } else {
        int len = socket_get_int(fd);
        if(len > buff_len) {
            LOGEE("socket_get_string your buff len=%d is too small, need len=%d\n",
                buff_len, len);
            return NULL;
        }

        read_len = safe_read(fd, buff, len);
        if(read_len != len) {
            LOGEE("socket_get_string read_len=%d len=%d\n", read_len, len);
            return NULL;
        }

        return buff;
    }
}

static int socket_get_binary(int fd, char* buff) {
    int read_len = 0;

    int len = socket_get_int(fd);
    if(len > 0) {
        read_len = safe_read(fd, buff, len);
        if(read_len != len) {
            LOGEE("socket_get_binary read_len=%d len=%d\n", read_len, len);
            return 0;
        }
    }
    return len;
}

void dump_agps_intf_supl_profile(agps_intf_supl_profile profile) {
    LOGDD("name=%s", profile.name);
    LOGDD("addr=%s", profile.addr);
    LOGDD("port=%d", profile.port);
    LOGDD("tls=%d", profile.tls);
    LOGDD("mcc_mnc=%s", profile.mcc_mnc);
    LOGDD("app_id=%s", profile.app_id);
    LOGDD("provider_id=%s", profile.provider_id);
    LOGDD("default_apn=%s", profile.default_apn);
    LOGDD("optional_apn=%s", profile.optional_apn);
    LOGDD("optional_apn_2=%s", profile.optional_apn_2);
    LOGDD("address_type=%s", profile.address_type);
}

void dump_agps_intf_agps_config(agps_intf_agps_config config) {
    LOGDD("agps_setting");
    LOGDD("  agps_enable=%d", config.agps_setting.agps_enable);
    LOGDD("  agps_protocol=%d (0=UP 1=CP)", config.agps_setting.agps_protocol);
    LOGDD("  gpevt=%d", config.agps_setting.gpevt);
    LOGDD("  e911_gps_icon_enable=%d", config.agps_setting.e911_gps_icon_enable);
    LOGDD("  lppe_network_location_disable=%d", config.agps_setting.lppe_network_location_disable);

    LOGDD("cp_setting");
    LOGDD("  molr_pos_method=%d (0=LOC_EST 1=ASSIST_DATA)", config.cp_setting.molr_pos_method);
    LOGDD("  external_addr_enable=%d", config.cp_setting.external_addr_enable);
    LOGDD("  external_addr=%s", config.cp_setting.external_addr);
    LOGDD("  mlc_number_enable=%d", config.cp_setting.mlc_number_enable);
    LOGDD("  mlc_number=%s", config.cp_setting.mlc_number);
    LOGDD("  cp_auto_reset=%d", config.cp_setting.cp_auto_reset);
    LOGDD("  epc_molr_lpp_payload_enable=%d", config.cp_setting.epc_molr_lpp_payload_enable);
    LOGDD("  epc_molr_lpp_payload_len=%d", config.cp_setting.epc_molr_lpp_payload_len);
    LOGDD("  molr_pos_method=0x%02x 0x%02x 0x%02x",
        config.cp_setting.epc_molr_lpp_payload[0] & 0xff,
        config.cp_setting.epc_molr_lpp_payload[1] & 0xff,
        config.cp_setting.epc_molr_lpp_payload[2] & 0xff);

    LOGDD("up_setting");
    LOGDD("  ca_enable=%d", config.up_setting.ca_enable);
    LOGDD("  udp_enable=%d", config.up_setting.udp_enable);
    LOGDD("  ni_request=%d", config.up_setting.ni_request);
    LOGDD("  roaming=%d", config.up_setting.roaming);
    LOGDD("  cdma_preferred=%d (0=WCDMA 1=CDMA 2=CDMA_FORCE)", config.up_setting.cdma_preferred);
    LOGDD("  pref_method=%d (0=MA 1=MB 2=NO_PREFER)", config.up_setting.pref_method);
    LOGDD("  supl_version=%d (1=SUPL1 2=SUPL2)", config.up_setting.supl_version);
    LOGDD("  tls_version=%d (0=1_0 1=1_1 2=1_2)", config.up_setting.tls_version);
    LOGDD("  supl_log=%d", config.up_setting.supl_log);
    LOGDD("  msa_enable=%d", config.up_setting.msa_enable);
    LOGDD("  msb_enable=%d", config.up_setting.msb_enable);
    LOGDD("  ecid_enable=%d", config.up_setting.ecid_enable);
    LOGDD("  otdoa_enable=%d", config.up_setting.otdoa_enable);
    LOGDD("  autonomous_enable=%d", config.up_setting.autonomous_enable);
    LOGDD("  aflt_enable=%d", config.up_setting.aflt_enable);
    LOGDD("  qop_hacc=%d", config.up_setting.qop_hacc);
    LOGDD("  qop_vacc=%d", config.up_setting.qop_vacc);
    LOGDD("  qop_loc_age=%d", config.up_setting.qop_loc_age);
    LOGDD("  qop_delay=%d", config.up_setting.qop_delay);
    LOGDD("  lpp_enable=%d", config.up_setting.lpp_enable);
    LOGDD("  cert_from_sdcard=%d", config.up_setting.cert_from_sdcard);
    LOGDD("  up_setting.ut2=%d", config.up_setting.ut2);
    LOGDD("  up_setting.ut3=%d", config.up_setting.ut3);
    LOGDD("  supl_ver_minor=%d", config.up_setting.supl_ver_minor);
    LOGDD("  supl_ver_ser_ind=%d", config.up_setting.supl_ver_ser_ind);
    LOGDD("  supl_log=%d", config.up_setting.supl_log);
    LOGDD("  no_sensitive_log=%d", config.up_setting.no_sensitive_log);
    LOGDD("  apn_enable=%d", config.up_setting.apn_enable);
    LOGDD("  sync_to_slp=%d", config.up_setting.sync_to_slp);
    LOGDD("  imsi_enable=%d", config.up_setting.imsi_enable);
    LOGDD("  cp_lppe_enable=%d", config.cp_setting.cp_lppe_enable);
    LOGDD("  up_lppe_enable=%d", config.up_setting.up_lppe_enable);
    LOGDD("  aosp_profile_enable=%d", config.up_setting.aosp_profile_enable);
    LOGDD("  bind_nlp_setting_to_supl=%d", config.up_setting.bind_nlp_setting_to_supl);
    LOGDD("  lbs_log_enable=%d", config.agps_setting.lbs_log_enable);
    LOGDD("  tcp_keepalive=%d", config.up_setting.tcp_keepalive);
    LOGDD("  sib8_sib16_enable=%d", config.gnss_setting.sib8_sib16_enable);
    LOGDD("  a_glonass_satellite_enable=%d", config.gnss_setting.a_glonass_satellite_enable);
    LOGDD("  a_beidou_satellite_enable=%d", config.gnss_setting.a_beidou_satellite_enable);
    LOGDD("  a_galileo_satellite_enable=%d", config.gnss_setting.a_galileo_satellite_enable);

    LOGDD("cur_supl_profile");
    LOGDD("  name=%s", config.cur_supl_profile.name);
    LOGDD("  addr=%s", config.cur_supl_profile.addr);
    LOGDD("  port=%d", config.cur_supl_profile.port);
    LOGDD("  tls=%d", config.cur_supl_profile.tls);
    LOGDD("  mcc_mnc=%s", config.cur_supl_profile.mcc_mnc);
    LOGDD("  app_id=%s", config.cur_supl_profile.app_id);
    LOGDD("  provider_id=%s", config.cur_supl_profile.provider_id);
    LOGDD("  default_apn=%s", config.cur_supl_profile.default_apn);
    LOGDD("  optional_apn=%s", config.cur_supl_profile.optional_apn);
    LOGDD("  optional_apn_2=%s", config.cur_supl_profile.optional_apn_2);
    LOGDD("  address_type=%s", config.cur_supl_profile.address_type);
}

void dump_agps_intf_profiling_info(agps_intf_profiling_info profiling) {
    int i = 0;
    LOGDD("element_num=%d", profiling.element_num);
    for(i = 0; i < profiling.element_num; i++) {
        agps_intf_profiling_element* element = &profiling.elements[i];
        LOGDD("  i=%d type=%d timestamp=%lld message=[%s]\n", i, element->type, element->timestamp, element->message);
    }
}

int set_template_0(app_mgr_cmd_enum cmd) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return -1;
    }

    // write
    put_int(buff, &offset, cmd);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return -1;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return 0;
}

int set_template_1(app_mgr_cmd_enum cmd, char data) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return -1;
    }

    // write
    put_int(buff, &offset, cmd);
    put_byte(buff, &offset, data);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return -1;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return 0;
}

int set_template_1_int(app_mgr_cmd_enum cmd, int data) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return -1;
    }

    // write
    put_int(buff, &offset, cmd);
    put_int(buff, &offset, data);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return -1;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return 0;
}

int get_template_agps_config(app_mgr_cmd_enum cmd, agps_intf_agps_config *config) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return -1;
    }

    // write
    put_int(buff, &offset, cmd);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return -1;
    }

    // read
    config->agps_setting.agps_enable = socket_get_byte(fd);
    config->agps_setting.agps_protocol = socket_get_int(fd);
    config->agps_setting.gpevt = socket_get_byte(fd);

    config->cp_setting.molr_pos_method = socket_get_int(fd);
    config->cp_setting.external_addr_enable = socket_get_byte(fd);
    socket_get_string(fd, config->cp_setting.external_addr, sizeof(config->cp_setting.external_addr));
    config->cp_setting.mlc_number_enable = socket_get_byte(fd);
    socket_get_string(fd, config->cp_setting.mlc_number, sizeof(config->cp_setting.mlc_number));
    config->cp_setting.cp_auto_reset = socket_get_byte(fd);
    config->cp_setting.epc_molr_lpp_payload_enable = socket_get_byte(fd);
    config->cp_setting.epc_molr_lpp_payload_len =
        socket_get_binary(fd, config->cp_setting.epc_molr_lpp_payload);

    config->up_setting.ca_enable = socket_get_byte(fd);
    config->up_setting.ni_request = socket_get_byte(fd);
    config->up_setting.roaming = socket_get_byte(fd);
    config->up_setting.cdma_preferred = socket_get_int(fd);
    config->up_setting.pref_method = socket_get_int(fd);
    config->up_setting.supl_version = socket_get_int(fd);
    config->up_setting.tls_version = socket_get_int(fd);
    config->up_setting.supl_log = socket_get_byte(fd);
    config->up_setting.msa_enable = socket_get_byte(fd);
    config->up_setting.msb_enable = socket_get_byte(fd);
    config->up_setting.ecid_enable = socket_get_byte(fd);
    config->up_setting.otdoa_enable = socket_get_byte(fd);
    config->up_setting.qop_hacc = socket_get_int(fd);
    config->up_setting.qop_vacc = socket_get_int(fd);
    config->up_setting.qop_loc_age = socket_get_int(fd);
    config->up_setting.qop_delay = socket_get_int(fd);
    config->up_setting.lpp_enable = socket_get_byte(fd);
    config->up_setting.cert_from_sdcard = socket_get_byte(fd);

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V14) {
        config->up_setting.auto_profile_enable = socket_get_byte(fd);
        config->up_setting.ut2 = socket_get_byte(fd);
        config->up_setting.ut3 = socket_get_byte(fd);
        config->up_setting.apn_enable = socket_get_byte(fd);
        config->up_setting.sync_to_slp = socket_get_byte(fd);
        config->up_setting.udp_enable = socket_get_byte(fd);
        config->up_setting.autonomous_enable = socket_get_byte(fd);
        config->up_setting.aflt_enable = socket_get_byte(fd);
        config->up_setting.imsi_enable = socket_get_byte(fd);

        config->gnss_setting.sib8_sib16_enable = socket_get_byte(fd);
        config->gnss_setting.gps_satellite_enable = socket_get_byte(fd);
        config->gnss_setting.glonass_satellite_enable = socket_get_byte(fd);
        config->gnss_setting.beidou_satellite_enable = socket_get_byte(fd);
        config->gnss_setting.galileo_satellite_enable = socket_get_byte(fd);
        config->gnss_setting.gps_satellite_support = socket_get_byte(fd);
        config->gnss_setting.glonass_satellite_support = socket_get_byte(fd);
        config->gnss_setting.beidou_satellite_support = socket_get_byte(fd);
        config->gnss_setting.galileo_satellite_support = socket_get_byte(fd);

        config->up_setting.supl_ver_minor = socket_get_byte(fd);
        config->up_setting.supl_ver_ser_ind = socket_get_byte(fd);

        config->gnss_setting.a_glonass_satellite_enable = socket_get_byte(fd);
    }

    socket_get_string(fd, config->cur_supl_profile.name, sizeof(config->cur_supl_profile.name));
    socket_get_string(fd, config->cur_supl_profile.addr, sizeof(config->cur_supl_profile.addr));
    config->cur_supl_profile.port = socket_get_int(fd);
    config->cur_supl_profile.tls = socket_get_byte(fd);
    socket_get_string(fd, config->cur_supl_profile.mcc_mnc, sizeof(config->cur_supl_profile.mcc_mnc));
    socket_get_string(fd, config->cur_supl_profile.app_id, sizeof(config->cur_supl_profile.app_id));
    socket_get_string(fd, config->cur_supl_profile.provider_id, sizeof(config->cur_supl_profile.provider_id));
    socket_get_string(fd, config->cur_supl_profile.default_apn, sizeof(config->cur_supl_profile.default_apn));
    socket_get_string(fd, config->cur_supl_profile.optional_apn, sizeof(config->cur_supl_profile.optional_apn));
    socket_get_string(fd, config->cur_supl_profile.optional_apn_2, sizeof(config->cur_supl_profile.optional_apn_2));
    socket_get_string(fd, config->cur_supl_profile.address_type, sizeof(config->cur_supl_profile.address_type));

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V14) {
        socket_get_string(fd, config->cdma_profile.name, sizeof(config->cdma_profile.name));
        config->cdma_profile.mcp_enable = socket_get_byte(fd);;
        socket_get_string(fd, config->cdma_profile.mcp_addr, sizeof(config->cdma_profile.mcp_addr));
        config->cdma_profile.mcp_port = socket_get_int(fd);;
        config->cdma_profile.pde_addr_valid = socket_get_byte(fd);;
        config->cdma_profile.pde_ip_type = socket_get_int(fd);;
        socket_get_string(fd, config->cdma_profile.pde_addr, sizeof(config->cdma_profile.pde_addr));
        config->cdma_profile.pde_port = socket_get_int(fd);;
        config->cdma_profile.pde_url_valid = socket_get_byte(fd);;
        socket_get_string(fd, config->cdma_profile.pde_url_addr, sizeof(config->cdma_profile.pde_url_addr));
    }

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V20) {
        //V15
        config->agps_setting.e911_gps_icon_enable = socket_get_byte(fd);
        //V16
        config->agps_setting.e911_open_gps = socket_get_byte(fd);
        //V17
        config->gnss_setting.a_gps_satellite_enable = socket_get_byte(fd);
        config->gnss_setting.a_beidou_satellite_enable = socket_get_byte(fd);
        config->gnss_setting.a_galileo_satellite_enable = socket_get_byte(fd);
        //V18
        config->up_setting.sha_version = socket_get_int(fd);
        config->up_setting.preferred_2g3g_cell_age = socket_get_int(fd);
        config->up_setting.ut1 = socket_get_byte(fd);
        config->up_setting.no_sensitive_log = socket_get_byte(fd);
        config->up_setting.tls_reuse_enable = socket_get_byte(fd);
        config->up_setting.imsi_cache_enable = socket_get_byte(fd);
        config->up_setting.supl_raw_data_enable = socket_get_byte(fd);
        config->up_setting.tc10_enable = socket_get_byte(fd);
        config->up_setting.tc10_use_apn = socket_get_byte(fd);
        config->up_setting.tc10_use_fw_dns = socket_get_byte(fd);
        config->up_setting.allow_ni_for_gps_off = socket_get_byte(fd);
        config->up_setting.force_otdoa_assist_req = socket_get_byte(fd);
        config->cp_setting.reject_non911_nilr_enable = socket_get_byte(fd);
        config->cp_setting.cp_2g_disable = socket_get_byte(fd);
        config->cp_setting.cp_3g_disable = socket_get_byte(fd);
        config->cp_setting.cp_4g_disable = socket_get_byte(fd);
        config->agps_setting.tc10_ignore_fw_config = socket_get_byte(fd);
        config->agps_setting.lppe_hide_wifi_bt_status = socket_get_byte(fd);
        //V19
        config->agps_setting.lppe_network_location_disable = socket_get_byte(fd);
        config->cp_setting.cp_lppe_enable = socket_get_byte(fd);
        config->up_setting.up_lppe_enable = socket_get_byte(fd);
        //V20
        config->cp_setting.support_cp_lppe = socket_get_byte(fd);
        config->gnss_setting.mnl_support_lppe = socket_get_byte(fd);
    }

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V21) {
        config->agps_setting.agps_nvram_enable = socket_get_byte(fd);
        config->agps_setting.lbs_log_enable = socket_get_byte(fd);
        config->agps_setting.lppe_crowd_source_confident = socket_get_int(fd);

        config->up_setting.esupl_apn_mode = socket_get_int(fd);
        config->up_setting.tcp_keepalive = socket_get_int(fd);
        config->up_setting.aosp_profile_enable = socket_get_byte(fd);
        config->up_setting.bind_nlp_setting_to_supl = socket_get_byte(fd);
    }

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V22) {
        config->agps_setting.ignore_si_for_e911 = socket_get_byte(fd);
        config->cp_setting.cp_lppe_wlan_enable = socket_get_byte(fd);
        config->cp_setting.cp_lppe_srn_enable = socket_get_byte(fd);
        config->cp_setting.cp_lppe_sensor_enable = socket_get_byte(fd);
        config->cp_setting.cp_lppe_dbh_enable = socket_get_byte(fd);

        config->up_setting.up_lppe_wlan_enable = socket_get_byte(fd);
        config->up_setting.up_lppe_srn_enable = socket_get_byte(fd);
        config->up_setting.up_lppe_sensor_enable = socket_get_byte(fd);
        config->up_setting.up_lppe_dbh_enable = socket_get_byte(fd);
        config->up_setting.ip_version_prefer = socket_get_int(fd);
        config->up_setting.up_lppe_in_2g3g_disable = socket_get_byte(fd);
        config->up_setting.up_rrlp_in_4g_disable = socket_get_byte(fd);
        config->up_setting.up_si_disable = socket_get_byte(fd);
    }

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V23) {
        config->up_setting.use_ni_slp = socket_get_byte(fd);
        config->agps_setting.use_tc10_config = socket_get_byte(fd);
        config->agps_setting.lppe_def_nlp_enable = socket_get_byte(fd);
    }

    if(cmd >= APP_MGR_CMD_GET_CONFIG_V24) {
        config->agps_setting.emergency_ext_secs = socket_get_int(fd);
        config->up_setting.aosp_pos_mode_enable = socket_get_byte(fd);
        config->up_setting.privacy_override_mode = socket_get_int(fd);
    }

    config->valid = 1;
    // read ACK
    socket_get_byte(fd);

    close(fd);
    return 0;
}

/******************************************************
*
*         Implementation API
*
*******************************************************/

agps_intf_agps_config get_agps_config_v3() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V3, &config);

    return config;
}

agps_intf_agps_config get_agps_config_v14() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V14, &config);
    return config;
}

agps_intf_agps_config get_agps_config_v20() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V20, &config);
    return config;
}

agps_intf_agps_config get_agps_config_v21() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V21, &config);
    return config;
}

agps_intf_agps_config get_agps_config_v22() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V22, &config);
    return config;
}

agps_intf_agps_config get_agps_config_v23() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V23, &config);
    return config;
}

agps_intf_agps_config get_agps_config_v24() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V24, &config);
    return config;
}

agps_intf_cdma_profile get_cdma_profile() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    get_template_agps_config(APP_MGR_CMD_GET_CONFIG_V14, &config);

    return config.cdma_profile;
}

agps_intf_supl_profile get_supl_profile() {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;
    agps_intf_supl_profile profile;

    memset(&profile, 0, sizeof(profile));

    fd = socket_connect();
    if(fd < 0) {
        return profile;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_GET_OMA_CP_SUPL_PROFILE);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return profile;
    }

    // read
    socket_get_string(fd, profile.name, sizeof(profile.name));
    socket_get_string(fd, profile.addr, sizeof(profile.addr));
    profile.port = socket_get_int(fd);
    profile.tls = socket_get_byte(fd);
    socket_get_string(fd, profile.mcc_mnc, sizeof(profile.mcc_mnc));
    socket_get_string(fd, profile.app_id, sizeof(profile.app_id));
    socket_get_string(fd, profile.provider_id, sizeof(profile.provider_id));
    socket_get_string(fd, profile.default_apn, sizeof(profile.default_apn));
    socket_get_string(fd, profile.optional_apn, sizeof(profile.optional_apn));
    socket_get_string(fd, profile.optional_apn_2, sizeof(profile.optional_apn_2));
    socket_get_string(fd, profile.address_type, sizeof(profile.address_type));

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return profile;
}

agps_intf_profiling_info get_agps_profiling_info() {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;
    agps_intf_profiling_info profiling;

    memset(&profiling, 0, sizeof(profiling));

    fd = socket_connect();
    if(fd < 0) {
        return profiling;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_GET_AGPS_PROFILING);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return profiling;
    }

    // read
    profiling.element_num = socket_get_int(fd);
    int i = 0;
    for(i = 0; i < profiling.element_num; i++) {
        agps_intf_profiling_element* element = &profiling.elements[i];
        element->type = socket_get_int(fd);
        element->timestamp = socket_get_long(fd);
        socket_get_string(fd, element->message, sizeof(element->message));
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return profiling;
}

agps_intf_agpsd_version get_agpsd_version() {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;
    agps_intf_agpsd_version info;

    memset(&info, 0, sizeof(info));

    fd = socket_connect();
    if(fd < 0) {
        return info;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_GET_AGPSD_VERSION);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return info;
    }

    if(socket_get_string(fd, info.agpsd_version_string, sizeof(info.agpsd_version_string))) {
        info.valid = 1;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return info;
}

agps_intf_imsi get_imsi_from_agpsd() {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;
    agps_intf_imsi info;

    memset(&info, 0, sizeof(info));

    fd = socket_connect();
    if(fd < 0) {
        return info;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_GET_IMSI);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return info;
    }

    info.valid = socket_get_byte(fd);
    socket_get_string(fd, info.imsi, sizeof(info));
    info.is_2_digit_mnc = socket_get_byte(fd);

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return info;
}

int get_emulator_mode() {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;
    int ret = 0;

    fd = socket_connect();
    if(fd < 0) {
        return 0;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_GET_EMULATOR_MODE);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return -1;
    }

    // read
    ret = socket_get_int(fd);

    // read ACK
    socket_get_byte(fd);

    close(fd);
    return ret;
}

agps_intf_agps_config get_agps_supl_profiles() {
    agps_intf_agps_config config;
    memset(&config, 0, sizeof(config));

    agps_mgr_agps_config xml;
    int i = 0;
    if (agps_xml_load(&xml, ORIGINAL_AGPES_PROFILE_PATH2)) { // for vendor partition
        LOGDD("AGPS XML load from %s", ORIGINAL_AGPES_PROFILE_PATH2);
        LOGDD("xml.supl_profiles_num = %d", xml.supl_profiles_num);

        config.supl_profiles_num = xml.supl_profiles_num;
        LOGDD("get_agps_supl_profiles[%d] name=%s, addr=%s, port=%d, tls=%d",
                i, config.supl_profiles[0].name, config.supl_profiles[0].addr,
                config.supl_profiles[0].port, config.supl_profiles[0].tls);
        for(i = 0; i < xml.supl_profiles_num; i++) {
            LBS_STRNCPY(config.supl_profiles[i].name, xml.supl_profiles[i].name, sizeof(config.supl_profiles[i].name));
            LBS_STRNCPY(config.supl_profiles[i].addr, xml.supl_profiles[i].addr, sizeof(config.supl_profiles[i].addr));
            config.supl_profiles[i].port = xml.supl_profiles[i].port;
            config.supl_profiles[i].tls = xml.supl_profiles[i].tls;
        }
        free(xml.supl_profiles);
    } else {
        LOGDD("Failed to load AGPS XML from %s", ORIGINAL_AGPES_PROFILE_PATH2);
    }
    return config;

}

void set_agps_enabled(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AGPS_ENABLE, enabled);
}

void set_protocol(agps_intf_agps_protocol protocol) {
    set_template_1(APP_MGR_CMD_SET_PROTOCOL, protocol);
}

void set_cdma_pref(agps_intf_cdma_preferred cdma_preferred) {
    set_template_1(APP_MGR_CMD_SET_CDMA_PREF, cdma_preferred);
}

void set_up_pref_method(agps_intf_pref_method pref_method) {
    set_template_1(APP_MGR_CMD_SET_UP_PREF_METHOD, pref_method);
}

void set_pos_technology_msa(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_POS_TECHNOLOGY_MSA, enabled);
}

void set_pos_technology_msb(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_POS_TECHNOLOGY_MSB, enabled);
}

void set_pos_technology_ecid(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_POS_TECHNOLOGY_ECID, enabled);
}

void set_pos_technology_otdoa(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_POS_TECHNOLOGY_OTDOA, enabled);
}

void set_pos_technology_autonomous(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AUTONOMOUS_ENABLE, enabled);
}

void set_pos_technology_aflt(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AFLT_ENABLE, enabled);
}

void set_supl_version(agps_intf_supl_version supl_version) {
    set_template_1(APP_MGR_CMD_SET_SUPL_VERSION, supl_version);
}

void set_tls_version(agps_intf_tls_version tls_version) {
    set_template_1(APP_MGR_CMD_SET_TLS_VERSION, tls_version);
}

void set_cert_verify(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_CA_ENABLE, enabled);
}

void set_supl_apn_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_SUPL_APN_ENABLE, enabled);
}

void set_sync_to_slp_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_SYNC_TO_SLP, enabled);
}

void set_udp_enable() {
    set_template_0(APP_MGR_CMD_SET_UDP_ENABLE);
}

void set_udp_enable_v2(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_UDP_ENABLE_V2, enabled);
}

void set_lpp_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPP_ENABLE, enabled);
}

void set_cert_from_sdcard(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_CERT_FROM_SDCARD_ENABLE, enabled);
}

void set_imsi_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_IMSI_ENABLE, enabled);
}

void set_auto_profile_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AUTO_PROFILE_ENABLE, enabled);
}

void set_supl_ut1(int timeout_in_second) {
    set_template_1(APP_MGR_CMD_SET_UT1, timeout_in_second);
}

void set_supl_ut2(int timeout_in_second) {
    set_template_1(APP_MGR_CMD_SET_UT2, timeout_in_second);
}

void set_supl_ut3(int timeout_in_second) {
    set_template_1(APP_MGR_CMD_SET_UT3, timeout_in_second);
}

void set_supl_sha_version(int version) {
    set_template_1_int(APP_MGR_CMD_SET_SUPL_SHA_VERSION, version);
}

void set_supl_tls_version(int version) {
    set_template_1_int(APP_MGR_CMD_SET_SUPL_TLS_VERSION, version);
}

void set_supl_ver_minor(int version) {
    set_template_1_int(APP_MGR_CMD_SET_SUPL_VER_MINOR, version);
}

void set_supl_ver_ser_ind(int version) {
    set_template_1_int(APP_MGR_CMD_SET_SUPL_VER_SER_IND, version);
}

void set_sib8_16_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_SIB8_16_ENABLE, enabled);
}

void set_gps_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_GPS_ENABLE, enabled);
}

void set_a_gps_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_A_GPS_ENABLE, enabled);
}

void set_glonass_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_GLONASS_ENABLE, enabled);
}

void set_a_glonass_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_A_GLONASS_ENABLE, enabled);
}

void set_beidou_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_BEIDOU_ENABLE, enabled);
}

void set_a_beidou_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_A_BEIDOU_ENABLE, enabled);
}

void set_galileo_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_GALILEO_ENABLE, enabled);
}

void set_a_galileo_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_A_GALILEO_ENABLE, enabled);
}

void set_supl_profile(const char* addr, int port, agps_bool tls_enabled) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_SUPL_PROFILE);
    put_string(buff, &offset, addr);
    put_int(buff, &offset, port);
    put_byte(buff, &offset, tls_enabled);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

//hacc, vacc: K value, loc_age: seconds from 0 to 65535, delay: 2^N, N from (0..7), unit is seconds
void set_qop(int hacc, int vacc, int loc_age, int delay) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_QOP);
    put_int(buff, &offset, hacc);
    put_int(buff, &offset, vacc);
    put_int(buff, &offset, loc_age);
    put_int(buff, &offset, delay);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_molr_pos_methd(agps_intf_molr_pos_method molr_pos_method) {
    set_template_1(APP_MGR_CMD_SET_MOLR_POS_METHDO, molr_pos_method);
}

void set_external_addr(agps_bool enabled, const char* external_addr) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_EXTERNAL_ADDR);
    put_byte(buff, &offset, enabled);
    put_string(buff, &offset, external_addr);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_mlc_number(agps_bool enabled, const char* mlc_number) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_MLC_NUMBER);
    put_byte(buff, &offset, enabled);
    put_string(buff, &offset, mlc_number);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_cp_auto_reset(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_CP_AUTO_RESET, enabled);
}

void set_allow_ni(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_ALLOW_NI, enabled);
}

void set_allow_roaming(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_ALLOW_ROAMING, enabled);
}

void set_supl_to_file(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_SUPL_2_FILE, enabled);
}

void set_reset_to_default() {
    set_template_0(APP_MGR_CMD_SET_RESET_TO_DEFAULT);
}

void set_supl_profile_full(agps_intf_supl_profile supl_profile) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_OMA_CP_SUPL_PROFILE);
    put_string(buff, &offset, supl_profile.name);
    put_string(buff, &offset, supl_profile.addr);
    put_int(buff, &offset, supl_profile.port);
    put_byte(buff, &offset, supl_profile.tls);
    put_string(buff, &offset, supl_profile.mcc_mnc);
    put_string(buff, &offset, supl_profile.app_id);
    put_string(buff, &offset, supl_profile.provider_id);
    put_string(buff, &offset, supl_profile.default_apn);
    put_string(buff, &offset, supl_profile.optional_apn);
    put_string(buff, &offset, supl_profile.optional_apn_2);
    put_string(buff, &offset, supl_profile.address_type);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_epc_molr_pdu_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_EPC_MOLR_PDU_ENABLE, enabled);
}

void set_epc_molr_pdu(const char* data, int data_len) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_EPC_MOLR_PDU);
    put_binary(buff, &offset, data, data_len);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_pde_profile(const char* addr, int port) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_PDE_PROFILE);
    put_string(buff, &offset, addr);
    put_int(buff, &offset, port);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_e911_gps_icon_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_E911_GPS_ICON_ENABLE, enabled);
}

void set_e911_open_gps_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_E911_OPEN_GPS_ENABLE, enabled);
}

void set_preferred_2g3g_cell_age(int preferred2g3gCellAge) {
    set_template_1_int(APP_MGR_CMD_SET_PREF_2G3G_CELL_AGE, preferred2g3gCellAge);
}

void set_no_sensitive_log(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_NO_SENSITIVE_LOG, enabled);
}

void set_tls_reuse_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_TLS_REUSE_ENABLE, enabled);
}

void set_imsi_cache_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_IMSI_CACHE_ENABLE, enabled);
}

void set_supl_raw_data_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_SUPL_RAW_DATA_ENABLE, enabled);
}

void set_tc10_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_TC10_ENABLE, enabled);
}

void set_tc10_use_apn(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_TC10_USE_APN, enabled);
}

void set_tc10_use_fw_dns(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_TC10_USE_FW_DNS, enabled);
}

void set_allow_ni_for_gps_off(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_ALLOW_NI_FOR_GPS_OFF, enabled);
}

void set_force_otdoa_assist_req(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_FORCE_OTDOA_ASSIST_REQ, enabled);
}

void set_reject_non911_nilr_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_REJECT_NON911_NILR_ENABLE, enabled);
}

void set_cp_2g_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_CP_2G_DISABLE, enabled);
}

void set_cp_3g_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_CP_3G_DISABLE, enabled);
}

void set_cp_4g_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_CP_4G_DISABLE, enabled);
}

void set_tc10_ignore_fw_config(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_TC10_IGNORE_FW_CONFIG, enabled);
}

void set_lppe_hide_wifi_bt_status(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_HIDE_WIFI_BT_STATUS, enabled);
}

void set_lppe_network_location_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_NETWORK_LOCATION_DISABLE, enabled);
}

void set_lppe_cp_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_CP_ENABLE, enabled);
}

void set_lppe_up_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_UP_ENABLE, enabled);
}

void set_vzw_debug_screen_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_VZW_DEBUG_SCREEN_ENABLE, enabled);
}

void set_aosp_profile_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AOSP_PROFILE_ENABLE, enabled);
}

void set_bind_nlp_setting_to_supl(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_BIND_NLP_SETTING_TO_SUPL, enabled);
}

void set_esupl_apn_mode(int mode) {
    set_template_1_int(APP_MGR_CMD_SET_ESUPL_APN_MODE, mode);
}

void set_tcp_keep_alive(int time) {
    set_template_1_int(APP_MGR_CMD_SET_TCP_KEEPALIVE, time);
}

void set_agps_nvram_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AGPS_NVRAM_ENABLE, enabled);
}

void set_lbs_log_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LBS_LOG_ENABLE, enabled);
}

void set_lppe_crowd_source_confident(int confident) {
    set_template_1_int(APP_MGR_CMD_SET_LPPE_CROWD_SOURCE_CONFIDENT, confident);
}

void set_ingore_si_for_e911(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_IGNORE_SI_FOR_E911, enabled);
}

void set_lppe_cp_wlan_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_CP_WLAN_ENABLE, enabled);
}

void set_lppe_cp_srn_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_CP_SRN_ENABLE, enabled);
}

void set_lppe_cp_sensor_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_CP_SENSOR_ENABLE, enabled);
}

void set_lppe_cp_dbh_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_CP_DBH_ENABLE, enabled);
}

void set_lppe_up_wlan_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_UP_WLAN_ENABLE, enabled);
}

void set_lppe_up_srn_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_UP_SRN_ENABLE, enabled);
}

void set_lppe_up_sensor_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_UP_SENSOR_ENABLE, enabled);
}

void set_lppe_up_dbh_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_UP_DBH_ENABLE, enabled);
}

void set_ip_version_prefer(agps_supl_ip_version_type ip_version_type) {
    set_template_1(APP_MGR_CMD_SET_IP_VERSION_PREFER, ip_version_type);
}

void set_up_lpp_in_2g3g_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_UP_LPP_IN_2G3G_DISABLE, enabled);
}

void set_up_rrlp_in_4g_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_UP_RRLP_IN_4G_DISABLE, enabled);
}

void set_up_si_disable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_UP_SI_DISABLE, enabled);
}

void set_up_use_ni_slp(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_USE_NI_SLP, enabled);
}

void set_use_tc10_config(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_USE_TC10_CONFIG, enabled);
}

void set_lppe_def_nlp_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_LPPE_DEF_NLP_ENABLE, enabled);
}

void set_up_aosp_pos_mode_enable(agps_bool enabled) {
    set_template_1(APP_MGR_CMD_SET_AOSP_POS_MODE_ENABLE, enabled);
}

void set_privacy_override_mode(int flags) {
    set_template_1_int(APP_MGR_CMD_SET_PRIVACY_OVERRIDE_MODE, flags);
}

void set_emergency_ext_secs(int seconds) {
    set_template_1_int(APP_MGR_CMD_SET_EMERGENCY_EXT_SECS, seconds);
}

void start_supl_2_periodic_session() {
    set_template_0(APP_MGR_CMD_START_PERIODIC);
}

void stop_supl_2_periodic_session() {
    set_template_0(APP_MGR_CMD_ABORT_PERIODIC);
}

void start_supl_2_area_event_session(agps_intf_area_event_type type) {
    set_template_1_int(APP_MGR_CMD_START_AREA_EVENT, type);
}

void stop_supl_2_area_event_session() {
    set_template_0(APP_MGR_CMD_ABORT_AREA_EVENT);
}

void start_test_case(int i) {
    set_template_1_int(APP_MGR_CMD_START_TEST_CASE, i);
}

void start_test_button(int i) {
    set_template_1_int(APP_MGR_CMD_START_TEST_BUTTON, i);
}

void do_reset_agpsd() {
    //TODO need to do IT
    set_template_0(APP_MGR_CMD_START_RESET_AGPSD);
}

void start_emualator_mode(agps_bool enabled) {
    //TODO need to do IT
    set_template_1(APP_MGR_CMD_START_EMULATOR_MODE, enabled);
}

void set_up_tc10_supl_ssl_method(int m) {
    set_template_1_int(APP_MGR_CMD_SET_TC10_SUPL_SSL_METHOD, m);
}

void set_up_tc10_auto_supl_ver_for_ni(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_TC10_AUTO_SUPL_VER_FOR_NI, enable);
}

void set_up_tc10_supl_ver_skt_ni(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_TC10_SUPL_VER_SKT_NI, enable);
}

void set_up_tc10_use_apn_ni(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_TC10_USE_APN_NI, enable);
}

void set_up_tc10_use_apn_si(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_TC10_USE_APN_SI, enable);
}

void set_cp_tc10_privacy_override(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_CP_PRIVACY_OVERRIDE, enable);
}

void set_up_supl_addr_ni(const char* addr) {
    char buff[MAX_BUFF_SIZE] = {0};
    int offset = 0;
    int fd = 0;

    fd = socket_connect();
    if(fd < 0) {
        return;
    }

    // write
    put_int(buff, &offset, APP_MGR_CMD_SET_SUPL_ADDR_NI);
    put_string(buff, &offset, addr);
    if(safe_write(fd, buff, offset) == -1) {
        close(fd);
        return;
    }

    // read ACK
    socket_get_byte(fd);

    close(fd);
}

void set_up_rrlp_google_supl(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_RRLP_GOOGLE_SUPL, enable);
}

void set_up_supl2_cap_ext_disable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_SUPL2_CAP_EXT_DISABLE, enable);
}

void set_ni_statistic_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_NI_STATISTIC_ENABLE, enable);
}

void set_up_operation_mode(int m) {
    set_template_1_int(APP_MGR_CMD_SET_UP_OPERATION_MODE, m);
}

void set_up_glonass_msa_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_GLONASS_MSA_ENABLE, enable);
}

void set_up_glonass_msb_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_GLONASS_MSB_ENABLE, enable);
}

void set_up_beidou_msa_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_BEIDOU_MSA_ENABLE, enable);
}

void set_up_beidou_msb_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_BEIDOU_MSB_ENABLE, enable);
}

void set_up_galileo_msa_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_GALILEO_MSA_ENABLE, enable);
}

void set_up_galileo_msb_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_GALILEO_MSB_ENABLE, enable);
}

void set_up_tc10_auto_supl_ver_for_eni(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_TC10_AUTO_SUPL_VER_FOR_ENI, enable);
}

void set_cp_tc10_lpp_guard_time_sec(int t) {
    set_template_1_int(APP_MGR_CMD_SET_TC10_CP_LPP_GUARD_TIME_SEC, t);
}

void set_cp_tc10_capability_control_enable(agps_bool enable) {
    set_template_1(APP_MGR_CMD_SET_TC10_CP_CAPABILITY_VALID_ENABLE, enable);
}

void set_cp_tc10_capability_control(int flags) {
    set_template_1_int(APP_MGR_CMD_SET_TC10_CP_CAPABILITY_ENABLE, flags);
}

void set_ignore_emergency_ext_secs_from_framework(agps_bool does_ignore) {
    set_template_1(APP_MGR_CMD_SET_IGNORE_EMERGENCY_EXT_SECS_FROM_FRAMEWORK, does_ignore);
}

