#include "mnldinf_ext.h"
#include "mnldinf_utility.h"
#include "mnldinf_data_coder.h"
#include "mnldinf_log.h"
#include "errno.h"

//int log_dbg_level = mnldinf_LOG_LEVEL;

#ifdef LOG_TAG
#undef LOG_TAG
#define LOG_TAG "mnldinf_ext"
#endif

//static float report_time_interval = 0;
char g_mnldinf_ext_msg_buf[HAL_MNL_BUFF_SIZE_SND*2] = {0};
cyclical_buffer_t g_mnldinf_ext_cbuffer;    // io - cyclic buffer
mnldinf_ext_client_cap g_mnldinf_ext_client_cap;
bool g_mnldinf_ext_cap_setted = false;

#define DUMP_EXT_CLIENT_CAP(cap) do {\
    LOGD("[%s]:mnldinf_ext_client_cap size:%lu, gnss_support=%d", __func__, sizeof(mnldinf_ext_client_cap), (cap)->support_gnss);\
} while(0)

#define DUMP_EXT_SERVER_CAP(cap) do {\
    LOGD("[%s]:mnldinf_ext_server_cap size:%lu, gnss_support=%d", __func__, sizeof(mnldinf_ext_server_cap), (cap)->support_gnss);\
} while(0)

static gps_cmd_record ext_cmd_list[GPS_HAL_CMD_RECORD_NUM];
static int ext_cmd_rcd_idx = 0;
static time_t ext_enter_time_ms = 0;
static timer_t ext_cmd_moniter_timer = INVALID_TIMERID;
static int ext_last_record_idx = 0xFF;

void mnldinf_ext_cmd_enter_record(mnl2hal_cmd cmd) {
    int ret = 0;
    /*Clear parameters before setting*/
    memset(ext_cmd_list[ext_cmd_rcd_idx].enter_time, 0, GPS_HAL_TIME_STR_LEN);
    memset(ext_cmd_list[ext_cmd_rcd_idx].exit_time, 0, GPS_HAL_TIME_STR_LEN);
    ext_cmd_list[ext_cmd_rcd_idx].cmd = 0;
    ext_cmd_list[ext_cmd_rcd_idx].exec_time = 0;

    ext_last_record_idx = 0xFF;  //Print all history command
    ext_enter_time_ms = mnldinf_get_time_in_millisecond();
    ret = mnldinf_get_time_str(ext_cmd_list[ext_cmd_rcd_idx].enter_time, GPS_HAL_TIME_STR_LEN);
    if(ret == -1) {
        LOGW("mnldinf_get_time_str fail(%s)", strerror(errno));
    }
    ext_cmd_list[ext_cmd_rcd_idx].cmd = cmd;

    ret = mnldinf_start_timer(ext_cmd_moniter_timer, GPS_HAL_CMD_MONITER_TIMEOUT);
    if(ret == -1) {
        LOGW("start_timer fail(%s)", strerror(errno));
    }
}

void mnldinf_ext_cmd_exit_record(mnl2hal_cmd cmd) {
    if(cmd == ext_cmd_list[ext_cmd_rcd_idx].cmd) {
        int ret = 0;
        ret = mnldinf_get_time_str(ext_cmd_list[ext_cmd_rcd_idx].exit_time, GPS_HAL_TIME_STR_LEN);
        if(ret == -1) {
            LOGW("mnldinf_get_time_str fail(%s)", strerror(errno));
        }
        ext_cmd_list[ext_cmd_rcd_idx].exec_time = mnldinf_get_time_in_millisecond() - ext_enter_time_ms;
        ext_cmd_rcd_idx++;
        ext_cmd_rcd_idx = ext_cmd_rcd_idx%GPS_HAL_CMD_RECORD_NUM;  //Over-write oldest recording
        ret = mnldinf_stop_timer(ext_cmd_moniter_timer);
        if(ret == -1) {
            LOGW("mnldinf_stop_timer fail(%s)", strerror(errno));
        }
    } else {
        LOGW("cmd not matched:enter->%d, exit->%d", ext_cmd_list[ext_cmd_rcd_idx].cmd, cmd);
    }
}

void mnldinf_ext_cmd_list_dump(void) {
    int print_idx = 0;
    int cur_rcd = ext_cmd_rcd_idx;
    int print_more = 0;
    int empty_cnt = 0;

    if(ext_last_record_idx != cur_rcd) {
        print_more = 1;
        ext_last_record_idx = cur_rcd;
    }

    LOGW("Dump GPS HAL command record:");
    for(print_idx = 0; print_idx < GPS_HAL_CMD_RECORD_NUM; print_idx++){
        if(ext_cmd_list[print_idx].cmd != 0) {  //Valid cmd
            if(print_idx == cur_rcd) {
                LOGW("[%2d]%s:%3d << Current command(%lld)", print_idx, ext_cmd_list[print_idx].enter_time, ext_cmd_list[print_idx].cmd, (long long)(mnldinf_get_time_in_millisecond() - ext_enter_time_ms ));
            } else {
                if(print_more) {
                    LOGW("[%2d]%s~%s(%lld):%3d", print_idx, ext_cmd_list[print_idx].enter_time, ext_cmd_list[print_idx].exit_time, (long long)ext_cmd_list[print_idx].exec_time, ext_cmd_list[print_idx].cmd );
                }
            }
        } else {
            empty_cnt++;
        }
    }
    if(empty_cnt) {
        LOGW("empty_cnt:%d", empty_cnt);
    }
}

void mnldinf_ext_cmd_list_init(void) {
    memset(ext_cmd_list, 0, sizeof(ext_cmd_list));
    ext_cmd_rcd_idx = 0;
    ext_enter_time_ms = 0;
    ext_last_record_idx = 0xFF;

    ext_cmd_moniter_timer = mnldinf_init_timer(mnldinf_ext_cmd_list_dump);
}

//Tell server the support capability of mnld extension interface
int mnldinf_ext_capability_update(int fd) {
    //LOGI("mnldinf_ext_capability_update, fd:%d", fd);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    if(g_mnldinf_ext_cap_setted == false) {
        LOGD("mnldinf_ext_capability_update, set as default.");
        memset(&g_mnldinf_ext_client_cap, 0, sizeof(mnldinf_ext_client_cap));
        g_mnldinf_ext_client_cap.support_gnss = 1;
    }
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_EXT_CAP_SYNC);
    mnldinf_put_binary(buff, &offset, (char *)&g_mnldinf_ext_client_cap, (int)sizeof(mnldinf_ext_client_cap));

    return mnldinf_tcp_send(fd, buff, offset);
}

void mnldinf_ext_capability_config(int fd, mnldinf_ext_client_cap *cap) {
    if(cap == NULL) {
        LOGE("NULL cap !!!!fd:%d", fd);
        return;
    }
    //DUMP_EXT_CLIENT_CAP(cap);
    memset(&g_mnldinf_ext_client_cap, 0, sizeof(mnldinf_ext_client_cap));
    memcpy(&g_mnldinf_ext_client_cap, cap, sizeof(mnldinf_ext_client_cap));
    g_mnldinf_ext_cap_setted = true;
    if(-1 == mnldinf_ext_capability_update(fd)) {
        LOGE("mnldinf_ext_capability_config fail");
    }
}

int mnldinf_ext_gnss_inject_time(int fd, int64_t time, int64_t time_reference, int uncertainty) {
    /*LOGD("mnldinf_ext_gnss_inject_time  time=%zd time_reference=%zd uncertainty=%d",
        time, time_reference, uncertainty);*/
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_GPS_INJECT_TIME);
    mnldinf_put_long(buff, &offset, time);
    mnldinf_put_long(buff, &offset, time_reference);
    mnldinf_put_int(buff, &offset, uncertainty);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_gnss_inject_location(int fd, double lat, double lng, float acc) {
    // LOGD("mnldinf_ext_gnss_inject_location  lat,lng %f,%f acc=%f", lat, lng, acc);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_GPS_INJECT_LOCATION);
    mnldinf_put_double(buff, &offset, lat);
    mnldinf_put_double(buff, &offset, lng);
    mnldinf_put_float(buff, &offset, acc);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_gnss_delete_aiding_data(int fd, gnss_delete_flag flags) {
    LOGD("flag=0x%x", flags);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_GPS_DELETE_AIDING_DATA);
    mnldinf_put_int(buff, &offset, flags);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_gnss_set_position_mode(int fd, gps_pos_mode mode) {
    LOGD("mode=%d", mode);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_GPS_SET_POSITION_MODE);
    mnldinf_put_int(buff, &offset, mode);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_data_conn_open(int fd, const char* apn) {
    LOGD("apn=[%s]", apn);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_DATA_CONN_OPEN);
    mnldinf_put_string(buff, &offset, apn);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_data_conn_open_with_apn_ip_type(int fd, uint64_t network_handle, const char* apn, apn_ip_type ip_type) {
    LOGD("apn=[%s] ip_type=%d",
        apn, ip_type);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_DATA_CONN_OPEN_WITH_APN_IP_TYPE);
    mnldinf_put_long(buff, &offset, network_handle);
    mnldinf_put_string(buff, &offset, apn);
    mnldinf_put_int(buff, &offset, ip_type);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_data_conn_closed(int fd) {
    LOGD("mnldinf_ext_data_conn_closed");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_DATA_CONN_CLOSED);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_data_conn_failed(int fd) {
    LOGD("mnldinf_ext_data_conn_failed");
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_DATA_CONN_FAILED);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_set_server(int fd, agps_type type, const char* hostname, int port) {
    LOGD("type=%d hostname=[%s] port=%d",
        type, hostname, port);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_SET_SERVER);
    mnldinf_put_int(buff, &offset, type);
    mnldinf_put_string(buff, &offset, hostname);
    mnldinf_put_int(buff, &offset, port);

    return mnldinf_tcp_send(fd, buff, offset);
    return 0;
}

int mnldinf_ext_set_ref_location(int fd, cell_type type, int mcc, int mnc, int lac, int cid) {
    LOGD("ype=%d mcc=%d mnc=%d lac=%d cid=%d",
        type, mcc, mnc, lac, cid);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_SET_REF_LOCATION);
    mnldinf_put_int(buff, &offset, type);
    mnldinf_put_int(buff, &offset, mcc);
    mnldinf_put_int(buff, &offset, mnc);
    mnldinf_put_int(buff, &offset, lac);
    mnldinf_put_int(buff, &offset, cid);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_set_id(int fd, agps_id_type type, const char* setid) {
    LOGD("type=%d setid=[%s]", type, setid);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_SET_ID);
    mnldinf_put_int(buff, &offset, type);
    mnldinf_put_string(buff, &offset, setid);

    return mnldinf_tcp_send(fd, buff, offset);
}


int mnldinf_ext_ni_message(int fd, char* msg, int len) {
    LOGD("len=%d", len);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_NI_MESSAGE);
    mnldinf_put_binary(buff, &offset, msg, len);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_send_pmtk(int fd, char* msg, int len) {
    LOGD("len=%d", len);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_SEND_PMTK);
    mnldinf_put_binary(buff, &offset, msg, len);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_ni_respond(int fd, int notif_id, ni_user_response_type user_response) {
    LOGD("notif_id=%d user_response=%d",
        notif_id, user_response);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_NI_RESPOND);
    mnldinf_put_int(buff, &offset, notif_id);
    mnldinf_put_int(buff, &offset, user_response);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_update_network_state(int fd, uint64_t network_handle, bool is_connected,
            uint16_t capabilities, const char* apn) {
    LOGD("connected=%d capabilities=%d apn=[%s]",
        is_connected, capabilities, apn);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_UPDATE_NETWORK_STATE);
    mnldinf_put_long(buff, &offset, network_handle);
    mnldinf_put_byte(buff, &offset, is_connected);
    mnldinf_put_short(buff, &offset, capabilities);
    mnldinf_put_string(buff, &offset, apn);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_update_network_availability(int fd, int available, const char* apn) {
    LOGD("available=%d apn=[%s]",
        available, apn);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_UPDATE_NETWORK_AVAILABILITY);
    mnldinf_put_int(buff, &offset, available);
    mnldinf_put_string(buff, &offset, apn);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_gnss_navigation_msg_enable(int fd, bool enabled) {
    LOGD("enabled=%d", enabled);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_GPS_NAVIGATION);
    mnldinf_put_int(buff, &offset, enabled);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_set_vzw_debug(int fd, bool enabled) {
    LOGD("enabled = %d\n", enabled);
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_VZW_DEBUG);
    mnldinf_put_int(buff, &offset, enabled);

    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_update_gnss_config(int fd, const char* config_data, int length) {
    LOGD("data length:%d\n", length);
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_GNSS_CONFIG);
    mnldinf_put_int(buff, &offset, length);
    mnldinf_put_string(buff, &offset, config_data);
    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_gnss_full_tracking_enable(int fd, bool enable) {
    LOGD("full tracking enable:%d\n", enable);
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_FULL_TRACKING);
    mnldinf_put_int(buff, &offset, enable);
    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_epo_enable(int fd,  epo_bitmap epo_cfg) {
    LOGD("mnldinf_ext_epo_enable:0x%x\n", epo_cfg);
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_EPO_ENABLE);
    mnldinf_put_int(buff, &offset, epo_cfg);
    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_set_sv_blacklist(int fd, long long* blacklist, int32_t size) {
    LOGD("hal2mnl_setBlacklist, size:%d, first SVID:0x%llx\n", size, *blacklist);
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_SV_BLACKLIST);
    mnldinf_put_int(buff, &offset, size);
    mnldinf_put_binary(buff, &offset, (const char*)blacklist, sizeof(long long)*size);
    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_set_correction(int fd, measurement_corrections* corrections) {
    LOGD("hal2mnl_set_correction\n");
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_CORRECTION);
    mnldinf_put_binary(buff, &offset, (const char*)corrections, sizeof(measurement_corrections));
    return mnldinf_tcp_send(fd, buff, offset);
}

int mnldinf_ext_set_nfw_access(int fd, char* proxy_apps, int32_t length) {
    LOGD("mnldinf_ext_set_nfw_access, proxy_apps:%s, len:%d\n", proxy_apps, length);
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_NFW_ACCESS);
    mnldinf_put_int(buff, &offset, length);
    mnldinf_put_string(buff, &offset, proxy_apps);
    return mnldinf_tcp_send(fd, buff, offset);
}
int mnldinf_ext_set_ttff_acc(int fd, ttff_acc acc_mode) {
    LOGD("set TTFF acc:%d\n", acc_mode);
    int offset = 0;
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);

    mnldinf_put_int(buff, &offset, HAL2MNL_SET_TTFF_ACC);
    mnldinf_put_int(buff, &offset, acc_mode);
    return mnldinf_tcp_send(fd, buff, offset);
}

// -1 means failure
int mnldinf_ext_cmd_hdlr(int fd, mnldinf_ext* hdlr) {
    char buff[HAL_MNL_BUFF_SIZE_SND] = {0};
    char buff_read[HAL_MNL_BUFF_SIZE_SND] = {0};
    int offset = 0;
    int ver;
    mnl2hal_cmd cmd;
    int read_len;
    int ret = 0;
    int msg_len = 0;

    read_len = mnldinf_safe_recv(fd, buff_read, sizeof(buff_read));
    if (read_len <= 0) {
        close(fd);
        if(hdlr->mnldinf_connection_broken) {
            LOGW("Connection broken......");
            hdlr->mnldinf_connection_broken();
        }
        LOGE("mnldinf_ext_cmd_hdlr() mnldinf_safe_recvfrom() failed read_len=%d, %s", read_len, strerror(errno));
        return -1;
    }

    mnldinf_put_msg_to_cycle(&g_mnldinf_ext_cbuffer, buff_read, read_len);

    while(mnldinf_get_one_msg(&g_mnldinf_ext_cbuffer, buff) > 0) {
        offset = 0;

        msg_len = mnldinf_get_int(buff, &offset, sizeof(buff));  //Get message length
        UNUSED(msg_len);
        ver = mnldinf_get_int(buff, &offset, sizeof(buff));
        UNUSED(ver);
        cmd = mnldinf_get_int(buff, &offset, sizeof(buff));
        //LOGD("CMD:%d(0x%x)", cmd, cmd);
        mnldinf_ext_cmd_enter_record(cmd);
        switch (cmd) {
        case MNL2HAL_REQUEST_WAKELOCK: {
            if (hdlr->mnldinf_request_wakelock) {
                LOGD("request_wakelock");
                hdlr->mnldinf_request_wakelock();
            } else {
                LOGE("mnl2hal_hdlr() request_wakelock is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_RELEASE_WAKELOCK: {
            if (hdlr->mnldinf_release_wakelock) {
                hdlr->mnldinf_release_wakelock();
            } else {
                LOGE("mnl2hal_hdlr() release_wakelock is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_REQUEST_UTC_TIME: {
            if (hdlr->mnldinf_request_utc_time) {
                hdlr->mnldinf_request_utc_time();
            } else {
                LOGE("mnl2hal_hdlr() request_utc_time is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_REQUEST_DATA_CONN: {
            if (hdlr->mnldinf_request_data_conn) {
                struct sockaddr_storage addr;
                agps_type type;
                mnldinf_get_binary(buff, &offset, (char*)&addr, sizeof(buff), sizeof(addr));
                type = mnldinf_get_int(buff, &offset, sizeof(buff));
                hdlr->mnldinf_request_data_conn(&addr, type);
            } else {
                LOGE("mnl2hal_hdlr() request_data_conn is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_RELEASE_DATA_CONN: {
            if (hdlr->mnldinf_release_data_conn) {
                hdlr->mnldinf_release_data_conn();
            } else {
                LOGE("mnl2hal_hdlr() release_data_conn is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_REQUEST_NI_NOTIFY: {
            if (hdlr->mnldinf_request_ni_notify) {
                int session_id = mnldinf_get_int(buff, &offset, sizeof(buff));
                agps_notify_type type = mnldinf_get_int(buff, &offset, sizeof(buff));
                char* requestor_id = mnldinf_get_string(buff, &offset, sizeof(buff));
                char* client_name = mnldinf_get_string(buff, &offset, sizeof(buff));
                ni_encoding_type requestor_id_encoding = mnldinf_get_int(buff, &offset, sizeof(buff));
                ni_encoding_type client_name_encoding  = mnldinf_get_int(buff, &offset, sizeof(buff));
                agps_ni_type ni_type = mnldinf_get_int(buff, &offset, sizeof(buff));
                hdlr->mnldinf_request_ni_notify(session_id, ni_type, type, requestor_id, client_name,
                    requestor_id_encoding, client_name_encoding);
            } else {
                LOGE("mnl2hal_hdlr() request_ni_notify is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_REQUEST_SET_ID: {
            if (hdlr->mnldinf_request_set_id) {
                request_setid flags = mnldinf_get_int(buff, &offset, sizeof(buff));
                hdlr->mnldinf_request_set_id(flags);
            } else {
                LOGE("mnl2hal_hdlr() request_set_id is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_REQUEST_REF_LOC: {
            if (hdlr->mnldinf_request_ref_loc) {
                request_refloc flags = mnldinf_get_int(buff, &offset, sizeof(buff));
                hdlr->mnldinf_request_ref_loc(flags);
            } else {
                LOGE("mnl2hal_hdlr() request_ref_loc is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_VZW_DEBUG_OUTPUT: {
            if (hdlr->mnldinf_output_vzw_debug) {
                char* str = mnldinf_get_string(buff, &offset, sizeof(buff));
                hdlr->mnldinf_output_vzw_debug(str);
            } else {
                LOGE("mnl2hal_hdlr() output_vzw_debug is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_UPDATE_GNSS_NAME: {
            if (hdlr->mnldinf_update_gnss_name) {
                int length = mnldinf_get_int(buff, &offset, sizeof(buff));
                char* name = mnldinf_get_string(buff, &offset, sizeof(buff));
                hdlr->mnldinf_update_gnss_name(name, length);
            } else {
                LOGE("mnl2hal_hdlr() update_gnss_name is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_REQUEST_NLP: {
            if (hdlr->mnldinf_request_nlp) {
                bool independent_from_gnss = mnldinf_get_byte(buff, &offset, sizeof(buff));
                bool is_user_emergency = mnldinf_get_byte(buff, &offset, sizeof(buff));
                hdlr->mnldinf_request_nlp(independent_from_gnss, is_user_emergency);
            } else {
                LOGE("mnl2hal_hdlr() update_gnss_name is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_GNSS_NAVIGATION: {
            if (hdlr->mnldinf_gnss_navigation_msg) {
                gnss_nav_msg msg;
                memset(&msg, 0, sizeof(msg));
                mnldinf_get_binary(buff, &offset, (char*)&msg, sizeof(buff), sizeof(gnss_nav_msg));
                hdlr->mnldinf_gnss_navigation_msg(&msg);
            } else {
                LOGE("mnl2hal_hdlr() gnss_navigation is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_NFW_NOTIFY: {
            if (hdlr->mnldinf_nfw_access_notify) {
                mnldinf_nfw_notification nfw_notify;
                memset(&nfw_notify, 0, sizeof(mnldinf_nfw_notification));
                mnldinf_get_binary(buff, &offset, (char*)&nfw_notify, sizeof(buff), sizeof(mnldinf_nfw_notification));
                hdlr->mnldinf_nfw_access_notify(&nfw_notify);
            } else {
                LOGE("mnldinf_nfw_access_notify() is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_EXT_CAP_SYNC: {
            if(hdlr->mnldinf_capability_update) {
                mnldinf_ext_server_cap cap;
                memset(&cap, 0, sizeof(cap));
                mnldinf_get_binary(buff, &offset, (char *)&cap, sizeof(buff), sizeof(cap));
                //DUMP_EXT_SERVER_CAP(&cap);
                hdlr->mnldinf_capability_update(&cap);
            } else {
                LOGE("mnldinf_capability_update() is NULL");
                ret = -1;
            }
            break;
        }
        case MNL2HAL_AGPS_LOCATION: {
            if (hdlr->mnldinf_agps_location_update) {
                mnldinf_agps_location location;
                memset(&location, 0, sizeof(location));
                mnldinf_get_binary(buff, &offset, (char*)&location, sizeof(buff), sizeof(mnldinf_agps_location));
                hdlr->mnldinf_agps_location_update(location);
            } else {
                LOGE("mnl2hal_hdlr() location is NULL");
                ret = -1;
            }
            break;
        }
        default: {
            LOGE("mnl2hal_hdlr() unknown cmd=%d", cmd);
            ret = -1;
            break;
        }
        }
        mnldinf_ext_cmd_exit_record(cmd);
    }

    return ret;
}

void mnldinf_ext_structure_size_dump(void) {
    PRINT_SIZE(gnss_nav_msg);
    PRINT_SIZE(mnldinf_nfw_notification);
    PRINT_SIZE(mnldinf_ext_server_cap);
    PRINT_SIZE(measurement_corrections);
    PRINT_SIZE(mnldinf_ext_client_cap);
}

int mnldinf_ext_register(char *client_name) {
    int fd = -1;

    fd = mnldinf_socket_tcp_client_connect_local(true, MNLDINF_EXT_TCP);
    //LOGD("New client:[%s], fd:%d", client_name, fd);
    //mnldinf_ext_structure_size_dump();

    mnldinf_socket_set_blocking(fd, 0); //Set as non-blocking
    mnldinf_buffer_initialize(&g_mnldinf_ext_cbuffer, g_mnldinf_ext_msg_buf, sizeof(g_mnldinf_ext_msg_buf));

    mnldinf_ext_cmd_list_init();
    return fd;
}
