#ifndef __MTK_GNSS_AT_STRUCT_H__
#define __MTK_GNSS_AT_STRUCT_H__

#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef int mtk_gnss_sv_flags;
#define MTK_GNSS_AT_SV_FLAGS_NONE                      0x00
#define MTK_GNSS_AT_SV_FLAGS_HAS_EPHEMERIS_DATA        0x01
#define MTK_GNSS_AT_SV_FLAGS_HAS_ALMANAC_DATA          0x02
#define MTK_GNSS_AT_SV_FLAGS_USED_IN_FIX               0x04

typedef int mtk_gnss_constellation;
#define MTK_GNSS_CONSTELLATION_UNKNOWN      0
#define MTK_GNSS_CONSTELLATION_GPS          1
#define MTK_GNSS_CONSTELLATION_SBAS         2
#define MTK_GNSS_CONSTELLATION_GLONASS      3
#define MTK_GNSS_CONSTELLATION_QZSS         4
#define MTK_GNSS_CONSTELLATION_BEIDOU       5
#define MTK_GNSS_CONSTELLATION_GALILEO      6
#define MTK_GNSS_CONSTELLATION_IRNSS        7

typedef int mtk_gnss_ni_type;
#define MTK_GNSS_NI_TYPE_VOICE              1
#define MTK_GNSS_NI_TYPE_UMTS_SUPL          2
#define MTK_GNSS_NI_TYPE_UMTS_CTRL_PLANE    3
#define MTK_GNSS_NI_TYPE_EMERGENCY_SUPL     4

typedef int mtk_gnss_ni_notify_type;
#define MTK_GNSS_NI_NOTIFY_TYPE_NONE                       0
#define MTK_GNSS_NI_NOTIFY_TYPE_NOTIFY_ONLY                1
#define MTK_GNSS_NI_NOTIFY_TYPE_NOTIFY_ALLOW_NO_ANSWER     2
#define MTK_GNSS_NI_NOTIFY_TYPE_NOTIFY_DENY_NO_ANSWER      3
#define MTK_GNSS_NI_NOTIFY_TYPE_PRIVACY                    4

typedef int mtk_gnss_ni_encoding_type;
#define MTK_GNSS_NI_ENCODING_TYPE_NONE   0
#define MTK_GNSS_NI_ENCODING_TYPE_GSM7   1
#define MTK_GNSS_NI_ENCODING_TYPE_UTF8   2
#define MTK_GNSS_NI_ENCODING_TYPE_UCS2   3

typedef int mtk_gnss_ni_response_type;
#define MTK_GNSS_NI_RESPONSE_ACCEPT     1
#define MTK_GNSS_NI_RESPONSE_DENY       2
#define MTK_GNSS_NI_RESPONSE_NORESP     3

typedef int mtk_gnss_supl_pref_method;
#define MTK_GNSS_SUPL_PREF_METHOD_MSA        0
#define MTK_GNSS_SUPL_PREF_METHOD_MSB        1
#define MTK_GNSS_SUPL_PREF_METHOD_NO_PREF    2

typedef int mtk_geo_alert_type;
#define MTK_GEO_ALERT_TYPE_ENTRY        (1 << 0)
#define MTK_GEO_ALERT_TYPE_EXIT         (1 << 1)

typedef int mtk_geo_state;
#define MTK_GEO_STATE_UNKNOWN       0
#define MTK_GEO_STATE_ENTERED       1
#define MTK_GEO_STATE_EXITED        2

typedef int mtk_geo_fence_create_state;
#define MTK_GEO_FENCE_CREATE_STATE_SUCCESS              0
#define MTK_GEO_FENCE_CREATE_STATE_ERROR                -1
#define MTK_GEO_FENCE_CREATE_STATE_INSUFFICIENT_MEMORY  -2
#define MTK_GEO_FENCE_CREATE_STATE_TOO_MANY_FENCE       -3

typedef int mtk_geo_track_state;
#define MTK_GEO_TRACK_STATE_OK          0
#define MTK_GEO_TRACK_STATE_FAILURE     -1

typedef int mtk_agps_location_type;
#define MTK_AGPS_LOCATION_TYPE_AFLT         0
#define MTK_AGPS_LOCATION_TYPE_CDMA_CELL    1
#define MTK_AGPS_LOCATION_TYPE_CP_MOLR      2
#define MTK_AGPS_LOCATION_TYPE_SUPL_END     3
#define MTK_AGPS_LOCATION_TYPE_SUPL_REF_LOC 4
#define MTK_AGPS_LOCATION_TYPE_CP_REF_LOC   5

typedef struct {
    int svid;
    mtk_gnss_constellation constellation;
    float cn0;
    float elevation;
    float azimuth;
    mtk_gnss_sv_flags flags;     // indicate the extra info of this satellite
    float carrier_frequency;    // Carrier frequency of the signal tracked in MHz. GPS central frequency for L1 = 1575.45 MHz or L5 = 1176.45 MHz
} mtk_gnss_satellite;

typedef struct {
    int num;
    mtk_gnss_satellite satellites[64];
} mtk_gnss_satellite_list;  // 1796 Bytes


typedef struct {
    bool lat_valid;
    double lat;

    bool lng_valid;
    double lng;

    bool alt_valid;
    float alt;

    bool speed_valid;
    float speed;

    bool bearing_valid;
    float bearing;

    bool h_acc_valid;
    float h_acc;

    bool v_acc_valid;
    float v_acc;

    bool s_acc_valid;
    float s_acc;

    bool b_acc_valid;
    float b_acc;

    bool timestamp_valid;
    long long timestamp;

    bool date_time_valid;   //auto assign by mtk_at_gen_gnss_location_notify()
    char date_time[32];     //auto assign by mtk_at_gen_gnss_location_notify()

    bool pdop_valid;
    float pdop;

    bool hdop_valid;
    float hdop;

    bool vdop_valid;
    float vdop;
} mtk_gnss_location;

typedef struct {
    double lat;
    double lng;

    bool alt_valid;
    float alt;
    
    bool speed_valid;
    float speed;
    
    bool bearing_valid;
    float bearing;

    bool h_acc_valid;
    float h_acc;
    
    bool timestamp_valid;
    long long timestamp;

    bool date_time_valid;   //auto assign by mtk_at_gen_gnss_location_notify()
    char date_time[32];     //auto assign by mtk_at_gen_gnss_location_notify()

    bool type_valid;
    mtk_agps_location_type type;
} mtk_agnss_location;

typedef struct {
    bool gnss_status;
    bool ni_status;
    int supl_maj_ver;
    int supl_min_ver;
    char gnss_version[256];
    char agps_version[128];
    int supl_ser_ind;
    char supl_addr[128];
    int supl_port;
    bool supl_tls_enabled;
    bool imsi_valid;
    char imsi[32];
    bool num_digital_mnc_in_imsi_valid;
    int num_digital_mnc_in_imsi;
} mtk_gnss_status;

typedef struct {
    bool msa_valid;
    bool msa;
    bool msb_valid;
    bool msb;
    bool mss_valid;
    bool mss;
    bool cid_valid;
    bool cid;
    bool aflt_valid;
    bool aflt;
    bool otdoa_valid;
    bool otdoa;
    bool supl_pref_method_valid;
    mtk_gnss_supl_pref_method supl_pref_method;
    bool supl_valid;
    bool supl;
    bool epo_valid;
    bool epo;
} mtk_gnss_agps_mode;

typedef struct {
    bool all;
    bool eph;
    bool alm;
    bool pos;
    bool time;
    bool iono;
    bool utc;
    bool svdir;
    bool rti;
    bool celldb;
} mtk_gnss_aiding_data;

typedef struct {
    int id;
    mtk_gnss_ni_type type;
    mtk_gnss_ni_notify_type notify_type;
    char request_id[1024];
    mtk_gnss_ni_encoding_type request_id_encode_type;
    char text[1024];
    mtk_gnss_ni_encoding_type text_encode_type;
} mtk_gnss_ni_notify;

typedef struct {
    int total_msg_len;
    int seq_no;
    char name[128];
    char data[1024];
} mtk_gnss_cert;

typedef struct {
    int num;
    char names[10][128];
} mtk_gnss_cert_name_list;

typedef struct {
    mtk_geo_alert_type alert_type;
    mtk_geo_state initial_state;
    double lat;
    double lng;
    double radius;  //in meters
    int unknowntimerms; //in milliseconds. Range <0~100000> milliseconds
} mtk_geo_add_circle;

typedef struct {
    int id;
    mtk_geo_state state;
    double lat;
    double lng;
    double alt;
    double speed;
    double heading;
    int hacc; //horizontal position accuracy, radial, in meters (68% confidence)
    int h_err_maj; //in meters
    int h_err_min; //in meters
    int h_err_angle; //in degree
    int h_confidence; //horizontal confidence of the position
    float pdop;
    float hdop;
    float vdop;
} mtk_geo_alert_notify;


bool mtk_at_parse_cmd(const char** at_cmd, const char* target_cmd);
int  mtk_at_parse_comma_num(const char* at_cmd);
bool mtk_at_parse_string(const char** at_cmd, char* output, int output_size);
bool mtk_at_parse_bool(const char** at_cmd, bool* output);
bool mtk_at_parse_int32(const char** at_cmd, int* output);
bool mtk_at_parse_int64(const char** at_cmd, long long* output);
bool mtk_at_parse_float(const char** at_cmd, float* output);
bool mtk_at_parse_double(const char** at_cmd, double* output);

void mtk_at_dump_mtk_gnss_satellite_list(mtk_gnss_satellite_list* list);
void mtk_at_dump_mtk_gnss_location(mtk_gnss_location* location);
void mtk_at_dump_mtk_agnss_location(mtk_agnss_location* location);
void mtk_at_dump_mtk_gnss_status(mtk_gnss_status* status);
void mtk_at_dump_mtk_gnss_agps_mode(mtk_gnss_agps_mode* mode);
void mtk_at_dump_mtk_gnss_aiding_data(mtk_gnss_aiding_data* aiding_data);
void mtk_at_dump_mtk_gnss_ni_notify(mtk_gnss_ni_notify* notify);
void mtk_at_dump_mtk_gnss_cert(mtk_gnss_cert* cert);
void mtk_at_dump_mtk_gnss_cert_name_list(mtk_gnss_cert_name_list* list);
void mtk_at_dump_mtk_geo_add_circle(mtk_geo_add_circle* circle);
void mtk_at_dump_mtk_geo_alert_notify(mtk_geo_alert_notify* alert);

void mtk_at_gen_gnss_start_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_stop_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_nmea_notify(char* at_cmd, int at_cmd_size, const char* nmea);
void mtk_at_gen_gnss_nmea_end_notify(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_satellite_notify(char* at_cmd, int at_cmd_size, mtk_gnss_satellite_list* list);
void mtk_at_gen_gnss_location_notify(char* at_cmd, int at_cmd_size, mtk_gnss_location* location);
void mtk_at_gen_agnss_location_notify(char* at_cmd, int at_cmd_size, mtk_agnss_location* location);
void mtk_at_gen_gnss_host_reset_notify(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_device_reset_notify(char* at_cmd, int at_cmd_size, const char* reason);
void mtk_at_gen_gnss_status_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_status_response(char* at_cmd, int at_cmd_size, mtk_gnss_status* status);
void mtk_at_gen_gnss_enable_set(char* at_cmd, int at_cmd_size, bool enabled);
void mtk_at_gen_gnss_ni_enable_set(char* at_cmd, int at_cmd_size, bool enabled);
void mtk_at_gen_gnss_agps_mode_set(char* at_cmd, int at_cmd_size, mtk_gnss_agps_mode* mode);
void mtk_at_gen_gnss_supl_version_set(char* at_cmd, int at_cmd_size, int maj, int min, int ser_ind);
void mtk_at_gen_gnss_supl_addr_set(char* at_cmd, int at_cmd_size, const char* addr, int port, bool tls_enabled);
void mtk_at_gen_gnss_delete_aiding_data_request(char* at_cmd, int at_cmd_size, mtk_gnss_aiding_data* flags);
void mtk_at_gen_gnss_ni_notify_request(char* at_cmd, int at_cmd_size, mtk_gnss_ni_notify* notify);
void mtk_at_gen_gnss_ni_notify_response(char* at_cmd, int at_cmd_size, int id, mtk_gnss_ni_response_type response);
void mtk_at_gen_gnss_ref_location_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_ref_location_response(char* at_cmd, int at_cmd_size, int age, double lat, double lng, float acc);
void mtk_at_gen_gnss_ref_time_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_ref_time_response(char* at_cmd, int at_cmd_size, long long time, int uncertainty);
void mtk_at_gen_gnss_nmea_config_set(char* at_cmd, int at_cmd_size, bool enabled);
void mtk_at_gen_gnss_ttff_qop_set(char* at_cmd, int at_cmd_size, int mode);
void mtk_at_gen_gnss_loopback_request(char* at_cmd, int at_cmd_size, const char* msg);
void mtk_at_gen_gnss_loopback_response(char* at_cmd, int at_cmd_size, const char* msg);
void mtk_at_gen_gnss_cert_set(char* at_cmd, int at_cmd_size, mtk_gnss_cert* cert);
void mtk_at_gen_gnss_cert_name_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_gnss_cert_name_response(char* at_cmd, int at_cmd_size, mtk_gnss_cert_name_list* list);
void mtk_at_gen_gnss_cert_delete_request(char* at_cmd, int at_cmd_size, const char* name);
void mtk_at_gen_gnss_cert_delete_all_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_geo_max_num_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_geo_max_num_response(char* at_cmd, int at_cmd_size, int num);
void mtk_at_gen_geo_add_circle_request(char* at_cmd, int at_cmd_size, mtk_geo_add_circle* circle);
void mtk_at_gen_geo_add_circle_response(char* at_cmd, int at_cmd_size, mtk_geo_fence_create_state state, int id);
void mtk_at_gen_geo_delete_request(char* at_cmd, int at_cmd_size, int id);
void mtk_at_gen_geo_delete_all_request(char* at_cmd, int at_cmd_size);
void mtk_at_gen_geo_alert_notify(char* at_cmd, int at_cmd_size, mtk_geo_alert_notify* notify);
void mtk_at_gen_geo_track_notify(char* at_cmd, int at_cmd_size, mtk_geo_track_state state, const char* date_time);
void mtk_at_gen_test_request(char* at_cmd, int at_cmd_size, int num1, int num2, double d1, double d2, const char* str1, const char* str2);


#ifdef __cplusplus
}
#endif

#endif

