#ifndef __MTK_LBS_UTILITY_H__
#define __MTK_LBS_UTILITY_H__

#include <time.h>
#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************
* Basic Utilities
**************************************************/
#ifndef UNUSED
#define UNUSED(x) (x)=(x)
#endif

void tag_log(int type, const char* tag, const char *fmt, ...);

#ifdef LOGD
#undef LOGD
#endif
#ifdef LOGW
#undef LOGW
#endif
#ifdef LOGE
#undef LOGE
#endif
//#define LOGD(...) tag_log(0, "DBG: ", __VA_ARGS__);
//#define LOGW(...) tag_log(0, "WRN: ", __VA_ARGS__);
//#define LOGE(...) tag_log(1, "ERR: ", __VA_ARGS__);

#define LOGD(...)   { printf(__VA_ARGS__); printf("\n"); fflush(stdout); }
#define LOGW(...)   { printf("\E[1;35;40m"); printf(__VA_ARGS__); printf("\E[0m"); printf("\n"); fflush(stdout); }
#define LOGE(...)   { printf("\E[1;31;40m"); printf(__VA_ARGS__); printf("\E[0m"); printf("\n"); fflush(stdout); }

#define LBS_STRNCPY(dst,src,size) do{\
                                       strncpy((char *)(dst), (src), (size - 1));\
                                      (dst)[size - 1] = '\0';\
                                     }while(0)

void msleep2(int interval);

// in millisecond
time_t get_tick();

// in millisecond
time_t get_time_in_millisecond();

/******************************************************************************
* Timer
******************************************************************************/
typedef void (*timer_routine) (int id);
//-1 means fail or timerid is returned

//NULL means fail or timerid is returned
timer_t timer_init(timer_routine cb, int id);
bool timer_deinit(timer_t timerid);

bool timer_start(timer_t timerid, int milliseconds);
bool timer_stop(timer_t timerid);

//-1 means fail or the remaining time is returned
int64_t timer_get_remaining_time(timer_t timerid);

/*************************************************
* Epoll
**************************************************/
// -1 means failure
int epoll_add_fd3(int epfd, int fd);

// -1 failed
int epoll_add_fd2(int epfd, int fd, uint32_t events);

// -1 failed
bool epoll_add_fd(int epfd, int fd, int events);

// -1 failed
int epoll_del_fd(int epfd, int fd);

int epoll_mod_fd(int epfd, int fd, uint32_t events);

/*************************************************
* Local UDP Socket
**************************************************/
// -1 means failure
int socket_bind_udp(const char* path);

// -1 means failure
int socket_set_blocking2(int fd, int blocking);

// -1 means failure
int safe_sendto(const char* path, const char* buff, int len);

// -1 means failure
int safe_recvfrom(int fd, char* buff, int len);

//-1 means fail or clientfd is returned
int socket_tcp_client_connect_local(bool abstract, const char* name);

//-1 means fail or serverfd is returned
int socket_udp_server_bind_local(bool abstract, const char* name);

//-1 means fail or clientfd is returned
int socket_udp_client_create_local(bool abstract, const char* name);

void dump_buff(const char* data, int len);


/******************************************************************************
* Utils
******************************************************************************/
#define assert(expr) {\
    if(!(expr)) {\
        LOGE("assert(%s) failed, %s %s() line=%d", #expr, __FILE__, __FUNCTION__, __LINE__);\
        exit(1);\
    }\
\
}

#define crash_with_log() {\
    LOGE("crash_with_log() %s %s() line=%d", __FILE__, __FUNCTION__, __LINE__);\
    exit(1);\
}

#define crash_with_log_0(file, function, line) {\
    LOGE("crash_with_log() %s %s() line=%d", file, function, line);\
    exit(1);\
}


#ifdef __cplusplus
}
#endif

#endif
