// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include "mtk_socket_utils.h"
#include "mtk_socket_data_coder.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <stddef.h> // offsetof
#include <stdarg.h>
#include <sys/stat.h>
#include <unistd.h> //usleep
#include <sys/socket.h>
#include <string.h>
#include <fcntl.h>
#include <arpa/inet.h> //inet_addr
#include <sys/un.h> //struct sockaddr_un
#include <sys/epoll.h>
#include <poll.h>
#include <sys/types.h>
#include <netdb.h>

#if defined(__ANDROID_OS__)
#include <log/log.h>     // Android log

#define ANDROID_LOG_TAG "mtk_socket"
#endif

#define NETLINK_ROUTE 0

static char *safe_strncpy(char *dest, const char *src, size_t n) {
    if (dest && n > 0) {
        dest[0] = '\0';
        strncat(dest, src, --n);
    }
    return dest;
}

#if !defined(__ANDROID_OS__)
//-1 means failure
static int get_time_str(char* buff, int len) {
    struct timeval  tv;
    struct timezone tz;
    struct tm      *tm;

    gettimeofday(&tv, &tz);
    tm = localtime(&tv.tv_sec);

    memset(buff, 0, len);
    sprintf(buff, "%04d/%02d/%02d %02d:%02d:%02d.%03d",
        tm->tm_year + 1900, 1 + tm->tm_mon, tm->tm_mday, tm->tm_hour, tm->tm_min,
        tm->tm_sec, (int)(tv.tv_usec / 1000));

    return 0;
}
#endif

void _mtk_socket_log(int type, const char *fmt, ...) {
    char buff[1024] = {0};
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buff, sizeof(buff), fmt, ap);
    va_end(ap);

#if defined(__ANDROID_OS__)
    if(type == 0) {
        __android_log_print(ANDROID_LOG_DEBUG, ANDROID_LOG_TAG, "%s", buff);
    } else {
        __android_log_print(ANDROID_LOG_ERROR, ANDROID_LOG_TAG, "ERR: %s", buff);
    }
#else
    char time_buff[64] = {0};
    get_time_str(time_buff, sizeof(time_buff));
    if(type == 0) {
        printf("%s %s\n", time_buff, buff);
    } else {
        printf("%s ERR: %s\n", time_buff, buff);
    }
    fflush(stdout);
#endif
}

//-1 means failure
int mtk_socket_server_bind_network(int port) {
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    int fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (fd < 0) {
        SOCK_LOGE("mtk_socket_server_bind_network() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if (bind(fd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        SOCK_LOGE("mtk_socket_server_bind_network() bind() failed reason=[%s]%d for port=[%d]",
            strerror(errno), errno, port);
        close(fd);
        return -1;
    }
    return fd;
}

//-1 means failure
int mtk_socket_server_bind_network_ipv6(int port) {
    struct sockaddr_in6 addr;
    memset(&addr, 0, sizeof(addr));
    int fd = socket(AF_INET6, SOCK_DGRAM, IPPROTO_UDP);
    if (fd < 0) {
        SOCK_LOGE("mtk_socket_server_bind_network_ipv6() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    addr.sin6_family = AF_INET6;
    addr.sin6_port = htons(port);
    addr.sin6_addr = in6addr_any;
    if (bind(fd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        SOCK_LOGE("mtk_socket_server_bind_network_ipv6() bind() failed reason=[%s]%d for port=[%d]",
            strerror(errno), errno, port);
        close(fd);
        return -1;
    }
    return fd;
}

//-1 means failure
int mtk_socket_server_bind_local(const char* path, mtk_socket_namespace sock_namespace) {
    int size;
    struct sockaddr_un addr;
    int fd = socket(AF_UNIX, SOCK_DGRAM, 0);
    if (fd < 0) {
        SOCK_LOGE("mtk_socket_server_bind_local() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_UNIX;
    size = strlen(path) + offsetof(struct sockaddr_un, sun_path) + 1;
    if(sock_namespace == SOCK_NS_ABSTRACT) {
        addr.sun_path[0] = 0;
        memcpy(addr.sun_path + 1, path, strlen(path));
    } else if(sock_namespace == SOCK_NS_FILESYSTEM) {
        safe_strncpy(addr.sun_path, path, sizeof(addr.sun_path));
        unlink(addr.sun_path);
    } else {
        SOCK_LOGE("mtk_socket_server_bind_local() unknown namespace=[%d]", sock_namespace);
        close(fd);
        return -1;
    }
    if (bind(fd, (struct sockaddr *)&addr, size) == -1) {
        SOCK_LOGE("mtk_socket_server_bind_local() bind() failed reason=[%s]%d for path=[%s]",
            strerror(errno), errno, path);
        close(fd);
        return -1;
    }
    return fd;
}

//-1 means fail or serverfd is returned
int socket_tcp_server_bind_local(bool abstract, const char* name) {
    int fd;
    int size;
    struct sockaddr_un addr;

    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_UNIX;
    size = strlen(name) + offsetof(struct sockaddr_un, sun_path) + 1;
    if(abstract) {
        addr.sun_path[0] = 0;
        memcpy(addr.sun_path + 1, name, strlen(name));
    } else {
        safe_strncpy(addr.sun_path, name, sizeof(addr.sun_path));
        if(unlink(addr.sun_path) == -1) {
            SOCK_LOGE("socket_tcp_server_bind_local() unlink() failed, reason=[%s]%d",
                strerror(errno), errno);
        }
    }
    fd = socket(AF_UNIX, SOCK_STREAM, 0);
    if(fd == -1) {
        SOCK_LOGE("socket_tcp_server_bind_local() socket() failed, reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    if(bind(fd, (struct sockaddr*)&addr, size) == -1) {
        SOCK_LOGE("socket_tcp_server_bind_local() bind() failed, abstruct=%d name=[%s] reason=[%s]%d",
            abstract, name, strerror(errno), errno);
        close(fd);
        return -1;
    }
    if(listen(fd, 5) == -1) {
        SOCK_LOGE("socket_tcp_server_bind_local() listen() failed, reason=[%s]%d",
            strerror(errno), errno);
    }
    return fd;
}

//-1 means fail or new clientfd is returned
int socket_tcp_server_new_connect(int serverfd) {
    int newfd;
    struct sockaddr_in addr;
    socklen_t len = sizeof(addr);

    newfd = accept(serverfd, (struct sockaddr*)&addr, &len);
    if(newfd == -1) {
        SOCK_LOGE("socket_tcp_server_new_connect() accept() failed, serverfd=%d reason=[%s]%d",
            serverfd, strerror(errno), errno);
        return -1;
    }
    return newfd;
}


void mtk_socket_client_init_network(mtk_socket_fd* sock_fd, const char* host, int port) {
    int len = strlen(host);
    memset(sock_fd, 0, sizeof(*sock_fd));
    sock_fd->fd = -1;
    sock_fd->is_local = false;
    pthread_mutex_init(&sock_fd->mutex, NULL);
    sock_fd->host = malloc(len + 1);
    safe_strncpy(sock_fd->host, host, len + 1);
    sock_fd->port = port;
}

void mtk_socket_client_init_local(mtk_socket_fd* sock_fd, const char* path, mtk_socket_namespace sock_namespace) {
    int len = strlen(path);
    memset(sock_fd, 0, sizeof(*sock_fd));
    sock_fd->fd = -1;
    sock_fd->is_local = true;
    pthread_mutex_init(&sock_fd->mutex, NULL);
    sock_fd->path = malloc(len + 1);
    safe_strncpy(sock_fd->path, path, len + 1);
    sock_fd->namesapce = sock_namespace;
}

void mtk_socket_client_cleanup(mtk_socket_fd* sock_fd) {
    mtk_socket_client_close(sock_fd);
    if(sock_fd->host) {
        free(sock_fd->host);
        sock_fd->host = NULL;
    }
    if(sock_fd->path) {
        free(sock_fd->path);
        sock_fd->path = NULL;
    }
}

static bool mtk_socket_connect_local(mtk_socket_fd* sock_fd) {
    int size;
    struct sockaddr_un addr;
    int fd = socket(AF_UNIX, SOCK_DGRAM, 0);
    if (fd < 0) {
        SOCK_LOGE("mtk_socket_connect_local() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return false;
    }
    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_LOCAL;
    size = strlen(sock_fd->path) + offsetof(struct sockaddr_un, sun_path) + 1;
    if(sock_fd->namesapce == SOCK_NS_ABSTRACT) {
        addr.sun_path[0] = 0;
        memcpy(addr.sun_path + 1, sock_fd->path, strlen(sock_fd->path));
    } else if(sock_fd->namesapce == SOCK_NS_FILESYSTEM) {
        safe_strncpy(addr.sun_path, sock_fd->path, sizeof(addr.sun_path));
    } else {
        SOCK_LOGE("mtk_socket_connect_local() unknown namespace=[%d]", sock_fd->namesapce);
        close(fd);
        return false;
    }
    if (connect(fd, (struct sockaddr *)&addr, size) < 0) {
        SOCK_LOGE("mtk_socket_connect_local() connect() failed reason=[%s]%d for path=[%s]",
            strerror(errno), errno, sock_fd->path);
        close(fd);
        return false;
    }
    sock_fd->fd = fd;
    return true;
}

static int mtk_socket_connect_network_ipv4(struct sockaddr_in* addr) {
    int port = ntohs(addr->sin_port);
    char ip_str[64] = {0};
    inet_ntop(AF_INET, &(addr->sin_addr), ip_str, sizeof(ip_str));
    int fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (fd < 0) {
        SOCK_LOGE("mtk_socket_connect_network_ipv4() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    //SOCK_LOGD("mtk_socket_connect_network_ipv4() IPv4=[%s] port=[%d]", ip_str, port);
    if (connect(fd, (struct sockaddr *)addr, sizeof(*addr)) < 0) {
        SOCK_LOGE("mtk_socket_connect_network_ipv4() connect() failed reason=[%s]%d for host=[%s] port=[%d]",
            strerror(errno), errno, ip_str, port);
        close(fd);
        return -1;
    }
    return fd;
}

//-1 means failure
static int mtk_socket_connect_network_ipv6(struct sockaddr_in6* addr) {
    int port = ntohs(addr->sin6_port);
    int fd = socket(AF_INET6, SOCK_DGRAM, IPPROTO_UDP);
    if (fd < 0) {
        SOCK_LOGE("mtk_socket_connect_network_ipv6() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    //unsigned char* ipv6_addr = addr->sin6_addr.s6_addr;
    //SOCK_LOGD("mtk_socket_connect_network_ipv6() IPv6=[%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x] port=[%d]",
    //    ipv6_addr[0], ipv6_addr[1], ipv6_addr[2], ipv6_addr[3], ipv6_addr[4], ipv6_addr[5], ipv6_addr[6], ipv6_addr[7],
    //    ipv6_addr[8], ipv6_addr[9], ipv6_addr[10], ipv6_addr[11], ipv6_addr[12], ipv6_addr[13], ipv6_addr[14], ipv6_addr[15],
    //    port);
    if (connect(fd, (struct sockaddr *)addr, sizeof(*addr)) < 0) {
        SOCK_LOGE("mtk_socket_connect_network_ipv6() connect() failed reason=[%s]%d for port=[%d]",
            strerror(errno), errno, port);
        close(fd);
        return -1;
    }
    return fd;
}

static bool mtk_socket_connect_network(mtk_socket_fd* sock_fd) {
    struct addrinfo hints;
    struct addrinfo *result;
    struct addrinfo *rp;
    int ret;
    char port_str[11] = {0};
    sprintf(port_str, "%u", sock_fd->port);
    memset(&hints, 0, sizeof(struct addrinfo));
    hints.ai_family = AF_UNSPEC;    // Allow IPv4 or IPv6, AF_UNSPEC, AF_INET, AF_INET6
    hints.ai_socktype = SOCK_DGRAM;
    hints.ai_flags = AI_ADDRCONFIG; // check local system
    hints.ai_protocol = IPPROTO_UDP;
    ret = getaddrinfo(sock_fd->host, port_str, &hints, &result);
    if(ret != 0) {
        SOCK_LOGE("mtk_socket_connect_network() getaddrinfo() failure reason=[%s] %d\n",
            gai_strerror(ret), ret);
        return false;
    }
    for (rp = result; rp != NULL; rp = rp->ai_next) {
        if(rp->ai_family == AF_INET) {
            ret = mtk_socket_connect_network_ipv4((struct sockaddr_in*)rp->ai_addr);
            if(ret >= 0) {
                sock_fd->fd = ret;
                break;
            }
        }
        if(rp->ai_family == AF_INET6) {
            ret = mtk_socket_connect_network_ipv6((struct sockaddr_in6*)rp->ai_addr);
            if(ret >= 0) {
                sock_fd->fd = ret;
                break;
            }
        }
    }
    freeaddrinfo(result);
    if(ret >= 0) {
        return true;
    } else {
        return false;
    }
}

bool mtk_socket_client_connect(mtk_socket_fd* sock_fd) {
    if(sock_fd->is_local) {
        return mtk_socket_connect_local(sock_fd);
    } else {
        return mtk_socket_connect_network(sock_fd);
    }
}

void mtk_socket_client_close(mtk_socket_fd* sock_fd) {
    if(sock_fd->fd >= 0) {
        close(sock_fd->fd);
        sock_fd->fd = -1;
    }
}

//-1 means failure
int mtk_socket_read(int fd, char* buff, int len) {
    int n, retry = 10;
    if(fd < 0 || buff == NULL || len < 0) {
        SOCK_LOGE("mtk_socket_read() invalid params fd=[%d] buff=[%p] len=[%d]", fd, buff, len);
        return -1;
    }
    if(len == 0) {
        return 0;
    }
    while((n = read(fd, buff, len)) < 0) {
        if(errno == EINTR) continue;
        if(errno == EAGAIN) {
            if(retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
            goto exit;
        }
        goto exit;
    }
    return n;
exit:
    SOCK_LOGE("mtk_socket_read() read() failed, fd=[%d] len=[%d] errno=[%s]%d",
        fd, len, strerror(errno), errno);
    return -1;
}

//-1 means failure
int mtk_socket_write(int fd, void* buff, int len) {
    int n, retry = 10;
    if(fd < 0 || buff == NULL || len < 0) {
        SOCK_LOGE("mtk_socket_write() invalid params fd=[%d] buff=[%p] len=[%d]", fd, buff, len);
        return -1;
    }
    while((n = write(fd, buff, len)) != len) {
        if(errno == EINTR) continue;
        if(errno == EAGAIN) {
            if(retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
            goto exit;
        }
        goto exit;
    }
    return n;
exit:
    SOCK_LOGE("mtk_socket_write() write() failed, fd=[%d] len=[%d] errno=[%s]%d\n",
        fd, len, strerror(errno), errno);
    return -1;
}

// <= 0 means no data received
int mtk_socket_poll(int fd, int timeout) {
    struct pollfd poll_fd[1];
    int ret = 0;
    memset(poll_fd, 0, sizeof(poll_fd));
    poll_fd[0].fd      = fd;
    poll_fd[0].events  = POLLIN;
    poll_fd[0].revents = 0;

    ret = poll(poll_fd, 1, timeout);
    if(ret > 0) {
        if(poll_fd[0].revents & POLLIN ||
            poll_fd[0].revents & POLLERR) {
            ret = 1 << 0;
        }
    }
    return ret;
}

void mtk_socket_buff_dump(const char* buff, int len) {
    int i = 0;
    char tmp[512] = {0};
    SOCK_LOGD("mtk_socket_buff_dump len=%d", len);
    for(i = 0; i < len; i++) {
        if((i % 16 == 0) && (i != 0)) {
            SOCK_LOGD("  %s", tmp);
            memset(tmp, 0, sizeof(tmp));
        }
        sprintf(tmp + ((i % 16) * 3), "%02x ", buff[i] & 0xff);
    }
    if(i > 0) {
        SOCK_LOGD("  %s", tmp);
    }
}

bool mtk_socket_string_is_equal(char* data1, char* data2) {
    return (strcmp(data1, data2) == 0)? true : false;
}

bool mtk_socket_bool_array_is_equal(bool data1[], int data1_size, bool data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_char_array_is_equal(char data1[], int data1_size, char data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_short_array_is_equal(short data1[], int data1_size, short data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_int_array_is_equal(int data1[], int data1_size, int data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_int64_t_array_is_equal(int64_t data1[], int data1_size, int64_t data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_float_array_is_equal(float data1[], int data1_size, float data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_double_array_is_equal(double data1[], int data1_size, double data2[], int data2_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(data1[i] != data2[i]) {
            return false;
        }
    }
    return true;
}

bool mtk_socket_string_array_is_equal(strings data1, int data1_size, strings data2, int data2_size, int string_size) {
    int i = 0;
    if(data1_size != data2_size) {
        return false;
    }
    for(i = 0; i < data1_size; i++) {
        if(!mtk_socket_string_is_equal(data1, data2)) {
            return false;
        }
        data1 = (char*)data1 + string_size;
        data2 = (char*)data2 + string_size;
    }
    return true;
}

void mtk_socket_bool_array_dump(bool input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_bool_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%d]", i, input[i]);
    }
}

void mtk_socket_char_array_dump(char input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_char_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%d]", i, input[i] & 0xff);
    }
}

void mtk_socket_short_array_dump(short input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_short_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%d]", i, input[i] & 0xffff);
    }
}

void mtk_socket_int_array_dump(int input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_int_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%d]", i, input[i]);
    }
}

void mtk_socket_int64_t_array_dump(int64_t input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_int64_t_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%lld]", i, (long long)input[i]);
    }
}

void mtk_socket_float_array_dump(float input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_float_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%f]", i, input[i]);
    }
}

void mtk_socket_double_array_dump(double input[], int size) {
    int i = 0;
    SOCK_LOGD("mtk_socket_double_array_dump size=%d", size);
    for(i = 0; i < size; i++) {
        SOCK_LOGD("  i=[%d] data=[%f]", i, input[i]);
    }
}

void mtk_socket_string_array_dump(strings input, int size1, int size2) {
    int i = 0;
    SOCK_LOGD("mtk_socket_string_array_dump size1=%d size2=%d", size1, size2);
    for(i = 0; i < size1; i++) {
        SOCK_LOGD("  i=[%d] data=[%s]", i, (char*)input);
        input = (char*)input + size2;
    }
}

bool mtk_socket_expected_bool(char* buff, int* offset, bool expected_value, const char* func, int line) {
    bool value = mtk_socket_get_bool(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_bool() failed, read=[%d], expected=[%d]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_char(char* buff, int* offset, char expected_value, const char* func, int line) {
    char value = mtk_socket_get_char(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_char() failed, read=[%d], expected=[%d]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_short(char* buff, int* offset, short expected_value, const char* func, int line) {
    short value = mtk_socket_get_short(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_short() failed, read=[%d], expected=[%d]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_int(char* buff, int* offset, int expected_value, const char* func, int line) {
    int value = mtk_socket_get_int(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_int() failed, read=[%d], expected=[%d]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_int64_t(char* buff, int* offset, int64_t expected_value, const char* func, int line) {
    int64_t value = mtk_socket_get_int64_t(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_int64_t() failed, read=[%lld], expected=[%lld]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_float(char* buff, int* offset, float expected_value, const char* func, int line) {
    float value = mtk_socket_get_float(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_float() failed, read=[%f], expected=[%f]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_double(char* buff, int* offset, double expected_value, const char* func, int line) {
    double value = mtk_socket_get_double(buff, offset);
    if(value != expected_value) {
        SOCK_LOGE("%s():%d mtk_socket_expected_double() failed, read=[%f], expected=[%f]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

bool mtk_socket_expected_string(char* buff, int* offset, const char* expected_value, int max_size, const char* func, int line) {
    char value[max_size];
    mtk_socket_get_string(buff, offset, value, sizeof(value));
    if(strcmp(value, expected_value) != 0) {
        SOCK_LOGE("%s():%d mtk_socket_expected_string() failed, read=[%s], expected=[%s]",
            func, line, value, expected_value);
        return false;
    }
    return true;
}

