// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include "gnss_atci_socket_utils.h"
#include "gnss_atci_socket_data_coder.h"
#include "gnss_atci_utility.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <stddef.h> // offsetof
#include <stdarg.h>
#include <sys/stat.h>
#include <unistd.h> //usleep
#include <sys/socket.h>
#include <string.h>
#include <fcntl.h>
#include <arpa/inet.h> //inet_addr
#include <sys/un.h> //struct sockaddr_un
#include <sys/epoll.h>
#include <poll.h>
#include <sys/types.h>
#include <netdb.h>
#include <inttypes.h>

#if defined(__ANDROID_OS__)
#include <cutils/log.h>     // Android log

#define ANDROID_LOG_TAG "mtk_socket"
#endif

char *safe_strncpy(char *dest, const char *src, size_t n) {
    if (dest && n > 0) {
        // Use strncat for performance because strncpy will always fill n bytes in dest
        dest[0] = '\0';            // Let dest be an empty string
        strncat(dest, src, --n);   // n-1 because strncat may fill n+1 bytes
    }
    return dest;
}

struct sockaddr_un sock_addr;
void gnss_atci_send(int fd, const char* ack, int len) {
    int ret = 0;
    int retry = 10;
    while ((ret = sendto(fd, ack, len, 0,
        (const struct sockaddr *)&sock_addr, sizeof(sock_addr))) == -1) {
        if (errno == EINTR) continue;
        if (errno == EAGAIN) {
            if (retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
        }
        LOGE("safe_sendto() sendto() failed path=[%s] ret=%d reason=[%s]%d",
            ret, strerror(errno), errno);
        break;
    }

}

//-1 means failure
int gnss_atci_socket_server_bind_local(const char* path, mtk_socket_namespace sock_namespace) {
    int size;
    struct sockaddr_un addr;
    //int fd = socket(AF_UNIX, SOCK_DGRAM, 0);
    int fd = socket(PF_LOCAL, SOCK_DGRAM, 0);
    if (fd < 0) {
        LOGE("mtk_socket_server_bind_local() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }
    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_UNIX;
    size = strlen(path) + offsetof(struct sockaddr_un, sun_path) + 1;
    if(sock_namespace == SOCK_NS_ABSTRACT) {
        addr.sun_path[0] = 0;
        memcpy(addr.sun_path + 1, path, strlen(path));
    } else if(sock_namespace == SOCK_NS_FILESYSTEM) {
        safe_strncpy(addr.sun_path, path, sizeof(addr.sun_path));
        unlink(addr.sun_path);
    } else {
        LOGE("mtk_socket_server_bind_local() unknown namespace=[%d]", sock_namespace);
        close(fd);
        return -1;
    }
    if (bind(fd, (struct sockaddr *)&addr, size) == -1) {
        LOGE("mtk_socket_server_bind_local() bind() failed reason=[%s]%d for path=[%s]",
            strerror(errno), errno, path);
        close(fd);
        return -1;
    }
    return fd;
}

//-1 means failure
int gnss_atci_socket_create(const char* path, mtk_socket_namespace sock_namespace) {
    int ret = 0;
   // struct sockaddr_un addr;
    int retry = 10;
    int fd = socket(PF_LOCAL, SOCK_DGRAM, 0);
    if (fd < 0) {
        LOGE("safe_sendto() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }

    int flags = fcntl(fd, F_GETFL, 0);
    if (fcntl(fd, F_SETFL, flags | O_NONBLOCK) == -1){
        LOGE("fcntl failed reason=[%s]%d",
                    strerror(errno), errno);

        close(fd);
        return -1;
    }

    memset(&sock_addr, 0, sizeof(sock_addr));
    sock_addr.sun_path[0] = 0;
    MNLD_STRNCPY(sock_addr.sun_path + 1, path,sizeof(sock_addr.sun_path) - 1);
    sock_addr.sun_family = AF_UNIX;

    return fd;
}

int safe_sendto(const char* path, const char* buff, int len) {
    int ret = 0;
    struct sockaddr_un addr;
    int retry = 10;
    int fd = socket(PF_LOCAL, SOCK_DGRAM, 0);
    if (fd < 0) {
        LOGE("safe_sendto() socket() failed reason=[%s]%d",
            strerror(errno), errno);
        return -1;
    }

    int flags = fcntl(fd, F_GETFL, 0);
    if (fcntl(fd, F_SETFL, flags | O_NONBLOCK) == -1){
        LOGE("fcntl failed reason=[%s]%d",
                    strerror(errno), errno);

        close(fd);
        return -1;
    }

    memset(&addr, 0, sizeof(addr));
    addr.sun_path[0] = 0;
    MNLD_STRNCPY(addr.sun_path + 1, path,sizeof(addr.sun_path) - 1);
    addr.sun_family = AF_UNIX;

    while ((ret = sendto(fd, buff, len, 0,
        (const struct sockaddr *)&addr, sizeof(addr))) == -1) {
        if (errno == EINTR) continue;
        if (errno == EAGAIN) {
            if (retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
        }
        LOGE("safe_sendto() sendto() failed path=[%s] ret=%d reason=[%s]%d",
            path, ret, strerror(errno), errno);
        break;
    }

    close(fd);
    return ret;
}


// -1 means failure
int gnss_atci_safe_recvfrom(int fd, char* buff, int len) {
    int ret = 0;
    int retry = 10;

    int flags = fcntl(fd, F_GETFL, 0);
    if (fcntl(fd, F_SETFL, flags | O_NONBLOCK) == -1){
        LOGE("fcntl failed reason=[%s]%d",
                    strerror(errno), errno);
    }

    while ((ret = recvfrom(fd, buff, len, 0,
         (const struct sockaddr *)&sock_addr, sizeof(sock_addr))) == -1) {
        LOGW("gnss_atci_safe_recvfrom() ret=%d len=%d", ret, len);
        if (errno == EINTR) continue;
        if (errno == EAGAIN) {
            if (retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
        }
        LOGE("gnss_atci_safe_recvfrom() recvfrom() failed reason=[%s]%d",
            strerror(errno), errno);
        break;
    }
    return ret;
}

int gnss_atci_safe_recv(int fd, char* buff, int len) {
    int ret = 0;
    int retry = 10;

    while ((ret = read(fd, buff, len)) == -1) {
        LOGW("mnldinf_safe_recvfrom() ret=%d len=%d", ret, len);
        if (errno == EINTR) continue;
        if (errno == EAGAIN) {
            if (retry-- > 0) {
                usleep(100 * 1000);
                continue;
            }
        }
        LOGE("mnldinf_safe_recvfrom() recvfrom() failed reason=[%s]%d",
            strerror(errno), errno);
        break;
    }
    return ret;
}

