#ifndef __MNLDINF_EXT_INTERFACE_H__
#define __MNLDINF_EXT_INTERFACE_H__

#include "mnldinf_common.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MNLDINF_EXT_TCP  "mnldinf_ext"

typedef struct {
    void (*mnldinf_connection_broken)();
    void (*mnldinf_request_wakelock)();
    void (*mnldinf_release_wakelock)();

    void (*mnldinf_request_utc_time)();
    void (*mnldinf_request_nlp)(bool independent_from_gnss, bool is_user_emergency);
    void (*mnldinf_request_ni_notify)(int session_id, agps_ni_type ni_type, agps_notify_type type, const char* requestor_id,
            const char* client_name, ni_encoding_type requestor_id_encoding,
            ni_encoding_type client_name_encoding);

    void (*mnldinf_request_data_conn)(struct sockaddr_storage* addr, agps_type type);
    void (*mnldinf_release_data_conn)();

    void (*mnldinf_request_set_id)(request_setid flags);
    void (*mnldinf_request_ref_loc)(request_refloc flags);
    void (*mnldinf_output_vzw_debug)(const char* str);

    void (*mnldinf_update_gnss_name)(const char* name, int length);

    void (*mnldinf_gnss_navigation_msg)(gnss_nav_msg *msg);
    void (*mnldinf_nfw_access_notify)(mnldinf_nfw_notification *nfw_notify);
    void (*mnldinf_capability_update)(mnldinf_ext_server_cap *cap);
    void (*mnldinf_agps_location_update)(mnldinf_agps_location location);
} mnldinf_ext;

int mnldinf_ext_data_conn_open(int fd, const char* apn);
int mnldinf_ext_data_conn_open_with_apn_ip_type(int fd, uint64_t network_handle, const char* apn, apn_ip_type ip_type);
int mnldinf_ext_data_conn_closed(int fd);
int mnldinf_ext_data_conn_failed(int fd);

int mnldinf_ext_set_server(int fd, agps_type type, const char* hostname, int port);
int mnldinf_ext_set_ref_location(int fd, cell_type type, int mcc, int mnc, int lac, int cid);
int mnldinf_ext_set_id(int fd, agps_id_type type, const char* setid);
//OpenWRT can't response
int mnldinf_ext_update_network_state(int fd, uint64_t network_handle, bool is_connected,
            uint16_t capabilities, const char* apn);

int mnldinf_ext_update_network_availability(int fd, int available, const char* apn);

int mnldinf_ext_set_vzw_debug(int fd, bool enabled);

int mnldinf_ext_gnss_inject_time(int fd, int64_t time, int64_t time_reference, int uncertainty);
int mnldinf_ext_gnss_inject_location(int fd, double lat, double lng, float acc);
int mnldinf_ext_ni_message(int fd, char* msg, int len);
int mnldinf_ext_ni_respond(int fd, int notif_id, ni_user_response_type user_response);

int mnldinf_ext_gnss_delete_aiding_data(int fd, gnss_delete_flag flags);
int mnldinf_ext_gnss_set_position_mode(int fd, gps_pos_mode mode);
int mnldinf_ext_update_gnss_config(int fd, const char* config_data, int length);
int mnldinf_ext_set_sv_blacklist(int fd, long long* blacklist, int32_t size);
int mnldinf_ext_send_pmtk(int fd, char* msg, int len);

int mnldinf_ext_gnss_navigation_msg_enable(int fd, bool enable);
int mnldinf_ext_gnss_full_tracking_enable(int fd, bool enable);  //To be implement

int mnldinf_ext_epo_enable(int fd,  epo_bitmap epo_cfg);
int mnldinf_ext_set_nfw_access(int fd, char* proxy_apps, int32_t length);
int mnldinf_ext_set_correction(int fd, measurement_corrections* corrections);
int mnldinf_ext_set_ttff_acc(int fd, ttff_acc acc_mode);

// -1 means failure
int mnldinf_ext_cmd_hdlr(int fd, mnldinf_ext* hdlr);

int mnldinf_ext_register(char *client_name);

void mnldinf_ext_capability_config(int fd, mnldinf_ext_client_cap *cap);

#ifdef __cplusplus
}
#endif

#endif
