#include <string.h>

#ifndef MAX
#define MAX(A,B) ((A)>(B)?(A):(B))
#endif
#ifndef MIN
#define MIN(A,B) ((A)<(B)?(A):(B))
#endif

//===============================================================
// get
char mnldinf_get_byte(char* buff, int* offset, int src_len) {
    char ret = 0;
    if (*offset >= 0 && *offset < src_len) {
        ret = buff[*offset];
        *offset += 1;
    }
    return ret;
}

short mnldinf_get_short(char* buff, int* offset, int src_len) {
    short ret = 0;
    ret |= mnldinf_get_byte(buff, offset, src_len) & 0xff;
    ret |= (mnldinf_get_byte(buff, offset, src_len) << 8);
    return ret;
}

int mnldinf_get_int(char* buff, int* offset, int src_len) {
    int ret = 0;
    ret |= mnldinf_get_short(buff, offset, src_len) & 0xffff;
    ret |= (mnldinf_get_short(buff, offset, src_len) << 16);
    return ret;
}

long long mnldinf_get_long(char* buff, int* offset, int src_len) {
    long long ret = 0;
    ret |= mnldinf_get_int(buff, offset, src_len) & 0xffffffffL;
    ret |= ((long long)mnldinf_get_int(buff, offset, src_len) << 32);
    return ret;
}

float mnldinf_get_float(char* buff, int* offset, int src_len) {
    float ret;
    int tmp = mnldinf_get_int(buff, offset, src_len);
    ret = *((float*)&tmp);
    return ret;
}

double mnldinf_get_double(char* buff, int* offset, int src_len) {
    double ret;
    long long tmp = mnldinf_get_long(buff, offset, src_len);
    ret = *((double*)&tmp);
    return ret;
}

char* mnldinf_get_string(char* buff, int* offset, int src_len) {
    char ret = mnldinf_get_byte(buff, offset, src_len);
    if (ret == 0) {
        return NULL;
    } else {
        char* p = NULL;
        int len = mnldinf_get_int(buff, offset, src_len);
        if (*offset < 0 || *offset >= src_len) {
            *offset = 0;
        }
        if ((len > src_len - *offset) || len < 0) {
            len = src_len - *offset;
        }
        if (len <= 0) {
            return NULL;
        }
        p = &buff[*offset];
        p[len-1] = 0;
        *offset += len;
        return p;
    }
}

char* mnldinf_get_string2(char* buff, int* offset, int src_len) {
    char* output = mnldinf_get_string(buff, offset, src_len);
    if (output == NULL) {
        return "";
    } else {
        return output;
    }
}

int mnldinf_get_binary(char* buff, int* offset, char* output, int src_len, int des_len) {
    int len = 0;
    if (*offset >= 0 && *offset <= src_len) {
        len = mnldinf_get_int(buff, offset, src_len);
        if (len > MIN((src_len-(*offset)), des_len)) {
            len = MIN((src_len-(*offset)), des_len);
        }
        if (len > 0) {
            memcpy(output, &buff[*offset], len);
            *offset += len;
        }
    }
    return len;
}

//===============================================================
// put
void mnldinf_put_byte(char* buff, int* offset, const char input) {
    *((char*)&buff[*offset]) = input;
    *offset += 1;
}

void mnldinf_put_short(char* buff, int* offset, const short input) {
    mnldinf_put_byte(buff, offset, input & 0xff);
    mnldinf_put_byte(buff, offset, (input >> 8) & 0xff);
}

void mnldinf_put_int(char* buff, int* offset, const int input) {
    mnldinf_put_short(buff, offset, input & 0xffff);
    mnldinf_put_short(buff, offset, (input >> 16) & 0xffff);
}

void mnldinf_put_long(char* buff, int* offset, const long long input) {
    mnldinf_put_int(buff, offset, input & 0xffffffffL);
    mnldinf_put_int(buff, offset, ((input >> 32L) & 0xffffffffL));
}

void mnldinf_put_float(char* buff, int* offset, const float input) {
    int* data = (int*)&input;
    mnldinf_put_int(buff, offset, *data);
}

void mnldinf_put_double(char* buff, int* offset, const double input) {
    long long* data = (long long*)&input;
    mnldinf_put_long(buff, offset, *data);
}

void mnldinf_put_string(char* buff, int* offset, const char* input) {
    if (input == NULL) {
        mnldinf_put_byte(buff, offset, 0);
    } else {
        int len = strlen(input) + 1;
        mnldinf_put_byte(buff, offset, 1);
        mnldinf_put_int(buff, offset, len);
        memcpy(&buff[*offset], input, len);
        *offset += len;
    }
}

void mnldinf_put_binary(char* buff, int* offset, const char* input, const int len) {
    mnldinf_put_int(buff, offset, len);
    if (len > 0) {
        memcpy(&buff[*offset], input, len);
        *offset += len;
    }
}

