#include "hal2mnl_interface.h"
#include "mtk_lbs_utility.h"
#include "data_coder.h"
#ifdef __ANDROID_OS__
#include <cutils/sockets.h>
#include <log/log.h>     /*logging in logcat*/
#endif
#include "hardware/gps_mtk.h"
#include "gpshal.h"
#include "errno.h"
#include "mnldinf_log.h"
#include "mnldinf_utility.h"
#include "mnldinf_data_coder.h"

float count = 0;
float report_time_interval = 0;
extern gpshal_context_t g_gpshal_ctx;

int hal2mnl_hal_reboot() {
    LOGD("hal2mnl_hal_reboot");
    return 0;
    #if 0
    char buff[HAL_MNL_BUFF_SIZE] = {0};
    int offset = 0;
    mnldinf_put_int(buff, &offset, HAL_MNL_INTERFACE_VERSION);
    mnldinf_put_int(buff, &offset, HAL2MNL_HAL_REBOOT);

    return mnldinf_safe_sendto(MTK_HAL2MNL, buff, offset);
    #endif
}

int hal2mnl_gps_init() {
    return mnldinf_basic_gnss_init(g_gpshal_ctx.fd_mnl2hal_basic);
}

int hal2mnl_gps_start() {
    return mnldinf_basic_gnss_start(g_gpshal_ctx.fd_mnl2hal_basic);
}
int hal2mnl_gps_stop() {
    return mnldinf_basic_gnss_stop(g_gpshal_ctx.fd_mnl2hal_basic);
}

int hal2mnl_gps_cleanup() {
    return mnldinf_basic_gnss_cleanup(g_gpshal_ctx.fd_mnl2hal_basic);
}

int hal2mnl_gps_inject_time(int64_t time, int64_t time_reference, int uncertainty) {
    return mnldinf_ext_gnss_inject_time(g_gpshal_ctx.fd_mnl2hal_ext, time, time_reference, uncertainty);
}

int hal2mnl_gps_inject_location(double lat, double lng, float acc) {
    return mnldinf_ext_gnss_inject_location(g_gpshal_ctx.fd_mnl2hal_ext, lat, lng, acc);
}

int hal2mnl_gps_delete_aiding_data(int flags) {
    return mnldinf_ext_gnss_delete_aiding_data(g_gpshal_ctx.fd_mnl2hal_ext, flags);
}

int hal2mnl_gps_fix_interval(uint32_t interval){
    return mnldinf_ext_gnss_fix_interval(g_gpshal_ctx.fd_mnl2hal_ext, interval);
}

int hal2mnl_gps_opmode(uint8_t opmode){
    return mnldinf_ext_gnss_opmode(g_gpshal_ctx.fd_mnl2hal_ext, opmode);
}

int hal2mnl_gps_elevation_angle(uint8_t elevation){
    return mnldinf_ext_gnss_elevation_angle(g_gpshal_ctx.fd_mnl2hal_ext, elevation);
}

int hal2mnl_gps_l5_disable(bool flag){
    return mnldinf_ext_gnss_l5_disable(g_gpshal_ctx.fd_mnl2hal_ext, flag);
}

int hal2mnl_gps_set_position_mode(gps_pos_mode mode, gps_pos_recurrence recurrence,
    int min_interval, int preferred_acc, int preferred_time, bool lowPowerMode) {

    if (min_interval <= 1000) {
        report_time_interval = 1;
    } else {
        report_time_interval = (float)min_interval/1000;
    }
    LOGD("set report location time interval is %f s\n", report_time_interval);

    return mnldinf_ext_gnss_set_position_mode(g_gpshal_ctx.fd_mnl2hal_ext, mode);
}

int hal2mnl_data_conn_open(const char* apn) {
    return mnldinf_ext_data_conn_open(g_gpshal_ctx.fd_mnl2hal_ext, apn);
}

int hal2mnl_data_conn_open_with_apn_ip_type(uint64_t networkHandle, const char* apn, apn_ip_type ip_type) {
    return mnldinf_ext_data_conn_open_with_apn_ip_type(g_gpshal_ctx.fd_mnl2hal_ext, networkHandle, apn, ip_type);
}

int hal2mnl_data_conn_closed() {
    return mnldinf_ext_data_conn_closed(g_gpshal_ctx.fd_mnl2hal_ext);
}

int hal2mnl_data_conn_failed() {
    return mnldinf_ext_data_conn_failed(g_gpshal_ctx.fd_mnl2hal_ext);
}

int hal2mnl_set_server(agps_type type, const char* hostname, int port) {
    return mnldinf_ext_set_server(g_gpshal_ctx.fd_mnl2hal_ext, type, hostname, port);
}

int hal2mnl_set_ref_location(cell_type type, int mcc, int mnc, int lac, int cid) {
    return mnldinf_ext_set_ref_location(g_gpshal_ctx.fd_mnl2hal_ext, type, mcc, mnc, lac, cid);
}

int hal2mnl_set_id(agps_id_type type, const char* setid) {
    return mnldinf_ext_set_id(g_gpshal_ctx.fd_mnl2hal_ext, type, setid);
}


int hal2mnl_ni_message(char* msg, int len) {
    return mnldinf_ext_ni_message(g_gpshal_ctx.fd_mnl2hal_ext, msg, len);
}

int hal2mnl_ni_respond(int notif_id, ni_user_response_type user_response) {
    return mnldinf_ext_ni_respond(g_gpshal_ctx.fd_mnl2hal_ext, notif_id, user_response);
}

int hal2mnl_update_network_state(uint64_t networkHandle, bool isConnected,
            uint16_t capabilities, const char* apn) {
    return mnldinf_ext_update_network_state(g_gpshal_ctx.fd_mnl2hal_ext, networkHandle, isConnected,
            capabilities, apn);
}

int hal2mnl_update_network_availability(int available, const char* apn) {
    return mnldinf_ext_update_network_availability(g_gpshal_ctx.fd_mnl2hal_ext, available, apn);
}

int hal2mnl_set_gps_measurement(bool enabled, bool enableFullTracking) {
    int ret1 = 0, ret2 = 0;

    ret1 = mnldinf_basic_gnss_measurement_enable(g_gpshal_ctx.fd_mnl2hal_basic, enabled);
    ret2 = mnldinf_ext_gnss_full_tracking_enable(g_gpshal_ctx.fd_mnl2hal_ext, enableFullTracking);
    if(ret1 < 0 || ret2 < 0) {
        return -1;
    } else {
        return ret1+ret2;
    }
}

int hal2mnl_set_gps_navigation(bool enabled) {
    return mnldinf_ext_gnss_navigation_msg_enable(g_gpshal_ctx.fd_mnl2hal_ext, enabled);
}

int hal2mnl_set_vzw_debug(bool enabled) {
    return mnldinf_ext_set_vzw_debug(g_gpshal_ctx.fd_mnl2hal_ext, enabled);
}

int hal2mnl_update_gnss_config(const char* config_data, int length) {
    return mnldinf_ext_update_gnss_config(g_gpshal_ctx.fd_mnl2hal_ext, config_data, length);
}

int hal2mnl_setBlacklist(long long* blacklist, int32_t size) {
    return mnldinf_ext_set_sv_blacklist(g_gpshal_ctx.fd_mnl2hal_ext, blacklist, size);
}

int hal2mnl_set_correction(MeasurementCorrections* corrections) {
    return mnldinf_ext_set_correction(g_gpshal_ctx.fd_mnl2hal_ext, (measurement_corrections *)corrections);
}

int hal2mnl_set_nfw_access(char* proxy_apps, int32_t length) {
    return mnldinf_ext_set_nfw_access(g_gpshal_ctx.fd_mnl2hal_ext, proxy_apps, length);
}

int hal2mnl_send_pmtk(char* msg, int len) {
    return mnldinf_ext_send_pmtk(g_gpshal_ctx.fd_mnl2hal_ext, msg, len);
}

#define GNSS_HAL "gnss_hal"

// -1 means failure
int create_mnl2hal_fd_basic() {
    int fd = mnldinf_basic_register(GNSS_HAL);
    if(fd < 0) {
        LOGE("Fail to create basic fd reason=[%s]%d",
            strerror(errno), errno);
    }
    return fd;
}

// -1 means failure
int create_mnl2hal_fd_ext() {
    int fd = mnldinf_ext_register(GNSS_HAL);
    if(fd < 0) {
        LOGE("Fail to create extension fd reason=[%s]%d",
            strerror(errno), errno);
    }
    return fd;
}
