#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <stddef.h>  // offsetof
#include <stdarg.h>
#include <sys/stat.h>
#include <unistd.h>  // usleep
#include <sys/socket.h>
#include <string.h>
#include <fcntl.h>
#include <arpa/inet.h>  // inet_addr
#include <sys/un.h>  // struct sockaddr_un
#include <pthread.h>
#include <sys/epoll.h>
#include <signal.h>
#include <semaphore.h>
#include <sys/syscall.h>

#if defined(__ANDROID_OS__)
#include <cutils/log.h>     // Android log
#endif
#include "gpslog_log.h"

#include "gpslog_utility.h"
//#include "gpslog_socket_utils.h"

#ifdef LOG_TAG
#undef LOG_TAG
#endif
#define LOG_TAG "gpslog_utility"

sem_t g_mnld_exit_sem;

// -1 means failure
int gpslog_block_here() {
    if (sem_init(&g_mnld_exit_sem, 0, 0) == -1) {
        LOGE("block_here() sem_init failure reason=%s\n", strerror(errno));
        return -1;
    }
    sem_wait(&g_mnld_exit_sem);
    if (sem_destroy(&g_mnld_exit_sem) == -1) {
        LOGE("block_here() sem_destroy reason=%s\n", strerror(errno));
    }
    return 0;
}

void gpslog_block_exit(void) {
    if(sem_post(&g_mnld_exit_sem) == -1) {
        LOGE("sem_post failed");
        _exit(0);
    }
}

/*************************************************
* Epoll
**************************************************/
// -1 means failure
int gpslog_epoll_add_fd(int epfd, int fd) {
    struct epoll_event ev;
    memset(&ev, 0, sizeof(ev));
    ev.data.fd = fd;
    ev.events = EPOLLIN;
    // don't set the fd to edge trigger
    // the some event like accept may be lost if two or more clients are connecting to server at the same time
    // level trigger is preferred to avoid event lost
    // do not set EPOLLOUT due to it will always trigger when write is available
    if (epoll_ctl(epfd, EPOLL_CTL_ADD, fd, &ev) == -1) {
        LOGE("gpslog_epoll_add_fd() epoll_ctl() failed reason=[%s]%d epfd=%d fd=%d",
            strerror(errno), errno, epfd, fd);
        return -1;
    }
    return 0;
}
