/***********************************************************************
*   This software/firmware and related documentation ("MediaTek Software")
*   are protected under relevant copyright laws. The information contained
*   herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
*
*   Without the prior written permission of MediaTek Inc. and/or its licensors,
*   any reproduction, modification, use or disclosure of MediaTek Software, and
*   information contained herein, in whole or in part, shall be strictly prohibited.
*
*   MediaTek Inc. (C) [2008]. All rights reserved.
*
*************************************************************************/
#ifndef MTK_GPS_AGPS_H
#define MTK_GPS_AGPS_H


#ifdef __cplusplus
   extern "C" {
#endif

#include "mtk_gps_type.h"

#define MGPSID (32)
#if ( defined(__ARMCC_VERSION) && (__ARMCC_VERSION < 200000 ) )
// for ADS1.x
#elif ( defined(__ARMCC_VERSION) && (__ARMCC_VERSION < 400000 ) )
// for RVCT2.x or RVCT3.x
#else
#pragma pack(4)
#endif



#define GPS_EPH_WORD_MAX    24
#define GPS_L5_EPH_WORD_MAX 22
#if 1//def AGPS_SUPPORT_GNSS
#define GLO_EPH_WORD_MAX    12
#define BDS_EPH_WORD_MAX    15
#define GAL_EPH_WORD_MAX    18
#endif

#define GPS_ALM_WORD_MAX    8
#define GPS_L5_ALM_WORD_MAX    5
#if 1//def AGPS_SUPPORT_GNSS
#define GLO_ALM_WORD_MAX    6
#define BDS_ALM_WORD_MAX    8
#define GAL_ALM_WORD_MAX    19
#endif
#define SUPPORT_AGA
#define AGPS_RRLP_MAX_PRM 14

/* MACROS *******************************************************************/

/**
 * among LPP/RRC/RRLP, the max number of elements for GNSS data is different in some data fields.
 * we take the largest value as element definition for common interface
 */
#define GNSS_MAX_REF_TIME_SAT_ELEMENT                    16  /* 64 for LPP, 16 for RRC, 12 for RRLP. Use 16 to reduce structure size */
#define GNSS_MAX_REF_CELL_FTA_ELEMENT                    16  /* 16 for LPP, 1 for RRC/RRLP */

#define GNSS_MAX_GNSS_GENERIC_ASSIST_DATA_ELEMENT        16  /* 16 for LPP, 8 for RRC/RRLP in provide assistance data;
                                                                16 for LPP/RRLP, 8 for RRC in capability */

/* GNSS Time Model */
#define GNSS_MAX_TIME_MODEL_ELEMENT                       5  /* 15 for LPP, 7 for RRC/RRLP, Use 5 since gnss-TO-ID only 5 (GPS, Galileo, QZSS, GLONASS, BDS) */

/* GNSS DGNSS */
#define GNSS_MAX_DGNSS_SGN_TYPE_ELEMENT                   3  /* 3 for LPP/RRLP, 8 for RRC */
#define GNSS_MAX_DGNSS_CORRECTION_INFO_ELEMENT           16  /* 64 for LPP/RRC, 16 for RRLP. Use 16 to reduce structure size */

/* GNSS Navigation Model */
#define GNSS_MAX_NAV_SAT_ELEMENT                         16  /* 64 for LPP/RRC, 32 for RRLP. Use 16 to reduce structure size */
#define GNSS_MAX_NAV_SAT_ELEMENT_BIT_POS                 64  /* 64 for LPP/RRC, 32 for RRLP, dedicated for assist data req */
#define GNSS_MAX_NAV_STD_CLK_MODEL_ELEMENT                4  /* 2 for LPP/RRLP, 4 for RRC */
#define GNSS_MAX_NAV_CLOCK_MODEL_ELEMENT                  6  /* currently there is 6 clock models */
#define GNSS_MAX_NAV_ORBIT_MODEL_ELEMENT                  6  /* currently there is 6 orbit models */

/* GNSS Real Time Integrity */
#define GNSS_MAX_RTI_BAD_SAT_ELEMENT                     16  /* 64 for LPP/RRC, 16 for RRLP. Use 16 to reduce structure size */

/* GNSS Data Bit Assistance */
#define GNSS_MAX_DBA_SGN_TYPE_ELEMENT                     8  /* 8 for LPP/RRC/RRLP */
#define GNSS_MAX_DBA_SAT_ELEMENT                         16  /* 64 for LPP/RRC, 32 for RRLP. Use 16 to reduce structure size */
#define GNSS_MAX_DBA_BIT_LENGTH                          64  /* 1024 bit for LPP/RRC/RRLP, but RRLP use integer intead of bit. Process only max 64 bits to reduce structure size */

/* GNSS Acquisition Assitance */
#define GNSS_MAX_ACQ_ASSIST_SAT_ELEMENT                  16  /* 64 for LPP/RRC, 16 for RRLP. Use 16 to reduce structure size */

/* GNSS Almanac */
#define GNSS_MAX_ALMANAC_SAT_ELEMENT                     32  /* 64 for LPP/RRC, 36 for RRLP. Use 32 to reduce structure size */

/* GNSS Auxiliary Information */
#define GNSS_MAX_AUX_SAT_ELEMENT                         64  /* 64 for LPP/RRC/RRLP. Use 16 to reduce structure size */

/* GNSS BDS Grid Ion Model */
#define GNSS_MAX_BDS_GRID_ION_ELEMENT                    320  /* 320 for LPP/RRC/RRLP. Use 16 to reduce structure size.
                                                                Spec description of BDS-GridModelParameter\gridIonList:
                                                                This list provides ionospheric grid point information for each grid point. Up to 16 instances are used in this version of the specification. */

/* GNSS DBDS Correction */
#define GNSS_MAX_DBDS_SGN_TYPE_ELEMENT                    3  /* 3 for LPP/RRLP, 8 for RRC */
#define GNSS_MAX_DBDS_CORRECTION_ELEMENT                 16  /* 64 for LPP/RRC/RRLP. Use 16 to reduce structure size */


/* MTK supports standalone GPS+QZSS+GLONASS+Galileo+Beidou, and assisted-GNSS supports A-GPS+A-GLONASS+A-BDS */
#define GNSS_MAX_SUPPORT_NUM    0x06 /* A-GPS + A-GLONASS + A-BDS + A-Galileo + NavIC + QZSS */


/* GNSS Measurement Info */
#define GNSS_MAX_MEASURED_GNSS_ELEMENT                   GNSS_MAX_SUPPORT_NUM  /* 16 for LPP, 8 for RRC/RRLP, Use GNSS_MAX_SUPPORT_NUM to reduce structure size */
#define GNSS_MAX_MEASURED_SGN_PER_GNSS_ELEMENT                              4  /* 8 for LPP/RRC/RRLP, Use 4 to reduce structure size */
#define GNSS_MAX_MEASURED_SAT_PER_SGN_ELEMENT                              16  /* 64 for LPP/RRC, 16 for RRLP. Use 16 to reduce structure size */

/* GNSS Request Additional Generic Assist Data */
#define GNSS_MAX_REQ_ADD_GENERIC_ASSIST_DATA_ELEMENT     GNSS_MAX_SUPPORT_NUM  /* 16 for LPP, 8 for RRC, unspecified for RRLP (up to 40 bytes), Use 9 since number of generic assistance data type is only 9 */


/* GNSS ID Bitmap, use two-byte representation */
#define GNSS_ID_BITMAP_NONE     0x00
#define GNSS_ID_BITMAP_GPS      0x8000  /* gps     (0) */
#define GNSS_ID_BITMAP_SBAS     0x4000  /* sbas    (1) */
#define GNSS_ID_BITMAP_QZSS     0x2000  /* qzss    (2) */
#define GNSS_ID_BITMAP_GALILEO  0x1000  /* galileo (3) */
#define GNSS_ID_BITMAP_GLONASS  0x0800  /* glonass (4) */
#define GNSS_ID_BITMAP_BDS      0x0400  /* bds     (5) */
#define GNSS_ID_BITMAP_NAVIC    0x0200  /* navic   (6) */

#define GNSS_ID_BITMAP_GPS_GLONASS        (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_GLONASS)
#define GNSS_ID_BITMAP_GPS_BDS            (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_BDS)
#define GNSS_ID_BITMAP_GPS_GLONASS_BDS    (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_GLONASS | GNSS_ID_BITMAP_BDS)
#define GNSS_ID_BITMAP_GPS_GALILEO              (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_GALILEO)
#define GNSS_ID_BITMAP_GPS_QZSS                 (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_QZSS)
#define GNSS_ID_BITMAP_GPS_NAVIC              (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_NAVIC)
#define GNSS_ID_BITMAP_GPS_GLONASS_BDS_GALILEO    (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_GLONASS | GNSS_ID_BITMAP_BDS | GNSS_ID_BITMAP_GALILEO)
#define GNSS_ID_BITMAP_GPS_GLONASS_BDS_GALILEO_NAVIC    (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_GLONASS | GNSS_ID_BITMAP_BDS | GNSS_ID_BITMAP_GALILEO | GNSS_ID_BITMAP_NAVIC)
#define GNSS_ID_BITMAP_GPS_GLONASS_BDS_GALILEO_NAVIC_QZSS    (GNSS_ID_BITMAP_GPS | GNSS_ID_BITMAP_GLONASS | GNSS_ID_BITMAP_BDS | GNSS_ID_BITMAP_GALILEO | GNSS_ID_BITMAP_NAVIC | GNSS_ID_BITMAP_QZSS)

/* SBAS ID Bitmap, use one-byte representation */
#define SBAS_ID_BITMAP_NONE   0x00
#define SBAS_ID_BITMAP_WASS   0x80  /* waas  (0) */
#define SBAS_ID_BITMAP_EGNOS  0x40  /* egnos (1) */
#define SBAS_ID_BITMAP_MSAS   0x20  /* msas  (2) */
#define SBAS_ID_BITMAP_GAGAN  0x10  /* gagan (3) */

/* GNSS Signal IDs Bitmap, use one-byte representation
 * GNSS    | Bit 1  | Bit 2 | Bit 3 | Bit 4 | Bit 5 | Bit 6 | Bit 7 | Bit 8 |
 *         | (MSB)  |       |       |       |       |       |       | (LSB) |
 * --------+--------+-------+-------+-------+-------+-------+-------+-------+
 * GPS     | L1 C/A |  L1C  |  L2C  |   L5  | -- reserved --|-------|-------|
 * SBAS    |   L1   | -- reserved --|-------|-------|-------|-------|-------|
 * QZSS    | QZS-L1 |QZS-L1C|QZS-L2C| QZS-L5| -- reserved --|-------|-------|
 * GLONASS |   G1   |   G2  |  G3   | -- reserved --|-------|-------|-------|
 * Galileo |   E1   |   E5a |  E5b  |   E6  |E5a+E5b| -- reserved --|-------|
 * BDS     |   B1I  | -- reserved --|-------|-------|-------|-------|-------|
 */
/* GNSS signal spectrum */
#define GNSS_SGN_ID_BITMAP_GPS_L1C_A       0x80  /* bit 1 */
#define GNSS_SGN_ID_BITMAP_GPS_L1C         0x40  /* bit 2 */
#define GNSS_SGN_ID_BITMAP_GPS_L2C         0x20  /* bit 3 */
#define GNSS_SGN_ID_BITMAP_GPS_L5          0x10  /* bit 4 */

#define GNSS_SGN_ID_BITMAP_SBAS_L1         0x80  /* bit 1 */

#define GNSS_SGN_ID_BITMAP_QZSS_L1C_A      0x80  /* bit 1 */
#define GNSS_SGN_ID_BITMAP_QZSS_L1C        0x40  /* bit 2 */
#define GNSS_SGN_ID_BITMAP_QZSS_L2C        0x20  /* bit 3 */
#define GNSS_SGN_ID_BITMAP_QZSS_L5         0x10  /* bit 4 */

#define GNSS_SGN_ID_BITMAP_GLONASS_G1      0x80  /* bit 1 */
#define GNSS_SGN_ID_BITMAP_GLONASS_G2      0x40  /* bit 2 */
#define GNSS_SGN_ID_BITMAP_GLONASS_G3      0x20  /* bit 3 */

#define GNSS_SGN_ID_BITMAP_GALILEO_E1      0x80  /* bit 1 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E5A     0x40  /* bit 2 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E5B     0x20  /* bit 3 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E6      0x10  /* bit 4 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E5_A_B  0x08  /* bit 5 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E1C     0x04  /* bit 6 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E1A     0x02  /* bit 7 */
#define GNSS_SGN_ID_BITMAP_GALILEO_E1B     0x01  /* bit 8 */

#define GNSS_SGN_ID_BITMAP_BDS_B1I         0x80  /* bit 1 */

#define GNSS_SGN_ID_BITMAP_NAVIC_L5_SPS      0x80  /* bit 1 */

#define GNSS_SGN_ID_EXT_BITMAP_GPS_L2Z 0x8000  /* bit 1 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L2C_M 0x4000  /* bit 2 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L2C_L 0x2000  /* bit 3 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L2C_M_L 0x1000  /* bit 4 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L5I 0x0800  /* bit 5 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L5Q 0x0400  /* bit 6 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L5_I_Q 0x0200  /* bit 7 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L1C_D 0x0100  /* bit 8 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L1C_P 0x0080  /* bit 9 */
#define GNSS_SGN_ID_EXT_BITMAP_GPS_L1C_D_P 0x0040  /* bit 10 */

#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L2C_L 0x8000  /* bit 1 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L2C_M_L 0x4000  /* bit 2 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L5I 0x2000  /* bit 3 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L5Q 0x1000  /* bit 4 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L5_I_Q 0x0800  /* bit 5 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L1C_D 0x0400  /* bit 6 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L1C_P 0x0200  /* bit 7 */
#define GNSS_SGN_ID_EXT_BITMAP_QZSS_L1C_D_P 0x0100  /* bit 8 */

#define GNSS_SGN_ID_EXT_BITMAP_GLONASS_G2A_I 0x8000  /* bit 1 */
#define GNSS_SGN_ID_EXT_BITMAP_GLONASS_G2A_P 0x4000  /* bit 2 */
#define GNSS_SGN_ID_EXT_BITMAP_GLONASS_G2A_I_P 0x2000  /* bit 3 */
#define GNSS_SGN_ID_EXT_BITMAP_GLONASS_G3I 0x1000  /* bit 4 */
#define GNSS_SGN_ID_EXT_BITMAP_GLONASS_G3Q 0x0800  /* bit 5 */
#define GNSS_SGN_ID_EXT_BITMAP_GLONASS_G3_I_Q 0x0400  /* bit 6 */

#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E1_B_C 0x8000  /* bit 1 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E1_A_B_C 0x4000  /* bit 2 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E6C 0x2000  /* bit 3 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E6A 0x1000  /* bit 4 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E6B 0x0800  /* bit 5 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E6_B_C 0x0400  /* bit 6 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E6_A_B_C 0x0200  /* bit 7 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5B_I 0x0100  /* bit 8 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5B_Q 0x0080  /* bit 9 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5B_I_Q 0x0040  /* bit 10 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5_A_B_I 0x0020  /* bit 11 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5_A_B_Q 0x0010  /* bit 12 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5_A_B_I_Q 0x0008  /* bit 13 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5A_I 0x0004  /* bit 14 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5A_Q 0x0002  /* bit 15 */
#define GNSS_SGN_ID_EXT_BITMAP_GALILEO_E5A_I_Q 0x0001  /* bit 16 */

#define GNSS_SGN_ID_EXT_BITMAP_BDS_B2_I_Q 0x8000  /* bit 1 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B1C_D 0x4000  /* bit 2 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B1C_P 0x2000  /* bit 3 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B1C_D_P 0x1000  /* bit 4 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B2A_D (0x0800 )  /* bit 20 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B2A_P (0x0400 )  /* bit 19 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B2A_D_P (0x0200 )  /* bit 18 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B2B_I (0x0100 )  /* bit 17 */
#define GNSS_SGN_ID_EXT_BITMAP_BDS_B2B_Q (0x0080 )  /* bit 16 */

/* GNSS Signal ID value */
#define GNSS_SGN_ID_VALUE_GPS_L1C_A       0
#define GNSS_SGN_ID_VALUE_GPS_L1C         1
#define GNSS_SGN_ID_VALUE_GPS_L2C         2
#define GNSS_SGN_ID_VALUE_GPS_L5          3
#define GNSS_SGN_ID_VALUE_GPS_L1P 4
#define GNSS_SGN_ID_VALUE_GPS_L1Z 5
#define GNSS_SGN_ID_VALUE_GPS_L2_C_A 6
#define GNSS_SGN_ID_VALUE_GPS_L2P 7
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2Z 8
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2C_M 9
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2C_L 10
#define GNSS_SGN_ID_EXT_VALUE_GPS_L2C_M_L 11
#define GNSS_SGN_ID_EXT_VALUE_GPS_L5I 12
#define GNSS_SGN_ID_EXT_VALUE_GPS_L5Q 13
#define GNSS_SGN_ID_EXT_VALUE_GPS_L5_I_Q 14
#define GNSS_SGN_ID_EXT_VALUE_GPS_L1C_D 15
#define GNSS_SGN_ID_EXT_VALUE_GPS_L1C_P 16
#define GNSS_SGN_ID_EXT_VALUE_GPS_L1C_D_P 17

#define GNSS_SGN_ID_VALUE_SBAS_L1         0
#define GNSS_SGN_ID_VALUE_SBAS_L5I 1
#define GNSS_SGN_ID_VALUE_SBAS_L5Q 2
#define GNSS_SGN_ID_VALUE_SBAS_L5_I_Q 3

#define GNSS_SGN_ID_VALUE_QZSS_L1C_A      0
#define GNSS_SGN_ID_VALUE_QZSS_L1C        1
#define GNSS_SGN_ID_VALUE_QZSS_L2C        2
#define GNSS_SGN_ID_VALUE_QZSS_L5         3
#define GNSS_SGN_ID_VALUE_QZSS_LEX_S 4
#define GNSS_SGN_ID_VALUE_QZSS_LEX_L 5
#define GNSS_SGN_ID_VALUE_QZSS_LEX_S_L 6
#define GNSS_SGN_ID_VALUE_QZSS_L2C_M 7
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L2C_L 8
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L2C_M_L 9
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L5I 10
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L5Q 11
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L5_I_Q 12
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L1C_D 13
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L1C_P 14
#define GNSS_SGN_ID_EXT_VALUE_QZSS_L1C_D_P 15

#define GNSS_SGN_ID_VALUE_GLONASS_G1      0
#define GNSS_SGN_ID_VALUE_GLONASS_G2      1
#define GNSS_SGN_ID_VALUE_GLONASS_G3      2
#define GNSS_SGN_ID_VALUE_GLONASS_G1P 3
#define GNSS_SGN_ID_VALUE_GLONASS_G2P 4
#define GNSS_SGN_ID_VALUE_GLONASS_G1A_D 5
#define GNSS_SGN_ID_VALUE_GLONASS_G1A_P 6
#define GNSS_SGN_ID_VALUE_GLONASS_G1A_D_P 7
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G2A_I 8
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G2A_P 9
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G2A_I_P 10
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G3I 11
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G3Q 12
#define GNSS_SGN_ID_EXT_VALUE_GLONASS_G3_I_Q 13

#define GNSS_SGN_ID_VALUE_GALILEO_E1      0
#define GNSS_SGN_ID_VALUE_GALILEO_E5A     1
#define GNSS_SGN_ID_VALUE_GALILEO_E5B     2
#define GNSS_SGN_ID_VALUE_GALILEO_E6      3
#define GNSS_SGN_ID_VALUE_GALILEO_E5_A_B  4
#define GNSS_SGN_ID_VALUE_GALILEO_E1C 5
#define GNSS_SGN_ID_VALUE_GALILEO_E1A 6
#define GNSS_SGN_ID_VALUE_GALILEO_E1B 7
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E1_B_C 8
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E1_A_B_C 9
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6C 10
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6A 11
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6B 12
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6_B_C 13
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E6_A_B_C 14
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5B_I 15
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5B_Q 16
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5B_I_Q 17
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5_A_B_I 18
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5_A_B_Q 19
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5_A_B_I_Q 20
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5A_I 21
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5A_Q 22
#define GNSS_SGN_ID_EXT_VALUE_GALILEO_E5A_I_Q 23

#define GNSS_SGN_ID_VALUE_BDS_B1I         0
#define GNSS_SGN_ID_VALUE_BDS_B1Q 1
#define GNSS_SGN_ID_VALUE_BDS_B1_I_Q 2
#define GNSS_SGN_ID_VALUE_BDS_B3I 3
#define GNSS_SGN_ID_VALUE_BDS_B3Q 4
#define GNSS_SGN_ID_VALUE_BDS_B3_I_Q 5
#define GNSS_SGN_ID_VALUE_BDS_B2I 6
#define GNSS_SGN_ID_VALUE_BDS_B2Q 7
#define GNSS_SGN_ID_EXT_VALUE_BDS_B2_I_Q 8
#define GNSS_SGN_ID_EXT_VALUE_BDS_B1C_D 9
#define GNSS_SGN_ID_EXT_VALUE_BDS_B1C_P 10
#define GNSS_SGN_ID_EXT_VALUE_BDS_B1C_D_P 11

#define GNSS_SGN_ID_VALUE_NAVIC_L5_SPS 0

#define GNSS_SGN_ID_VALUE_MAX             7
#define GNSS_SGN_ID_EXT_VALUE_MAX 23

/* GNSS Clock and Orbit Model Value (for Navigation Model) */
#define GNSS_NAV_CLOCK_MODEL_1_VALUE_STANDARD  1  /* model-1 */
#define GNSS_NAV_CLOCK_MODEL_2_VALUE_NAV       2  /* model-2 */
#define GNSS_NAV_CLOCK_MODEL_3_VALUE_CNAV      3  /* model-3 */
#define GNSS_NAV_CLOCK_MODEL_4_VALUE_GLONASS   4  /* model-4 */
#define GNSS_NAV_CLOCK_MODEL_5_VALUE_SBAS      5  /* model-5 */
#define GNSS_NAV_CLOCK_MODEL_6_VALUE_BDS       6  /* model-6 */
#define GNSS_NAV_CLOCK_MODEL_8_VALUE_NAVIC     8  /* model-8 */

#define GNSS_NAV_ORBIT_MODEL_1_VALUE_KEPLERIAN_SET       1  /* model-1 */
#define GNSS_NAV_ORBIT_MODEL_2_VALUE_NAV_KEPLERIAN_SET   2  /* model-2 */
#define GNSS_NAV_ORBIT_MODEL_3_VALUE_CNAV_KEPLERIAN_SET  3  /* model-3 */
#define GNSS_NAV_ORBIT_MODEL_4_VALUE_GLONASS_ECEF        4  /* model-4 */
#define GNSS_NAV_ORBIT_MODEL_5_VALUE_SBAS_ECEF           5  /* model-5 */
#define GNSS_NAV_ORBIT_MODEL_6_VALUE_BDS_KEPLERIAN_SET   6  /* model-6 */
#define GNSS_NAV_ORBIT_MODEL_8_VALUE_NAVIC_KEPLERIAN_SET 8  /* model-8 */

/* Almanac Model Value */
#define GNSS_ALMANAC_MODEL_1_VALUE_KEPLERIAN_SET          1  /* model-1 */
#define GNSS_ALMANAC_MODEL_2_VALUE_NAV_KEPLERIAN_SET      2  /* model-2 */
#define GNSS_ALMANAC_MODEL_3_VALUE_REDUCED_KEPLERIAN_SET  3  /* model-3 */
#define GNSS_ALMANAC_MODEL_4_VALUE_MIDI_KEPLERIAN_SET     4  /* model-4 */
#define GNSS_ALMANAC_MODEL_5_VALUE_GLONASS_SET            5  /* model-5 */
#define GNSS_ALMANAC_MODEL_6_VALUE_ECEF_SBAS_SET          6  /* model-6 */
#define GNSS_ALMANAC_MODEL_7_VALUE_BDS_ALMANAC_SET        7  /* model-7 */
#define GNSS_ALMANAC_MODEL_8_VALUE_NAVIC_ALMANAC_SET      8  /* model-8 */

/* UTC Model Value */
#define GNSS_UTC_MODEL_1_VALUE  1  /* model-1 (0) */
#define GNSS_UTC_MODEL_2_VALUE  2  /* model-2 (1) */
#define GNSS_UTC_MODEL_3_VALUE  3  /* model-3 (2) */
#define GNSS_UTC_MODEL_4_VALUE  4  /* model-4 (3) */
#define GNSS_UTC_MODEL_5_VALUE  5  /* model-5 (4) */

/* Ionospheric Model */
#define GNSS_ION_MODEL_KLOBUCHAR  0x80  /* klobuchar (0) */
#define GNSS_ION_MODEL_NEQUICK    0x40  /* neQuick   (1) */

/* Klobuchar Model Parameter - dataID (2 bits) */
/**
 * '11': the parameters have been generated by QZSS
 * '10': the parameters have been generated by NAVIC
 * '01': the parameters have been generated by BDS
 * '00': the parameters are applicable worldwide
 */
#define GNSS_ION_KLOBUCHAR_DATA_ID_VALUE_QZSS    0x03
#define GNSS_ION_KLOBUCHAR_DATA_ID_VALUE_NAVIC   0x02
#define GNSS_ION_KLOBUCHAR_DATA_ID_VALUE_BDS     0x01
#define GNSS_ION_KLOBUCHAR_DATA_ID_VALUE_WW      0x00
#define GNSS_ION_KLOBUCHAR_DATA_ID_MASK          0x03

/* Navigation Model */
#define GNSS_NAV_CLOCK_MODEL_1_STANDARD  0x80  /* model-1 (0) */
#define GNSS_NAV_CLOCK_MODEL_2_NAV       0x40  /* model-2 (1) */
#define GNSS_NAV_CLOCK_MODEL_3_CNAV      0x20  /* model-3 (2) */
#define GNSS_NAV_CLOCK_MODEL_4_GLONASS   0x10  /* model-4 (3) */
#define GNSS_NAV_CLOCK_MODEL_5_SBAS      0x08  /* model-5 (4) */
#define GNSS_NAV_CLOCK_MODEL_6_BDS       0x04  /* model-6 (5) */
#define GNSS_NAV_CLOCK_MODEL_7_BDS2      0x02  /* model-7 (6) */
#define GNSS_NAV_CLOCK_MODEL_8_NAVIC     0x01  /* model-8 (7) */

#define GNSS_NAV_ORBIT_MODEL_1_KEPLERIAN_SET       0x80  /* model-1 (0) */
#define GNSS_NAV_ORBIT_MODEL_2_NAV_KEPLERIAN_SET   0x40  /* model-2 (1) */
#define GNSS_NAV_ORBIT_MODEL_3_CNAV_KEPLERIAN_SET  0x20  /* model-3 (2) */
#define GNSS_NAV_ORBIT_MODEL_4_GLONASS_ECEF        0x10  /* model-4 (3) */
#define GNSS_NAV_ORBIT_MODEL_5_SBAS_ECEF           0x08  /* model-5 (4) */
#define GNSS_NAV_ORBIT_MODEL_6_BDS_KEPLERIAN_SET   0x04  /* model-6 (5) */
#define GNSS_NAV_ORBIT_MODEL_7_BDS_KEPLERIAN_SET2  0x02  /* model-7 (6) */
#define GNSS_NAV_ORBIT_MODEL_8_NAVIC_KEPLERIAN_SET 0x01  /* model-8 (7) */


/* Almanac */
#define GNSS_ALMANAC_MODEL_1_KEPLERIAN_SET          0x80  /* model-1 (0) */
#define GNSS_ALMANAC_MODEL_2_NAV_KEPLERIAN_SET      0x40  /* model-2 (1) */
#define GNSS_ALMANAC_MODEL_3_REDUCED_KEPLERIAN_SET  0x20  /* model-3 (2) */
#define GNSS_ALMANAC_MODEL_4_MIDI_KEPLERIAN_SET     0x10  /* model-4 (3) */
#define GNSS_ALMANAC_MODEL_5_GLONASS_SET            0x08  /* model-5 (4) */
#define GNSS_ALMANAC_MODEL_6_ECEF_SBAS_SET          0x04  /* model-6 (5) */
#define GNSS_ALMANAC_MODEL_7_BDS_ALMANAC_SET        0x02  /* model-7 (6) */
#define GNSS_ALMANAC_MODEL_8_NAVIC_ALMANAC_SET      0x01  /* model-8 (7) */


/* UTC Model*/
#define GNSS_UTC_MODEL_1  0x80  /* model-1 (0) */
#define GNSS_UTC_MODEL_2  0x40  /* model-2 (1) */
#define GNSS_UTC_MODEL_3  0x20  /* model-3 (2) */
#define GNSS_UTC_MODEL_4  0x10  /* model-4 (3) */
#define GNSS_UTC_MODEL_5  0x08  /* model-5 (4) */


/* GNSS measurement fields validity bitmask */
#define GNSS_MEAS_INFO_CARRIER_QUALITY_VALIDITY   0x01
#define GNSS_MEAS_INFO_INT_CODE_PHASE_VALIDITY    0x02
#define GNSS_MEAS_INFO_DOPPLER_VALIDITY           0x04
#define GNSS_MEAS_INFO_ADR_VALIDITY               0x08
#define GNSS_MEAS_INFO_ALL_VALIDITY               0x0F

#define CHECK_GNSS_MEAS_INFO_CARRIER_QUALITY_VALIDITY(validity)      ((validity & GNSS_MEAS_INFO_ALL_VALIDITY) & GNSS_MEAS_INFO_CARRIER_QUALITY_VALIDITY) ? KAL_TRUE : KAL_FALSE
#define SET_GNSS_MEAS_INFO_CARRIER_QUALITY_VALIDITY(validity)        (validity |= GNSS_MEAS_INFO_CARRIER_QUALITY_VALIDITY)

#define CHECK_GNSS_MEAS_INFO_INT_CODE_PHASE_VALIDITY(validity)       ((validity & GNSS_MEAS_INFO_ALL_VALIDITY) & GNSS_MEAS_INFO_INT_CODE_PHASE_VALIDITY) ? KAL_TRUE : KAL_FALSE
#define SET_GNSS_MEAS_INFO_INT_CODE_PHASE_VALIDITY(validity)         (validity |= GNSS_MEAS_INFO_INT_CODE_PHASE_VALIDITY)

#define CHECK_GNSS_MEAS_INFO_DOPPLER_VALIDITY(validity)              ((validity & GNSS_MEAS_INFO_ALL_VALIDITY) & GNSS_MEAS_INFO_DOPPLER_VALIDITY) ? KAL_TRUE : KAL_FALSE
#define SET_GNSS_MEAS_INFO_DOPPLER_VALIDITY(validity)                (validity |= GNSS_MEAS_INFO_DOPPLER_VALIDITY)

#define CHECK_GNSS_MEAS_INFO_ADR_VALIDITY(validity)                  ((validity & GNSS_MEAS_INFO_ALL_VALIDITY) & GNSS_MEAS_INFO_ADR_VALIDITY) ? KAL_TRUE : KAL_FALSE
#define SET_GNSS_MEAS_INFO_ADR_VALIDITY(validity)                    (validity |= GNSS_MEAS_INFO_ADR_VALIDITY)


/* GNSS assist data type bitmask */
#define GNSS_ASSIST_MASK_NONE                        0x0

#define GNSS_COM_ASSIST_MASK_REF_TIME                (1 << 0)  /* 0x0001 */
#define GNSS_COM_ASSIST_MASK_REF_LOCATION            (1 << 1)  /* 0x0002 */
#define GNSS_COM_ASSIST_MASK_IONOSPHERE              (1 << 2)  /* 0x0004 */
#define GNSS_COM_ASSIST_MASK_EARTH_ORIENT_PARAMS     (1 << 3)  /* 0x0008 */

#define GNSS_GEN_ASSIST_MASK_TIME_MODEL              (1 << 4)  /* 0x0010 */
#define GNSS_GEN_ASSIST_MASK_DGNSS_CORRECTION        (1 << 5)  /* 0x0020 */
#define GNSS_GEN_ASSIST_MASK_NAV_MODEL               (1 << 6)  /* 0x0040 */
#define GNSS_GEN_ASSIST_MASK_RTI                     (1 << 7)  /* 0x0080 */
#define GNSS_GEN_ASSIST_MASK_DATA_BIT_ASSIST         (1 << 8)  /* 0x0100 */
#define GNSS_GEN_ASSIST_MASK_ACQUISITION             (1 << 9)  /* 0x0200 */
#define GNSS_GEN_ASSIST_MASK_ALMANAC                 (1 <<10)  /* 0x0400 */
#define GNSS_GEN_ASSIST_MASK_UTC_MODEL               (1 <<11)  /* 0x0800 */
#define GNSS_GEN_ASSIST_MASK_AUX_INFO                (1 <<12)  /* 0x1000 */
#define GNSS_GEN_ASSIST_MASK_DBDS_CORRECTION         (1 <<13)  /* 0x2000 */
#define GNSS_GEN_ASSIST_MASK_BDS_GRID_MODEL          (1 <<14)  /* 0x4000 */

// LPPE HA Part
#define MAX_ENUM_VALUE    2147483647

#define GNSS_HA_COM_ASSIST_MASK_IONOSPHERE           (1 << 15)  /* 0x08000 */
#define GNSS_HA_COM_ASSIST_MASK_TROPOSPHERE          (1 << 16)  /* 0x10000 */
#define GNSS_HA_COM_ASSIST_MASK_ALTITUDE             (1 << 17)  /* 0x20000 */
#define GNSS_HA_COM_ASSIST_MASK_SOLAR_RADIATION      (1 << 18)  /* 0x40000 */
#define GNSS_HA_COM_ASSIST_MASK_CCP                 (1 << 19)  /* 0x80000 */
#define GNSS_HA_GEN_ASSIST_MASK_CCP                (1 << 20)  /* 0x100000 */
#define GNSS_HA_GEN_ASSIST_MASK_DEGRADATION         (1 << 21)  /* 0x200000 */


#define GNSS_ASSIST_MB_MANDATORY_MASK                (GNSS_COM_ASSIST_MASK_REF_TIME            | \
                                                      GNSS_COM_ASSIST_MASK_REF_LOCATION        | \
                                                      GNSS_COM_ASSIST_MASK_IONOSPHERE          | \
                                                      GNSS_COM_ASSIST_MASK_EARTH_ORIENT_PARAMS | \
                                                      GNSS_GEN_ASSIST_MASK_TIME_MODEL          | \
                                                      GNSS_GEN_ASSIST_MASK_DGNSS_CORRECTION    | \
                                                      GNSS_GEN_ASSIST_MASK_NAV_MODEL           | \
                                                      GNSS_GEN_ASSIST_MASK_RTI                 | \
                                                      GNSS_GEN_ASSIST_MASK_DATA_BIT_ASSIST     | \
                                                      GNSS_GEN_ASSIST_MASK_ALMANAC             | \
                                                      GNSS_GEN_ASSIST_MASK_UTC_MODEL           | \
                                                      GNSS_GEN_ASSIST_MASK_AUX_INFO            | \
                                                      GNSS_GEN_ASSIST_MASK_DBDS_CORRECTION     | \
                                                      GNSS_GEN_ASSIST_MASK_BDS_GRID_MODEL)     /* 0x7DFF */


#define GNSS_ASSIST_MA_MANDATORY_MASK               (GNSS_COM_ASSIST_MASK_REF_TIME             | \
                                                     GNSS_GEN_ASSIST_MASK_ACQUISITION          | \
                                                     GNSS_GEN_ASSIST_MASK_AUX_INFO)      /* 0x1201 */


#define GNSS_ASSIST_TIME_INDEPENDENT_MASK           (GNSS_COM_ASSIST_MASK_REF_LOCATION)  /* 0x0002 */


#define GNSS_LAST_SEC_TIME       1000
#define GNSS_MDT_GPS_RESPONSE_TIME  1000
#define GNSS_MDT_LBS_ERRC_PERIOD_TIME  1280
#define GNSS_INIT_TIMER_INTERVAL       10000


/* ---LPPe HA GNSS Interface--- maximum element definition */
#define GNSS_HA_MAX_LOCAL_KLOBUCHAR_MODEL_ELEMENT     16
#define GNSS_HA_MAX_LOCAL_KLOBUCHAR_MODEL              8
#define GNSS_HA_MAX_STORM_ELEMENT                     16
#define GNSS_HA_MAX_LOCAL_TROPO_DELAY_AREA_ELEMENT     8
#define GNSS_HA_MAX_LOCAL_TROPO_DELAY_TIME_ELEMENT     8
#define GNSS_HA_MAX_LOCAL_SURFACE_PARAMS_ELEMENT       8
#define GNSS_HA_MAX_LOCAL_SURFACE_PARAMS_TIME_ELEMENT  8
#define GNSS_HA_MAX_ALTITUDE_ASSIST_AREA_ELEMENT       8
#define GNSS_HA_MAX_PRESSURE_ASSIST_ELEMENT           16
#define GNSS_HA_MAX_CCP_SIGNAL_SUPP_ELEMENT            8
#define GNSS_HA_MAX_CCP_PREF_STATION_LIST_ELEMENT      8  /* OMA-TS-LPPe: maxReferenceStations */
#define GNSS_HA_MAX_WA_IONO_SURF_PER_SV_ELEMENT       16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */
#define GNSS_HA_MAX_MECHANICS_SV_ELEMENT              16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */
#define GNSS_HA_MAX_DCB_LIST_ELEMENT                  16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */
#define GNSS_HA_MAX_DCB_ELEMENT                       16
#define GNSS_HA_MAX_DEGRAD_MODEL_ELEMENT              16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */
#define GNSS_HA_MAX_CCP_GENERIC_ELEMENT                8
#define GNSS_HA_MAX_CCP_PER_SIG_ELEMENT                8
#define GNSS_HA_MAX_CCP_PER_SV_ELEMENT                16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */
#define GNSS_HA_MAX_REQ_NAV_MODEL_ID_ELEMENT           8
#define GNSS_HA_MAX_MEAS_PER_GNSS_ELEMENT             16
#define GNSS_HA_MAX_MEAS_PER_SIGNAL_ELEMENT            8
#define GNSS_HA_MAX_MEAS_PER_SV_ELEMENT               16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */
#define GNSS_HA_MAX_TEC_PER_SV_ELEMENT                16  /* OMA-TS-LPPe: defines 64, reduce size to 16 */

#define GNSS_HA_MAX_GNSS_GENERIC_ASSIST_DATA_ELEMENT  16
#define GNSS_HA_MAX_GENERIC_AD_NAV_MODEL_ID_ELEMENT    8
#define GNSS_HA_MAX_HA_GNSS_CAPA_ELEMENT               8


/* ---LPPe HA GNSS Interface--- optional field validity bit definition */
#define GNSS_HA_MAPPING_FUNC_PARAMS_BIT_BH_VALID      0x80
#define GNSS_HA_MAPPING_FUNC_PARAMS_BIT_CH_VALID      0x40
#define GNSS_HA_MAPPING_FUNC_PARAMS_BIT_AW_VALID      0x20
#define GNSS_HA_MAPPING_FUNC_PARAMS_BIT_BW_VALID      0x10
#define GNSS_HA_MAPPING_FUNC_PARAMS_BIT_CW_VALID      0x08

#define GNSS_HA_LOCAL_TROPO_DELAY_TIME_ELEMENT_BIT_EH_VALID     0x80
#define GNSS_HA_LOCAL_TROPO_DELAY_TIME_ELEMENT_BIT_ZW0_VALID    0x40
#define GNSS_HA_LOCAL_TROPO_DELAY_TIME_ELEMENT_BIT_EW_VALID     0x20
#define GNSS_HA_LOCAL_TROPO_DELAY_TIME_ELEMENT_BIT_GN_VALID     0x10
#define GNSS_HA_LOCAL_TROPO_DELAY_TIME_ELEMENT_BIT_GE_VALID     0x08

#define GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_GN_PRESSURE       0x80
#define GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_GE_PRESSURE       0x40
#define GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_TEMPERATURE       0x20
#define GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_TEMPERATURE_RATE  0x10
#define GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_GN_TEMPERATURE    0x08
#define GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_GE_TEMPERATURE    0x04


/* ---LPPe HA GNSS Interface--- bitmask field bit defintion */
#define GNSS_HA_COMM_AD_REQ_IONO_BIT_KLOBUCHAR_MODEL        0x01
#define GNSS_HA_COMM_AD_REQ_IONO_BIT_IONO_STORM_WARNING     0x02

#define GNSS_HA_COMM_AD_REQ_TROPO_BIT_DELAY_LIST            0x01
#define GNSS_HA_COMM_AD_REQ_TROPO_BIT_SURFACE_PARAMS        0x02

#define GNSS_HA_IONO_MEAS_REQ_BIT_TEC_PER_SV                0x01
#define GNSS_HA_IONO_MEAS_REQ_BIT_ZENITH_TEC                0x02

#define GNSS_HA_COMM_IONO_AD_SUPP_BIT_LOCAL_KLOBUCHAR            0x01
#define GNSS_HA_COMM_IONO_AD_SUPP_BIT_IONO_STORM_WARNING         0x02
#define GNSS_HA_COMM_IONO_AD_SUPP_BIT_WIDE_AREA_IONO_SURFACE     0x04

#define GNSS_HA_COMM_TROPO_AD_SUPP_BIT_LOCAL_TROPOSPHERE_DELAY   0x01
#define GNSS_HA_COMM_TROPO_AD_SUPP_BIT_SURFACE_PARAMETERS        0x02
#define GNSS_HA_COMM_TROPO_AD_SUPP_BIT_MULTI_GRID_POINTS         0x04

#define GNSS_HA_COMM_CCP_AD_SUPP_BIT_SUPPORT_AREA_ASSIST         0x01
#define GNSS_HA_COMM_CCP_AD_SUPP_BIT_MULTI_REF_STATION           0x02

#define GNSS_HA_GENE_AD_SUPP_BIT_BIT_TEC_PER_SV                  0x01
#define GNSS_HA_GENE_AD_SUPP_BIT_BIT_ZENITH_TEC                  0x02

#define GNSS_HA_MODE_SUPPORT_BIT_UE_BASED                        0x01
#define GNSS_HA_MODE_SUPPORT_BIT_UE_ASSISTED                     0x02

#define GNSS_HA_ANT_SUPPORT_BIT_ANT_DESCRIPTION                  0x01
#define GNSS_HA_ANT_SUPPORT_BIT_ANT_ORIENTATION                  0x02


/* GNSS standard clock model element */
#define ITEM_0_IS_INAV 0
#define ITEM_1_IS_INAV 1
#define ITEM_0_IS_FNAV 0
#define ITEM_1_IS_FNAV 1
#define STANDARD_CLOCK_MODEL_INAV 0
#define STANDARD_CLOCK_MODEL_FNAV 1


/* ---LPP HA GNSS Interface--- maximum element definition */
#define GNSS_MAX_EQUAL_INT_AMBIGUITY_LEVEL_REF_STATION_ID_NUM 16
#define GNSS_MAX_SSR_RELATIVE_LOCATION_ELEMENT 64
#define GNSS_MAX_RTK_SAT_SIGNAL_DATA_ELEMENT 24
#define GNSS_MAX_RTK_SAT_DATA_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_ORBIT_CORRECTION_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_CLOCK_CORRECTION_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_CODE_BIAS_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_CODE_BIAS_SIG_ELEMENT 16
#define GNSS_MAX_SSR_URA_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_PHASE_BIAS_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_PHASE_BIAS_SIG_ELEMENT 16
#define GNSS_MAX_SSR_STEC_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_STEC_RESIDUAL_SAT_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_SSR_GRID_ELEMENT 64
#define GNSS_MAX_NAVIC_CORRECTION_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */
#define GNSS_MAX_NAVIC_REGION_IGP_ELEMENT 16
#define GNSS_MAX_SAT_LIST_ELEMENT 32 /* Spec defines 64, use 32 to reduce structure size */




typedef enum {
    MTK_AGPS_OPEN_TYPE_UNKNOWN = 0,             // 0 (i.e., old agpsd)
    MTK_AGPS_OPEN_TYPE_C2K     = 0x10,          // 0x10
    MTK_AGPS_OPEN_TYPE_SUPL    = 0x20,          // 0x20
    MTK_AGPS_OPEN_TYPE_CP_NILR = 0x30,          // 0x30
    MTK_AGPS_OPEN_TYPE_CP_MTLR,                 // 0x31
    MTK_AGPS_OPEN_TYPE_CP_MOLR,                 // 0x32
    MTK_AGPS_OPEN_TYPE_CP_QUERY,                // 0x33
    MTK_AGPS_OPEN_TYPE_CP_MLR                   // 0x34
} mtk_agps_open_type;

typedef struct
{
  UINT8 u1Arg1;
  UINT8 u1Arg2;
  UINT8 u1Arg3; //VERSION
  UINT8 u1Arg4; //C2K Flag
} MTK_GPS_AGPS_CMD_MODE_T;

typedef struct
{
#ifdef AGPS_SUPPORT_QOPMS
  float u1Delay;  // Response time in unit of sec.
                  // change  from interge sec to mini-sec. so the Required response time will be more accurate
                  // for example
                  //old : $PMTK293,16,0,0,51*<Check Sum>
                  //new: $PMTK293,15.296,0,0,51*<Check Sum>
#else
  UINT8 u1Delay;  // Response time in unit of sec.
#endif
  UINT32 u4HAcc;  // Horizontal accuracy in unit of meter.
  UINT16 u2VAcc;  // Vertical accuracy in unit of meter.
  UINT16 u2PRAcc; // Pseudorange accuracy in unit of meter.
  float  f4DelayEarlyFix; //[TS 36.355 R12] new item->responseTimeEarlyFix-r12
  UINT32 u4PeriodicMode;// For Moving Scenario, default 0:normal mod, 1:moving scenario, >1, reserved.
  UINT8 u1HAccConf;//(MSB only)Horizontal confidence [0~100]. 0 consider as "no information" and consider it as 90%.
  UINT8 u1VAccConf;//(MSB only)Confidence associated with the altitude[0~100].0 consider as "no information" and consider it as 90%.
  UINT8 u1PRAccConf;//(MSA only)MA accuracy confidence associated with the pseudorange error [0~100].0 consider as "no information" and consider it as 90%.
} MTK_GPS_AGPS_CMD_QOP_T;

typedef struct
{
  UINT8 u1SvId;
  UINT32 au4Word[GPS_EPH_WORD_MAX];
} MTK_GPS_ASSIST_EPH_T;

typedef struct
{
  UINT32 u1SvId;
  UINT32 au1Byte[55];
  UINT32 u1Lf;
} MTK_ASSIST_GLON_EPH_T;


typedef struct
{
  UINT8 u1SvId;
  UINT16 u2WeekNo;
  UINT32 au4Word[GPS_ALM_WORD_MAX];
} MTK_GPS_ASSIST_ALM_T;

typedef struct
{
  UINT16 u2WeekNo;
  double dfTow;        // sec
  double dfTowRms;     // ms
  double dfFS_Tow;     // sec, not used
  double dfFS_TowRms;  // ms, not used
  MTK_GPS_BOOL fgTimeComp;   /* TRUE: indicate ref time compensation from modem , FALSE: no ref time composate   */
  double   dfTimeDelay;      /* the value of ref time compensation */
  UINT8  gpsWeekCycleNumber; //INTEGER(0..7) -- GPS Acquisition Assistance Rel-10 Extension
} MTK_GPS_ASSIST_TIM_T;

typedef struct
{
  UINT16 u2WeekNo;
  double dfTow;        // sec
  double dfTowRms;     // ms
  double dfFTime;      // sec, Frame Time correspond to GPS TOW
  double dfFTimeRms;   // ms, Frame Time RMS accuracy
} MTK_GPS_ASSIST_FTA_T, MTK_GPS_AGPS_DT_FTIME_T;    // Fine Time Assistance

typedef struct
{
  double dfLat;        // Receiver Latitude in degrees
  double dfLon;        // Receiver Longitude in degrees
  double dfAlt;        // Receiver Altitude in meters
  float fAcc_Maj;     // semi-major RMS accuracy [m]
  float fAcc_Min;     // semi-minor RMS accuracy [m]
  UINT8 u1Maj_Bear;   // Bearing of semi-major axis in degrees
  float fAcc_Vert;    // Vertical RMS accuracy [m]
  UINT8 u1Confidence; // Position Confidence: range from 0 ~ 100 [%]
} MTK_GPS_ASSIST_LOC_T;

typedef struct
{
   double dUtc_hms;  // UTC: hhmmss.sss
   double dUtc_ymd;  //  UTC: yyyymmdd
   UINT8 u1FixType;  // the type of measurements performed by the MS [0: 2D or 1: 3D]
   double dfLat;     // latitude (degree)
   double dfLon;     // longitude (degree)
   INT16 i2Alt;      // altitude (m)
   float fUnc_SMaj;  // semi-major axis of error ellipse (m)
   float fUnc_SMin;  // semi-minor axis of error ellipse (m)
   UINT16 u2Maj_brg; // bearing of the semi-major axis (degrees) [0 - 179]
   float fUnc_Vert;  // Altitude uncertainty
   UINT8 u1Conf;     // The confidence by which the position is known to be within the shape description, expressed as a percentage. [0 ~ 100] (%)
   UINT16 u2HSpeed;  // Horizontal speed (km/hr)
   UINT16 u2Bearing; // Direction (degree) of the horizontal speed [0 ~ 359]
} MTK_GPS_AGPS_CMD_MA_LOC_T;
typedef struct
{
  double dfClkDrift;   // GPS Clock Frequency Error [nsec/sec]
  INT32 i4ClkRMSAcc;  // Frequency Measurement RSM Accuracy [nsec/sec]
  INT32 i4ClkAge;     // Age (sec) of the clock drift value since last estimated
} MTK_GPS_ASSIST_CLK_T;

typedef struct
{
  INT8 i1a0;         // Klobuchar - alpha 0  (seconds)           / (2^-30)
  INT8 i1a1;         // Klobuchar - alpha 1  (sec/semi-circle)   / (2^-27/PI)
  INT8 i1a2;         // Klobuchar - alpha 2  (sec/semi-circle^2) / (2^-24/PI^2)
  INT8 i1a3;         // Klobuchar - alpha 3  (sec/semi-circle^3) / (2^-24/PI^3)
  INT8 i1b0;         // Klobuchar - beta 0   (seconds)           / (2^11)
  INT8 i1b1;         // Klobuchar - beta 1   (sec/semi-circle)   / (2^14/PI)
  INT8 i1b2;         // Klobuchar - beta 2   (sec/semi-circle^2) / (2^16/PI^2)
  INT8 i1b3;         // Klobuchar - beta 3   (sec/semi-circle^3) / (2^16/PI^3)
} MTK_GPS_ASSIST_KLB_T;

typedef struct
{
  INT32 i4A1;         // UTC parameter A1 (seconds/second)/(2^-50)
  INT32 i4A0;         // UTC parameter A0 (seconds)/(2^-30)
  UINT8 u1Tot;        // UTC reference time of week (seconds)/(2^12)
  UINT8 u1WNt;        // UTC reference week number (weeks)
  INT8 i1dtLS;       // UTC time difference due to leap seconds before event (seconds)
  UINT8 u1WNLSF;      // UTC week number when next leap second event occurs (weeks)
  UINT8 u1DN;         // UTC day of week when next leap second event occurs (days)
  INT8 i1dtLSF;      // UTC time difference due to leap seconds after event (seconds)
} MTK_GPS_ASSIST_UCP_T;

typedef struct
{
  INT8 i1NumBad;        // Number of Bad Satellites listed
  UINT8 au1SvId[MTK_GPS_SV_MAX_PRN]; // A list of bad SV id
} MTK_GPS_ASSIST_BSV_T;


typedef struct
{
  UINT8 u1SV;          // SV PRN number (1 ~ 32) (0 means no data available)
  INT32 i4GPSTOW;      // TOW of last Acquisition Assistance data, Units 0.08 sec
  INT16 i2Dopp;        // Doppler value. Units 2.5 Hz
  INT8 i1DoppRate;    // Doppler rate of change. Units (1/42) Hz/s
  UINT8 u1DoppSR;      // Doppler search range. index. [0 ~ 4]
  UINT16 u2Code_Ph;     // C/A Code Phase chips [range 0..1022]
                    //    relative to the previous msec edge
  INT8 i1Code_Ph_Int; // Integer C/A Code msec into the GPS Data Bit
                    //    [range 0..19 msec]  (-1 if not known)
  INT8 i1GPS_Bit_Num; // GPS Data Bit Number, modulo 80 msec  [range 0..3]
                    //    (-1 if not known)
  UINT8 u1CodeSR;      // Code search range. index. [0 ~ 15]
  UINT8 u1Azim;        // Azimuth. Units 11.25 degrees
  UINT8 u1Elev;        // Elevation. Units 11.25 degrees
} MTK_GPS_ASSIST_ACQ_T;


#define RTCM_MAX_N_SAT 11
typedef struct
{
  UINT8 u1SatID;  // [1 - 32]
  UINT8 u1IODE;   // [0 - 255]
  UINT8 u1UDRE;   // [0 - 3]
  INT16 i2PRC;    // [-655.04 - 655.04], Units 0.32m
  INT8 i1RRC;    // [-4.064 - 4.064], Units 0.032m
} MTK_GPS_RTCM_SV_CORR_T;

typedef struct
{
  UINT32 u4Tow;     // the baseline time for the corrections are valid [0 - 604799]
  UINT8 u1Status;  // the status of the differential corrections [0 - 7]
  UINT8 u1NumSv;   // the number of satellites for which differential corrections are available [1 - 11]
  MTK_GPS_RTCM_SV_CORR_T arSVC[RTCM_MAX_N_SAT];
} MTK_GPS_ASSIST_DGP_T;

#define TOW_MAX_N_SAT 11
typedef struct
{
    UINT8 u1SatID;   // [1 - 32]
    UINT16 u2TLM;    // [0 - 16383]
    UINT8 u1Anti_s;  // [0 - 1]
    UINT8 u1Alert;   // [0 - 1]
    UINT8 u1Reserved;  // [0 - 3]
} MTK_GPS_TOW_SV_T;

typedef struct
{
  UINT16 u2WN;      // GPS week number (weeks)
  UINT32 u4Tow;     // GPS time of week  of the TLM message applied [0 - 604799]
  UINT8 u1NumSv;   // the number of satellites for which TOW assist are available [1 - 11]
  MTK_GPS_TOW_SV_T atSV[TOW_MAX_N_SAT];
} MTK_GPS_ASSIST_TOW_T;

typedef struct
{
  MTK_GPS_BOOL fgAcceptAlm;    // Satellite Almanac
  MTK_GPS_BOOL fgAcceptUcp;    // UTC Model
  MTK_GPS_BOOL fgAcceptKlb;    // Ionospheric Model
  MTK_GPS_BOOL fgAcceptEph;    // Navigation Model
  MTK_GPS_BOOL fgAcceptDgps;   // DGPS Corrections
  MTK_GPS_BOOL fgAcceptLoc;    // Reference Location
  MTK_GPS_BOOL fgAcceptTim;    // Reference Time
  MTK_GPS_BOOL fgAcceptAcq;    // Acquisition Assistance
  MTK_GPS_BOOL fgAcceptBsv;    // Real-Time Integrity
} MTK_GPS_AGPS_CMD_ACCEPT_MAP_T;

typedef struct
{
   UINT32 u4Frame;   // BTS Reference Frame number during which the location estimate was measured [0 - 65535]
   UINT16 u2WeekNo;  // the GPS week number for which the location estimate is valid
   UINT32 u4TowMS;   // the GPS TOW (ms) for which the location estimate is valid [0 - 604799999]
   UINT8 u1FixType;  // the type of measurements performed by the MS [0: 2D or 1: 3D]
   double dfLat;         // latitude (degree)
   double dfLon;         // longitude (degree)
   INT16 i2Alt;      // altitude (m)
   float fUnc_SMaj;      // semi-major axis of error ellipse (m)
   float fUnc_SMin;      // semi-minor axis of error ellipse (m)
   UINT16 u2Maj_brg; // bearing of the semi-major axis (degrees) [0 - 179]
   float fUnc_Vert;      // Altitude uncertainty
   UINT8 u1Conf;     // The confidence by which the position is known to be within the shape description, expressed as a percentage. [0 ~ 100] (%)
   UINT16 u2HSpeed;  // Horizontal speed (km/hr)
   UINT16 u2Bearing; // Direction (degree) of the horizontal speed [0 ~ 359]
} MTK_GPS_AGPS_DT_LOC_EST_T;


typedef struct               // Satellite Pseudorange Measurement Data
{
   UINT8 u1PRN_num;      // Satellite PRN number [1 - 32]
   UINT8 u1SNR;          // Satellite Signal to Noise Ratio [dBHz} (range 0-63)
   INT16 i2Dopp;         // Measured Doppler frequency [0.2 Hz] (range +/-6553.6)
   UINT16 u2Code_whole;   // Satellite Code phase measurement - whole chips
                    //   [C/A chips] (range 0..1022)
   UINT16 u2Code_fract;   // Satellite Code phase measurement - fractional chips
                    //   [2^-10 C/A chips] (range 0..1023)
   UINT8 u1Mul_Path_Ind; // Multipath indicator (range 0..3)
                    //   (see TIA/EIA/IS-801 Table 3.2.4.2-7)
   UINT8 u1Range_RMS_Exp;// Pseudorange RMS error: Exponent (range 0..7)
                    //   (see TIA/EIA/IS-801 Table 3.2.4.2-8)
   UINT8 u1Range_RMS_Man;// Pseudorange RMS error: Mantissa (range 0..7)
                    //   (see TIA/EIA/IS-801 Table 3.2.4.2-8)

} MTK_GPS_AGPS_PRM_SV_DATA_T;        // Satellite Pseudorange Measurement Data

typedef struct
{
   UINT32 u4Frame;         // [0 - 65535]
   UINT8 u1NumValidMeas;  // Number of valid measurements available (0..NUM_CH)
   UINT32 u4GpsTow;        // Time of validity [ms] modulus 14400000
   MTK_GPS_AGPS_PRM_SV_DATA_T SV_Data[AGPS_RRLP_MAX_PRM];  // Satellite Pseudorange Measurement Data
} MTK_GPS_AGPS_DT_GPS_MEAS_T;     // RRLP Pseudorange Data

typedef struct
{
    UINT8 u1Type;
} MTK_GPS_AGPS_DT_FTIME_ERR_T;

typedef struct
{
    UINT16 u2AckCmd;
    UINT8 u1Flag;
} MTK_GPS_AGPS_DT_ACK_T;

typedef struct
{
    UINT8 u1Type;
} MTK_GPS_AGPS_DT_LOC_ERR_T;

typedef struct
{
    UINT16 u2BitMap;
                        //  bit0 0x0001  // almanac
                        //  bit1 0x0002  // UTC model
                        //  bit2 0x0004  // ionospheric model
                        //  bit3 0x0008  // navigation data
                        //  bit4 0x0010  // DGPS corrections
                        //  bit5 0x0020  // reference location
                        //  bit6 0x0040  // reference time
                        //  bit7 0x0080  // acquisition assistance
                        //  bit8 0x0100  // Real-Time integrity
} MTK_GPS_AGPS_DT_REQ_ASSIST_T;
typedef struct
{

    UINT8 u1FixType;
    UINT8 u1FixQuality;
    UINT8 u1SelectType;
    double dfWRTSeaLevel;
    float dfPDOP;
    float dfHDOP;
    float dfVDOP;

    UINT8 u1SatNumInUse;
    UINT8 SVInUsePRNs[MTK_GPS_SV_MAX_NUM];

    UINT8 u1SatNumInView;
    UINT8 u1SVInViewPRNs[MTK_GPS_SV_MAX_NUM];
    INT8  u1SVInViewEle[MTK_GPS_SV_MAX_NUM];
    UINT16 u1SVInViewAzi[MTK_GPS_SV_MAX_NUM];
    float u1SVInViewSNR[MTK_GPS_SV_MAX_NUM];

} MTK_GPS_AGPS_DT_LOC_EXTRA_T;
#if defined(AGPS_SUPPORT_GNSS)
//start for AGPS_SUPPORT_GNSS
/* for AGPS with GNSS supported GNSS assist bitmap   */

/* The BITMAP is define for PMTK760 coding operation of MODEM/AGPSD/MNL , but NOT the same as GNSS ID(3GPP protocol). */
#define BITMAP_GPS     0
#define BITMAP_GLONASS 1
#define BITMAP_GALILEO 2
#define BITMAP_BEIDOU  3


#define BITINDEX_TMOD    0
#define BITINDEX_DGNSS   1
#define BITINDEX_EPH     2
#define BITINDEX_RTI     3
#define BITINDEX_DBA     4
#define BITINDEX_AA      5
#define BITINDEX_ALM     6
#define BITINDEX_UTC     7
#define BITINDEX_AUX     8

#define BITMAP_TMOD    0x0001
#define BITMAP_DGNSS   0x0002
#define BITMAP_EPH     0x0004
#define BITMAP_RTI     0x0008
#define BITMAP_DBA     0x0010
#define BITMAP_AA      0x0020
#define BITMAP_ALM     0x0040
#define BITMAP_UTC     0x0080
#define BITMAP_AUX     0x0100

typedef struct
{
   //UINT16 u2BitMap;
   MTK_GPS_BOOL fgReqTime; //commonAssistDataReq: GNSS reference time request flag
   MTK_GPS_BOOL fgReqLoc;  //commonAssistDataReq: GNSS reference location request flag
   MTK_GPS_BOOL fgReqIon;  //commonAssistDataReq: GNSS reference Inospheris request flag
   MTK_GPS_BOOL fgReqEop;  //commonAssistDataReq: GNSS reference EarthOrentationParameters request flag
   UINT16       u2BitMap[GNSS_ID_MAX_NUM];  //GenerateAssistDataReq:  u2BitMap
                        //  bit0 0x0001  // Time mode Request
                        //  bit1 0x0002  // Differential Corrections Request
                        //  bit2 0x0004  // Navigation Model(Ephemeris) Request
                        //  bit3 0x0008  // Real-Time Integrity Request
                        //  bit4 0x0010  // Data Bit Assistance Request
                        //  bit5 0x0020  // Acquisition Assist Request
                        //  bit6 0x0040  // Almanac Request
                        //  bit7 0x0080  // UTC Model Request
                        //  bit8 0x0100  // Auxiliary Information Request
} MTK_AGNSS_DT_REQ_ASSIST_T;

typedef struct
{

   UINT8  u1GnssTimeID;    /* gnss system time ID:eque to GNSS-ID(,0-GPS,1-SBAS, 2-QZSS,3-Galileo,4-GLONASS, 5~16 reserved) */
   INT16 i2DayNo;         /* [0-32767] gnssDayNumber do not report DayNo to server */
   UINT32 u4Todms;        /* [0-3599999] in seconds */
   UINT16 u2GnssIDsInUse;   //in-use GNSSID bitmap :
                           //bit 0:gps
                           //bit 1:sbas
                           //bit 2:qzss
                           //bit 3:galileo
                           //bit 4:glonass
                           //bit 5~15:reserved

   UINT8 u1FixType;  // the type of measurements performed by the MS [0: 2D or 1: 3D]
   double dfLat;         // latitude (degree)
   double dfLon;         // longitude (degree)
   INT16 i2Alt;      // altitude (m)
   float fUnc_SMaj;      // semi-major axis of error ellipse (m)
   float fUnc_SMin;      // semi-minor axis of error ellipse (m)
   UINT16 u2Maj_brg; // bearing of the semi-major axis (degrees) [0 - 179]
   float fUnc_Vert;      // Altitude uncertainty
   UINT8 u1Conf;     // The confidence by which the position is known to be within the shape description, expressed as a percentage. [0 ~ 100] (%)
   UINT16 u2HSpeed;  // Horizontal speed (km/hr)
   UINT16 u2Bearing; // Direction (degree) of the horizontal speed [0 ~ 359]

   UINT16 u4Frame;
   UINT16 u2GnssIDsUsed;
   float fUnc_SMaj_Raw;      // Raw semi-major axis of error ellipse (m)
   float fUnc_SMin_Raw;      // Raw semi-minor axis of error ellipse (m)
   float fUnc_Vert_Raw;      // Raw altitude uncertainty

} MTK_AGNSS_DT_LOC_EST_T;

typedef struct
{

   UINT16 u1PRN_num;               //
   MTK_GNSS_ID_ENUM eGnssID;       //in-use GNSSID  :
                           //bit 0:gps
                           //bit 1:sbas
                           //bit 2:qzss
                           //bit 3:galileo
                           //bit 4:glonass
                           //bit 5~15:reserved
   UINT8 u2SignalID;       //in-use signal ID  :
                           //now for GPS only support GNSS_SGN_ID_VALUE_GPS_L1C_A
                           //now for GLONASS only support GNSS_SGN_ID_VALUE_GLONASS_G1
                           //now for QZSS only support GNSS_SGN_ID_VALUE_QZSS_L1C_A

   UINT8  u1SNR;         //[0..63] SNR
   INT16  i2Dopp;        // [-32768..32767]
   UINT32 u4CodePh;      //[0..2097151] ms 21-bits with 2^-21 resolution
   UINT8  u1CodePhInt;   //[0~127] ms
   UINT8  u1Mul_Path_Ind;  //[0~3] refer to RRLP table A.9

   UINT8  u1CarryQualInd; //[0~3]
   UINT32 u1Adr;          //[0..33554431] 25-bits with 2^-10 resolution
   UINT8  u1Range_RMS_Man ;         //Pseudorange RMS Error mantissa
   UINT8  u1Range_RMS_Exp;         //Pseudorange RMS Error Exponent

   UINT8  u1SigBitmap;
}MTK_GPS_AGNSS_PRM_SV_DATA_T;
#define AGNSS_RRLP_MAX_PRM 78
typedef struct
{
  UINT8 u1NumValidGPSSig;
  UINT8 u1GPSSigIDs;
  UINT8 u1NumValidGLOSig;
  UINT8 u1GLOSigIDs;
}MTK_AGNSS_SIGNALIDS_T;

typedef struct
{

   UINT8  u1GnssTimeID;    /* gnss system time ID:eque to GNSS-ID(,0-GPS,1-SBAS, 2-QZSS,3-Galileo,4-GLONASS, 5~16 reserved) */
   INT16  i2DayNo;
   UINT32 u4Todms;        /* [0-3599999] in ms */
   UINT16 u2TodFrag;      /* [0-3999] with resolution of 250ns optional */
   UINT32 u4TodUnc ;         /* [0-127] with resolution of 250ns optional */
   UINT8  u1NumValidMeas;
   UINT8  u1NumValidGnss;
   UINT16 u2GnssIDsInUse;     //in-use GNSSID bitmap
   MTK_AGNSS_SIGNALIDS_T  u1SignalIDsInUse;   //in-use GNSSID bitmap :
   UINT8  u1CodePhAmb;     // [0~127 ]the codephase ambiguity in interge ms default set to 0 optional
   MTK_GPS_AGNSS_PRM_SV_DATA_T SV_Data[AGNSS_RRLP_MAX_PRM];  // Satellite Pseudorange Measurement Data

} MTK_AGNSS_DT_MEAS_T;     // RRLP Pseudorange Data MTK_AGNSS_DT_REQ_ASSIST_T
//MTK_GPS_AGPS_DT_GPS_MEAS_T


/*=== GNSS Common Assistance Data ===*/
typedef struct
{
    UINT8    u1GnssTimeID;    /* gnss system time ID:eque to GNSS-ID(,0-GPS,1-SBAS, 2-QZSS,3-Galileo,4-GLONASS, 5~16 reserved) */
    /**
     * This field specifies the sequential number of days from the origin of the GNSS System Time as follows:
     * GPS, QZSS, SBAS  Days from January 6th 1980 00:00:00 UTC(USNO)
     * Galileo V             TBD;
     * GLONASS V         Days from January 1st 1996
     */
    UINT16   u2DN;           /* [0-32767] gnssDayNumber  */
    double   dfTod;          /* [0-86399.999] in seconds */
    double   dfTodRms;       /* K = [0..127], uncertainty r (microseconds) = C*(((1+x)^K)-1), C=0.5, x=0.14 */
    MTK_GPS_BOOL u1NotifyLeap;   /* [0~1] flag to notify leap second only present when gnss=GLONASS */
    MTK_GPS_BOOL fgTimeComp;   /* TRUE: indicate ref time compensation from modem , FALSE: no ref time composate   */
    double   dfTimeDelay;      /* the ref time compensation */
    UINT8    ganssDayCycleNumber;//INTEGER(0..7) -- GPS Acquisition Assistance Rel-10 Extension
} MTK_GNSS_ASSIST_TIM_T;

typedef MTK_GPS_ASSIST_LOC_T MTK_GNSS_ASSIST_LOC_T;

/* start for gnss ionospheric model */

//gnss Klobuchar model
typedef struct
{
    UINT8 u1DataID;              /*bit[0..1] : "11"generated by QZSS. aplicable within the area of QZSS */
                                 /*               "00"generated by GPS,GLONASS.  aplicable worldwild   */
    MTK_GPS_ASSIST_KLB_T rdata;  /*these field is simillar to GPS Klobuchar struct */

}MTK_GNSS_ASSIST_KLB_T;

//gnss NeQuick model
typedef struct
{
    UINT16  u2Ai0;  /* [0..4095] */
    UINT16  u2Ai1;  /* [0..4095] */
    UINT16  u2Ai2;  /* [0..4095] */
    /* optional field */
    /**
      * iono storm flag represent five region: [value 0: no disturbance, value 1: disturbance]
      *  region 1: for the northern region (60X<MODIP<90X)
      *  region 2: for the northern middle region (30X<MODIP<60X)
      *  region 3: for the equatorial region (-30X<MODIP<30X)
      *  region 4: for the southern middle region (-60X<MODIP<-30X)
      *  region 5: for the southern region (-90X<MODIP<-60X)
      */
    UINT8   u2StValidBit;  /*Stormflag valid bitmap to indicate if fgStormFlag is aviliable or not */
                              /*bit0 -> indicate fgStormFlag[0]  aviliable or not*/
                              /*bit1 -> indicate fgStormFlag[1]  aviliable or not*/
                              /*bit2 -> indicate fgStormFlag[2]  aviliable or not*/
                              /*bit3 -> indicate fgStormFlag[3]  aviliable or not*/
                              /*bit4 -> indicate fgStormFlag[4]  aviliable or not*/
    MTK_GPS_BOOL fgStormFlag[5];

}MTK_GNSS_ASSIST_NQK_T;

typedef struct
{
    UINT8 u1InoModel;            /*[0~7] 0: INO Klobuchar Model -used for GPS,GLONASS,QZSS */
                                 /*         1: NeQuick Model          - used for Galileo */
  union
  {
    MTK_GNSS_ASSIST_KLB_T rAKlb;  /*Klobuchar Model  */
    MTK_GNSS_ASSIST_NQK_T rANqk;  /*NeQuick    Model  */
 }data;

}MTK_GNSS_ASSIST_ION_T;

/* end for gnss ionospheric model */


/* start for gnss earth orientation parameters */
typedef struct
{
    UINT16  u2Teop;         /* [0..65535], EOP data reference time in seconds, scale factor 2^4 seconds */
    INT32   i4PmX;          /* [-1048576..1048575], X-axis polar motion value at reference time in arc-seconds, scale factor 2^(-20) arc-seconds */
    INT16   i2PmXdot;       /* [-16384..16383], X-axis polar motion drift at reference time in arc-seconds/day, scale factor 2^(-21) arc-seconds/day */
    INT32   i4PmY;          /* [-1048576..1048575], Y-axis polar motion value at reference time in arc-seconds, scale factor 2^(-20) arc-seconds */
    INT16   i2PmYdot;       /* [-16384..16383] Y-axis polar motion drift at reference time in arc-seconds/day, scale factor 2^(-21) arc-seconds/day */
    INT32   i4DeltaUT1;     /* [-1073741824..1073741823], UT1-UTC diff at reference time in seconds, scale factor 2^(-24) seconds */
    INT32   i4DeltaUT1dot;  /* [-262144..262143], the rate of UT1-UTC diff at reference time in seconds/day, scale factor 2^(-25) seconds/day */
} MTK_GNSS_ASSIST_EOP_T;
/* end for gnss earth orientation parameters */




/*=== GNSS Generic Assistance Data ===*/

/* start for gnss time model */
/**
 * in LPP, location server could provide up to 15 GNSS-GNSS system time offset
 * in RRC/RRLP, location server could provide up to 7 GNSS-GNSS system time offset
 * i.e. generic assist data is for GPS, time model could provide GPS-GLONASS time offset
 */
typedef struct
{
    /* note that RRC/RRLP tA0, tA1 range is larger than LPP, although scale factor is the same */
    MTK_GNSS_ID_ENUM eGnssID;
    UINT16        u2TmodTOW;  /* [0..65535], the reference time of week TOW , scale factor 2^4 seconds */
    INT32         i4Ta0;         /* [-67108864..67108863] for LPP, [-2147483648 .. 2147483647] for RRC/RRLP, the bias coefficient, scale factor 2^(-35) seconds */
    INT16         i2Ta1;         /* [-4096..4095] for LPP, [-8388608 .. 8388607] for RRC/RRLP, the drift coefficient, scale factor 2^(-51) seconds/second */
    INT8          i1Ta2;         /* [-64..63], the drift rate correction coefficient, scale factor 2^(-68) seconds/second^2 */
    MTK_GNSS_TO_ID_ENUM   eGnssToId; /* GPS, Galileo, QZSS, GLOANSS */
    /* optional field */
    UINT16        u2WeekNo;    /* [0..8191], the reference week */
    INT8          i1DeltaT;    /* [-128..127], the integer number of seconds of GNSS-GNSS time offset */
} MTK_GNSS_ASSIST_TMOD_T;


typedef MTK_GPS_ASSIST_EPH_T MTK_ASSIST_GPS_EPH_T;
//aGLONASS EPH
typedef struct
{
  UINT8 u1SvId;  // GLONASS SV PRN number 1~24
  UINT32 au4Word[GLO_EPH_WORD_MAX];
} MTK_GLO_ASSIST_EPH_T;

typedef struct
{
  UINT8 u1SvId;  // BD SV PRN number 1~30
  UINT32 au4Word[BDS_EPH_WORD_MAX];
} MTK_BDS_ASSIST_EPH_T;

#ifdef SUPPORT_AGA
typedef struct
{
  UINT8 u1SvId;  // Gallileo SV PRN number 1~30
  UINT32 au4Word[GAL_EPH_WORD_MAX];
} MTK_GAL_ASSIST_EPH_T;
#endif

typedef struct
{
  UINT8 u1SvId;
  UINT32 au4Word[GPS_L5_EPH_WORD_MAX];
} MTK_GPS_L5_ASSIST_EPH_T;
typedef struct
{
    MTK_GNSS_ID_ENUM  eGnssID;

    union
    {
       MTK_GPS_ASSIST_EPH_T  rAGpsEph;  /* for GPS eph  */
       MTK_GLO_ASSIST_EPH_T  rAGloEph;  /* for GLO eph  */
       MTK_BDS_ASSIST_EPH_T   rABDEph;   /* for BD eph  */
      // MTK_QZS_ASSIST_EPH_T  rAQzsEph;     /* for GLONASS */
       MTK_GAL_ASSIST_EPH_T  rAGAEph;     /* for Gallileo */
       MTK_GPS_L5_ASSIST_EPH_T rAGpsL5Eph; /* for GPS L5*/
    } data;
} MTK_GNSS_ASSIST_EPH_T;

//aGLONASS ALM
typedef struct
{
  UINT8 u1SvId;//GLONASS SV PRN:1~24
  UINT16 u2DayNum;
  UINT32 au4Word[GLO_ALM_WORD_MAX];
} MTK_GLO_ASSIST_ALM_T;

//ABD ALM
typedef struct
{
  UINT8 u1SvId;
  UINT16 u2DayNum;
  UINT32 au4Word[BDS_ALM_WORD_MAX];
} MTK_BDS_ASSIST_ALM_T;

#ifdef SUPPORT_AGA
typedef struct
{
  UINT8 u1SvId;
  UINT16 u2WeekNo;
  UINT8 au1Word[GAL_ALM_WORD_MAX];
} MTK_GAL_ASSIST_ALM_T;
#endif

typedef struct
{
  UINT8 u1SvId;
  UINT16 u2WeekNo;
  UINT32 au4Word[GPS_L5_ALM_WORD_MAX];
} MTK_GPS_L5_ASSIST_ALM_T;
typedef struct
{
    MTK_GNSS_ID_ENUM  eGnssID;

    union
    {
       MTK_GPS_ASSIST_ALM_T  rAGpsAlm;  /* for GPS alm  */
       MTK_GLO_ASSIST_ALM_T  rAGloAlm;  /* for GLONASS alm  */
       MTK_BDS_ASSIST_ALM_T  rABDAlm;   /* for BDS alm  */
       MTK_GAL_ASSIST_ALM_T  rAGAAlm;     /* for Gallileo */
       MTK_GPS_L5_ASSIST_ALM_T  rAGpsL5Alm; /* for GPS L5*/
    } data;
} MTK_GNSS_ASSIST_ALM_T;

/* start for gnss real time integrity */

typedef struct
{
   UINT16  u1SVID;
   UINT8  u1BSignalIDs;  /* identidy the bad signal or signals of a satellite, bit string representation, map to GNSS_SGN_ID_BITMAP_* */
} MTK_GNSS_ASSIST_BSIG_T;

typedef struct
{
    MTK_GNSS_ID_ENUM        eGnssID;
    UINT8                   u1BsvNum;
    MTK_GNSS_ASSIST_BSIG_T  rBsv[MGPSID];
} MTK_GNSS_ASSIST_BSV_T;
/* end for gnss real time integrity */

typedef enum
{
    GNSS_ACQ_ASSIST_DOPPLER_UNCERTAINTY_EXT_ENUM_D60,
    GNSS_ACQ_ASSIST_DOPPLER_UNCERTAINTY_EXT_ENUM_D80,
    GNSS_ACQ_ASSIST_DOPPLER_UNCERTAINTY_EXT_ENUM_D100,
    GNSS_ACQ_ASSIST_DOPPLER_UNCERTAINTY_EXT_ENUM_D120,
    GNSS_ACQ_ASSIST_DOPPLER_UNCERTAINTY_EXT_ENUM_NO_INFO
} MTK_GNSS_ACQ_DOPP_UNCERT_EXT_ENUM;

/* start for gnss acquisition assistance */
typedef struct
{
    MTK_GNSS_ID_ENUM  eGnssID;
    UINT16  u2SvId;         //,GPS:1~32 GLO:65~96
    UINT8   u1SigID;        /* GNSS type, map to GNSS_SGN_ID_VALUE_* */
    UINT8   u1Conf;         /* [0..100]  only for LPP */
    double  dfTod;          /* [0-86399.999] in seconds */
    INT16   i2Dopp0;        /* [-2048..2047], Doppler (0th order term) value for velocity, scale factor 0.5 m/s in th range from -1024 m/s to +1023.5 m/s */
    UINT8   u1Dopp1;        /* [0..63], i1DoppRate, Doppler (1th order term) value for acceleration, scale factor 1/210 m/s^2 in the range from -0.2 m/s^2 to +0.1 m/s^2 */
    UINT8   u1DoppSR;       /* [0..4], defined values: 2.5 m/s, 5 m/s, 10 m/s, 20 m/s, 40 m/s encoded as integer range 0-4 by 2^(-n)*40 m/s, n=0-4 */
    UINT16  u2CodePh;    /* [0..1022], scale factor 2^(-10) ms in the range from 0 to (1-2^(-10)) ms */
    UINT8   u1CodePhInt; /* [0..127], integer codephase, scale factor 1ms */
    UINT8   u1CodePhSR;  /* [0..31], map to value-to-searchwindow table (ms) */
    UINT16  u2Azim;         /* [0..511], azimuth angle a, x-degrees of satellite x<=a<x+0.703125, scale factor 0.703125 degrees */
    UINT8   u1Elev;         /* [0..127], elevation angle e, y-degrees of satellite y>=e<y+0.703125, scale factr 0.703125 degrees */
    /* optional field */
    MTK_GPS_BOOL fgCodePh1023;    /* only use if codePhase is 1022, codePhase value is 1023*2^(-10) = (1-2^(-10)) ms */
    /* if support dopplerUncertaintyExtR10, should ignore dopplerUncertainty field */
    MTK_GNSS_ACQ_DOPP_UNCERT_EXT_ENUM u1DopExtEnum; /* enumerated value map to 60 m/s, 80 m/s, 100 m/s, 120 ms, and No Information */
    UINT8   u1CodeSR;

} MTK_GNSS_ASSIST_ACQ_T;
/* end for gnss acquisition assistance */

/* start for gnss acquisition assistance */
typedef struct
{
   double GPSTOW;
   double dfGNSSTOD;
   MTK_GPS_BOOL AzElIncl;
   MTK_GPS_BOOL UseEph;
   unsigned char NumSV;
   UINT16  SV[24];         //,GPS:1~32 GLO:65~96
   UINT8   u1SigID[24];        /* GNSS type, map to GNSS_SGN_ID_VALUE_* */
   UINT8   u1Conf[24];         /* [0..100]  only for LPP */
   double  dfTod[24];          /* [0-86399.999] in seconds */
   INT16   Dopp[24];        /* [-2048..2047], Doppler (0th order term) value for velocity, scale factor 0.5 m/s in th range from -1024 m/s to +1023.5 m/s */
   UINT8   DoppRate[24];        /* [0..63], i1DoppRate, Doppler (1th order term) value for acceleration, scale factor 1/210 m/s^2 in the range from -0.2 m/s^2 to +0.1 m/s^2 */
   UINT8   DoppSR[24];       /* [0..4], defined values: 2.5 m/s, 5 m/s, 10 m/s, 20 m/s, 40 m/s encoded as integer range 0-4 by 2^(-n)*40 m/s, n=0-4 */
   UINT16  Code_Ph[24];    /* [0..1022], scale factor 2^(-10) ms in the range from 0 to (1-2^(-10)) ms */
   UINT8   Code_Ph_Int[24]; /* [0..127], integer codephase, scale factor 1ms */
   UINT8   CodePhSR[24];  /* [0..31], map to value-to-searchwindow table (ms) */
   UINT8   CodeSR[24];
   UINT16  Azim[24];         /* [0..511], azimuth angle a, x-degrees of satellite x<=a<x+0.703125, scale factor 0.703125 degrees */
   UINT8   Elev[24];         /* [0..127], elevation angle e, y-degrees of satellite y>=e<y+0.703125, scale factr 0.703125 degrees */
   /* optional field */
   MTK_GPS_BOOL fgCodePh1023[24];    /* only use if codePhase is 1022, codePhase value is 1023*2^(-10) = (1-2^(-10)) ms */
   /* if support dopplerUncertaintyExtR10, should ignore dopplerUncertainty field */
   MTK_GNSS_ACQ_DOPP_UNCERT_EXT_ENUM u1DopExtEnum[24]; /* enumerated value map to 60 m/s, 80 m/s, 100 m/s, 120 ms, and No Information */

} s_NA_GLO_AcqAss;

/* start for gnss acquisition assistance */
typedef struct
{
    double dfGNSSTOD;
    MTK_GPS_BOOL AzElIncl;
    MTK_GPS_BOOL UseEph;
    unsigned char NumSV;
    UINT16  SV[24];         //,GPS:1~32 GLO:65~96
    UINT8   u1SigID[24];        /* GNSS type, map to GNSS_SGN_ID_VALUE_* */
    UINT8   u1Conf[24];         /* [0..100]  only for LPP */
    double  dfTod[24];          /* [0-86399.999] in seconds */
    INT16   Dopp[24];        /* [-2048..2047], Doppler (0th order term) value for velocity, scale factor 0.5 m/s in th range from -1024 m/s to +1023.5 m/s */
    UINT8   DoppRate[24];        /* [0..63], i1DoppRate, Doppler (1th order term) value for acceleration, scale factor 1/210 m/s^2 in the range from -0.2 m/s^2 to +0.1 m/s^2 */
    UINT8   DoppSR[24];       /* [0..4], defined values: 2.5 m/s, 5 m/s, 10 m/s, 20 m/s, 40 m/s encoded as integer range 0-4 by 2^(-n)*40 m/s, n=0-4 */
    UINT16  Code_Ph[24];    /* [0..1022], scale factor 2^(-10) ms in the range from 0 to (1-2^(-10)) ms */
    UINT8   Code_Ph_Int[24]; /* [0..127], integer codephase, scale factor 1ms */
    UINT8   CodePhSR[24];  /* [0..31], map to value-to-searchwindow table (ms) */
    UINT8   CodeSR[24];
    UINT16  Azim[24];         /* [0..511], azimuth angle a, x-degrees of satellite x<=a<x+0.703125, scale factor 0.703125 degrees */
    UINT8   Elev[24];         /* [0..127], elevation angle e, y-degrees of satellite y>=e<y+0.703125, scale factr 0.703125 degrees */
    /* optional field */
    MTK_GPS_BOOL fgCodePh1023[24];    /* only use if codePhase is 1022, codePhase value is 1023*2^(-10) = (1-2^(-10)) ms */
    /* if support dopplerUncertaintyExtR10, should ignore dopplerUncertainty field */
    MTK_GNSS_ACQ_DOPP_UNCERT_EXT_ENUM u1DopExtEnum[24]; /* enumerated value map to 60 m/s, 80 m/s, 100 m/s, 120 ms, and No Information */
} MTK_GNSS_ASSIST_ACQ_RAW_DATA_T;
/* end for gnss acquisition assistance */

/* start for gnss acquisition assistance */
typedef struct
{
    UINT16  Code_Ph[24];    /* [0..1022], scale factor 2^(-10) ms in the range from 0 to (1-2^(-10)) ms */
    UINT8   Code_Ph_Int[24]; /* [0..127], integer codephase, scale factor 1ms */
    UINT8 Acq_GPS_Secs;
    MTK_GPS_BOOL AzElIncl;
    MTK_GPS_BOOL UseEph;
    double dfGNSSTOD;
    UINT8   CodeSR[24];
    unsigned char NumSV;
    UINT16  SV[24];         //,GPS:1~32 GLO:65~96
    UINT8   u1SigID;        /* GNSS type, map to GNSS_SGN_ID_VALUE_* */
    UINT8   u1Conf;         /* [0..100]  only for LPP */
    double  dfTod;          /* [0-86399.999] in seconds */
    INT16   Dopp[24];        /* [-2048..2047], Doppler (0th order term) value for velocity, scale factor 0.5 m/s in th range from -1024 m/s to +1023.5 m/s */
    UINT8   DoppRate[24];        /* [0..63], i1DoppRate, Doppler (1th order term) value for acceleration, scale factor 1/210 m/s^2 in the range from -0.2 m/s^2 to +0.1 m/s^2 */
    UINT8   DoppSR[24];       /* [0..4], defined values: 2.5 m/s, 5 m/s, 10 m/s, 20 m/s, 40 m/s encoded as integer range 0-4 by 2^(-n)*40 m/s, n=0-4 */
    UINT16  CodePh[24];    /* [0..1022], scale factor 2^(-10) ms in the range from 0 to (1-2^(-10)) ms */
    UINT8   CodePhInt[24]; /* [0..127], integer codephase, scale factor 1ms */
    UINT8   CodePhSR[24];  /* [0..31], map to value-to-searchwindow table (ms) */
    UINT16  Azim[24];         /* [0..511], azimuth angle a, x-degrees of satellite x<=a<x+0.703125, scale factor 0.703125 degrees */
    UINT8   Elev[24];         /* [0..127], elevation angle e, y-degrees of satellite y>=e<y+0.703125, scale factr 0.703125 degrees */
    /* optional field */
    MTK_GPS_BOOL fgCodePh1023;    /* only use if codePhase is 1022, codePhase value is 1023*2^(-10) = (1-2^(-10)) ms */
    /* if support dopplerUncertaintyExtR10, should ignore dopplerUncertainty field */
    MTK_GNSS_ACQ_DOPP_UNCERT_EXT_ENUM u1DopExtEnum; /* enumerated value map to 60 m/s, 80 m/s, 100 m/s, 120 ms, and No Information */
} MTK_GNSS_ASSIST_ACQ_DATA_T;
/* end for gnss acquisition assistance */

typedef struct
{
   UINT32 Code_whole;
   UINT32 Code_fract;

   UINT16 PRN_num;               //
   INT8 i1ChannelID;
   MTK_GNSS_ID_ENUM eGnssID;       //in-use GNSSID  :
                           //bit 0:gps
                           //bit 1:sbas
                           //bit 2:qzss
                           //bit 3:galileo
                           //bit 4:glonass
                           //bit 5~15:reserved
   UINT8 u2SignalID;       //in-use signal ID  :
                           //now for GPS only support GNSS_SGN_ID_VALUE_GPS_L1C_A
                           //now for GLONASS only support GNSS_SGN_ID_VALUE_GLONASS_G1
                           //now for QZSS only support GNSS_SGN_ID_VALUE_QZSS_L1C_A

   UINT8  SNR;         //[0..63] SNR
   INT16  Dopp;        // [-32768..32767]
   UINT32 u4CodePh;      //[0..2097151] ms 21-bits with 2^-21 resolution
   UINT8  u1CodePhInt;   //[0~127] ms
   UINT8  Mul_Path_Ind;  //[0~3] refer to RRLP table A.9

   UINT8  u1CarryQualInd; //[0~3]
   UINT32 u1Adr;          //[0..33554431] 25-bits with 2^-10 resolution
   UINT8  Range_RMS_Man ;         //Pseudorange RMS Error mantissa
   UINT8  Range_RMS_Exp;         //Pseudorange RMS Error Exponent
}MTK_IS801_SV_DATA_T;

typedef struct
{
   UINT8 Time_Ref;     //I4
   UINT8 TimeRefSrc;   //I4
   UINT8 NumValidMeas; //U4
   UINT32 Time_Tow;
   UINT8  u1GnssTimeID;    /* gnss system time ID:eque to GNSS-ID(,0-GPS,1-SBAS, 2-QZSS,3-Galileo,4-GLONASS, 5~16 reserved) */
   INT16  i2DayNo;        /* [0-] in day */
   UINT32 u4Todms;        /* [0-3599999] in ms */
   UINT16 u2TodFrag;      /* [0-3999] with resolution of 250ns optional */
   UINT32 u4TodUnc ;         /* [0-127] with resolution of 250ns optional */
   UINT8  u1NumValidMeas;
   UINT8  u1NumValidGnss;
   UINT16 u2GnssIDsInUse;     //in-use GNSSID bitmap
   MTK_AGNSS_SIGNALIDS_T  u1SignalIDsInUse;   //in-use GNSSID bitmap :
   UINT8  u1CodePhAmb;     // [0~127 ]the codephase ambiguity in interge ms default set to 0 optional
   MTK_IS801_SV_DATA_T SV_Data[AGNSS_RRLP_MAX_PRM];  // Satellite Pseudorange Measurement Data

}s_API_IS801_GNSS_PRMeas;

/* start for gnss utc model */
/* for GPS UTC model */
/*
typedef struct
{
    INT32  i4UtcA1;         //[-8388608..8388607], scale factor 2^(-50) seconds/second
    INT32  i4UtcA0;         // [-2147483648..2147483647], scale factor 2^(-30) seconds
    UINT8  u1UtcTot;        // [0..255], scale factor 2^12 seconds
    UINT8  u1UtcWNt;        // [0..255], scale factor 1 week
    INT8   i1UtcDeltaTls;   //[-128..127], scale factor 1 second
    UINT8  u1UtcWNlsf;      // [0..255], scale factor 1 week
    INT8   i1UtcDN;         // [-128..127], scale factor 1 day
    INT8   i1UtcDeltaTlsf;  // [-128..127], scale factor 1 second
} MTK_GPS_ASSIST_UCP_T;
*/

/* for QZSS UTC model */
typedef struct
{
    INT16   i2UtcA0;         /* [-32768..32767], bias coefficient of GNSS time scale relative to UTC time scale, scale factor 2^(-35) seconds */
    INT16   i2UtcA1;         /* [-4096..4095], drift coefficient of GNSS time scale relative to UTC time scale, scale factor 2^(-51) seconds/second */
    INT8    i1UtcA2;         /* [-64..63], drift rate correction coefficient of GNSS time sacel relative to UTC time scale, scale factor 2^(-68) seconds/second^2 */
    INT8    i1UtcDeltaTls;   /* [-128..127], current or past leap second count, scale factor 1 second */
    UINT16  u2UtcTot;        /* [0..65535], time data reference time of week, scale factor 2^4 seconds */
    UINT16  u2UtcWNot;       /* [0..8191], time data reference week number, scale factor 1 week */
    UINT8   u1UtcWNlsf;      /* [0..255], leap second reference week number, scale factor 1 week */
    UINT8   u1UtcDN;         /* 4 bits field, leap second reference day number, scale factor 1 day */
    INT8    i1UtcDeltaTlsf;  /* [-128..127], current or future leap second count, scale factor 1 second */
} MTK_QZSS_ASSIST_UCP_T;

/* for GLONASS  UTC model */
typedef struct
{
    UINT16  u2nA;            /* [1..1461], callendar day number within four-year period beginning since the leap year, scale factor 1 day */
    INT32   i4tauC;          /* [-2147483648..2147483647], GLONASS time scale correction to UTC(SU), scale factor 2^(-31) seconds */
    //optional field                      /* mandatory present if GLONASS-M satellites are presnet in the current GLONASS constellation */
    INT16   i2b1;            /* [-1024..1023],default 0.  coefficient to determine delta UT1, scale factor 2^(-10) seconds */
    INT16   i2b2;            /* [-512..511],default 0.      coefficient to determind delta UT1, scale factor 2^(-16) seconds/msd */
    UINT8   u1kp;            /* 2 bits field, default 0.       notification of expected leap second correction */
} MTK_GLO_ASSIST_UCP_T;

/* for SBAS  UTC model */
typedef struct
{
    INT32  i4UtcA1wnt;       /* [-8388608..8388607], scale factor 2^(-50) seconds/second */
    INT32  i4UtcA0wnt;       /* [-2147483648..2147483647], scale factor 2^(-30) seconds */
    UINT8  u1UtcTot;         /* [0..255], scale factor 2^12 seconds */
    UINT8  u1UtcWNt;         /* [0..255], scale factor 1 week */
    INT8   i1UtcDeltaTls;    /* [-128..127], scale factor 1 second */
    UINT8  u1UtcWNlsf;       /* [0..255], scale factor 1 week */
    INT8   i1UtcDN;          /* [-128..127], scale factor 1 day */
    INT8   i1UtcDeltaTlsf;   /* [-128..127], scale factor 1 second */
    INT8   i1UtcStandardID;  /* [0..7], if GNSS-ID indicates SBAS, this field indicated the UTC stadard used for the SBAS network time indicated by SBAS-ID to UTC relation */
} MTK_SBAS_ASSIST_UCP_T;

/* for BDS UTC model */
typedef struct
{
    INT32  i4UtcA0;       /* [-2147483648..2147483647], scale factor 2^(-30) seconds */
    INT32  i4UtcA1;       /*[-8388608..8388607], scale factor 2^(-50) seconds/second */
    INT8   i1UtcDeltaTls;   /* [-128..127], scale factor 1 second */
    UINT8  u1UtcWNlsf;       /* [0..255], scale factor 1 week */
    UINT8  u1UtcDN;          /* [-128..127], scale factor 1 day */
    INT8   i1UtcDeltaTlsf;   /* [-128..127], scale factor 1 second */
} MTK_BDS_ASSIST_UCP_T;

#ifdef SUPPORT_AGA
typedef struct
{
   INT32  i4A1;         // UTC parameter A1 (seconds/second)/(2^-50)
   INT32  i4A0;         // UTC parameter A0 (seconds)/(2^-30)
   UINT32 u4Tot;        // UTC reference time of week (seconds)/(2^12)
   UINT8  u1WNt;        // UTC reference week number (weeks)
   INT8   i1dtLS;       // UTC time difference due to leap seconds before event (seconds)
   UINT8  u1WNLSF;      // UTC week number when next leap second event occurs (weeks)
   UINT8  u1DN;         // UTC day of week when next leap second event occurs (days)
   INT8   i1dtLSF;      // UTC time difference due to leap seconds after event (seconds)
} MTK_GAL_ASSIST_UCP_T;
#endif

typedef struct
{
    MTK_GNSS_UTC_TYPE_ENUM  u1UtcMd;

    union
    {
       MTK_GPS_ASSIST_UCP_T   utcModel1;  /* for GPS */
       MTK_QZSS_ASSIST_UCP_T  utcModel2;  /* for QZSS */
       MTK_GLO_ASSIST_UCP_T   utcModel3;  /* for GLONASS */
       MTK_SBAS_ASSIST_UCP_T utcModel4;   /* for SBAS */
       MTK_BDS_ASSIST_UCP_T utcModel5;    /* for BDS */
       MTK_GAL_ASSIST_UCP_T utcModel6;    /* for GALILEO */
    } data;
} MTK_GNSS_ASSIST_UCP_T;
/* end for gnss utc model */

/* start for gnss data bit assistance */
typedef struct
{
    MTK_GNSS_ID_ENUM  eGnssID;
    UINT16   u2GnssTOD;     /* [0..3599999] milli-second, reference time of the first bit of the data modulo 1 hour, scale factor 1 second */
   // UINT16   u2GnssTODms;   /* [0..999], fractional part of gnssTD, scale factor 1 milli-second */
    UINT16   u2SvId;
    UINT8    u1SigType;
    UINT16   u2DataBitsNum; /* data bit original max is 1024 bits */
    UINT16   u2Num; /* x th PMTK for this SV-signal */
    UINT16   u2NumIndex; /* Index; */
    UINT32   au4Word[16];/* 16Word*4-byte*8-bits = 2^9 =512 bit */
} MTK_GNSS_ASSIST_DBA_T;
/* end for gnss data bit assistance */

/* start for gnss aux info */
typedef struct
{
    UINT8   u1SvId;           // PRN GPS:1~32  GLO:1~24
    UINT8    u1SigAvai;      /* 8 bits field, indicate the ranging signals supported by the satellite indicated by svID */
    /* optional field */
    INT8    i1ChannelId;     /* indicate the GLONASS carrier frequency number of the satellite identified by svID */
                            /* for GLONASS[-7..13]. if there are no this parameter, this para is set "256": 0xff
                                                      for GPS there is no part for this para in PMTK765.So need to handle this para besides GLONASS  */
} MTK_GNSS_ASSIST_AUX_ELE_T;

typedef struct
{
    //MTK_GNSS_AUX_TYPE_ENUM eType;
    MTK_GNSS_ID_ENUM eGnssID;
    UINT8 u1GnssEleNum;
    MTK_GNSS_ASSIST_AUX_ELE_T  rGnssEle[GNSS_MAX_AUX_SAT_ELEMENT];

} MTK_GNSS_ASSIST_AUX_T;
/* end for gnss aux info */
/* for GNSS capbility   */

typedef struct
{
    MTK_GNSS_ID_ENUM eGnssID;
    UINT8            u1SigBitmap;
} MTK_GNSS_SIGNAL_T;

typedef struct
{
    MTK_GPS_BOOL       fgADR;
    MTK_GPS_BOOL       fgFta;
    MTK_GPS_BOOL       fgDgnss;
    UINT8              u1GnssNum;
    MTK_GNSS_SIGNAL_T  GnssSigIDs[GNSS_ID_MAX_NUM];

    MTK_GPS_AGNSS_PRM_SV_DATA_T SV_Data[AGNSS_RRLP_MAX_PRM];
} MTK_AGNSS_DT_CAPBILITY_T;
typedef struct
{

    UINT8    u1GnssTimeID;    /* gnss system time ID:eque to GNSS-ID(,0-GPS,1-SBAS, 2-QZSS,3-Galileo,4-GLONASS, 5~16 reserved) */
    /**
     * This field specifies the sequential number of days from the origin of the GNSS System Time as follows:
     * GPS, QZSS, SBAS  Days from January 6th 1980 00:00:00 UTC(USNO)
     * Galileo V             TBD;
     * GLONASS V         Days from January 1st 1996
     */
    UINT16   u2DN;           /* [0-32767] gnssDayNumber  */
    double   dfTod;          /* [0-86399.999] in seconds */
    double   dfTodRms;       /* K = [0..127], uncertainty r (microseconds) = C*(((1+x)^K)-1), C=0.5, x=0.14 */
    double   dfFTime;        // sec, Frame Time correspond to GNSS TOD
    double   dfFTimeRms;     // ms, Frame Time RMS accuracy
} MTK_GNSS_ASSIST_FTA_T, MTK_GNSS_AGPS_DT_FTIME_T;    // Fine Time Assistance
#endif
//end for AGPS_SUPPORT_GNSS
typedef struct
{
    UINT8    u1Type;                 /* 1: co-clock clock drift ;2:.... */
    UINT32   u4ClkErrRange;          /* ppb need to convert to ppm */
    //INT32   u4ClkErrRange;          /* ppb need to convert to ppm */
}MTK_GPS_ASSIST_FREQ_T;
typedef struct
{

    UINT8    u1FtaType;        /* Frame sync aiding type */
    UINT16   u2WeekNum;        /* [0-32767] gnssWeekNumber  */
    double   dfTow;            /* [0-604799.999] in seconds */
    double   dfTowOffset;      /* [0-999.999] in us */
    UINT8    u1ClkDriftFlag;   // flag of clock drift. 1:
    double   dfClkDrift;       // clock drift +/-20000 ppb (+/-20ppm)
    UINT8    errType;
} MTK_GNSS_ASSIST_FSYNC_T, MTK_GNSS_AGPS_DT_FSYNC_T;    // Fine Time Assistance

typedef struct
{
    UINT16 u2Cmd;  // PMTK command ID:
                       // please get the data arguements in the following corresponding data structure.
    union
    {
        MTK_GPS_AGPS_DT_ACK_T rAck;              // PMTK001
        MTK_GPS_AGPS_CMD_MODE_T rAgpsMode;       // PMTK290
        MTK_GPS_AGPS_DT_REQ_ASSIST_T rReqAssist; // PMTK730
        MTK_GPS_AGPS_DT_LOC_EST_T rLoc;          // PMTK731
        MTK_GPS_AGPS_DT_GPS_MEAS_T rPRM;         // PMTK732
        MTK_GPS_AGPS_DT_LOC_ERR_T rLocErr;       // PMTK733
        MTK_GPS_AGPS_DT_FTIME_T rFTime;          // PMTK734
        MTK_GPS_AGPS_DT_FTIME_ERR_T rFTimeErr;   // PMTK735
        MTK_GPS_AGPS_DT_LOC_EXTRA_T rLocExtra;     // PMTK742/743/744
#if defined(AGPS_SUPPORT_GNSS)
        MTK_AGNSS_DT_REQ_ASSIST_T  rGnssReqAssist; // PMTK760
        MTK_AGNSS_DT_LOC_EST_T     rGnssLoc;       // PMTK761
        MTK_AGNSS_DT_MEAS_T        rGnssPRM;       // PMTK763
        MTK_AGNSS_DT_CAPBILITY_T   rGnssCap;       // PMTK764
#endif
    } uData;
} MTK_GPS_AGPS_RESPONSE_T;



#if defined(AGPS_SUPPORT_GNSS)
typedef struct
{
    UINT8 u1Arg1;  // version of Query location parameters: 1:GNSS format  0:GPS format
    UINT8 u1Arg2;  // if is for early report? 1:early report  0:normal report
    UINT8 u1Arg3;
    UINT8 u1Arg4;
    UINT16 u1Arg5;
} MTK_GNSS_CMD_LOC_T;

typedef struct
{
    UINT8 u1Arg1;  // version of Query measurement parameters: 1:GNSS format  0:GPS format
    UINT8 u1Arg2;  // if is for early report? 1:early report  0:normal report
    UINT8 u1Arg3;  // multi freq measurment req?
    UINT16 u1Arg4; // gnss bitmap
} MTK_GNSS_CMD_MEAS_T;

typedef struct
{
    UINT8 u1Arg1;  // 1: Query parameters using GNSS format  0:GPS format
} MTK_GNSS_CMD_BITMAP_T;

typedef struct
{
    UINT8 u1Arg1;  // 1: Query parameters using GNSS format  0:GPS format
} MTK_GNSS_CMD_CAPB_T;
#endif
typedef struct
{
  UINT16    u2Cmd;  // PMTK command ID: if the PMTK command has data arguments,
                        // please assign the data in the following  corresponding data structure.
  union
  {
    MTK_GPS_AGPS_CMD_MODE_T rMode;              // PMTK290
    MTK_GPS_AGPS_CMD_ACCEPT_MAP_T rAcceptMap;   // PMTK292
    MTK_GPS_AGPS_CMD_QOP_T rQop;                // PMTK293
    MTK_GPS_ASSIST_EPH_T rAEph;             // PMTK710
    MTK_GPS_ASSIST_ALM_T rAAlm;             // PMTK711
    MTK_GPS_ASSIST_TIM_T rATim;             // PMTK712
    MTK_GPS_ASSIST_LOC_T rALoc;             // PMTK713
    MTK_GPS_ASSIST_CLK_T rAClk;             // PMTK714
    MTK_GPS_ASSIST_KLB_T rAKlb;             // PMTK715
    MTK_GPS_ASSIST_UCP_T rAUcp;             // PMTK716
    MTK_GPS_ASSIST_BSV_T rABsv;             // PMTK717
    MTK_GPS_ASSIST_ACQ_T rAAcq;             // PMTK718
    MTK_GPS_ASSIST_FTA_T rAFta;             // PMTK719
    MTK_GPS_ASSIST_DGP_T rARtcm;            // PMTK720
    MTK_GPS_ASSIST_TOW_T rATow;             // PMTK725
    MTK_GPS_AGPS_CMD_MA_LOC_T rAMA_Loc;     // PMTK739
#if defined(AGPS_SUPPORT_GNSS)
    MTK_GNSS_CMD_LOC_T  rLoc;             // PMTK485,1*   PMTK485,0*
    MTK_GNSS_CMD_MEAS_T rMeas;            // PMTK486,1*   PMTK486,0*
    MTK_GNSS_CMD_BITMAP_T rBitMap;        // PMTK487,1*   PMTK487,0*
    MTK_GNSS_CMD_CAPB_T  rCapb;                 // PMTK493,1* PMTK493,0*

    MTK_GNSS_ASSIST_TIM_T  rAGnssTim;           // PMTK752
    MTK_GNSS_ASSIST_TMOD_T rAGnssTmod;          // PMTK753
    MTK_GNSS_ASSIST_ION_T rAGnssIon;            // PMTK754
    MTK_GNSS_ASSIST_UCP_T rAGnssUcp;            // PMTK755
    MTK_GNSS_ASSIST_DBA_T rAGnssDba;            // PMTK756
    MTK_GNSS_ASSIST_BSV_T rAGnssBsv;            // PMTK757
    MTK_GNSS_ASSIST_ACQ_T rAGnssAcq;            // PMTK758
    MTK_GNSS_ASSIST_EOP_T rAGnssEop;            // PMTK759
    MTK_GNSS_ASSIST_AUX_T rAGnssAux;            // PMTK765
    MTK_GNSS_ASSIST_EPH_T rAGnssEph;            // PMTK710
    MTK_GNSS_ASSIST_ALM_T rAGnssAlm;            // PMTK713
    MTK_GNSS_ASSIST_LOC_T rAGnssLoc;            // PMTK712
    MTK_GNSS_ASSIST_FTA_T rAGnssFta;            // PMTK766
#endif
    MTK_GNSS_ASSIST_FSYNC_T rAGnssFsync;        // PMTK768
    MTK_GPS_ASSIST_FREQ_T rAGPSFreq;            // PMTK680
  } uData;
} MTK_GPS_AGPS_CMD_DATA_T;


#if ( defined(__ARMCC_VERSION) && (__ARMCC_VERSION < 200000 ) )
// for ADS1.x
#elif ( defined(__ARMCC_VERSION) && (__ARMCC_VERSION < 400000 ) )
// for RVCT2.x or RVCT3.x
#else
#pragma pack()
#endif

/* NNUM ********************************************************************/

typedef enum
{
    GNSS_NETWORK_CELL_TYPE_NULL,
    GNSS_NETWORK_CELL_TYPE_EUTRA,
    GNSS_NETWORK_CELL_TYPE_UTRA,
    GNSS_NETWORK_CELL_TYPE_GSM
} gnss_network_cell_type_enum;

typedef enum
{
    GNSS_COMMON_ASSIST_DATA_TYPE_REF_TIME,
    GNSS_COMMON_ASSIST_DATA_TYPE_REF_LOCACTION,
    GNSS_COMMON_ASSIST_DATA_TYPE_ION_MODEL,
    GNSS_COMMON_ASSIST_DATA_TYPE_EARTH_ORIENT_PARAMS,
    GNSS_COMMON_HA_ASSIST_DATA_TYPE_ION_MODEL,
    GNSS_COMMON_HA_ASSIST_DATA_TYPE_TROPO_MODEL,
    GNSS_COMMON_HA_ASSIST_DATA_TYPE_ALT,
    GNSS_COMMON_HA_ASSIST_DATA_TYPE_SOLAR,
    GNSS_COMMON_HA_ASSIST_DATA_TYPE_CCP
} gnss_common_assist_data_type_enum;

typedef enum
{
    GNSS_GENERIC_ASSIST_DATA_TYPE_TIME_MODEL,
    GNSS_GENERIC_ASSIST_DATA_TYPE_DGNSS_CORRECTION,
    GNSS_GENERIC_ASSIST_DATA_TYPE_NAVIGATION_MODEL,
    GNSS_GENERIC_ASSIST_DATA_TYPE_RTI,
    GNSS_GENERIC_ASSIST_DATA_TYPE_DATA_BIT_ASSIST,
    GNSS_GENERIC_ASSIST_DATA_TYPE_ACQUISITION,
    GNSS_GENERIC_ASSIST_DATA_TYPE_ALMANAC,
    GNSS_GENERIC_ASSIST_DATA_TYPE_UTC_MODEL,
    GNSS_GENERIC_ASSIST_DATA_TYPE_AUX_INFO,
    GNSS_GENERIC_ASSIST_DATA_TYPE_DBDS_CORRECTION,
    GNSS_GENERIC_ASSIST_DATA_TYPE_BDS_GRID_MODEL,
    GNSS_GENERIC_HA_ASSIST_DATA_TYPE_CCP,
    GNSS_GENERIC_HA_ASSIST_DATA_TYPE_DEGRADATION
} gnss_generic_assist_data_type_enum;

typedef enum
{
    GNSS_NAV_MODEL_REQ_TYPE_STORED_NAV_LIST,
    GNSS_NAV_MODEL_REQ_TYPE_REQ_NAV_LIST
} gnss_nav_model_req_type_enum;

typedef enum
{
    GNSS_UTC_MODEL_TYPE_MODEL1,  /* GPS, Galileo, QZSS */
    GNSS_UTC_MODEL_TYPE_MODEL2,  /* NAVIC, BDS B1C */
    GNSS_UTC_MODEL_TYPE_MODEL3,  /* GLONASS */
    GNSS_UTC_MODEL_TYPE_MODEL4,  /* SBAS */
    GNSS_UTC_MODEL_TYPE_MODEL5   /* BDS B1I */
} gnss_utc_model_type_enum;


typedef enum
{
    GNSS_AUX_INFO_GNSS_TYPE_GPS,
    GNSS_AUX_INFO_GNSS_TYPE_GLONASS,
    GNSS_AUX_INFO_GNSS_TYPE_BDS
} gnss_aux_info_gnss_type_enum;


typedef enum
{
    GNSS_POS_RESULT_TYPE_POS_CNF,
    GNSS_POS_RESULT_TYPE_ASSIST_DATA_REQ
} gnss_pos_result_type_enum;


typedef enum
{
    GNSS_MEAS_RESULT_TYPE_MEAS_CNF,
    GNSS_MEAS_RESULT_TYPE_ASSIST_DATA_REQ
} gnss_meas_result_type_enum;


typedef enum
{
    GNSS_LOC_RESULT_NULL,
    GNSS_LOC_RESULT_NO_ERROR,
    GNSS_LOC_RESULT_UNDEFINED,
    GNSS_LOC_RESULT_REQ_TIMEOUT,
    GNSS_LOC_RESULT_NOT_ENOUGH_SATELLITES,
    GNSS_LOC_RESULT_ASSIST_DATA_MISSING,  /* not used in POS(MEAS)_REQ/CNF primitive */

    /* dedicated for RRLP */
    GNSS_LOC_RESULT_METHOD_NOT_SUPPORTED,
    GNSS_LOC_RESULT_REFERENCE_BTS_NOT_SERVING_BTS,

    /* dedicated for RRC */
    GNSS_LOC_RESULT_NOT_ACCOMPLISHED_TIMING_OF_CELL_FRAMES,  /* similar to FINE_TIME_ASSISTANCE_MEASUREMENTS_NOT_POSSIBLE */
    GNSS_LOC_RESULT_REFERENCE_CELL_NOT_SERVING_CELL,         /* reference cell's SFN cannot be decoded */

    /* dedicated for LPP */
    GNSS_LOC_RESULT_FINE_TIME_ASSISTANCE_MEASUREMENTS_NOT_POSSIBLE,  /* fineTimeAssistanceMeasurementsNotPossible IE present */
    GNSS_LOC_RESULT_ADR_MEASUREMENTS_NOT_POSSIBLE,                   /* adrMeasurementsNotPossible IE present */
    GNSS_LOC_RESULT_MULTI_FREQUENCY_MEASUREMENTS_NOT_POSSIBLE        /* multiFrequencyMeasurementsNotPossible IE present */
    //#ifdef __EARLY_FIX_SUPPORT__
       ,GNSS_LOC_RESULT_EARLY_FIX,                                       /* Early fix result */
        GNSS_LOC_RESULT_EARLY_FIX_NO_RESULT                              /* Early fix no result */
    //#endif
} gnss_loc_result_enum;

typedef enum {
    TIME_SIB_RESULT_OK          =0,         /* ERRC/EL1 reported useful info, check fields in lbs_errc_read_time_sib_ind_struct */
    TIME_SIB_RESULT_NOT_TRY     =1,         /* No valid SIB info, and LBS doesnt need to try again */
    TIME_SIB_RESULT_RE_TRY      =2,         /* No valid SIB info, and LBS may try again */
    TIME_SIB_RESULT_TIMEOUT     =3          /* While trying to read SIB for time sync, guard timer timeouts(2s), Can retry, ask ERRC for further check*/
} time_sib_result_enum;

typedef enum {
    TIME_SIB_CDMA_SYS_TIME_SYNC  =0,
    TIME_SIB_CDMA_SYS_TIME_ASYNC =1
} time_sib_cdma_sys_time_type_enum;

typedef enum {
    GNSS_TIME,
    GPS_TIME,
    UTC_TIME
} frame_sync_pulse_time_type_enum;


/* ---LPPe HA GNSS Interface--- */
typedef enum
{
    GNSS_HA_IONO_MODEL_TYPE_STATIC_MODEL,
    GNSS_HA_IONO_MODEL_TYPE_PERIODIC_MODEL,
    GNSS_HA_IONO_MODEL_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_iono_model_type_enum;


typedef enum
{
    GNSS_HA_COMMON_ASSIST_DATA_TYPE_IONO_MODEL,
    GNSS_HA_COMMON_ASSIST_DATA_TYPE_TROPO_MODEL,
    GNSS_HA_COMMON_ASSIST_DATA_TYPE_ALTITUDE,
    GNSS_HA_COMMON_ASSIST_DATA_TYPE_SOLAR_RAD,
    GNSS_HA_COMMON_ASSIST_DATA_TYPE_CCP_ASSIST,
    GNSS_HA_COMMON_ASSIST_DATA_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_common_assist_data_type_enum;


typedef enum
{
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_WA_ION_SURF,
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_SV_MECHANICS,
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_SV_DCB,
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_DEGRAD_MODEL,
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_CCP_ASSIST,
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_NAV_MODEL,
    GNSS_HA_GENERIC_ASSIST_DATA_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_generic_assist_data_type_enum;


typedef enum
{
    GNSS_HA_CCP_ASSIST_COMMON_TYPE_COMMOM,
    GNSS_HA_CCP_ASSIST_COMMON_TYPE_CONTROL,
    GNSS_HA_CCP_ASSIST_COMMON_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_ccp_assist_common_type_enum;


typedef enum
{
    GNSS_HA_SV_TYPE_GPS_IIR,
    GNSS_HA_SV_TYPE_GPS_IIRM,
    GNSS_HA_SV_TYPE_GPS_IIF,
    GNSS_HA_SV_TYPE_GPS_III,
    GNSS_HA_SV_TYPE_GLONASS_M,
    GNSS_HA_SV_TYPE_GLONASS_K1,
    GNSS_HA_SV_TYPE_GLONASS_K2,
    GNSS_HA_SV_TYPE_GLONASS_KM,
    GNSS_HA_SV_TYPE_UNKNOWN,
    GNSS_HA_SV_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_sv_type_enum;


typedef enum
{
   GNSS_HA_DCB_REF_PD_PILOT,
   GNSS_HA_DCB_REF_PD_DATA,
   GNSS_HA_DCB_REF_PD_NOT_APPLICABLE,
   GNSS_HA_DCB_REF_MAX = MAX_ENUM_VALUE
} gnss_ha_dcb_ref_pd_enum;


typedef enum
{
    GNSS_HA_CODE_PHASE_ERR_TYPE_RMS,
    GNSS_HA_CODE_PHASE_ERR_TYPE_CNR,
    GNSS_HA_CODE_PHASE_ERR_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_code_phase_err_type_enum;


typedef enum
{
    GNSS_HA_AGNSS_QOR_TYPE_10_M,
    GNSS_HA_AGNSS_QOR_TYPE_1_KM,
    GNSS_HA_AGNSS_QOR_TYPE_10_KM,
    GNSS_HA_AGNSS_QOR_TYPE_100_KM,
    GNAA_HA_AGNSS_QOR_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_agnss_qor_type_enum;


typedef enum
{
    GNSS_HA_HORI_UNC_TYPE_CEP,
    GNSS_HA_HORI_UNC_TYPE_ELLIPSE,
    GNSS_HA_HORI_UNC_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_hori_unc_type_enum;


typedef enum
{
    GNSS_HA_MULTIPATH_DETECTION_TYPE_LOW,
    GNSS_HA_MULTIPATH_DETECTION_TYPE_MODERATE,
    GNSS_HA_MULTIPATH_DETECTION_TYPE_HIGH,
    GNSS_HA_MULTIPATH_DETECTION_TYPE_NOT_MEASURED,
    GNSS_HA_MULTIPATH_DETECTION_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_multipath_detect_type_enum;


typedef enum
{
    GNSS_HA_TGT_ERR_CAUSE_UNDEFINED,
    GNSS_HA_TGT_ERR_CAUSE_HA_METHOD_NOT_SUPPORTED,
    GNSS_HA_TGT_ERR_CAUSE_MAX = MAX_ENUM_VALUE
} gnss_ha_tgt_err_cause_enum;


typedef enum
{
    GNSS_HA_TGT_IONO_MEAS_ERR_CAUSE_UNDEFINED,
    GNSS_HA_TGT_IONO_MEAS_ERR_CAUSE_IONO_MEAS_NOT_SUPPORTED,
    GNSS_HA_TGT_IONO_MEAS_ERR_CAUSE_IONO_MEAS_NOT_AVAILABLE,
    GNSS_HA_TGT_IONO_MEAS_ERR_CAUSE_MAX = MAX_ENUM_VALUE
} gnss_ha_tgt_iono_meas_err_cause_enum;

typedef enum
{
    GNSS_HA_TGT_ENV_OBSERVE_ERR_CAUSE_UNDEFINED,
    GNSS_HA_TGT_ENV_OBSERVE_ERR_CAUSE_SURF_MEAS_NOT_SUPPORTED,
    GNSS_HA_TGT_ENV_OBSERVE_ERR_CAUSE_SURF_MEAS_NOT_AVAILABLE,
    GNSS_HA_TGT_ENV_OBSERVE_ERR_CAUSE_MAX = MAX_ENUM_VALUE
} gnss_ha_tgt_env_observe_err_cause_enum;


typedef enum
{
    GNSS_HA_TGT_GNSS_ERR_CAUSE_UNDEFINED,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_NOT_SUPPORTED_BY_TARGET,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_UNAVAILABLE_FOR_ALL_REQUESTED_SIGNALS,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_ANTENNA_INFO_NOT_SUPPORTED,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_ANTENNA_INFO_NOT_AVAILABLE,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_PRESSURE_INFO_NOT_SUPPORTED,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_PRESSURE_INFO_NOT_AVAILABLE,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_UNABLE_TO_MODIFY_CTRL_PARAMS,
    GNSS_HA_TGT_GNSS_ERR_CAUSE_GNSS_MAX = MAX_ENUM_VALUE
} gnss_ha_tgt_gnss_err_cause_enum;

typedef enum
{
    GNSS_HA_STEC_Residual_Correction_b7 = 1,
    GNSS_HA_STEC_Residual_Correction_b16
} gnss_stec_residual_correction_enum;

typedef enum
{
    GNSS_HA_EqualIntegerAmbiguityLevel_allReferenceStations = 1,
    GNSS_HA_EqualIntegerAmbiguityLevel_referenceStationList
} gnss_equal_int_ambiguity_level_enum;

typedef enum
{
    GNSS_HA_GNSS_SSR_LIST_OF_CORRECTION_POINTS = 1,
    GNSS_HA_GNSS_SSR_ARRAY_OF_CORRECTION_POINTS
} gnss_ssr_correction_points_enum;

typedef enum
{
    GNSS_HA_REQ_CCP_REF_STATION_TYPE_POS_BASED,
    GNSS_HA_REQ_CCP_REF_STATION_TYPE_ID_BASED,
    GNSS_HA_REQ_CCP_REF_STATION_TYPE_KILL_LIST,
    GNSS_HA_REQ_CCP_REF_STATION_TYPE_MAX = MAX_ENUM_VALUE
} gnss_ha_req_ccp_ref_station_type_enum;

typedef enum
{
   GNSS_HA_SSR_SAT_REF_DATUM_itrf,
   GNSS_HA_SSR_SAT_REF_DATUM_regional
} gnss_ssr_orbit_corrections_sat_ref_datum_enum;


/* LPP_GNSS_ID_gnss_id */
typedef enum {
    GNSS_LPP_ID_GPS,
    GNSS_LPP_ID_SBAS,
    GNSS_LPP_ID_QZSS,
    GNSS_LPP_ID_GALILEO,
    GNSS_LPP_ID_GLONASS,
    GNSS_LPP_ID_BDS,
    GNSS_LPP_ID_NAVIC,
    GNSS_LPP_ID_MAX,
} gnss_id_enum;


typedef enum
{
    GNSS_CLOCK_MODEL_TYPE_STANDARD,
    GNSS_CLOCK_MODEL_TYPE_NAV,
    GNSS_CLOCK_MODEL_TYPE_CNAV,
    GNSS_CLOCK_MODEL_TYPE_GLONASS,
    GNSS_CLOCK_MODEL_TYPE_SBAS,
    GNSS_CLOCK_MODEL_TYPE_BDS,
    GNSS_CLOCK_MODEL_TYPE_BDS_2,
    GNSS_CLOCK_MODEL_TYPE_NAVIC
} gnss_clock_model_type_enum;


typedef enum
{
    GNSS_ORBIT_MODEL_TYPE_KEPLERIAN_SET,
    GNSS_ORBIT_MODEL_TYPE_NAV_KEPLERIAN_SET,
    GNSS_ORBIT_MODEL_TYPE_CNAV_KEPLERIAN_SET,
    GNSS_ORBIT_MODEL_TYPE_GLONASS_ECEF,
    GNSS_ORBIT_MODEL_TYPE_SBAS_ECEF,
    GNSS_ORBIT_MODEL_TYPE_BDS_KEPLERIAN_SET,
    GNSS_ORBIT_MODEL_TYPE_BDS_KEPLERIAN_SET_2,
    GNSS_ORBIT_MODEL_TYPE_NAVIC_KEPLERIAN_SET
} gnss_orbit_model_type_enum;

typedef enum
{
    GNSS_ALMANAC_TYPE_KEPLERIAN_SET,
    GNSS_ALMANAC_TYPE_NAV_KEPLERIAN_SET,
    GNSS_ALMANAC_TYPE_REDUCED_KEPLERIAN_SET,
    GNSS_ALMANAC_TYPE_MIDI_KEPLERIAN_SET,
    GNSS_ALMANAC_TYPE_GLONASS_SET,
    GNSS_ALMANAC_TYPE_ECEF_SBAS_SET,
    GNSS_ALMANAC_TYPE_BDS_ALMANAC_SET,
    GNSS_ALMANAC_TYPE_NAVIC_ALMANAC_SET
} gnss_almanac_type_enum;

typedef enum{
    ERRC_MDT_NO_REPORT_LOCATION,
    ERRC_MDT_REQUEST_STORE_LOCATION,                   /* ERRC request report stored location, LBS will determine report mode by ERRC request and User location setting. */
    ERRC_MDT_REQUEST_OPEN_GPS                          /* ERRC request report GPS, LBS will determine report mode by ERRC request and User location setting. */
} errc_lbs_gnss_pos_mdt_type_enum;

typedef enum
{
   GNSS_HA_RleIonoElement_ionoIndex_noaaScales_selected = 1,
   GNSS_HA_RleIonoElement_ionoIndex_UnKnowItem_selected,
   GNSS_HA_RleIonoElement_ionoIndex_MAX = MAX_ENUM_VALUE
} gnss_ha_rle_iono_element_selector_enum;


typedef enum
{
   GNSS_HA_NOAASCALES_G1,
   GNSS_HA_NOAASCALES_G2,
   GNSS_HA_NOAASCALES_G3,
   GNSS_HA_NOAASCALES_G4,
   GNSS_HA_NOAASCALES_G5,
   GNSS_HA_NOAASCALES_UNKNOWN,
   GNSS_HA_NOAASCALES_NONE,
   GNSS_HA_NOAASCALES_MAX = MAX_ENUM_VALUE
} gnss_ha_noaa_scales_enum;


typedef enum
{
   GNSS_HA_ELLIPSOID_POINT_LATITUDESIGN_NORTH,
   GNSS_HA_ELLIPSOID_POINT_LATITUDESIGN_SOUTH,
   GNSS_HA_ELLIPSOID_POINT_LATITUDESIGN_MAX = MAX_ENUM_VALUE
} gnss_ha_ellopsoid_point_latitude_sign_enum;


typedef enum
{
   GNSS_HA_ANTENNA_DESCRIPTION_IGS_ANTENNA_NAME_SELECTED = 1,
   GNSS_HA_ANTENNA_DESCRIPTION_PROPRIETARY_NAME_SELECTED,
   GNSS_HA_ANTENNA_DESCRIPTION_UNKNOWN_ITEM_SELECTED,
   GNSS_HA_ANTENNA_DESCRIPTION_MAX = MAX_ENUM_VALUE
} gnss_ha_antenna_description_selector_enum;


typedef enum
{
   GNSS_HA_NAVMODEL_COORDINATE_BASED_REFERENCED_TO_CENTER_OF_MASS,
   GNSS_HA_NavModel_COORDINATE_BASED_REFERENCED_TO_ANTENNA_PHASE_CENTER,
   GNSS_HA_NavModel_COORDINATE_BASED_REFERENCED_TO_MAX = MAX_ENUM_VALUE
} gnss_ha_nav_model_coordinate_based_referenced_enum;


typedef enum
{
    LIST_GPS_ASSIST_ALMANAC,
    LIST_GPS_ASSIST_NAVIGATION_MODEL,
    LIST_GPS_ASSIST_REF_LOCATION,
    LIST_GNSS_COMMON_ASSIST_DATA_REF_LOCACTION,
    LIST_GNSS_GENERIC_ASSIST_DATA_NAVIGATION_MODEL,
    LIST_GNSS_GENERIC_ASSIST_DATA_ALMANAC,

    LIST_GPS_GNSS_ASSIST_DATA_TYPE_MAX
} list_gps_gnss_assist_data_type_enum;


typedef enum
{
    GNSS_RTK_REF_STATION_IND_PHYSICAL,
    GNSS_RTK_REF_STATION_IND_NON_PHYSICAL
} gnss_rtk_ref_station_indicator_enum;


typedef enum
{
    GNSS_ANTENNA_SET_UP_ID_NON_ZERO
} gnss_antenna_set_up_id_enum;

typedef enum
{
    LPP_HA_GNSS_ASSIST_DATA_CTRL_REQ_TYPE_START_QUERY,
    LPP_HA_GNSS_ASSIST_DATA_CTRL_REQ_TYPE_STOP_QUERY,
} lpp_ha_gnss_assist_data_ctrl_req_type_enum;


typedef enum
{
    LPP_HA_GNSS_ASSIST_DATA_SOURCE_CP,
    LPP_HA_GNSS_ASSIST_DATA_SOURCE_UP,
} lpp_ha_gnss_assist_data_source_enum;

typedef enum
{
    LPP_HA_GNSS_ASSIST_DATA_CTRL_IND_TYPE_NW_PERIODIC_PARAMETER_UPDATE,
    LPP_HA_GNSS_ASSIST_DATA_CTRL_IND_TYPE_NW_END_TRANSACTION,
    LPP_HA_GNSS_ASSIST_DATA_CTRL_IND_TYPE_LEGACY_SESSION_ONGOING,
    LPP_HA_GNSS_ASSIST_DATA_CTRL_IND_TYPE_NW_NOT_AVAILABLE,
    LPP_HA_GNSS_ASSIST_DATA_CTRL_IND_TYPE_NW_ABORT,
    LPP_HA_GNSS_ASSIST_DATA_CTRL_IND_TYPE_ASK_RSP
} lpp_ha_gnss_assist_data_ctrl_ind_type_enum;


typedef enum
{
    LPP_HA_GNSS_COMMON_ASSIST_DATA_TYPE_RTK_REF_STAT_INFO,
    LPP_HA_GNSS_COMMON_ASSIST_DATA_TYPE_RTK_COM_OBSERV,
    LPP_HA_GNSS_COMMON_ASSIST_DATA_TYPE_SSR_CORR
} lpp_ha_gnss_common_assist_data_type_enum;


typedef enum
{
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_RTK_OBSERV,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_ORBIT_CORR,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_CLK_CORR,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_CODE_BIAS,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_URA,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_PHASE_BIAS,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_STEC_CORR,
    LPP_HA_GNSS_GENERIC_ASSIST_DATA_TYPE_SSR_GRID_CORR
} lpp_ha_gnss_generic_assist_data_type_enum;

/*-------------------------------
  A-GNSS-ProvideAssistanceData
    -> gnss-CommonAssistData
-------------------------------*/
/*=== GNSS Common Assistance Data ===*/

typedef enum
{
    SBAS_ID_WAAS   = 0,
    SBAS_ID_EGNOS  = 1,
    SBAS_ID_MSAS   = 2,
    SBAS_ID_GAGAN  = 3,
    SBAS_ID_BEIDOU = 4,
    SBAS_ID_END
} MTK_SBAS_ID_ENUM;

/* start for gnss reference time */
typedef struct
{
    kal_uint8   svID;         /* satellite PRN [1..64] */
    kal_uint16  tlmWord;      /* telemetry message [0..16383] */
    kal_uint8   antiSpoof;    /* anti spoof flag [0..1] */
    kal_uint8   alert;        /* alert flag [0..1] */
    kal_uint8   tlmRsvdBits;  /* 2 bit reserved bits [0..3] */
} gnss_gps_tow_assist_struct;

typedef struct
{
    MTK_GNSS_ID_ENUM                gnssTimeID;
    /**
     * This field specifies the sequential number of days from the origin of the GNSS System Time as follows:
     * GPS, QZSS, SBAS V Days from January 6th 1980 00:00:00 UTC(USNO)
     * Galileo V TBD;
     * GLONASS V Days from January 1st 1996
     */
    kal_uint16                  gnssDayNumber;           /* [0..32767] */
    kal_uint32                  gnssTimeOfDay;           /* [0..86399] in seconds */
    kal_bool                    gnssTimeOfDayFracMsecValid;
    kal_uint16                  gnssTimeOfDayFracMsec;   /* [0..999] in milli-seconds */
    kal_bool                    notificationLeapSecondValid;
    kal_uint8                   notificationLeapSecond;  /* only present when gnss=GLONASS */
    kal_uint8                   numGpsTowAssist;         /* only present when gnss=GPS */
    gnss_gps_tow_assist_struct  gpsTowAssist[GNSS_MAX_REF_TIME_SAT_ELEMENT];
} gnss_system_time_struct;

/* LPP_GNSS_ReferenceStationID_r15 */
typedef struct
{
    kal_uint16 referenceStationID; /* 0..65535 */
    kal_bool providerNameValid;
    kal_uint32 providerNameLen;
    kal_char providerName[32]; /* SIZE (1..32) */
} gnss_ref_station_id_struct;

/* LPP_AntennaDescription_r15 */
typedef struct
{
    kal_uint32 antennaDescriptorLen;
    kal_char antennaDescriptor[256]; /* SIZE (1..256) */
    kal_bool antennaSetUpIDValid;
    gnss_antenna_set_up_id_enum antennaSetUpID;
} gnss_antenna_description_struct;

/* LPP_AntennaReferencePointUnc_r15 */
typedef struct
{
    kal_uint8 uncX; /* 0..255 */
    kal_uint8 confX; /* 0..100 */
    kal_uint8 uncY; /* 0..255 */
    kal_uint8 confY; /* 0..100 */
    kal_uint8 uncZ; /* 0..255 */
    kal_uint8 confZ; /* 0..100 */
} gnss_antenna_ref_point_unc_struct;

/* LPP_PhysicalReferenceStationInfo_r15 */
typedef struct
{
    gnss_ref_station_id_struct physicalReferenceStationID;
    kal_int64 phyArpEcefX; /* -137438953472..137438953471 */
    kal_int64 phyArpEcefY; /* -137438953472..137438953471 */
    kal_int64 phyArpEcefZ; /* -137438953472..137438953471 */
    kal_bool phyArpUncValid;
    gnss_antenna_ref_point_unc_struct phyArpUnc; /* OPTIONAL */
} gnss_physical_ref_station_info_struct;

/* LPP_ReferenceStationList_r16 */
typedef struct
{
    kal_uint8 numRefStationElm;
    gnss_ref_station_id_struct refStationElm[GNSS_MAX_EQUAL_INT_AMBIGUITY_LEVEL_REF_STATION_ID_NUM];
} gnss_ref_station_list_struct;

/* LPP_EqualIntegerAmbiguityLevel_r16 */
typedef struct
{
    gnss_equal_int_ambiguity_level_enum selection;
    union
    {
        gnss_ref_station_list_struct refStationList;
    } choice;
} gnss_equal_int_ambiguity_level_struct;

/* LPP_GNSS_RTK_ReferenceStationInfo_r15 */
typedef struct
{
    gnss_ref_station_id_struct referenceStationID;
    gnss_rtk_ref_station_indicator_enum referenceStationIndicator;
    kal_int64 antennaReferencePointEcefX; /* -137438953472..137438953471 */
    kal_int64 antennaReferencePointEcefY; /* -137438953472..137438953471 */
    kal_int64 antennaReferencePointEcefZ; /* -137438953472..137438953471 */
    kal_bool antennaHeightValid;
    kal_uint16 antennaHeight; /* 0..65535 */
    kal_bool antennaDescriptionValid;
    gnss_antenna_description_struct antennaDescription;
    kal_bool antennaRefPointUncValid;
    gnss_antenna_ref_point_unc_struct antennaRefPointUnc;
    kal_bool phyRefStationInfoValid;
    gnss_physical_ref_station_info_struct physicalRefStationInfo;
    kal_bool equalIntAmbiguityLevelValid;
    gnss_equal_int_ambiguity_level_struct equalIntAmbiguityLevel;
} gnss_rtk_ref_station_info_struct;

/* LPP_GNSS_RTK_CommonObservationInfo_r15 */
typedef struct
{
    gnss_ref_station_id_struct referenceStationID;
    kal_uint8 clockSteeringIndicator; /* 0..3 */
    kal_uint8 externalClockIndicator; /* 0..3 */
    kal_bool smoothingIndicator; /* KAL_TRUE: Divergence-free smoothing; KAL_FALSE: Other type of smoothing */
    kal_uint8 smoothingInterval; /* 3 bits */
} gnss_rtk_common_observ_info_struct;

/* LPP_RelativeLocationElement_r16 */
typedef struct
{
    kal_int16 deltaLatitude; /* -512..511 */
    kal_int16 deltaLongitude; /* -1024..1023 */
} gnss_relative_location_element_struct;

/* LPP_GNSS_SSR_ListOfCorrectionPoints_r16_relativeLocationsList_r16 */
typedef struct
{
    kal_uint8 numRelativeLocElm;
    gnss_relative_location_element_struct relativeLocElm[GNSS_MAX_SSR_RELATIVE_LOCATION_ELEMENT];
} gnss_relative_locations_list_struct;

/* LPP_GNSS_SSR_ListOfCorrectionPoints_r16 */
typedef struct
{
    kal_int16 referencePointLatitude; /* -16384..16383 */
    kal_int16 referencePointLongitude; /* -32768..32767 */
    gnss_relative_locations_list_struct relativeLocList;
} gnss_ssr_list_of_correction_points_struct;

/* LPP_GNSS_SSR_ArrayOfCorrectionPoints_r16 */
typedef struct
{
    kal_int16 referencePointLatitude; /* -16384..16383 */
    kal_int16 referencePointLongitude; /* -32768..32767 */
    kal_uint8 numberOfStepsLatitude; /* 0..63 */
    kal_uint8 numberOfStepsLongitude; /* 0..63 */
    kal_uint16 stepOfLatitude; /* 1..511 */
    kal_uint16 stepOfLongitude; /* 1..1023 */
    kal_bool bitmaskOfGridsValid;
    kal_uint8 bitmaskOfGrids[8]; /* Only the first numberOfStepsLatitude*numberOfStepsLongitude bits are used, the remainder are set to '0' */
} gnss_ssr_array_of_correction_points_struct;

/* LPP_GNSS_SSR_CorrectionPoints_r16_correctionPoints_r16 */
typedef struct
{
    gnss_ssr_correction_points_enum selection;
    union
    {
      gnss_ssr_list_of_correction_points_struct listOfCorrectionPoints;
      gnss_ssr_array_of_correction_points_struct arrayOfCorrectionPoints;
    } choice;
} gnss_correction_points_struct;

/* LPP_GNSS_SSR_CorrectionPoints_r16 */
typedef struct
{
    kal_uint16 correctionPointSetID; /* 0..16383 */
    gnss_correction_points_struct correctionPoints; /* MANDATORY */
} gnss_ssr_correction_points_struct;


/*-------------------------------
  A-GNSS-ProvideAssistanceData
    -> gnss-GenericAssistData
-------------------------------*/

/* LPP_GNSS_RTK_SatelliteSignalDataElement_r15 */
typedef struct
{
    kal_uint8 gnssSignalID; /* map to GNSS_SGN_ID_VALUE_*, 0..7 */
    kal_bool gnssSignalIDExtValid; /* KAL_TRUE: gnssSignalID is set to 7 and shall be ignored */
    kal_uint8 gnssSignalIDExt; /* map to GNSS_SGN_ID_EXT_VALUE_*, 8..23 */
    kal_int32 finePseudoRange; /* -524288..524287 */
    kal_int32 finePhaseRange; /* -8388608..8388607 */
    kal_uint16 lockTimeIndicator; /* 0..1023 */
    kal_bool halfCycleAmbiguityIndicator; /* KAL_TRUE: half-cycle ambiguity; KAL_FALSE: no half-cycle ambiguity */
    kal_bool carrierToNoiseRatioValid;
    kal_uint16 carrierToNoiseRatio; /* 0..1023 */
    kal_bool finePhaseRangeRateValid;
    kal_int16 finePhaseRangeRate; /* -16384..16383 */
} gnss_rtk_sat_signal_data_element_struct;

/* LPP_GNSS_RTK_SatelliteSignalDataList_r15 */
typedef struct
{
    kal_uint8 numRtkSatSigDataElm;
    gnss_rtk_sat_signal_data_element_struct rtkSatSigDataElm[GNSS_MAX_RTK_SAT_SIGNAL_DATA_ELEMENT];
} gnss_rtk_sat_signal_data_list_struct;

/* LPP_GNSS_RTK_SatelliteDataElement_r15 */
typedef struct
{
    kal_uint8 svID;
    kal_bool integerMsValid;
    kal_uint8 integerMs; /* 0..254 */
    kal_uint16 roughRange; /* 0..1023 */
    kal_bool roughPhaseRangeRateValid;
    kal_int16 roughPhaseRangeRate; /* -8192..8191 */
    gnss_rtk_sat_signal_data_list_struct rtkSatSigDataList;
} gnss_rtk_sat_data_element_struct;

/* LPP_GNSS_ObservationList_r15 */
typedef struct
{
    kal_uint8 numRtkSatDataElm;
    gnss_rtk_sat_data_element_struct rtkSatDataElm[GNSS_MAX_RTK_SAT_DATA_ELEMENT];
} gnss_observations_list_struct;

/* LPP_GNSS_RTK_Observations_r15 */
typedef struct
{
    gnss_system_time_struct epochTime;
    gnss_observations_list_struct observationList;
} gnss_rtk_observations_struct;

/* LPP_SSR_OrbitCorrectionSatelliteElement_r15 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    kal_uint16 iod; /* 11 bits */
    kal_int32 deltaRadial; /* -2097152..2097151 */
    kal_int32 deltaAlongTrack; /* -524288..524287 */
    kal_int32 deltaCrossTrack; /* -524288..524287 */
    kal_bool dotDeltaRadialValid;
    kal_int32 dotDeltaRadial; /* -1048576..1048575 */
    kal_bool dotDeltaAlongTrackValid;
    kal_int32 dotDeltaAlongTrack; /* -262144..262143 */
    kal_bool dotDeltaCrossTrackValid;
    kal_int32 dotDeltaCrossTrack; /* -262144..262143 */
} gnss_ssr_orbit_correction_sat_element_struct;

/* LPP_SSR_OrbitCorrectionList_r15 */
typedef struct
{
    kal_uint8 numSsrOrbitSatElm;
    gnss_ssr_orbit_correction_sat_element_struct ssrOrbitSatElm[GNSS_MAX_SSR_ORBIT_CORRECTION_SAT_ELEMENT];
} gnss_ssr_orbit_correction_list_struct;

/* LPP_GNSS_SSR_OrbitCorrections_r15 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    gnss_ssr_orbit_corrections_sat_ref_datum_enum satRefDatum;
    kal_uint8 iodSsr; /* 0..15 */
    gnss_ssr_orbit_correction_list_struct ssrOrbitSatList;
} gnss_ssr_orbit_corrections_struct;

/* LPP_SSR_ClockCorrectionSatelliteElement_r15 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    kal_int32 deltaClockC0; /* -2097152..2097151 */
    kal_bool deltaClockC1Valid;
    kal_int32 deltaClockC1; /* -1048576..1048575 */
    kal_bool deltaClockC2Valid;
    kal_int32 deltaClockC2; /* -67108864..67108863 */
} gnss_ssr_clock_correction_sat_element_struct;

/* LPP_SSR_ClockCorrectionList_r15 */
typedef struct
{
    kal_uint8 numSsrClockSatElm;
    gnss_ssr_clock_correction_sat_element_struct ssrClockSatElm[GNSS_MAX_SSR_CLOCK_CORRECTION_SAT_ELEMENT];
} gnss_ssr_clock_correction_list_struct;

/* LPP_GNSS_SSR_ClockCorrections_r15 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    kal_uint8 iodSsr; /* 0..15 */
    gnss_ssr_clock_correction_list_struct ssrClockSatList;
} gnss_ssr_clock_corrections_struct;

/* LPP_SSR_CodeBiasSignalElement_r15 */
typedef struct
{
    kal_uint8 gnssSignalID; /* map to GNSS_SGN_ID_VALUE_*, 0..7 */
    kal_bool gnssSignalIDExtValid; /* KAL_TRUE: gnssSignalID is set to 7 and shall be ignored */
    kal_uint8 gnssSignalIDExt; /* map to GNSS_SGN_ID_EXT_VALUE_*, 8..23 */
    kal_int16 codeBias; /* -8192..8191 */
} gnss_ssr_code_bias_signal_element_struct;

/* LPP_SSR_CodeBiasSignalList_r15 */
typedef struct
{
    kal_uint8 numSsrCodeBiasSigElm;
    gnss_ssr_code_bias_signal_element_struct ssrCodeBiasSigElm[GNSS_MAX_SSR_CODE_BIAS_SIG_ELEMENT];
} gnss_ssr_code_bias_signal_list_struct;

/* LPP_SSR_CodeBiasSatElement_r15 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    gnss_ssr_code_bias_signal_list_struct ssrCodeBiasSigList;
} gnss_ssr_code_bias_sat_element_struct;

/* LPP_SSR_CodeBiasSatList_r15 */
typedef struct
{
    kal_uint8 numSsrCodeBiasSatElm;
    gnss_ssr_code_bias_sat_element_struct ssrCodeBiasSatElm[GNSS_MAX_SSR_CODE_BIAS_SAT_ELEMENT];
} gnss_ssr_code_bias_sat_list_struct;

/* LPP_GNSS_SSR_CodeBias_r15 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    kal_uint8 iodSsr; /* 0..15 */
    gnss_ssr_code_bias_sat_list_struct ssrCodeBiasSatList;
} gnss_ssr_code_bias_struct;

/* LPP_SSR_URA_SatElement_r16 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    kal_uint8 ssrUra; /* 6 bits. The 3 MSB define the CLASS with a range of 0-7 and the 3 LSB define the VALUE with a range of 0-7 */
} gnss_ssr_ura_sat_element_struct;

/* LPP_SSR_URA_SatList_r16 */
typedef struct
{
    kal_uint8 numSsrUraSatElm;
    gnss_ssr_ura_sat_element_struct ssrUraSatElm[GNSS_MAX_SSR_URA_SAT_ELEMENT];
} gnss_ssr_ura_sat_list_struct;

/* LPP_GNSS_SSR_URA_r16 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    kal_uint8 iodSsr; /* 0..15 */
    gnss_ssr_ura_sat_list_struct ssrUraSatList;
} gnss_ssr_ura_struct;

/* LPP_SSR_PhaseBiasSignalElement_r16 */
typedef struct
{
    kal_uint8 gnssSignalID; /* map to GNSS_SGN_ID_VALUE_*, 0..7 */
    kal_bool gnssSignalIDExtValid; /* KAL_TRUE: gnssSignalID is set to 7 and shall be ignored */
    kal_uint8 gnssSignalIDExt; /* map to GNSS_SGN_ID_EXT_VALUE_*, 8..23 */
    kal_int16 phaseBias; /* -16384..16383 */
    kal_uint8 phaseDiscontinuityIndicator; /* 0..3 */
    kal_bool phaseBiasIntegerIndicatorValid;
    kal_uint8 phaseBiasIntegerIndicator; /* 0..3 */
} gnss_ssr_phase_bias_signal_element_struct;

/* LPP_SSR_PhaseBiasSignalList_r16 */
typedef struct
{
    kal_uint8 numSsrPhaseBiasSigElm;
    gnss_ssr_phase_bias_signal_element_struct ssrPhaseBiasSigElm[GNSS_MAX_SSR_PHASE_BIAS_SIG_ELEMENT];
} gnss_ssr_phase_bias_signal_list_struct;

/* LPP_SSR_PhaseBiasSatElement_r16 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    gnss_ssr_phase_bias_signal_list_struct ssrPhaseBiasSigList;
} gnss_ssr_phase_bias_sat_element_struct;

/* LPP_SSR_PhaseBiasSatList_r16 */
typedef struct
{
    kal_uint8 numSsrPhaseBiasSatElm;
    gnss_ssr_phase_bias_sat_element_struct ssrPhaseBiasSatElm[GNSS_MAX_SSR_PHASE_BIAS_SAT_ELEMENT];
} gnss_ssr_phase_bias_sat_list_struct;

/* LPP_GNSS_SSR_PhaseBias_r16 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    kal_uint8 iodSsr; /* 0..15 */
    gnss_ssr_phase_bias_sat_list_struct ssrPhaseBiasSatList;
} gnss_ssr_phase_bias_struct;

/* LPP_STEC_SatElement_r16 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    kal_uint8 stecQualityIndicator; /* 6 bits. The 3 MSB define the CLASS with a range of 0-7 and the 3 LSB define the VALUE with a range of 0-7 */
    kal_int16 stecC00; /* -8192..8191 */
    kal_bool stecC01Valid;
    kal_int16 stecC01; /* -2048..2047 */
    kal_bool stecC10Valid;
    kal_int16 stecC10; /* -2048..2047 */
    kal_bool stecC11Valid;
    kal_int16 stecC11; /* -512..511 */
} gnss_stec_sat_element_struct;

/* LPP_STEC_SatList_r16 */
typedef struct
{
    kal_uint8 numStecSatElm;
    gnss_stec_sat_element_struct stecSatElm[GNSS_MAX_SSR_STEC_SAT_ELEMENT];
} gnss_stec_sat_list_struct;

/* LPP_GNSS_SSR_STEC_Correction_r16 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    kal_uint8 iodSsr; /* 0..15 */
    kal_uint16 correctionPointSetID; /* 0..16383 */
    gnss_stec_sat_list_struct stecSatList;
} gnss_ssr_stec_correction_struct;

/* LPP_TropospericDelayCorrection_r16 */
typedef struct
{
    kal_int16 tropoHydroStaticVerticalDelay; /* -256..255 */
    kal_int8 tropoWetVerticalDelay; /* -128..127 */
} gnss_troposperic_delay_correction_struct;

/* LPP_STEC_ResidualSatElement_r16 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    gnss_stec_residual_correction_enum selection;
    union
    {
        kal_int8 b7; /* -64..63 */
        kal_int16 b16; /* -32768..32767 */
    } choice;
} gnss_stec_residual_sat_element_struct;

/* LPP_STEC_ResidualSatList_r16 */
typedef struct
{
    kal_uint8 numResidualSatElm;
    gnss_stec_residual_sat_element_struct stecResidualSatElm[GNSS_MAX_STEC_RESIDUAL_SAT_ELEMENT];
} gnss_stec_residual_sat_list_struct;

/* LPP_GridElement_r16 */
typedef struct
{
    kal_bool tropospericDelayCorrectionValid;
    gnss_troposperic_delay_correction_struct tropospericDelayCorrection; /* OPTIONAL */
    gnss_stec_residual_sat_list_struct stecResidualSatList;
} gnss_grid_element_struct;

/* LPP_GridList_r16 */
typedef struct
{
    kal_uint8 numGridElm;
    gnss_grid_element_struct gridElm[GNSS_MAX_SSR_GRID_ELEMENT];
} gnss_grid_list_struct;

/* LPP_GNSS_SSR_GriddedCorrection_r16 */
typedef struct
{
    gnss_system_time_struct epochTime;
    kal_uint8 ssrUpdateInterval; /* 0..15 */
    kal_uint8 iodSsr; /* 0..15 */
    kal_bool troposphericDelayQualityIndicatorValid;
    kal_uint8 troposphericDelayQualityIndicator; /* 6 bits. The 3 MSB define the CLASS with a range of 0-7 and the 3 LSB define the VALUE with a range of 0-7 */
    kal_uint16 correctionPointSetID; /* 0..16383 */
    gnss_grid_list_struct gridList;
} gnss_ssr_gridded_correction_struct;

typedef struct
{
    kal_uint16  igpID;  /* indicate the ionospheric grid point (IGP) number as defined in BDS ICD v2.0, sec 5.3.3.8 */
    kal_uint16  dt;     /* indicate dT as defined in BDS ICD v2.0, sec 5.3.3.8.1, i.e. the vertical delay at the corresponding IGP indicated by igp-ID, scale factor 0.125 meter */
    kal_uint8   givei;  /* indicate the Grid Ionospheric Vertical Error Index (GIVEI) which is used to describe the delay correction accuracy at ionospheric grid point indicated by igp-ID, the mapping between GIVEI and GIVE is defined in BDS ICD v2.0, sec 5.3.3.8.2 */
} gnss_bds_grid_ion_element_struct;

typedef struct
{
    kal_uint16                        numGridIonElement;
    gnss_bds_grid_ion_element_struct  gridIonElement[GNSS_MAX_BDS_GRID_ION_ELEMENT];  /* a list that provides ionospheric grid point information for each grid point. Up to 16 instances are used in this version of the specification. The values 17 to 320 are reserved for future use */
} gnss_bds_grid_ion_list_struct;

typedef struct
{
    kal_uint16                     bdsRefTime;   /* [0..3599], the time for which the grid model parameters are valid, modulo 1 hour. bdsRefTime is given in BDS system time, scale factor 1 second */
    gnss_bds_grid_ion_list_struct  gridIonList;  /* a list that provides ionospheric grid point information for each grid point. Up to 16 instances are used in this version of the specification. The values 17 to 320 are reserved for future use */
} gnss_bds_grid_model_params_struct;


/* LPP_NavIC_EDC_r16 */
typedef struct
{
    kal_int16 navicAlphaEDC; /* -8192..8191 */
    kal_int16 navicBetaEDC; /* -8192..8191 */
    kal_int16 navicGammaEDC; /* -16384..16383 */
    kal_int16 navicAoIcorrection; /* -2048..2047 */
    kal_int16 navicAoRAcorrection; /* -2048..2047 */
    kal_int16 navicSemiMajorcorrection; /* -2048..2047 */
} gnss_navic_edc_struct;

/* LPP_NavIC_CDC_r16 */
typedef struct
{
    kal_int16 navicClockBiasCorrection; /* -4096..4095 */
    kal_int8 navicClockDriftCorrection; /* -128..127 */
} gnss_navic_cdc_struct;

/* LPP_NavIC_CorrectionElementAutoNav_r16 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    kal_uint16 navicTod; /* 0..65535 */
    kal_uint8 navicIodec; /* 0..255 */
    kal_int8 navicUDRAI; /* -16..15 */
    kal_int8 navicUDRArateI; /* -16..15 */
    gnss_navic_edc_struct navicEDC;
    gnss_navic_cdc_struct navicCDC;
} gnss_navic_correction_element_auto_nav_struct;

/* LPP_NavIC_CorrectionListAutoNav_r16 */
typedef struct
{
    kal_uint8 numNavicCorrElmAutoNav;
    gnss_navic_correction_element_auto_nav_struct navicCorrElmAutoNav[GNSS_MAX_NAVIC_CORRECTION_ELEMENT];
} gnss_navic_correction_list_auto_nav_struct;

/* LPP_NavIC_DifferentialCorrections_r16 */
typedef struct
{
    kal_uint16 navicRefTOWC; /* 0..50400 */
    gnss_navic_correction_list_auto_nav_struct navicCorrListAutoNav;
} gnss_navic_differential_corrections_struct;

/* LPP_RegionIgpElement_r16 */
typedef struct
{
    kal_uint8 regionID; /* 0..15 */
    kal_uint8 givei1; /* 0..15 */
    kal_uint16 givd1; /* 0..511 */
    kal_uint8 givei2; /* 0..15 */
    kal_uint16 givd2; /* 0..511 */
    kal_uint8 givei3; /* 0..15 */
    kal_uint16 givd3; /* 0..511 */
    kal_uint8 givei4; /* 0..15 */
    kal_uint16 givd4; /* 0..511 */
    kal_uint8 givei5; /* 0..15 */
    kal_uint16 givd5; /* 0..511 */
    kal_uint8 givei6; /* 0..15 */
    kal_uint16 givd6; /* 0..511 */
    kal_uint8 givei7; /* 0..15 */
    kal_uint16 givd7; /* 0..511 */
    kal_uint8 givei8; /* 0..15 */
    kal_uint16 givd8; /* 0..511 */
    kal_uint8 givei9; /* 0..15 */
    kal_uint16 givd9; /* 0..511 */
    kal_uint8 givei10; /* 0..15 */
    kal_uint16 givd10; /* 0..511 */
    kal_uint8 givei11; /* 0..15 */
    kal_uint16 givd11; /* 0..511 */
    kal_uint8 givei12; /* 0..15 */
    kal_uint16 givd12; /* 0..511 */
    kal_uint8 givei13; /* 0..15 */
    kal_uint16 givd13; /* 0..511 */
    kal_uint8 givei14; /* 0..15 */
    kal_uint16 givd14; /* 0..511 */
    kal_uint8 givei15; /* 0..15 */
    kal_uint16 givd15; /* 0..511 */
} gnss_region_igp_element_struct;

/* LPP_RegionIgpsList_r16 */
typedef struct
{
    kal_uint8 numRegionIgpElm;
    gnss_region_igp_element_struct regionIgpElm[GNSS_MAX_NAVIC_REGION_IGP_ELEMENT];
} gnss_region_igp_list_struct;

/* LPP_NavIC_GridModelParameter_r16 */
typedef struct
{
    kal_uint16 navicRefTOWC; /* 0..50400 */
    kal_uint16 regionMasked; /* 0..1023 */
    gnss_region_igp_list_struct regionIgpsList;
} gnss_navic_grid_model_param_struct;


/*-------------------------------
  Control transaction message
-------------------------------*/

/* LPP_GNSS_RTK_ReferenceStationInfoReq_r15 */
typedef struct
{
    kal_bool antennaDescriptionReq;
    kal_bool antennaHeightReq;
    kal_bool physicalReferenceStationReq;
    kal_bool stationIDValid;
    gnss_ref_station_id_struct stationID;
} gnss_rtk_ref_station_info_req_struct;

/* LPP_GNSS_SSR_CorrectionPointsReq_r16 */
typedef struct
{
   kal_bool corrPointSetIDReqValid;
   kal_uint16 correctionPointSetIDReq; /* 0..16383 */
} gnss_ssr_correction_points_req_struct;

/* LPP_GNSS_SignalIDs */
typedef struct
{
    kal_uint8 signalIDs; /* map to GNSS_SGN_ID_BITMAP_* */
    kal_bool signalIDsExtValid;
    kal_uint16 signalIDsExt; /* map to GNSS_SGN_ID_EXT_BITMAP_* */
} gnss_signal_ids_struct;

/* LPP_GNSS_RTK_ObservationsReq_r15 */
typedef struct
{
    gnss_signal_ids_struct gnssRtkSignalsReq;
    kal_bool gnssRtkIntegerMsReq;
    kal_bool gnssRtkPhaseRangeRateReq;
    kal_bool gnssRtkCnrReq;
    kal_bool stationIDValid;
    gnss_ref_station_id_struct stationID;
} gnss_rtk_observations_req_struct;

/* LPP_SatListElement_r15 */
typedef struct
{
    kal_uint8 svID; /* 0..63 */
    kal_uint16 iod; /* BIT STRING (SIZE(11)) */
} gnss_sat_list_element_struct;

/* LPP_GNSS_NavListInfo_r15 */
typedef struct
{
    kal_uint8 numSatListElm;
    gnss_sat_list_element_struct satListElm[GNSS_MAX_SAT_LIST_ELEMENT];
} gnss_nav_list_info_struct;

/* LPP_GNSS_SSR_OrbitCorrectionsReq_r15 */
typedef struct
{
    gnss_nav_list_info_struct storedNavList;
} gnss_ssr_orbit_corrections_req_struct;

/* LPP_GNSS_SSR_ClockCorrectionsReq_r15 */
typedef struct
{
    gnss_nav_list_info_struct storedNavList;
} gnss_ssr_clock_corrections_req_struct;

/* LPP_GNSS_SSR_CodeBiasReq_r15 */
typedef struct
{
    gnss_signal_ids_struct signalAndTrackingModeIdMap;
    gnss_nav_list_info_struct storedNavList;
} gnss_ssr_code_bias_req_struct;

/* LPP_GNSS_SSR_PhaseBiasReq_r16 */
typedef struct
{
    gnss_signal_ids_struct signalAndTrackingModeIdMap;
    gnss_nav_list_info_struct storedNavList;
} gnss_ssr_phase_bias_req_struct;

typedef struct
{
    kal_bool rtkRefStatInfoReqValid;
    gnss_rtk_ref_station_info_req_struct rtkRefStatInfoReq;
    kal_bool ssrCorrReqValid;
    gnss_ssr_correction_points_req_struct ssrCorrReq;
} lpp_ha_gnss_common_assist_data_request_struct;

typedef struct
{
    gnss_id_enum gnssId;
    kal_bool sbasIdValid;
    MTK_SBAS_ID_ENUM sbasId;

    kal_bool rtkObservReqValid;
    gnss_rtk_observations_req_struct rtkObservReq;
    kal_bool ssrOrbitCorrReqValid;
    gnss_ssr_orbit_corrections_req_struct ssrOrbitCorrReq;
    kal_bool ssrClkCorrReqValid;
    gnss_ssr_clock_corrections_req_struct ssrClkCorrReq;
    kal_bool ssrCodeBiasReqValid;
    gnss_ssr_code_bias_req_struct ssrCodeBiasReq;
    kal_bool ssrUraReqValid;
    kal_bool ssrPhaseBiasReqValid;
    gnss_ssr_phase_bias_req_struct ssrPhaseBiasReq;
    kal_bool ssrStecCorrReqValid;
    kal_bool ssrGridCorrReqValid;
    kal_bool gnssBDSGridModelReq;
} lpp_ha_gnss_generic_assist_data_struct;

/* LPP_GNSS_PeriodicControlParam_r15 */
typedef struct
{
    kal_uint8 deliveryAmount; /* 1..32 */
    kal_uint8 deliveryInterval; /* 1..64 */
} gnss_periodic_control_param_struct;

/* LPP_GNSS_PeriodicAssistDataReq_r15 */
typedef struct
{
    kal_bool rtkObservReqValid;
    gnss_periodic_control_param_struct rtkObservReq;
    kal_bool ssrOrbitCorrReqValid;
    gnss_periodic_control_param_struct ssrOrbitCorrReq;
    kal_bool ssrClkCorrReqValid;
    gnss_periodic_control_param_struct ssrClkCorrReq;
    kal_bool ssrCodeBiasReqValid;
    gnss_periodic_control_param_struct ssrCodeBiasReq;
    kal_bool ssrUraReqValid;
    gnss_periodic_control_param_struct ssrUraReq;
    kal_bool ssrPhaseBiasReqValid;
    gnss_periodic_control_param_struct ssrPhaseBiasReq;
    kal_bool ssrStecCorrReqValid;
    gnss_periodic_control_param_struct ssrStecCorrReq;
    kal_bool ssrGridCorrReqValid;
    gnss_periodic_control_param_struct ssrGridCorrReq;
} gnss_periodic_assist_data_req_struct;

typedef struct
{
    lpp_ha_gnss_common_assist_data_request_struct haGnssCommonAssistData;
    kal_uint8 numGnssGenericAssistData;
    lpp_ha_gnss_generic_assist_data_struct haGnssGenericAssistData[GNSS_MAX_REQ_ADD_GENERIC_ASSIST_DATA_ELEMENT];
    gnss_periodic_assist_data_req_struct periodicAssistDataReq;
} lpp_ha_gnss_assist_data_request_struct;

/* [AP->MD] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_ASSIST_DATA_CTRL_REQ */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    lpp_ha_gnss_assist_data_ctrl_req_type_enum ctrlReqType;
    lpp_ha_gnss_assist_data_request_struct haGnssAssistDataReq;
} lpp_lbs_ha_gnss_assist_data_ctrl_req_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_ASSIST_DATA_CTRL_CNF */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
} lpp_lbs_ha_gnss_assist_data_ctrl_cnf_struct;

/* LPP_GNSS_PeriodicAssistData_r15 */
typedef struct
{
    kal_bool rtkObservValid;
    gnss_periodic_control_param_struct rtkObserv;
    kal_bool ssrOrbitCorrValid;
    gnss_periodic_control_param_struct ssrOrbitCorr;
    kal_bool ssrClkCorrValid;
    gnss_periodic_control_param_struct ssrClkCorr;
    kal_bool ssrCodeBiasValid;
    gnss_periodic_control_param_struct ssrCodeBias;
    kal_bool ssrUraValid;
    gnss_periodic_control_param_struct ssrUra;
    kal_bool ssrPhaseBiasValid;
    gnss_periodic_control_param_struct ssrPhaseBias;
    kal_bool ssrStecCorrValid;
    gnss_periodic_control_param_struct ssrStecCorr;
    kal_bool ssrGridCorrValid;
    gnss_periodic_control_param_struct ssrGridCorr;
} gnss_periodic_assist_data_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_ASSIST_DATA_CTRL_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    lpp_ha_gnss_assist_data_source_enum source;
    lpp_ha_gnss_assist_data_ctrl_ind_type_enum ctrlIndType;
    gnss_periodic_assist_data_struct periodicAssistData;
} lpp_lbs_ha_gnss_assist_data_ctrl_ind_struct;

/* [AP->MD] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_ASSIST_DATA_CTRL_RSP */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
} lpp_lbs_ha_gnss_assist_data_ctrl_rsp_struct;


/*-------------------------------
  Data transaction message
    -> Common assistance data
-------------------------------*/

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_COMMON_ASSIST_DATA_RTK_REF_STAT_INFO_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_rtk_ref_station_info_struct rtkRefStatInfo;
} lpp_lbs_ha_gnss_common_assist_data_rtk_ref_stat_info_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_COMMON_ASSIST_DATA_RTK_COM_OBSERV_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_rtk_common_observ_info_struct rtkComObserv;
} lpp_lbs_ha_gnss_common_assist_data_rtk_com_observ_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_COMMON_ASSIST_DATA_SSR_CORR_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_ssr_correction_points_struct ssrCorr;
} lpp_lbs_ha_gnss_common_assist_data_ssr_corr_ind_struct;

/*-------------------------------
  Data transaction message
    -> Generic assistance data
-------------------------------*/

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_RTK_OBSERV_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_rtk_observations_struct rtkObserv;
} lpp_lbs_ha_gnss_generic_assist_data_rtk_observ_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_ORBIT_CORR_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_orbit_corrections_struct ssrOrbitCorr;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_orbit_corr_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_CLK_CORR_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_clock_corrections_struct ssrClkCorr;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_clk_corr_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_CODE_BIAS_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_code_bias_struct ssrCodeBias;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_code_bias_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_URA_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_ura_struct ssrUra;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_ura_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_PHASE_BIAS_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_phase_bias_struct ssrPhaseBias;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_phase_bias_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_STEC_CORR_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_stec_correction_struct ssrStecCorr;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_stec_corr_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LPP_HA_GNSS_GENERIC_ASSIST_DATA_SSR_GRID_CORR_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_ssr_gridded_correction_struct ssrGridCorr;
} lpp_lbs_ha_gnss_generic_assist_data_ssr_grid_corr_ind_struct;

/* [MD->AP] AGPS_MD_HUGE_DATA_TYPE_LCSP_GNSS_GENERIC_ASSIST_DATA_BDS_GRID_MODEL_IND */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppPeriodicSessionID; /* 0..255 */
    kal_uint8 lppTransactionID; /* 0..255 */
    gnss_id_enum gnssId;
    kal_bool sbasIdValid; /* only present when gnss is sbas */
    MTK_SBAS_ID_ENUM sbasId;
    gnss_bds_grid_model_params_struct bdsGridModel;
} lpp_lbs_lcsp_gnss_generic_assist_data_bds_grid_model_ind_struct;

/* [AP->MD] AGPS_MD_HUGE_DATA_TYPE_LCSP_GNSS_GENERIC_ASSIST_DATA_RSP */
typedef struct
{
    kal_uint16 internalTransactionID; /* 0..65535 */
    kal_uint8 lppTransactionID;
    gnss_generic_assist_data_type_enum type;
} lpp_lbs_lcsp_gnss_generic_assist_data_rsp_struct;


/*gnss2lcsp_struct*/



/*=== GNSS Common Assistance Data ===*/

/* start for gnss reference time */


/* start for gnss reference location */
typedef struct
{
    kal_bool    signOfLatitude;        /* TRUE: SOUTH, FALSE: NORTH */
    kal_uint32  degreesLatitude;       /* [0..8388607] */
    kal_int32   degreesLongitude;      /* [-8388608..8388607] */
    kal_bool    signOfAltitude;        /* TRUE: DEPTH, FALSE: HEIGHT */
    kal_uint16  altitude;              /* [0..32767] */
    kal_uint8   uncertaintySemiMajor;  /* K: [0..127], uncertainty r (meter) = C*((1+x)^K-1), C=10, x=0.1 */
    kal_uint8   uncertaintySemiMinor;  /* K: [0..127], uncertaintyr (meter) = C*((1+x)^K-1), C=10, x=0.1 */
    kal_uint8   orientationMajorAxis;  /* bearing angle degree: [0-179] */
    kal_uint8   uncertaintyAltitude;   /* K: [0..127], uncertainty h (meter) = C*((1+x)^K-1), C=45, x=0.025 */
    kal_uint8   confidence;            /* [0..100] */
} gnss_reference_location_struct;
/* end for gnss reference location */

/* ---LPPe HA GNSS Interface---begin--- */
typedef struct
{
    gnss_system_time_struct  beginTime;          /* specify the start time of the validity period */
    kal_bool                 beginTimeAltValid;
    kal_uint16               beginTimeAlt;       /* [0..2881], specify the alternative start time, and the start time is relative the time the message was received, scale factor 15 min (range from 0 minutes to 43215 min = 30 days) */
    kal_uint16               duration;           /* [0..2881], specify the duration of the validity period after the beginTime, scale factor 15 min (range from 0 minutes to 43215 min = 30 days) */
} gnss_ha_validity_period_struct;


typedef struct
{
    kal_uint8                 regionSizeInv;       /* [1..255], specify the inverse of the size of each side of the region in degrees, for value N the size is 10/N degrees */
    kal_bool                  areaWidthValid;
    kal_uint16                areaWidth;           /* [2..9180], specify the number of regions in the area in East-West direction, if the field is not present, the value is 1 */
    kal_uint16                codedLatOfNWCorner;  /* [0..4589], specify the latitude of the North-West corner of the area, encoded as explained in OMA-TS-LPPe Appendix C.1 */
    kal_uint16                codedLonOfNWCorner;  /* [0..9179], specify the longitude of the North-West corner of the area, encoded as explained in OMA-TS-LPPe Appendix C.1 */

    kal_bool                  rleListValid;
    //LPP_EXT_OMA_LPPe_RleList  rleList;             /* TBD: redefine internal structure? */  /* This field lists the regions in which the data is valid. If the field is not present, the data is valid in all the regions in the area */
} gnss_ha_validity_area_struct;


typedef struct
{
    kal_uint8   regionSizeInv;       /* specify the inverse of the size of each side of the region in degrees, for value N the size is 10/N degrees */
    kal_bool    areaWidthValid;
    kal_uint16  areaWidth;           /* specify the number of regions in the area in East-West direction, if the field is not present, the value is 1 */
    kal_uint16  codedLatOfNWCorner;  /* specify the latitude of the North-West corner of the area, encoded as explained in OMA-TS-LPPe Appendix C.1 */
    kal_uint16  codedLonOfNWCorner;  /* specify the longitude of the North-West corner of the area, encoded as explained in OMA-TS-LPPe Appendix C.1 */
} gnss_ha_storm_validity_area_struct;  /* only used in gnss_ha_iono_storm_ind_struct */


typedef struct
{
    kal_uint8  duration;          /* [1..63], scale factor 15 min, range [15, 945 min], i.e. upto 16 hours */
    kal_bool   durationLSBValid;
    kal_uint8  durationLSB;       /* [1..89], finer granularity duration, scale factor is 10 seconds, range [10, 890] seconds */
} gnss_ha_duration;


typedef struct
{
    kal_uint8   validityBitmap;  /* bhValid, chValid, awValid, bwValid, cwValid, use GNSS_HA_MAPPING_FUNC_PARAMS_BIT_*_VALID */
    kal_uint16  ah;  /* [0..16383], the a-coefficient of the hydrostatic mapping function, scale factor 2^-14 */
    /* optional */
    kal_uint16  bh;  /* [0..16383], the b-coefficient of the hydrostatic mapping function, scale factor 2^-14 */
    /* optional */
    kal_uint16  ch;  /* [0..16383], the c-coefficient of the hydrostatic mapping function, scale factor 2^-14 */
    /* optional */
    kal_uint16  aw;  /* [0..16383], the a-coefficient of the wet mapping function, scale factor 2^-14 */
    /* optional */
    kal_uint16  bw;  /* [0..16383], the b-coefficient of the wet mapping function, scale factor 2^-14 */
    /* optional */
    kal_uint16  cw;  /* [0..16383], the c-coefficient of the wet mapping function, scale factor 2^-14 */
} gnss_ha_mapping_func_params_struct;


typedef struct
{
    kal_int32  latitude;            /* [-2147483648..2147483647], latitude based on WGS84 [GPS-ICD-200D] datum, the relation between the latitude X in range [-90', 90'],
                                       and the coded number N is N = floor((X/90')*2^31), where value N=2^31 is coded as N=2^31-1, resolution 4.7 mm */
    kal_int32  longitude;           /* [-2147483648..2147483647], longitude based on WGS84 [GPS-ICD-200D] datum, the relation between the longitude X in range [-180', 180'),
                                       and the coded number N is floor((X/180')*2^31), worst-case resolution (at the Equator) 9.3 mm */
    kal_bool   cepValid;
    kal_uint8  cep;                 /* [0..255], horizontal uncertainty expressed as Circular Error Probable expressed as the coded number N,
                                       the relation between the CEP and the coded number is given by CEP = 0.3*((1+0.02)^N - 1) meters, range [0, 45.6) meters */
    kal_bool   uncSemiMajorValid;
    kal_uint8  uncSemiMajor;        /* [0..255], the semi-major axis of the horizontal uncertainty ellipse expressed as the coded number N,
                                       the relation between the semi-major axis and the coded number is given by semi-major axis = 0.3*( (1+0.02)^N -1) meters, range [0, 45.6) meters */
    kal_bool   uncSemiMinorValid;
    kal_uint8  uncSemiMinor;        /* [0..255], the semi-minor axis of the horizontal uncertainty ellipse expressed as the coded number N,
                                       the relation between the semi-minor axis and the coded number is given by semi-minor axis = 0.3*((1+0.02)^N -1) meters, range [0, 45.6) meters */
    kal_bool   offsetAngleValid;
    kal_uint8  offsetAngle;         /* [0..179], the angle of semi-major axis measured clockwise with respect to True North in steps of 1 degree */

    kal_bool   confHorizontalValid;
    kal_uint8  confHorizontal;      /* [0..99], specify the horizontal confidence percentage associated with the CEP or Uncertainty Ellipse depending upon which is included */
    kal_int32  altitude;            /* [-64000..1280000], altitude with respect to WGS84 [GPS-ICD-200D] ellipsoid, scale factor 2^(-7) meters, range [-500, 10000] meters */
    kal_uint8  uncAltitude;         /* [0..255], the altitude uncertainty expressed as the coded number N, the relation between the altitude uncertainty and
                                       the coded number is given by uncertainty= 0.3*((1+0.02)^N -1) meters, range [0, 45.6) meters */
    kal_bool   confVerticalValid;
    kal_uint8  confVertical;        /* [0..99], specify the confidence percentage associated with the altitude uncertainty */
} gnss_ha_high_accu_3d_position_struct;

/* begin of gnss_ha_ionospheric_model */
typedef struct
{
    gnss_ha_validity_period_struct  validityPeriod;  /* specify the start time and duration of the model validity period */
    kal_int8                        alfa0;           /* [-128..127], specify the alpha0 parameter of the Klobuchar model, scale factor 2^(-30) seconds */
    kal_int8                        alfa1;           /* [-128..127], specify the alpha1 parameter of the Klobuchar model, scale factor 2^(-27) seconds/semi-circle */
    kal_int8                        alfa2;           /* [-128..127], specify the alpha2 parameter of the Klobuchar model, scale factor 2^(-24) seconds/semi-circle^2 */
    kal_int8                        alfa3;           /* [-128..127], specify the alpha3 parameter of the Klobuchar model, scale factor 2^(-24) seconds/semi-circle^3 */
    kal_int8                        beta0;           /* [-128..127], specify the beta0 parameter of the Klobuchar model, scale factor 2^11 seconds */
    kal_int8                        beta1;           /* [-128..127], specify the beta1 parameter of the Klobuchar model, scale factor 2^14 seconds/semi-circle */
    kal_int8                        beta2;           /* [-128..127], specify the beta2 parameter of the Klobuchar model, scale factor 2^16 seconds/semi-circle^2 */
    kal_int8                        beta3;           /* [-128..127], specify the beta3 parameter of the Klobuchar model, scale factor 2^16 seconds/semi-circle^3 */
} gnss_ha_local_klobuchar_model_struct;


typedef struct
{
    gnss_ha_validity_area_struct          validityArea;
    kal_uint8                             numKlobucharModel;
    gnss_ha_local_klobuchar_model_struct  klobucharModel[GNSS_HA_MAX_LOCAL_KLOBUCHAR_MODEL];  /* local klobuchar model per validity period */
} gnss_ha_local_klobuchar_model_element_struct;


typedef struct
{
    kal_uint8                                     numKlobucharElement;
    gnss_ha_local_klobuchar_model_element_struct  klobucharElement[GNSS_HA_MAX_LOCAL_KLOBUCHAR_MODEL_ELEMENT];  /* local klobuchar model per validity area */
} gnss_ha_local_klobuchar_model_list_struct;


typedef struct
{
    gnss_ha_validity_period_struct      validityPeriod;   /* specify the time interval over which the storm data is valid */
    //LPP_EXT_OMA_LPPe_AGNSS_RleListIono  rleListIono;      /* TBD: structure is too big, redefine internal structure? */
} gnss_ha_storm_element_struct;


typedef struct
{
    kal_uint8                     numStormElement;
    gnss_ha_storm_element_struct  stormElement[GNSS_HA_MAX_STORM_ELEMENT];  /* storm indication element per validity period */
} gnss_ha_storm_list_struct;


typedef struct
{
    gnss_ha_storm_validity_area_struct  area;       /* rlelist is not not included or ignored in IonoStormIndication */
    gnss_ha_storm_list_struct           stormList;  /* provide information on the ionospheric activity in the area defined by area */
} gnss_ha_iono_storm_ind_struct;


typedef struct
{
    kal_bool                                   localKlobucharListValid;
    gnss_ha_local_klobuchar_model_list_struct  localKlobucharList;  /* localized Klobuchar model */

    kal_bool                                   ionoStormIndValid;
    gnss_ha_iono_storm_ind_struct              ionoStormInd;        /* information on the ionosphere conditions in the area */
} gnss_ha_ionospheric_static_model_struct;


typedef struct
{
    kal_bool                      durationValid;
    gnss_ha_duration              duration;           /* specify the length of the continuous periodic assistance session */

    kal_bool                      rateValid;
    kal_uint8                     rate;               /* [1..64], specify the length of the continuous periodic assistance session */

    kal_bool                      refPositionValid;
    //LPP_EXT_Ellipsoid_Point       referencePosition;  /* TBD: redefine internal structure? */

    kal_bool                      validityAreaValid;
    gnss_ha_validity_area_struct  validityArea;
} gnss_ha_wa_iono_control_param_struct;


typedef struct
{
    gnss_ha_validity_period_struct  validityPeriod;  /* define the validity period of the widea area ionosphere correction */
} gnss_ha_wa_iono_common_param_struct;


typedef struct
{
    kal_bool                                controlParamsValid;
    gnss_ha_wa_iono_control_param_struct    controlParams;       /* carry the control parameters of the periodic Wide Area ionosphere surface corrections */
    kal_bool                                commonParamsValid;
    gnss_ha_wa_iono_common_param_struct     commonParams;        /* carry the common parameters of the periodic Wide Area ionosphere surface corrections */
} gnss_ha_ionospheric_periodic_model_struct;


typedef struct
{
    kal_uint16                                     transactionID;
    gnss_ha_iono_model_type_enum                   type;
    union
    {
        gnss_ha_ionospheric_static_model_struct    staticModel;
        gnss_ha_ionospheric_periodic_model_struct  periodicWAIono;  /* based on the real-time GNSS observations and thus updated frequently to the target */
    } data;
} gnss_ha_common_ionospheric_model_struct;
/* end of gnss_ha_ionospheric_model */


/* begin of gnss_ha_troposphere_model */
typedef struct
{
    gnss_ha_validity_period_struct      validityPeriod;     /* specify the start time and duration of the local troposphere parameters validity period */
    kal_uint16                          zh0;                /* [0..4095], the hydrostatic zenith delay (meters), measured at the reference altitude level, scale factor 2^(-10) m */

    kal_uint8                           validityBitmap;     /* ehValid, zw0Valid, ewValid, gNValid, gEValid, use GNSS_HA_LOCAL_TROPO_DELAY_TIME_ELEMENT_BIT_*_VALID */
    /* optional */
    kal_uint16                          eh;                 /* [0..4095], the exponential fit parameter (1/m) for scaling zh0 to the target altitude, scale factor 2^(-20) (1/m) */
    /* optional */
    kal_uint16                          zw0;                /* [0..4095], the wet zenith delay (meters), measured at the reference altitude level, scale factor 2^(-10) m */
    /* optional */
    kal_uint16                          ew;                 /* [0..4095], the exponential fit parameter (1/m) for scaling zw0 to the target altitude, scale factor 2^(-20) (1/m) */
    /* optional */
    kal_int16                           gN;                 /* [-8192..8191], the gradient parameter (m) in North direction of the azimuthally asymmetric part of the tropospheric slant delay, scale factor 2^(-7) m */
    /* optioanl */
    kal_int16                           gE;                 /* [-8192..8191], the gradient parameter (m) in East direction of the azimuthally asymmetric part of the tropospheric slant delay, scale factor 2^(-7) m */

    gnss_ha_mapping_func_params_struct  mappingFuncParams;  /* coefficients of the mapping functions */
} gnss_ha_local_tropo_delay_time_element_struct;


typedef struct
{
    kal_uint8                                      numDelayTimeElement;
    gnss_ha_local_tropo_delay_time_element_struct  delayTimeElement[GNSS_HA_MAX_LOCAL_TROPO_DELAY_TIME_ELEMENT];
} gnss_ha_local_tropo_delay_time_list_struct;


typedef struct
{
    gnss_ha_validity_area_struct                validityArea;         /* specify the geographical validity area of the local troposphere model parameters */

    kal_bool                                    refAltitudeValid;
    kal_int16                                   refAltitude;          /* [-1000..8192], specify the reference altitude (from nominal sea level, EGM96) at which the delay measurements are made, scale factor 1m, if absent, the reference altitude is the zero nominal sea level */

    kal_bool                                    graRefPositionValid;
    //LPP_EXT_Ellipsoid_Point                     graRefPosition;       /* TBD: redefine internal structure? */  /* specify the origion for the spatial gradients gN and gE, if absent, the origin is taken as the middle point of the validity area */

    gnss_ha_local_tropo_delay_time_list_struct  delayList;            /* specify the troposphere delays */
} gnss_ha_local_tropo_delay_area_element_struct;


typedef struct
{
    kal_uint8                                      numDelayAreaElement;
    gnss_ha_local_tropo_delay_area_element_struct  delayAreaElement[GNSS_HA_MAX_LOCAL_TROPO_DELAY_AREA_ELEMENT];
} gnss_ha_troposphere_delay_list_struct;


typedef struct
{
    gnss_ha_validity_period_struct      validityPeriod;  /* specify the start time and duration of the surface parameter validity period */

    kal_int16                           pressure;        /* [-1024..1023], local atmospheric pressure measurement (hPa) at the altitude given by refAltitude, scale factor 0.1 hPa, the value is added to the nominal pressure of 1013hPa */
    kal_int8                            pressureRate;    /* [-128..127], rate of change of pressure, when calculating the pressure, the origin of time is the begin time of the validity period, scale factor 10 Pa/hour */

    kal_uint8                           validityBitmap;  /* gNpressureValid, gEpressureValid, temperatureValid, temperatureRateValid, gNtemperatureValid, gEtemperatureValid, use GNSS_HA_LOCAL_SURF_PARAMS_TIME_ELEMENT_BIT_* */
    /* optional */
    kal_int8                            gNpressure;      /* [-128..127], specify the northward gradient of the atmospheric pressure, if this field is present, but gE is not given, the eastward gradient is zero, scale factor 10 Pa/km */
    /* optional */
    kal_int8                            gEpressure;      /* [-128..127], specify the eastward gradient of the atmospheric pressure, if this field is present, but gN is not given, the nothward gradient is zero, scale factor 10 Pa/km */
    /* optional */
    kal_int8                            temperature;     /* [-64..63], local temperature measurement at the reference altitude refAltitude, scale factor 1K, the value is added to 273K */
    /* optional */
    kal_int8                            temperatureRate; /* [-16..16], local temperature change rate, the scale factor 1K/hour */
    /* optional */
    kal_int8                            gNtemperature;   /* [-8..7], specify the northward gradient of the temperature, if this field is present, but gE is not given, the eastward gradient is zero, scale factor 1 K/km */
    /* optional*/
    kal_int8                            gEtemperature;   /* [-8..7], specify the eastward gradient of the temperature, if this field is present, but gN is not given, the nothward gradient is zero, scale factor 1 K/km */

    gnss_ha_mapping_func_params_struct  mappingFuncParams;  /* coefficients of the mapping functions */
} gnss_ha_local_surface_params_time_element_struct;


typedef struct
{
    kal_uint8                                         numParamsTimeElements;
    gnss_ha_local_surface_params_time_element_struct  paramsTimeElement[GNSS_HA_MAX_LOCAL_SURFACE_PARAMS_TIME_ELEMENT];
} gnss_ha_local_surface_params_struct;


typedef struct
{
    gnss_ha_validity_area_struct         validityArea;         /* specify the geographical validity area of the local troposphere model parameters */

    kal_bool                             refAltitudeValid;
    kal_int16                            refAltitude;          /* [-1000..8192], specify the reference altitude (from nominal sea level, EGM96) at which the surface measurements are made, scale factor 1m, if absent, the reference altitude is the zero nominal sea level EGM96 */

    kal_bool                             graRefPositionValid;
    //LPP_EXT_Ellipsoid_Point              graRefPosition;       /* TBD: redefine internal structure? */  /* specify the origion for the spatial gradients gN and gE, if absent, the origin is taken as the middle point of the validity area */

    gnss_ha_local_surface_params_struct  paramsList;           /* specify the surface parameters */
} gnss_ha_local_surface_params_element_struct;


typedef struct
{
    kal_uint8                                    numParamsElements;
    gnss_ha_local_surface_params_element_struct  paramsElement[GNSS_HA_MAX_LOCAL_SURFACE_PARAMS_ELEMENT];
} gnss_ha_local_surface_params_list_struct;


typedef struct
{
    kal_uint16                                transactionID;
    kal_bool                                  tropoDelayListValid;
    gnss_ha_troposphere_delay_list_struct     tropoDelayList;         /* provide the zenith troposphere delay components determined in a given location and the needed parameters to adjust the delay to the target's altitude */
    kal_bool                                  surfaceParamListValid;
    gnss_ha_local_surface_params_list_struct  surfaceParametersList;  /* provide the surface pressure and optionally temperature that allow the target to compute the tropospheric delay using one of the known atmosphere models, such as the Hopfield or Saastamoinen model */
} gnss_ha_common_troposphere_model_struct;
/* end of gnss_ha_troposphere_model */


/* begin of gnss_ha_altitude_assist */
typedef struct
{
    gnss_ha_validity_period_struct  validityPeriod;     /* specify the start time and duration of the altitude assistance validity period */

    kal_int16                       pressure;           /* [-1024..1023], local atmospheric pressure measurement (hPa) at the altitude given by refAltitude, scale factor 10 Pa, the value is added to the nominal pressure of 1013hPa */
    kal_bool                        pressureRateValid;
    kal_int8                        pressureRate;       /* [-128..127], rate of change of pressure, when calculating the pressure, the origin of time is the begin time of the validity period, scale factor 10 Pa/hour */

    kal_bool                        gNValid;
    kal_int8                        gN;                 /* [-128..127], specify the northward gradient of the atmospheric pressure, scale factor 10 Pa/km */
    kal_bool                        gEValid;
    kal_int8                        gE;                 /* [-128..127], specify the eastward gradient of the atmospheric pressure, scale factor 10 Pa/km */
} gnss_ha_pressure_assist_element_struct;


typedef struct
{
   kal_uint8                               numPressureElements;
   gnss_ha_pressure_assist_element_struct  pressureElement[GNSS_HA_MAX_PRESSURE_ASSIST_ELEMENT];
} gnss_ha_pressure_assist_list_struct;


typedef struct
{
   gnss_ha_validity_area_struct         validityArea;            /* specify the geographical validity area of the altitude assistance */

   kal_bool                             gradRefPositionValid;
   gnss_reference_location_struct       gradRefPosition;         /* specify the origin for the spatial gradients gN and gE, if absent, the origin is taken as the middle point of the validity area */

   kal_bool                             refAltitudeValid;
   kal_int16                            refAltitude;             /* specify the reference altitude (from nominal sea level, [EGM96]) at which the surface measurements are made, scale factor 1m, if absent, the reference altitude is the zero nominal sea level */

   gnss_ha_pressure_assist_list_struct  pressureAssistanceList;  /* specify the set of pressure assistance elements for different periods of time */
} gnss_ha_altitude_assist_area_element_struct;


typedef struct
{
    kal_uint16                                   transactionID;
    kal_uint8                                    numAltitudeAreaElement;
    gnss_ha_altitude_assist_area_element_struct  altitudeAreaElement[GNSS_HA_MAX_ALTITUDE_ASSIST_AREA_ELEMENT];
} gnss_ha_common_altitude_assist_struct;
/* end of gnss_ha_altitude_assist */


/* begin of gnss_ha_altitude_assist */
typedef struct
{
    kal_uint16  transactionID;
    kal_uint16  solarRad;  /* specifies the solar radiation at one AU from the Sun, scale factor 1 Wm^(-2) */
} gnss_ha_common_solar_radiation_struct;
/* end of gnss_ha_altitude_assist */


/* begin of gnss_ha_common_ccp_assist */
typedef struct
{
    MTK_GNSS_ID_ENUM  gnssID;       /* specify the GNSS type */
    kal_uint8     gnssSignals;  /* specify the GNSS signal types for which CCP assistance can be provided in the area, GNSS Signal(s), map to GNSS_SGN_ID_BITMAP_* */
} gnss_ha_ccp_signal_supp_element_struct;


typedef struct
{
    kal_uint8                               numSigSuppElement;
    gnss_ha_ccp_signal_supp_element_struct  sigSuppElement[GNSS_HA_MAX_CCP_SIGNAL_SUPP_ELEMENT];
} gnss_ha_ccp_signal_supp_struct;


typedef struct
{
    gnss_ha_validity_area_struct    areaDescr;  /* provide the description of the area */
    gnss_ha_ccp_signal_supp_struct  sigSupp;    /* provide the GNSS signal support information */
} gnss_ha_ccp_support_area_struct;


typedef struct
{
   kal_uint16                                 refStationID;       /* define the ID of the reference station */
   gnss_ha_high_accu_3d_position_struct       refStationLoc;      /* define the location of the reference station, of which ID is refStationID */
   kal_bool                                   antennaDescrValid;
   //LPP_EXT_OMA_LPPe_AGNSS_AntennaDescription  antennaDescr;       /* TBD: redefine internal structure? */ /* specify the antenna type used at the reference station */
} gnss_ha_ccp_pref_station_list_element_struct;


typedef struct
{

    kal_uint8                                     numPrefStationElement;
    gnss_ha_ccp_pref_station_list_element_struct  prefStationElement[GNSS_HA_MAX_CCP_PREF_STATION_LIST_ELEMENT];
} gnss_ha_ccp_pref_station_list_struct;


typedef struct
{
    kal_bool                              supportAreaValid;
    gnss_ha_ccp_support_area_struct       supportArea;      /* provide information on the area, in which CCP is supported */

    kal_bool                              nbrListValid;
    gnss_ha_ccp_pref_station_list_struct  nbrList;          /* provide information on the possible neighbour reference stations */

    kal_bool                              durationValid;
    gnss_ha_duration                      duration;         /* specify the length of the continuous periodic assistance session */

    kal_bool                              rateValid;
    kal_uint8                             rate;             /* [1..64], specify the interval between the assistance data deliveries in seconds */

    kal_bool                              refStationListValid;
    gnss_ha_ccp_pref_station_list_struct  refStationList;   /* provide the locations of the reference stations for which CCP assistance is being provided */
} gnss_ha_ccp_assist_common_ctrl_params_struct;


typedef struct
{
    kal_uint16                           transactionID;
    gnss_ha_ccp_assist_common_type_enum  type;
    union
    {
        gnss_system_time_struct                       commParamsRefSysTime;  /* define the CCP-specific common parameters (reference time) */
        gnss_ha_ccp_assist_common_ctrl_params_struct  ctrlParams;            /* define the CCP-specific control parameters */
    } data;
} gnss_ha_common_ccp_assist_struct;
/* end of gnss_ha_common_ccp_assist */


/* begin of gnss_ha_req_ionospheric_model */
typedef struct
{
    kal_uint8                ionoReq;            /* specify which ionosphere models are being requested for, mapping to GNSS_HA_COMM_AD_REQ_IONO_BIT_* */

    kal_bool                 reqBeginTimeValid;
    gnss_system_time_struct  reqBeginTime;       /* specify the first time instant when an ionosphere model is needed, if absent, begin time is the current time */

    gnss_ha_duration         duration;           /* specify for how long period the ionospheric model is requested */
} gnss_ha_req_ionospheric_static_model_struct;


typedef struct
{
    kal_bool          durationValid;
    gnss_ha_duration  duration;       /* specify the length of the continuous periodic assistance session */

    kal_bool          rateValid;
    kal_uint8         rate;           /* [0..64], specify the interval between the assistance data deliveries in seconds */
} gnss_ha_req_ionospheric_periodic_model_struct;


typedef struct
{
    gnss_ha_iono_model_type_enum                   type;
    union
    {
        gnss_ha_req_ionospheric_static_model_struct    staticModelReq;     /* request for the one-shot ionosphere models */
        gnss_ha_req_ionospheric_periodic_model_struct  periodicWAIonoReq;  /* request for periodic ionosphere models */
    } data;
} gnss_ha_req_ionospheric_model_struct;
/* end of gnss_ha_req_ionospheric_model */


/* begin of gnss_ha_req_troposphere_model */
typedef struct
{
    kal_uint8                tropoModelReq;           /* specify the desired model or models, mapping to GNSS_HA_COMM_AD_REQ_TROPO_BIT_* */

    kal_bool                 supportMultiGridPoints;  /* indicate if the target is requesting parameter sets originating from multiple locations around it (TRUE)
                                                         FALSE means that only the nearest grid point parameters are requested */

    kal_bool                 reqBeginTimeValid;
    gnss_system_time_struct  reqBeginTime;            /* specify the first time instant when a valid troposphere model is needed, if absent, the begin time is the current time */

    gnss_ha_duration         duration;                /* specify how long time the tropospheric model is requested for */
} gnss_ha_req_troposphere_model_struct;
/* end of gnss_ha_req_troposphere_model */


/* begin of gnss_ha_req_altitude_assist */
typedef struct
{
    kal_bool                 reqBeginTimeValid;
    gnss_system_time_struct  reqBeginTime;       /* specify the first time instant when altitude assistance is needed, if absent, the begin time is the current time */

    kal_bool                 durationValid;
    gnss_ha_duration         duration;           /* specify how long time the altitude assistance is requested for, if absent, altitude assistance is requested for the current moment */
} gnss_ha_req_altitude_assist_struct;
/* end of gnss_ha_req_altitude_assist */


/* begin of gnss_ha_req_ccp_ctrl_params */
typedef struct
{
   gnss_ha_high_accu_3d_position_struct  reqRefStationLoc;  /* request for a new reference station based on the position. The position may or may not be the target position */
   gnss_ha_agnss_qor_type_enum           qor;               /* QoR (Quality-of-Reference station) defines how close to the requested location the closest reference station must be
                                                               In case the closest reference station is within the uncertainty area of the target location, the QoR parameter is neglected */
} gnss_ha_req_ccp_pos_based_ref_station_struct;


typedef struct
{
    kal_uint8   numRefStationIDElement;
    kal_uint16  refStationIDElement[GNSS_HA_MAX_CCP_PREF_STATION_LIST_ELEMENT];  /* [0..65535], contain the reference station ID list */
} gnss_ha_req_ccp_ref_station_list_struct;


typedef struct
{
    gnss_ha_req_ccp_ref_station_type_enum             type;
    union
    {
        gnss_ha_req_ccp_pos_based_ref_station_struct  posBasedRefStationReq;
        gnss_ha_req_ccp_ref_station_list_struct       idBasedRefStationReq;    /* request for CCP AD for a new reference station based on the reference station ID */
        gnss_ha_req_ccp_ref_station_list_struct       refStationKillList;      /* terminate CCP AD deliveries for selected reference stations based on their reference station IDs */
    } data;
} gnss_ha_req_ccp_ref_station_struct;


typedef struct
{
    kal_bool                            durationValid;
    gnss_ha_duration                    duration;          /* specify the length of the continuous periodic assistance session */

    kal_bool                            rateValid;
    kal_uint8                           rate;              /* [1..64], specify the interval between the assistance data deliveries in seconds */

    kal_bool                            refStationValid;
    gnss_ha_req_ccp_ref_station_struct  refStation;        /* specify the request/modification of the active reference station set */
} gnss_ha_req_ccp_common_req_struct;


typedef struct
{
    kal_bool                           ccpSuppAreaReq;    /* TRUE if request for the information on the CCP assistance availability in the target area */
    kal_bool                           ccpNbrListReq;     /* TRUE if request for the information on the reference stations in the vicinity of the target */

    gnss_ha_req_ccp_common_req_struct  ccpCommonRequest;  /* request for a new reference station or stopping CCP AD delivery for a reference station */
} gnss_ha_req_ccp_ctrl_params_struct;
/* end of gnss_ha_req_ccp_ctrl_params */


/* begin of gnss_ha_degradation_model */
typedef struct
{
    kal_uint8  clockRMS0;       /* specify the constant term of the clock model degradation model by cRMS0 =((1+0.1)^clockRMS0 -1) meters,
                                   where clockRMS0 = 31 denotes 'Use At Own Risk', the range is [0, 16.45) meters, refer to OMA-TS-LPPe Appendix C.6.1 */
    kal_bool   clockRMS1Valid;
    kal_uint8  clockRMS1;       /* specify the first order term of the clock model degradation model, cRMS1, scale factor 2^(-14) m/s,
                                   range [0, 4.3e-4) m/s, refer to OMA-TS-LPPe Appendix C.6.1 */
} gnss_ha_clock_model_degrad_model_struct;


typedef struct
{
    kal_uint8  orbitRMS0;       /* specify the constant term of the orbit model degradation model by oRMS0 =((1+0.1)^orbitRMS0 -1) meters,
                                   where orbitRMS0 = 31 denotes 'Use At Own Risk', the range is [0, 16.45) meters, refer to OMA-TS-LPPe Appendix C.6.2 */
    kal_bool   orbitRMS1Valid;
    kal_uint8  orbitRMS1;       /* specify the first order term of the orbit model degradation model, oRMS1, scale factor 2^(-14) m/s, range [0, 4.3e-4) m/s,
                                   refer to OMA-TS-LPPe Appendix C.6.2 */
} gnss_ha_orbit_model_degrad_model_struct;


typedef struct
{
    kal_uint8                                svID;                   /* [0..63], specify the SV for which degradation models are provided */
    gnss_ha_clock_model_degrad_model_struct  clockDegradationModel;  /* provide the degradation model for the clock model */
    gnss_ha_orbit_model_degrad_model_struct  orbitDegradationModel;  /* provide the degradation model for the orbit model */
} gnss_ha_degrad_model_element_struct;


typedef struct
{
    kal_uint16                               transactionID;
    MTK_GNSS_ID_ENUM                             gnssId;

    kal_uint8                                numDegradModelElement;
    gnss_ha_degrad_model_element_struct      degradModelElement[GNSS_HA_MAX_DEGRAD_MODEL_ELEMENT];
} gnss_ha_generic_degradation_model_struct;
/* end of gnss_ha_degradation_model */


/* begin of gnss_ha_generic_ccp_assist */
typedef struct
{
    gnss_ha_code_phase_err_type_enum  type;
    union
    {
        kal_uint8  codePhaseRMSError;  /* contain the pseudorange RMS error value, representation refer to TS 36.355 floating-point representation of GNSS-MeasurementList field descriptions */
        kal_uint8  cnr;                /* carrier-to-noise ratio, scale factor 0.25 dB-Hz, range [0, 63.75] dB-Hz */
    } data;
} gnss_ha_code_phase_error_struct;


typedef struct
{
    kal_uint8                        svID;                      /* [0..63], identify the SV for which CCP assistance is being provided */

    kal_bool                         intCodePhaseValid;
    kal_uint8                        intCodePhase;              /* [0..255], indicate the integer milli-second part of the code phase */

    kal_uint32                       codePhase;                 /* [0.. 14989622], contain the sub-millisecond part of the code phase observation
                                                                   for the particular satellite signal at the reference time, scale factor 0.02 meters, range [0, 299792.44] meters */

    kal_bool                         codePhaseErrorValid;
    gnss_ha_code_phase_error_struct  codePhaseError;            /* code phase error */

    kal_int32                        phaseRangeDelta;           /* [-524288.. 524287], define the (Phase Range V Pseudorange), scale factor 0.5 mm, range [-262.144, 262.1435] meters */

    kal_bool                         phaseRangeRMSErrorValid;
    kal_uint8                        phaseRangeRMSerror;        /* [0..127], contain the RMS error of the continuous carrier phase, scale factor 2^(-10) meters, in the range [0, 0.12403) meters */

    kal_bool                         lockIndicator;             /* TRUE: if the carrier phase tracking has been continuous between the previous and the current assistance
                                                                   data delivery. FALSE: a cycle slip has occurred */
} gnss_ha_ccp_sv_element_struct;


typedef struct
{
    kal_uint8                      numCCPPerSVElement;
    gnss_ha_ccp_sv_element_struct  ccpPerSVElement[GNSS_HA_MAX_CCP_PER_SV_ELEMENT];
} gnss_ha_ccp_per_sv_list_struct;


typedef struct
{
    kal_uint8                       signalID;      /* indicate the signal id, map to GNSS_SGN_ID_VALUE_* */
    gnss_ha_ccp_per_sv_list_struct  ccpPerSVlist;
} gnss_ha_ccp_per_signal_element_struct;


typedef struct
{
    kal_uint8                              numCCPPerSigElement;
    gnss_ha_ccp_per_signal_element_struct  ccpPerSigElement[GNSS_HA_MAX_CCP_PER_SIG_ELEMENT];
} gnss_ha_ccp_per_signal_list_struct;


typedef struct
{
   kal_uint16                          refStationID;      /* define the ID of the reference station to which the CCP assistance is provided */
   gnss_ha_ccp_per_signal_list_struct  ccpPerSignalList;
} gnss_ha_ccp_generic_element_struct;


typedef struct
{
    kal_uint16                               transactionID;
    MTK_GNSS_ID_ENUM                             gnssId;
    kal_uint8                                numCCPGenericElement;
    gnss_ha_ccp_generic_element_struct       ccpGenericElement[GNSS_HA_MAX_CCP_GENERIC_ELEMENT];
} gnss_ha_generic_ccp_assist_struct;
/* end of gnss_ha_generic_ccp_assist */


/* begin of gnss_ha_req_ccp_generic_struct */
typedef struct
{
    kal_uint8  ccpGnssSignalsReq;  /* specify the GNSS signal types for which the CCP assistance is requested by the target device, GNSS Signal(s), map to GNSS_SGN_ID_BITMAP_* */
} gnss_ha_req_ccp_generic_struct;
/* end of gnss_ha_req_ccp_generic_struct */

typedef struct
{
    MTK_GNSS_ID_ENUM                          gnssId;
    //kal_bool                        waIonoSurfaceReq;     /* TRUE if wide area ionosphere correction surface is requested for the SVs of this GNSS */
    //gnss_ha_req_mechanics_struct    mechanicsReq;         /* request the SV mechanics information */
    //gnss_ha_req_dcb_struct          dcbReq;               /* request the differential code biases to gain higher accuracy */
    kal_bool                              degradModelReq;       /* TRUE if request the accuracy models for the SV orbit and clock models to get a better understanding of the accuracy of the computed position */
    gnss_ha_req_ccp_generic_struct        ccpAssistGenericReq;  /* request for the CCP reference assistance data for high accuracy */
    //gnss_ha_req_nav_model_struct    navigationModelReq;   /* TBD. request for the navigation models defined in LPPe */

} gnss_ha_generic_assist_struct;

typedef struct
{
    kal_uint16                            transactionID;

    /* Common assistance data*/
    kal_bool                              ionoModelReqValid;
    gnss_ha_req_ionospheric_model_struct  ionoModelReq;        /* request for ionosphere models */

    kal_bool                              tropoModelReqValid;
    gnss_ha_req_troposphere_model_struct  tropoModelReq;       /* request troposphere models */

    kal_bool                              altAssistReqValid;
    gnss_ha_req_altitude_assist_struct    altAssistReq;        /* request altitude assistance for improved availability */

    kal_bool                              solarRadReq;         /* TRUE if request the solar radiation intensity */

    kal_bool                              ccpCtrlParamsReqValid;
    gnss_ha_req_ccp_ctrl_params_struct    ccpCtrlParamsReq;    /* request for the control parameters of the CCP AD session.*/

    /* Generic assistance data */
    kal_uint8                             numGnssSupport;
    gnss_ha_generic_assist_struct         genericAssistReq[16];
} gnss_ha_assist_data_request_ind_struct;

typedef struct
{
     kal_int32 type; /* refer to agps_md_huge_data_type */
} gnss_ha_assist_ack_struct;

typedef struct
{
    unsigned int u4_lppe_assis_data_bitmap;
    gnss_ha_ionospheric_static_model_struct *ionospheric_static_model;
    gnss_ha_ionospheric_periodic_model_struct *ionospheric_periodic_model;
    gnss_ha_common_troposphere_model_struct *troposphere_model;
    gnss_ha_common_altitude_assist_struct *altitude_assist;
    gnss_ha_common_solar_radiation_struct *solar_radiation;
    gnss_system_time_struct    *ccp_specific_common_para_ref_time;
    gnss_ha_ccp_assist_common_ctrl_params_struct*  ctrlParams;
    gnss_ha_generic_ccp_assist_struct *ccp_generic_assist_struct;
    gnss_ha_generic_degradation_model_struct *generic_degradation_model;
} gnss_lppe_database;
typedef struct
{
    /*LPPE_enabled is for agent to management lppe assistant data, can be setted by driver*/
    kal_uint8    LPPE_enabled;
    /*ionospher must choose one, can't require both according to spec*/
    kal_bool prefer_ionospheric_static_model;
    /*common ccp must choose one, can't require both according to spec*/
    kal_bool prefer_ccp_common_ctrl_params;
}agent_lppe_config;


/*****************************************************************************
 * FUNCTION
 *  mtk_agps_get_param
 * DESCRIPTION
 *  Get the current setting of the AGPS Agent
 * PARAMETERS
 *  key         [IN]   the configuration you want to know
 *  value       [OUT]  the current setting
 * RETURNS
 *  success(MTK_GPS_SUCCESS); failure (MTK_GPS_ERROR)
 *****************************************************************************/
INT32
mtk_agps_get_param (MTK_GPS_PARAM key, void* value, UINT16 srcMod, UINT16 dstMod);

/*****************************************************************************
 * FUNCTION
 *  mtk_agps_set_param
 * DESCRIPTION
 *  Change the behavior of the AGPS Agent
 * PARAMETERS
 *  key         [IN]   the configuration needs to be changed
 *  value       [IN]   the new setting
 * RETURNS
 *  success(MTK_GPS_SUCCESS); failure (MTK_GPS_ERROR)
 *****************************************************************************/
INT32
mtk_agps_set_param (MTK_GPS_PARAM key, const void* value, UINT16 srcMod, UINT16 dstMod);
INT32
mtk_agps_set_param_with_payload_len (MTK_GPS_PARAM key, const void* value, UINT16 srcMod, UINT16 dstMod, int len);

/*****************************************************************************
 * FUNCTION
 *  mtk_gps_sys_agps_disaptcher_callback
 * DESCRIPTION
 *  called by MNL when need send data
 * PARAMETERS
 *  type: msg type, length: payload length, data: payload pointer
 * RETURNS
 *  none
 *****************************************************************************/
INT32
mtk_gps_sys_agps_disaptcher_callback (UINT16 type, UINT16 length, char *data);

#ifdef __cplusplus
   }  /* extern "C" */
#endif

#endif


