#include "mtk_gps.h"
#include "mtk_gps_type.h"
#include "mtk_gps_sys_fp.h"
//#include "mtk_gps_sys_fp_macro.h"
#include "mtk_lbs_utility.h"
#include<time.h>
#include<sys/time.h>
#include<errno.h>

#define MNL_START_TIME 500
#define MNL_NMEA_INTERVAL 1000
#define MNL_STOP_TIME 500

extern INT32 mtk_gps_sys_agps_disaptcher_callback(UINT16 type, UINT16 length, char *data);
extern INT32 mtk_gps_sys_gps_mnl_callback(MTK_GPS_NOTIFICATION_TYPE msg);
extern INT32 mtk_gps_sys_nmea_output_to_mnld(const char * buffer, UINT32 length);

static void mnl_start_done();
static void mnl_nmea_report();
static void mnl_stop_done();

timer_t mnl_open_timer;
timer_t mnl_nmea_timer;
//timer_t mnl_close_timer;

MTK_GPS_SYS_FUNCTION_PTR_T mnl_cb_func;

static void mnl_start_done() {
    char i1Assist_Req = 0;
    mtk_gps_sys_agps_disaptcher_callback(MTK_AGPS_CB_START_REQ, 1, &i1Assist_Req);

    start_timer(mnl_nmea_timer, MNL_START_TIME);
}

int gNmeaCount = 0;
static void mnl_nmea_report() {
    #define NMEA_BUFFER_LEN 10*1024
    int ret = 0;
    char buffer_not_fix[NMEA_BUFFER_LEN] = {"$GNGGA,092152.975,3032.4269,N,10403.7720,E,0,0,,534.9,M,-31.9,M,,*79\r\n$GPGSA,A,1,,,,,,,,,,,,,99.99,99.99,1.00*01\r\n$GPGSV,3,1,10,06,65,337,,19,61,033,,17,52,071,,02,37,268,*7A\r\n$GNRMC,092152.975,V,3032.4269,N,10403.7720,E,0.000,0.00,260617,,,N*55\r\n$GNACCURACY,7.1*10\r\n"};
    char nmea_fixed[NMEA_BUFFER_LEN] = {"$GNGGA,065826.000,2446.3072,N,12101.2991,E,1,22,0.52,115.1,M,15.1,M,,*79\r\n$GNGSA,A,3,15,21,10,12,13,,,,,,,,0.88,0.52,0.71,1*07\r\n$GNGSA,A,3,71,72,80,70,86,,,,,,,,0.88,0.52,0.71,2*01\r\n$GNGSA,A,3,12,01,04,33,,,,,,,,,0.88,0.52,0.71,3*04\r\n$GNGSA,A,3,12,37,22,35,08,09,38,,,,,,0.88,0.52,0.71,4*0E\r\n$GNGSA,A,3,195,,,,,,,,,,,,0.88,0.52,0.71,5*39\r\n$GPGSV,3,1,11,24,77,159,,21,51,290,20.1,15,48,024,11.7,20,33,321,,1*69\r\n$GPGSV,3,2,11,05,21,106,,13,19,046,14.1,12,10,151,19.0,29,09,211,,1*67\r\n$GPGSV,3,3,11,10,08,310,17.9,32,02,256,,51,,,,1*78\r\n$GPGSV,1,1,3,26,83,193,45.2,03,35,296,39.5,32,34,120,38.3,7*72\r\n$GLGSV,2,1,8,73,49,093,,71,39,015,10.7,86,37,246,28.4,72,24,317,11.8,1*5A\r\n$GLGSV,2,2,8,87,21,312,,70,18,068,12.3,80,12,033,16.9,85,10,192,,1*4F\r\n$GAGSV,3,1,12,18,52,000,,19,52,000,,12,47,266,5.0,20,37,109,,7*54\r\n$GAGSV,3,2,12,21,37,109,,32,35,195,,33,35,195,8.7,04,26,289,18.3,7*49\r\n$GAGSV,3,3,12,01,21,166,16.9,27,17,055,,10,15,316,,11,15,316,,7*61\r\n$GAGSV,1,1,3,12,47,266,20.0,33,35,195,16.0,04,26,289,12.9,1*6D\r\n$BDGSV,6,1,24,18,69,334,,13,66,241,,38,61,203,,06,60,333,,1*7D\r\n$BDGSV,6,2,24,03,59,204,,16,57,319,,08,54,188,11.0,01,53,142,,1*66\r\n$BDGSV,6,3,24,39,49,195,,59,49,136,,09,48,286,14.8,36,44,171,,1*61\r\n$BDGSV,6,4,24,02,40,242,,04,38,118,,20,29,079,,35,26,247,18.9,1*6E\r\n$BDGSV,6,5,24,22,25,310,11.9,57,22,273,,07,19,169,,05,17,259,,1*6A\r\n$BDGSV,6,6,24,29,14,196,,12,13,299,12.9,37,12,041,13.6,10,06,191,,1*72\r\n$BDGSV,1,1,2,38,61,203,11.7,35,26,247,22.3,4*48\r\n$QZGSV,1,1,4,199,83,359,,193,66,053,,194,49,131,,195,17,170,19.0,1*5D\r\n$GNRMC,065826.000,A,2446.3072,N,12101.2991,E,0.000,0.00,181019,,,A,V*37\r\n$GNVTG,0.00,T,,M,0.000,N,0.000,K,A*23\r\n$PMTKTSX1,323163,-16493.935,42.431,40.172,55ae0000,-1.664871,-1.649394,-0.250522,-0.273268,0.600247,-1.622,1.0*5E\r\n$PMTKGEPH,32,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1*35\r\n$PMTKGALM,31,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1*2A\r\n$GNACCURACY,2.5,163.6,1.6,25.4*25\r\n"};
    char log_time[NMEA_BUFFER_LEN];
    time_t tm;
    struct tm *p = NULL;
    char *gps_debuglog_file_name_format_str;

    if (time(&tm)==((time_t)-1)) {
        LOGE("time()  fail(%s)!!\r\n", strerror(errno));
    }
    p = localtime(&tm);

    if(p == NULL) {
        LOGE("Get localtime fail:[%s]%d", strerror(errno), errno);
    }

    mtk_gps_sys_gps_mnl_callback(MTK_GPS_MSG_FIX_READY);

    gps_debuglog_file_name_format_str = "[%04d_%02d%02d_%02d%02d%02d]";
    memset(log_time, 0x00, sizeof(log_time));
    MNLD_SNPRINTF(log_time, sizeof(log_time), gps_debuglog_file_name_format_str,
    1900 + p->tm_year, 1 + p->tm_mon, p->tm_mday,
    p->tm_hour, p->tm_min, p->tm_sec);
    if(mnl_cb_func.sys_alps_gps_dbg2file_mnld != NULL) {
        mnl_cb_func.sys_alps_gps_dbg2file_mnld(log_time, strlen(log_time));
    }
    if(gNmeaCount++ < 3) {
        int length = strlen(buffer_not_fix);
        mtk_gps_sys_nmea_output_to_mnld(buffer_not_fix, length);
        if(mnl_cb_func.sys_alps_gps_dbg2file_mnld != NULL) {
            mnl_cb_func.sys_alps_gps_dbg2file_mnld(buffer_not_fix, strlen(buffer_not_fix));
        }
    } else {
        int length = strlen(nmea_fixed);
        mtk_gps_sys_nmea_output_to_mnld(nmea_fixed, length);
        if(mnl_cb_func.sys_alps_gps_dbg2file_mnld != NULL) {
            mnl_cb_func.sys_alps_gps_dbg2file_mnld(nmea_fixed, strlen(nmea_fixed));
        }
    }

    ret = start_timer(mnl_nmea_timer, MNL_NMEA_INTERVAL);
    LOGD("start_timer ret:%d, gNmeaCount:%d", ret, gNmeaCount);
}

static void mnl_stop_done() {

}

MTK_GPS_BOOT_STATUS
mtk_gps_mnl_run(const MTK_GPS_INIT_CFG* default_cfg, const MTK_GPS_DRIVER_CFG* driver_dfg) {
    mnl_open_timer = init_timer(mnl_start_done);
    mnl_nmea_timer = init_timer(mnl_nmea_report);
    //mnl_close_timer = init_timer(mnl_stop_done);
    start_timer(mnl_open_timer, MNL_START_TIME);
    gNmeaCount = 0;

    return MNL_INIT_SUCCESS;
}

void
mtk_gps_mnl_stop(void) {
    LOGD("");
    stop_timer(mnl_open_timer);
    stop_timer(mnl_nmea_timer);
}

INT32
mtk_gps_set_param(MTK_GPS_PARAM key, const void* value) {
    start_timer(mnl_open_timer, MNL_START_TIME);
    return 0;
}

INT32
mtk_gps_get_param(MTK_GPS_PARAM key, void* value) {
    return 0;
}

INT32
mtk_gps_get_mnl_info(MTK_GPS_MNL_INFO* lib_info) {
    return 0;
}

void mtk_gps_mnl_create_dbg_port(UINT32 port_num) {

}

INT32 mtk_gps_delete_nv_data(UINT32 assist_data_bit_map) {
    return 0;
}

INT32 mtk_gps_inject_ntp_time(MTK_GPS_NTP_T* ntp) {
    return 0;
}

INT32 mtk_gps_inject_nlp_location(MTK_GPS_NLP_T* nlp) {
    return 0;
}

void
mtk_gnss_get_measurement(Gnssmeasurement GpQzMeasurement[MTK_GPS_SV_MAX_PRN+MTK_QZS_SV_MAX_PRN], Gnssmeasurement GloMeasurement[MTK_GLON_SV_MAX_NUM],
Gnssmeasurement BDMeasurement[MTK_BEDO_SV_MAX_NUM], Gnssmeasurement GalMeasurement[MTK_GLEO_SV_MAX_NUM],Gnssmeasurement SBASMeasurement[MTK_SBAS_SV_MAX_NUM],
INT8 GpQz_Ch_Proc_Ord_PRN[MTK_GPS_SV_MAX_PRN+MTK_QZS_SV_MAX_PRN],INT8 Glo_Ch_Proc_Ord_PRN[MTK_GLON_SV_MAX_NUM],INT8 BD_Ch_Proc_Ord_PRN[MTK_BEDO_SV_MAX_NUM],
INT8 Gal_Ch_Proc_Ord_PRN[MTK_GLEO_SV_MAX_NUM],INT8 SBAS_Ch_Proc_Ord_PRN[MTK_SBAS_SV_MAX_NUM]) {

}

INT32
mtk_gnss_get_clock(Gnssclock *GnssClock){
    return 0;
}

INT32
mtk_gnss_get_navigation_event (GnssNavigationmessage *NavEvent, UINT8 SVID, UINT8 SV_type){
    return 0;
}

UINT16
mtk_gps_set_mpe_info(UINT8 *msg){
    return 0;
}

int
mtk_gps_mnl_mpe_callback_reg(MPECallBack *name){
    return 0;
}

INT32
mtk_gps_set_debug_type(const UINT8 debug_type){
    return 0;
}

INT32
mtk_gps_get_position_accuracy(double *Lat, double *Lon, int *accuracy){
    return 0;
}

void
mtk_gps_mnl_get_sensor_info(UINT8 *msg, int len){}

void
mtk_gps_mnl_set_sensor_info(UINT8 *msg, int len){}

int
mtk_gps_mnl_trigger_mpe(void) {
    return 0;
}

INT32 mtk_agps_agent_qepo_file_update() {
    return 0;
}

INT32 mtk_agps_agent_mtknav_file_update() {
    return 0;
}

INT32 mtk_gps_ofl_set_option(UINT32 cfg_bitmask) {
    return 0;
}

INT32 mtk_gps_ofl_set_user(UINT32 user_bitmask) {
    return 0;
}

INT32 mtk_gps_ofl_rst_stpgps_begin_ntf() {
    return 0;
}

INT32 mtk_gps_ofl_send_flp_data(UINT8 *buf, UINT32 len) {
    return 0;
}

INT32 mtk_gps_flp_get_location(void *buf, UINT32 buf_len, UINT32 *p_get_len) {
    return 0;
}

UINT32 mtk_gps_log_line_enc_inplace(char *buffer, UINT32 length) {
    return 0;
}

unsigned char mtk_gps_get_MNL_Config_XML_param (char MNL_Config_File_Path[], MTK_GPS_MNL_CONFIG_XML_PARAM *mnl_config_xml) {
    return 0;
}

void mtk_gps_set_MNL_Config_XML_param (char MNL_Config_File_Path[], MTK_GPS_MNL_CONFIG_XML_PARAM *mnl_config_xml){}

INT32
mtk_agps_set_param (MTK_GPS_PARAM key, const void* value, UINT16 srcMod, UINT16 dstMod) {
    return 0;
}

INT32
mtk_agps_set_param_with_payload_len (MTK_GPS_PARAM key, const void* value, UINT16 srcMod, UINT16 dstMod, int len) {
    return 0;
}

INT32
mtk_agps_agent_epo_file_update() {
    return 0;
}

INT32
mtk_agps_agent_qepo_bd_file_update() {
    return 0;
}

INT32
mtk_agps_agent_qepo_ga_file_update() {
    return 0;
}

INT32
mtk_agps_agent_qepo_get_rqst_time(UINT16 *wn, UINT32 *tow, UINT32 *sys_time) {
    return 0;
}

//int SUPL_encrypt(unsigned char *plain, unsigned char *cipher, unsigned int length) {}
//int SUPL_decrypt(unsigned char *plain, unsigned char *cipher, unsigned int length) {}
INT32
mtk_gps_sys_function_register (MTK_GPS_SYS_FUNCTION_PTR_T *fp_t) {
    mnl_cb_func.sys_alps_gps_dbg2file_mnld = fp_t->sys_alps_gps_dbg2file_mnld;
    return 0;
}

INT32 mtk_gps_geofence_get_position (mtk_geofence_position_info* pos_data)
{
    return -1;
}
